/*

Space caft header

*/
#ifndef SPACECRAFT_H
#define SPACECRAFT_H

#include <new>
#include <string>
#include <GL/glut.h>
#include "PilotDisplay.h"
#include "TextureLoader.h"
#include "Weapon.h"

#define ROLL 1
#define PITCH 2
#define YAW 3

class Spacecraft {

public:
	Spacecraft();
	renderView(int = 3);
	viewInverse();
	initializeShip(int);
	float mCamera[4][4];
	float mOrientation[4][4];
	float vPosition[3];
	float vVelocity[3];
	float fSpeed;
	float fMass;
	float roll;
	float pitch;
	float yaw;
	float zoom;
	float zoom_speed;
	float for_thrust_scale;

	bool insideShip;
	bool move_mode;
	bool m_forward;
	bool m_reverse;
	bool m_left;
	bool m_right;
	bool m_up;
	bool m_down;
	bool r_right;
	bool r_left;
	bool p_up;
	bool p_down;
	bool y_right;
	bool y_left;

	int health;
	PilotDisplay display;
	Weapon laser;

private:
	drawCraft();
	body();
	wing();
	rocketNozzle();
	flame();
	moveForward();
	moveReverse();
	moveLeft();
	moveRight();
	moveUp();
	moveDown();
	rollRight();
	rollLeft();
	pitchUp();
	pitchDown();
	yawRight();
	yawLeft();
	rocket_left_foreward();
	rocket_left_aft();
	rocket_right_foreward();
	rocket_right_aft();
	rocket_top_foreward();
	rocket_top_aft();
	rocket_top_left();
	rocket_top_right();
	rocket_bottom_foreward();
	rocket_bottom_aft();
	rocket_bottom_left();
	rocket_bottom_right();
	TextureLoader tl;
	GLuint g_Texture[5];
	int colorID;
};

#endif
