/*

  display class for the pilot

*/
#include "PilotDisplay.h"

PilotDisplay::PilotDisplay(int type){
	hud_intensity = 50;
	RPYon = true;
	POSon = true;
	DIRon = true;
	HUDon = true;
	HEALTHon = true;
	crosshair_on = true;
}

void PilotDisplay::increase_hud_intensity(){
	if (hud_intensity < 100) hud_intensity++;
}
void PilotDisplay::decrease_hud_intensity(){
	if (hud_intensity > 1) hud_intensity--;
}

void PilotDisplay::render_hud(float r, float p, float y, 
							  float px, float py, float pz, 
							  float dx, float dy, float dz,
							  int health){
	float h_i;
	char buffer[80];
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(-2,2,-1.5,1.5);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	//glTranslatef(0,-0.5,0);
	h_i = 0.5 + ((float)hud_intensity * 0.005);
	glColor4f(0.6,0.6,0.8,h_i);
	glLineWidth(2.0);
	glBegin(GL_LINES);
		glVertex2f(-0.9,0.0);
		glVertex2f(-0.1,0.0);
		glVertex2f(0.1,0.0);
		glVertex2f(0.9,0.0);
		glVertex2f(0.0,-0.65);
		glVertex2f(0.0,-0.1);
		glVertex2f(0.0,0.1);
		glVertex2f(0.0,0.65);
	glEnd();
	glBegin(GL_LINE_LOOP);
		glVertex2f(-0.1,-0.1);
		glVertex2f(0.1,-0.1);
		glVertex2f(0.1,0.1);
		glVertex2f(-0.1,0.1);
	glEnd();
	glLineWidth(1.0);
	glBegin(GL_LINE_LOOP);
		glVertex2f(-1,-0.5);
		glVertex2f(-1,0.5);
		glVertex2f(-0.75,0.75);
		glVertex2f(0.75,0.75);
		glVertex2f(1,0.5);
		glVertex2f(1,-0.5);
		glVertex2f(0.75,-0.75);
		glVertex2f(-0.75,-0.75);
	glEnd();
	glColor4f(0.6,0.6,0.8,0.1);
	glBegin(GL_POLYGON);
		glVertex2f(-0.75,-0.75);
		glVertex2f(0.75,-0.75);
		glVertex2f(1,-0.5);
		glVertex2f(1,0.5);
		glVertex2f(0.75,0.75);
		glVertex2f(-0.75,0.75);
		glVertex2f(-1,0.5);
		glVertex2f(-1,-0.5);
	glEnd();
	//HUD intensity
	glColor4f(0.6,0.6,0.8,h_i);
	glRasterPos2f(-0.19,-0.73);
	sprintf(buffer, "Brightness: %d%%",hud_intensity);
	displayText(GLUT_BITMAP_HELVETICA_12, buffer);
	if (RPYon) displayRPY(r, p, y);
	if (POSon) displayPosition(px, py, pz);
	if (DIRon) displayDirection(dx, dy, dz);
	if (HEALTHon) displayHealth(health);
	/*
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
	glFrustum(-0.04, 0.04, -0.03, 0.03, 0.1, 1E6);
	*/
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
}

void PilotDisplay::displayText(void *font, char *str){
   int i,l = strlen(str);
   for(i=0;i<l;i++)
      glutBitmapCharacter(font,*str++);
}

void PilotDisplay::displayRPY(float r, float p, float y){
	char buffer[80];

	glRasterPos2f(-0.98,0.46);
	sprintf(buffer, "rollV: %0.2f",	r);
	displayText(GLUT_BITMAP_HELVETICA_12, buffer);

	glRasterPos2f(-0.98,0.41);
	sprintf(buffer, "pitchV: %0.2f", p);
	displayText(GLUT_BITMAP_HELVETICA_12, buffer);

	glRasterPos2f(-0.98,0.36);
	sprintf(buffer, "yawV: %0.2f", y);
	displayText(GLUT_BITMAP_HELVETICA_12, buffer);
}
void PilotDisplay::displayPosition(float x, float y, float z){
	char buffer[80];

	glRasterPos2f(-0.94, -0.34);
	sprintf(buffer,"POS");
	displayText(GLUT_BITMAP_HELVETICA_12,buffer);

	glRasterPos2f(-0.98, -0.39);
	sprintf(buffer,"X: %.2f", x);
	displayText(GLUT_BITMAP_HELVETICA_12,buffer);

	glRasterPos2f(-0.98, -0.44);
	sprintf(buffer,"Y: %.2f", y);
	displayText(GLUT_BITMAP_HELVETICA_12,buffer);
	
	glRasterPos2f(-0.98, -0.49);
	sprintf(buffer,"Z: %.2f", z);
	displayText(GLUT_BITMAP_HELVETICA_12,buffer);
}
void PilotDisplay::displayDirection(float x, float y, float z){
	char buffer[80];

	glRasterPos2f(0.85, -0.34);
	sprintf(buffer,"DIR");
	displayText(GLUT_BITMAP_HELVETICA_12,buffer);

	glRasterPos2f(0.81, -0.39);
	sprintf(buffer,"X: %.2f", x);
	displayText(GLUT_BITMAP_HELVETICA_12,buffer);

	glRasterPos2f(0.81, -0.44);
	sprintf(buffer,"Y: %.2f", y);
	displayText(GLUT_BITMAP_HELVETICA_12,buffer);
	
	glRasterPos2f(0.81, -0.49);
	sprintf(buffer,"Z: %.2f", z);
	displayText(GLUT_BITMAP_HELVETICA_12,buffer);
}
void PilotDisplay::displayHealth(int health){
	char buffer[80];
	glRasterPos2f(-0.14, 0.69);
	sprintf(buffer,"Health: %d",health);
	displayText(GLUT_BITMAP_HELVETICA_12,buffer);
}

