/*

  MessageHandler header

*/

#ifndef MESSAGEHANDLER_H
#define MESSAGEHANDLER_H

#define MAX_MESSAGE_LENGTH 32768

#include <winsock2.h>
#include <cstring>
#include <iostream>
#include "Message.h"

class MessageHandler {
public:
	MessageHandler();
	~MessageHandler();
	//These return formatted messages
	char *createLoginMessage(char*, char*);	//name, password
	char *createOPMessage(int, int, float[4][4], float[3]);
	char *createSCMessage(int, int, int);
	char *createEndGameMessage(int, int, int);
	char *createNewGameMessage(int, int, int, int ,int, int, int, char*);
	char *createGameListRequestMessage(int);
	char *createGameListMessage(char*);
	char *createGameJoinMessage(int, int, int);
	char *createGameExitMessage(int, int, int);
	//
	bool parseMessage(char*, Message &);

	float *parseOrientationAndPosition(char*);
	char *parseName(char*);
	char *parsePwd(char*);
	char *parseCreateGame();
	int parseState(char*);
private:
	char *formattedMessage;
	float *orientationAndPosition;
	char string[20];

};

#endif