/*

  Game class file

*/

#include "Game.h"

Game::Game(){
	inUse = false;
	numberofAIteams = 0;
	numberofAIplayers = 0;
	backgroundmusicon = true;
	soundeffectson = true;
}

void Game::InitializeNewGame(int tid, int t, int p, int a, char* name){
	dt = 0.001;
	id = tid;
	inUse = true;
	gameover = false;
	gamePort = 10041;
	numberofHumanteams = t;
	team = new Team[numberofHumanteams];
	numberofHumanplayers = p;
	arenatype = a;
	ZeroMemory(nameofgame, 50);
	strcpy(nameofgame, name);
	//setup arena
	arena.initializeArena();
	//setup teams
	char blue[] = "Blue";
	char red[] = "Red";
	team[0].InitializeTeam(0, p, "Blue");
	team[1].InitializeTeam(1, p, "Red");
	team[0].theShip.vPosition[0] = -2.0;
	team[0].theShip.vPosition[2] = 0.0;
	team[1].theShip.vPosition[0] = 2.0;
	team[1].theShip.vPosition[2] = 0.0;
	myShip = &team[tid].theShip;
	winner = -1;
}
void Game::endgame(int tid, bool lost){
	char buffer[80];
		
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(-1,1,-0.75,0.75);

	glMatrixMode(GL_MODELVIEW);
	glScalef(4.0, 4.0, 4.0);
	glRasterPos2f(-0.05,0.0);
	if(lost){
		sprintf(buffer, "You lost");
	}
	else {
		sprintf(buffer, "You Win");
	}	
	displayText(GLUT_BITMAP_HELVETICA_18, buffer);

}
void Game::displayText(void *font, char *str){
   int i,l = strlen(str);
   for(i=0;i<l;i++) glutBitmapCharacter(font,*str++);
}

void Game::ClearGame(){
	inUse = false;
	numberofAIteams = 0;
	numberofAIplayers = 0;
	numberofHumanteams = 0;
	numberofHumanplayers = 0;	
}
void Game::printMatrix(float m[4][4]){
	for (int i = 0; i < 4; i++){
		for (int j = 0; j < 4; j++){
			cout<<m[i][j]<<"  ";
		}
		cout<<endl;
	}
	cout<<endl;
}
void Game::renderGame(int tid, int position){	

/////////////////////////////////////////////////////////
	if (position == PILOT){
		glPushMatrix();			
			glMultMatrixf((GLfloat*) myShip->mOrientation);

			glRotatef(myShip->roll, 1, 0, 0);
			glRotatef(myShip->pitch, 0, 1, 0);
			glRotatef(myShip->yaw, 0, 0, 1);

			glGetFloatv(GL_MODELVIEW_MATRIX, (GLfloat*) myShip->mOrientation);
		glPopMatrix();
	}
//////////////////////////////////////////////////////////
	//setup where we look
	if (myShip->insideShip){
		gluLookAt(	myShip->vPosition[0], 
					myShip->vPosition[1], 
					myShip->vPosition[2], 
					myShip->vPosition[0]+myShip->mCamera[0][0], 
					myShip->vPosition[1]+myShip->mCamera[1][0], 
					myShip->vPosition[2]+myShip->mCamera[2][0],
					myShip->mCamera[0][2], 
					myShip->mCamera[1][2], 
					myShip->mCamera[2][2]);
	}
	else{
		gluLookAt(	myShip->vPosition[0]+1, 
					myShip->vPosition[1]+0.7, 
					myShip->vPosition[2]+0.5, 
					myShip->vPosition[0], 
					myShip->vPosition[1],
					myShip->vPosition[2],
					0.0, 0.0, 1.0	);
	}
	// draw the playing field
	glPushMatrix();		
		arena.drawArena();
	glPopMatrix();
	//draw their ship (always rendered from outside)
	team[1-tid].theShip.renderView();
	//draw our ship, this should be the last ship drawn
	myShip->renderView(position);	
	//if we have a winner
}

///////////////////////
// 
///////////////////////
int Game::checkforweaponstrike(int tid){
	//set lp to laser position 
	float lp[] = {(team[1-tid].theShip.vPosition[0] - team[1-tid].theShip.laser.pos[0]),
					(team[1-tid].theShip.vPosition[1] - team[1-tid].theShip.laser.pos[1]),
					(team[1-tid].theShip.vPosition[2] - team[1-tid].theShip.laser.pos[2])};
	float P[] = {(lp[0] - myShip->vPosition[0]),
					(lp[1] - myShip->vPosition[1]),
					(lp[2] - myShip->vPosition[2])};
	float L[] = {myShip->mCamera[0][0],
				 myShip->mCamera[1][0],
				 myShip->mCamera[2][0]};
	float lenL = sqrt(L[0]*L[0] + L[1]*L[1] + L[2]*L[2]);
	float LxP[] = { L[1]*P[2] - L[2]*P[1],
					L[0]*P[2] - L[2]*P[0],
					L[0]*P[1] - L[1]*P[0]};
	float lenLxP = sqrt(LxP[0]*LxP[0] + LxP[1]*LxP[1] + LxP[2]*LxP[2]);
	float D = lenLxP / lenL;
	cout<<"D = "<<D<<endl;
	if (D < 0.1) return 1;
	else return 0;
}
