/* 

  Arena source file

*/

#include "Arena.h"

Arena::Arena(int t){
	type = t;
}

Arena::initializeArena(){
	//initialize textures
	char bfile[] = "images\\background.bmp";
	background = new char[strlen(bfile) + 1];
	strcpy(background, bfile);
	tl.LoadBMP(g_Texture, background, 0);
	createStarField();
	starson = true;
	delete background;
}

Arena::drawArena(){
	switch(type){
	case 1:
		basicArena();
		break;
	case 2:
		break;
	default:
		break;
	}
}
Arena::basicArena(){

	glDisable(GL_CULL_FACE);
	int size = 1000;	
	glDisable(GL_TEXTURE_2D);
	//center sphere for reference
	glColor3f(1,1,1);
	GLUquadricObj* center = gluNewQuadric();
		gluQuadricDrawStyle(center, GLU_LINE);
		gluSphere(center, 0.05, 36, 18);	
	gluDeleteQuadric(center);
	glBindTexture(GL_TEXTURE_2D, g_Texture[0]);
	glEnable(GL_TEXTURE_2D);
	//outer sphere map
	GLUquadric* sphere = gluNewQuadric();
		gluQuadricTexture(sphere, GL_TRUE);
		glColor3f(0.71,0.31,0.75);
		glRotatef(90, 1,0,0);
		gluSphere(sphere, size, 36, 18);
	gluDeleteQuadric(sphere);
	glEnable(GL_CULL_FACE);
	glDisable(GL_TEXTURE_2D);
	//star field
	if (starson) glCallList(STARS);
		
}
Arena::createStarField(){

	glNewList(STARS, GL_COMPILE);
	srand(time(NULL));			//the server could pass the random seed to keep things the same
	int pointsize;
	for (int i = 0; i < 5000; i++) {
		glPushMatrix();
		glPushAttrib(GL_CURRENT_BIT);
		float Xtemp = ((float)rand() / 32768 * 2000) - 1000;
		float Ytemp = ((float)rand() / 32768 * 2000) - 1000;
		float Ztemp = ((float)rand() / 32768 * 2000) - 1000;
		pointsize = ((float)rand() / 32768 * 4) + 1;
		glPointSize(pointsize);	
		float Rtemp = ((float)rand() / 163840) + 0.6;
		float Gtemp = ((float)rand() / 163840) + 0.7;
		float Btemp = ((float)rand() / 327680) + 0.85;
		glColor3f(Rtemp, Gtemp, Btemp);
		glBegin(GL_POINTS);
			glVertex3f(Xtemp, Ytemp, Ztemp);
		glEnd();
		glPopAttrib();
		glPopMatrix();		
	}
	glEndList();
}