/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.sealdatatypes;

import java.util.ArrayList;

/**
 *
 * @author samuelgbeecher
 */
public class SealTagType extends SealDataType {
    private String name;
    private String description;
    private ArrayList<String> colors;

    public boolean hasColor(String color){
        return colors.contains(color);
    }

    public SealTagType(String nameIn){
        name = nameIn;
        colors = new ArrayList<String>();
    }

    public void addColor(String color){
        if(colors.contains(color))
            return;

        colors.add(color);
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the colors
     */
    public ArrayList<String> getColors() {
        return colors;
    }

    /**
     * @return the description
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    public void setDescription(String description) {
        this.description = description;
    }


}
