/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.sealdatatypes;

import android.text.format.DateFormat;
import java.util.ArrayList;
import java.util.Date;

/**
 *
 * @author samuelgbeecher
 */
public class SealObservation extends SealDataType {
    private static final long serialVersionUID = 2;

    private long id; // simple incremented int. Does not rely on anything particular
    private long datetime;

    private String observer; // FK
    private String island;
    private String rookery; // FK
    private String rookerySection;
    private String comments;

    private int sealNum; // This is not an fk, but rather a reference used by the observer. some int. required

    // there are several codes needed for observation
    private int visibilityCode;
    private int pupCode;
    private String age;

    private boolean confirmFirstTag; // was the observation information confirmed.
    private boolean confirmSecondTag;
    private boolean otherFlipperSeen, otherTagSeen;
    private boolean photosTaken;

    private Seal seal;

    public SealObservation(){
        id = -1;
        pupCode = -1;

    }


    /**
     * @return the id
     */
    public long getId() {
        return id;
    }

    public void setId(long newID){
        id = newID;
    }

    /**
     * @return the observer
     */
    public String getObserver() {
        return observer;
    }

    /**
     * @param observer the observer to set
     */
    public void setObserver(String observer) {
        this.observer = observer;
    }

    /**
     * @return the rookery
     */
    public String getRookery() {
        return rookery;
    }

    /**
     * @param rookery the rookery to set
     */
    public void setRookery(String rookery) {
        this.rookery = rookery;
    }

    /**
     * @return the comments
     */
    public String getComments() {
        return comments;
    }

    /**
     * @param comments the comments to set
     */
    public void setComments(String comments) {
        this.comments = comments;
    }

    /**
     * @return the sealNum
     */
    public int getSealNum() {
        return sealNum;
    }

    /**
     * @param sealNum the sealNum to set
     */
    public void setSealNum(int sealNum) {
        this.sealNum = sealNum;
    }

    /**
     * @return the visibilityCode
     */
    public int getVisibilityCode() {
        return visibilityCode;
    }

    /**
     * @param visibilityCode the visibilityCode to set
     */
    public void setVisibilityCode(int visibilityCode) {
        this.visibilityCode = visibilityCode;
    }

    /**
     * @return the pupCode
     */
    public int getPupCode() {
        return pupCode;
    }

    /**
     * @param pupCode the pupCode to set
     */
    public void setPupCode(int pupCode) {
        this.pupCode = pupCode;
    }

    /**
     * @return the age
     */
    public String getAge() {
        return age;
    }

    /**
     * @param age the age to set
     */
    public void setAge(String age) {
        this.age = age;
    }

    /**
     * @return the confirmed
     */
    public boolean isFirstTagConfirmed() {
        return confirmFirstTag;
    }

    /**
     * @param confirmed the confirmed to set
     */
    public void setFirstTagConfirmed(boolean confirmed) {
        this.confirmFirstTag = confirmed;
    }

    /**
     * @return the confirmed
     */
    public boolean isSecondTagConfirmed() {
        return confirmSecondTag;
    }

    /**
     * @param confirmed the confirmed to set
     */
    public void setSecondTagConfirmed(boolean confirmed) {
        this.confirmSecondTag = confirmed;
    }

    /**
     * @return the otherFlipperSeen
     */
    public boolean isOtherFlipperSeen() {
        return otherFlipperSeen;
    }

    /**
     * @param otherFlipperSeen the otherFlipperSeen to set
     */
    public void setOtherFlipperSeen(boolean otherFlipperSeen) {
        this.otherFlipperSeen = otherFlipperSeen;
    }

    /**
     * @return the photosTaken
     */
    public boolean isPhotosTaken() {
        return photosTaken;
    }

    /**
     * @param photosTaken the photosTaken to set
     */
    public void setPhotosTaken(boolean photosTaken) {
        this.photosTaken = photosTaken;
    }

    /**
     * @return the seal
     */
    public Seal getSeal() {
        return seal;
    }

    /**
     * @param seal the seal to set
     */
    public void setSeal(Seal seal) {
        this.seal = seal;
    }

    public boolean equals(Object o){
        if(o == this)
            return true;
        else if(o instanceof SealObservation){
            SealObservation obs = (SealObservation) o;
            return obs.getSealNum() == this.getSealNum();
        }
        else{
            return false;
        }
    }

    /**
     * @return the island
     */
    public String getIsland() {
        return island;
    }

    /**
     * @param island the island to set
     */
    public void setIsland(String island) {
        this.island = island;
    }

    /**
     * @return the datetime
     */
    public long getDatetime() {
        return datetime;
    }

    /**
     * @param datetime the datetime to set
     */
    public void setDatetime(long datetime) {
        this.datetime = datetime;

        if(seal != null){
            seal.setLastSeen(datetime);
        }
    }

    /**
     * @return the rookerySection
     */
    public String getRookerySection() {
        return rookerySection;
    }

    /**
     * @param rookerySection the rookerySection to set
     */
    public void setRookerySection(String rookerySection) {
        this.rookerySection = rookerySection;
    }

     /**
     * @return the otherTagSeen
     */
    public boolean isOtherTagSeen() {
        return otherTagSeen;
    }

    /**
     * @param otherTagSeen the otherTagSeen to set
     */
    public void setOtherTagSeen(boolean otherTagSeen) {
        this.otherTagSeen = otherTagSeen;
    }

    public String toString(){
        String info = "";

        info += "\nObserver: " + observer;
        info += "\nIsland: " + island;
        info += "\nRookery: " + rookery;
        info += "\nSection: " + rookerySection;
        info += "\nSeal Number: " + sealNum;
        info += seal.toString();
        info += "\nConfirm First Tag: " + confirmFirstTag;
        info += "\nConfirm Second Tag: " + confirmSecondTag;
        info += "\nAge: " + age;
        info += "\nPup Code: " + pupCode;
        info += "\nPhotos Taken: " + photosTaken;
        info += "\nComments: " + comments;

        return info;
    }

    public boolean equals(SealObservation obs){
        return obs.getObserver().equalsIgnoreCase(this.getObserver()) &&
                obs.getIsland().equalsIgnoreCase(this.getIsland()) &&
                obs.getRookery().equalsIgnoreCase(this.getRookery()) &&
                obs.getRookerySection().equalsIgnoreCase(this.getRookerySection()) &&
                obs.getSeal().equals(this.getSeal()) &&
                obs.getSealNum() == this.getSealNum() &&
                obs.getVisibilityCode() == this.getVisibilityCode() &&
                (obs.isOtherFlipperSeen() == this.isOtherFlipperSeen()) &&
                (obs.isOtherTagSeen() == this.isOtherTagSeen());
                //obs.getPupCode() == this.getPupCode();
    }

    /**
     * For observations with more than one tag, returned string is two records, one for each tag. 
     * @return the CSV representation of a single observation
     */
    public String toCSV(){
        CSVRecord record = new CSVRecord();

        record.addItem(seal.getId());
        record.addItem(island.toUpperCase());
        record.addItem(rookery.toUpperCase());
        record.addItem(rookerySection.toUpperCase());
        record.addItem(observer.toUpperCase());

        Date date = new Date();
        date.setTime(datetime * 1000);

        record.addItem(DateFormat.format("MM/dd/yy", date).toString());
        record.addItem(DateFormat.format("h:mm", date).toString());

        // unused fields in the excel sheet
        record.addBlank();
        record.addBlank();
        record.addBlank();
        record.addBlank();

        record.addItem(visibilityCode+"");

        SealTag first = seal.getFirstTag();
        SealTag second = seal.getSecondTag();
        CSVRecord copy = null;

        if(second != null){
            copy = new CSVRecord(record);
            copy.addItems(getTagInfo(second));
            copy.addItem((confirmSecondTag ? "Y" : "N"));
        }

        if(first != null){
            record.addItems(getTagInfo(first));
            record.addItem((confirmFirstTag ? "Y" : "N"));
        }

        ArrayList<String> extras = new ArrayList<String>();

        extras.add((otherFlipperSeen ? "Y" : "N"));
        extras.add((otherTagSeen ? "Y" : "N"));
        
        if(pupCode >= 0){
            extras.add(pupCode +"");
        }

        extras.add(pupCode+"");
        extras.add(seal.getSex()+"");
        extras.add((photosTaken ? "Y" : "N"));
        extras.add(comments);

        String secondRecord = "";
        if(copy != null){
            copy.addItems(extras);
            secondRecord += copy.getCSV();
        }
        
        record.addItems(extras);

        return record.getCSV() + secondRecord;
    }
    
    private ArrayList<String> getTagInfo(SealTag tag){
        ArrayList<String> list = new ArrayList<String>();

        String side;
        side = tag.getSide().charAt(0)+"";
        list.add(side);
        
        if(tag.getLossCode() < 0){
            list.add(tag.getType());
        }
        else{
            list.add(tag.getLossCode() + "");
        }
        
        String color = tag.getColor();
        
        if(color == null)
            color = " ";

        list.add(tag.getType() + tag.getNumber() + color.charAt(0));

        list.add(color);

        return list;
    }

    
}
