/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.sealdatatypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/**
 *
 * @author samuelgbeecher
 */
public class SealIsland extends SealDataType {
    private String name;
    private HashMap<String, Rookery> rookeries;

    public SealIsland(String nameIn){
        name = nameIn;
        rookeries = new HashMap<String, Rookery>();
    }

    public void addRookery(String name){
        rookeries.put(name, new Rookery(name));
    }

    public void addSection(String rookery, String section){
        Rookery rook = rookeries.get(rookery);
        rook.addSection(section);
    }

    public ArrayList<String> getRookeries(){
        ArrayList<String> rookeryList = new ArrayList<String>();

        Set keys = rookeries.keySet();

        for(Iterator itr = keys.iterator(); itr.hasNext(); ){
            rookeryList.add((String)itr.next());
        }

        return rookeryList;
    }

    public ArrayList<String> getSections(String rookery){
        Rookery rook = rookeries.get((String) rookery);
        return rook.sections;
    }

    public String getName(){
        return name;
    }

    class Rookery{
       private String name;
       private ArrayList<String> sections;

        public Rookery(String nameIn){
            name = nameIn;
            sections = new ArrayList<String>();
        }

        public void addSection(String section){
            if(sections.contains(section))
                return;

            sections.add(section);
        }

        public String getName(){
            return name;
        }

        public ArrayList<String> getSections(){
            return sections;
        }
    }


}
