/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.sealdatatypes;

import android.text.format.DateFormat;
import java.util.Date;

/**
 *
 * @author samuelgbeecher
 */
public class SealCount extends SealDataType {
    private static long serialVersionUID = 1;

    private long id;
    private long startEntryTime;
    private long endEntryTime;

    private String observer;
    private String rookery;
    private String island;
    private String rookerySection;

    private int liveLoneBullCount;
    private int liveTerrBullCount;
    private int liveHaremBullCount;
    private int liveFemaleCount;
    private int livePupCount;

    private int deadNonAdolescentCount;
    private int deadBullCount;
    private int deadFemaleCount;
    private int deadPupCount;

//    public SealCount(){
//        id = 0;
//        startEntryTime = 0;
//        endEntryTime = 0;
//        
//        observer = null;
//        rookery = null;
//        island = null;
//        rookerySection = null;
//        
//        
//     
//        
//    }

    public long getId(){
        return id;
    }

    public void setId(long newId){
        id = newId;
    }

    /**
     * @return the aliveLoneBullCount
     */
    public int getLiveLoneBullCount() {
        return liveLoneBullCount;
    }

    /**
     * @param aliveLoneBullCount the aliveLoneBullCount to set
     */
    public void setLiveLoneBullCount(int aliveLoneBullCount) {

        this.liveLoneBullCount = aliveLoneBullCount;
    }

    /**
     * @return the aliveTerrBullCount
     */
    public int getLiveTerrBullCount() {
        return liveTerrBullCount;
    }

    /**
     * @param aliveTerrBullCount the aliveTerrBullCount to set
     */
    public void setLiveTerrBullCount(int aliveTerrBullCount) {

        this.liveTerrBullCount = aliveTerrBullCount;
    }

    /**
     * @return the aliveHaremBullCount
     */
    public int getLiveHaremBullCount() {

        return liveHaremBullCount;
    }

    /**
     * @param aliveHaremBullCount the aliveHaremBullCount to set
     */
    public void setLiveHaremBullCount(int aliveHaremBullCount) {

        this.liveHaremBullCount = aliveHaremBullCount;
    }

    /**
     * @return the aliveFemaleCount
     */
    public int getLiveFemaleCount() {
        return liveFemaleCount;
    }

    /**
     * @param aliveFemaleCount the aliveFemaleCount to set
     */
    public void setLiveFemaleCount(int aliveFemaleCount) {

        this.liveFemaleCount = aliveFemaleCount;
    }

    /**
     * @return the alivePupCount
     */
    public int getLivePupCount() {
        return livePupCount;
    }

    /**
     * @param alivePupCount the alivePupCount to set
     */
    public void setLivePupCount(int alivePupCount) {

        this.livePupCount = alivePupCount;
    }

    /**
     * @return the deadNonAdolescentCount
     */
    public int getDeadNonAdolescentCount() {
        return deadNonAdolescentCount;
    }

    /**
     * @param deadNonAdolescentCount the deadNonAdolescentCount to set
     */
    public void setDeadNonAdolescentCount(int deadNonAdolescentCount) {

        this.deadNonAdolescentCount = deadNonAdolescentCount;
    }

    /**
     * @return the deadBullCount
     */
    public int getDeadBullCount() {
        return deadBullCount;
    }

    /**
     * @param deadBullCount the deadBullCount to set
     */
    public void setDeadBullCount(int deadBullCount) {
        this.deadBullCount = deadBullCount;
    }

    /**
     * @return the deadFemaleCount
     */
    public int getDeadFemaleCount() {
        return deadFemaleCount;
    }

    /**
     * @param deadFemaleCount the deadFemaleCount to set
     */
    public void setDeadFemaleCount(int deadFemaleCount) {
        this.deadFemaleCount = deadFemaleCount;
    }

    /**
     * @return the deadPupCount
     */
    public int getDeadPupCount() {
        return deadPupCount;
    }

    /**
     * @param deadPupCount the deadPupCount to set
     */
    public void setDeadPupCount(int deadPupCount) {
        this.deadPupCount = deadPupCount;
    }

    /**
     * @return the observer
     */
    public String getObserver() {
        return observer;
    }

    /**
     * @param observer the observer to set
     */
    public void setObserver(String observer) {
        this.observer = observer;
    }

    /**
     * @return the rookery
     */
    public String getRookery() {
        return rookery;
    }

    /**
     * @param rookery the rookery to set
     */
    public void setRookery(String rookery) {
        this.rookery = rookery;
    }

    /**
     * @return the island
     */
    public String getIsland() {
        return island;
    }

    /**
     * @param island the island to set
     */
    public void setIsland(String island) {
        this.island = island;
    }

    /**
     * @return the section
     */
    public String getRookerySection() {
        return rookerySection;
    }

    /**
     * @param section the section to set
     */
    public void setRookerySection(String section) {
        this.rookerySection = section;
    }

    /**
     * @return the startDatetime
     */
    public long getStartEntryTime() {
        return startEntryTime;
    }

    /**
     * @param startDatetime the startDatetime to set
     */
    public void setStartEntryTime(long startDatetime) {
        this.startEntryTime = startDatetime;
    }

    /**
     * @return the endDatetime
     */
    public long getEndEntryTime() {
        return endEntryTime;
    }

    /**
     * @param endDatetime the endDatetime to set
     */
    public void setEndEntryTime(long endDatetime) {
        this.endEntryTime = endDatetime;
    }


    public boolean isEmpty(){
        return liveLoneBullCount == 0 && liveTerrBullCount == 0 && liveHaremBullCount == 0 && liveFemaleCount == 0 && livePupCount == 0 &&
                deadNonAdolescentCount == 0 && deadBullCount == 0 && deadFemaleCount == 0 && deadPupCount == 0;
    }

    public String toCSV(){
        CSVRecord record = new CSVRecord();
        
        record.addItem(island.toUpperCase());
        record.addItem(rookery.toUpperCase());
        record.addItem(rookerySection.toUpperCase());
        record.addBlank();
        record.addItem(observer.toUpperCase());

        Date date = new Date(this.startEntryTime*1000);

        record.addItem(DateFormat.format("MM/dd/yy", date).toString());
        record.addItem(DateFormat.format("h:mm", date).toString());

        date.setTime(this.endEntryTime * 1000);
        record.addItem(DateFormat.format("h:mm", date).toString());

        record.addItem(liveLoneBullCount + "");
        record.addItem(liveTerrBullCount + "");
        record.addItem(liveHaremBullCount + "");
        record.addItem(liveFemaleCount + "");
        record.addItem(livePupCount + "");
        record.addItem(deadPupCount + "");
        record.addItem(deadFemaleCount + "");
        record.addItem(deadBullCount + "");
        record.addItem(deadNonAdolescentCount + "");

        return record.getCSV();
    }
 
}

