/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.sealdatatypes;

import java.io.Serializable;

/**
 *
 * @author samuelgbeecher
 */
public class Seal extends SealDataType implements Serializable{
       

	private String id; //pk
	private SealTag firstTag; //fk
	private SealTag secondTag; //fk
	private String sex; // 
        private long lastSeen; // Date Time

	public Seal(){
            setId("");
            setFirstTag(null);
            setSecondTag(null);
            setSex("female");
	}


	public void setSex(String newSex) {
            sex = newSex;
	}


	public String getSex() {
            return sex;
	}


	public void setSecondTag(SealTag newSecondTag) {
            if(newSecondTag != null)
                newSecondTag.setSealId(this.getId());
            
            secondTag = newSecondTag;
	}


	public SealTag getSecondTag() {
            return secondTag;
	}


	public void setFirstTag(SealTag newFirstTag) {
            if(newFirstTag != null)
                newFirstTag.setSealId(this.getId());
            
            firstTag = newFirstTag;
	}


	public SealTag getFirstTag() {
            return firstTag;
	}

        public SealTag getLeftTag() {
            if(firstTag != null && firstTag.getSide().toUpperCase().charAt(0) == 'L')
            {
                return firstTag;
            }
            else if(secondTag != null && secondTag.getSide().toUpperCase().charAt(0) == 'L')
            {
                return secondTag;
            }
            else
            {
                return null;
            }
        }

        public SealTag getRightTag() {
            if(firstTag != null && firstTag.getSide().toUpperCase().charAt(0) == 'R')
            {
                return firstTag;
            }
            else if(secondTag != null && secondTag.getSide().toUpperCase().charAt(0) == 'R')
            {
                return secondTag;
            }
            else
            {
                return null;
            }
        }

	public void setId(String newId) {
            id = newId;

            if(firstTag != null)
                firstTag.setSealId(newId);

            if(secondTag != null)
                secondTag.setSealId(newId);
	}


	public String getId() {
            return id;
	}

	public Seal copy() {
            Seal hardCopy = new Seal();

            hardCopy.setSex(this.getSex());
            hardCopy.setSecondTag(this.getSecondTag());
            hardCopy.setFirstTag(this.getFirstTag());
            hardCopy.setId(this.getId());

            return hardCopy;
	}

    /**
     * @return the lastSeen
     */
    public long getLastSeen() {
        return lastSeen;
    }

    /**
     * @param lastSeen the lastSeen to set
     */
    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
    }



    public boolean equals(Object obj){
        boolean result = false;
        if(obj == null){
            return false;
        }
        else if(obj instanceof Seal){
            Seal seal = (Seal)obj;
            boolean returnVal = //seal.getId().equalsIgnoreCase(this.getId()) &&
                ((seal.getFirstTag() != null && seal.getFirstTag().equals(this.getFirstTag())) || (seal.getFirstTag() == this.getFirstTag())) &&
                seal.getSex().equalsIgnoreCase(this.getSex()) &&
                ((seal.getSecondTag() != null && seal.getSecondTag().equals(this.getSecondTag())) || (seal.getSecondTag() == this.getSecondTag()));
            return returnVal;
        }
        else{
            return false;
        }
    }

    public String toString(){
        String info = "";

        info += "\nID: " + id;
        info += "\nSex: " + sex;
        info += "\nLast Seen: " + lastSeen;

        if(firstTag != null)
            info += "\nFirst Tag - > " + firstTag.toString();

        if(secondTag != null)
            info += "\nSecond Tag - > " + secondTag.toString();

        return info;
    }


}
