/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.sealdatatypes;

import java.util.ArrayList;

/**
 *
 * @author samuelgbeecher
 */
public class CSVRecord {
    public static final String BLANK = "";

    private ArrayList<String> csvData;

    public CSVRecord(){
        csvData = new ArrayList<String>();
    }

    public CSVRecord(CSVRecord record){
        csvData = new ArrayList<String>(record.getItemList());
    }

    public void addItem(String item){
        csvData.add(item);
    }

    public void addItems(ArrayList<String> items){
        csvData.addAll(items);
    }

    public void addItems(CSVRecord generator){
        csvData.addAll(generator.getItemList());
    }

    public void addBlank(){
        csvData.add(BLANK);
    }

    public ArrayList getItemList(){
        return csvData;
    }

    public void clear(){
        csvData = new ArrayList<String>();
    }

    public String getCSV(){
        String csv = "";

        if(!csvData.isEmpty()){
            csv += csvData.get(0);
            for(int i = 1; i < csvData.size(); i++){
                 csv += "," + csvData.get(i);
            }
        }

        csv += "/n";

        return csv;
    }

}
