/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.database;

import android.content.ContentValues;
import android.database.Cursor;
import org.me.sealproject.sealdatatypes.SealTag;

/**
 *
 * @author samuelgbeecher
 */
public class Tags extends SealBaseColumns{
    public static final String NAME = "Tag";

    public static final String ID = "id"; // pk string

    public static final String NUMBER = "number";

    /** FK String. Second Column. */
    public static final String SEAL_ID = "sealId";
    /** String. Third Column. */
    public static final String SIDE = "side"; // character
    /** int. Fourth Column. */
    public static final String TYPE= "type"; // fk int
    /** String. Fifth Column. */
    public static final String COLOR="color"; // string
    /** int. Sixth Column. */
    public static final String LOST = "lossCode"; // fk int


    public static final String CREATE_TAG_TABLE = "CREATE TABLE "+NAME+" ("
                                                    +ID+" INTEGER PRIMARY KEY AUTOINCREMENT, "
                                                    +NUMBER+" TEXT NOT NULL, "
                                                    +TYPE+" TEXT NOT NULL, "
                                                    +COLOR+" TEXT, " // color is not required. but is used in the identifier. Interesting... 
                                                    +SEAL_ID+" TEXT NOT NULL, "
                                                    +SIDE+" TEXT NOT NULL, "
                                                    +LOST+" INTEGER);";

    
     public static final String TRIGGER_DELETE = "fk_delete_tag";
     public static final String TRIGGER_ADD = "fk_insert_tag";
     public static final String TRIGGER_UPDATE = "fk_update_tag";

     /** Apply Foreign Key constraint on sealId */
     public static final String CREATE_TRIGGER_ADD = "CREATE TRIGGER "+TRIGGER_ADD+" BEFORE INSERT ON "+NAME+" FOR EACH ROW BEGIN  "
             + "SELECT RAISE(ROLLBACK, 'insert on table \""+NAME+"\" violates foreign key constraint \""+SEAL_ID+"\"') WHERE  "
             + "(SELECT "+Seals.ID+" FROM "+Seals.NAME+" WHERE "+Seals.ID+" = NEW."+SEAL_ID+") IS NULL; "
             + "END;";

     /** Restrict Update */
     public static final String CREATE_TRIGGER_UPDATE = "CREATE TRIGGER "+TRIGGER_UPDATE+" BEFORE UPDATE ON "+NAME+" FOR EACH ROW BEGIN  "
             + "SELECT RAISE(ROLLBACK, 'update on table \""+NAME+"\" violates foreign key constraint \""+SEAL_ID+"\"') WHERE  "
             + "(SELECT "+Seals.ID+" FROM "+Seals.NAME+" WHERE "+Seals.ID+" = NEW."+SEAL_ID+") IS NULL; "
             + "END;";

     /** Restrict Delete. This is currently not used as Observations are not required to be consistent in their data */
//      public static final String CREATE_TRIGGER_DELETE = "CREATE TRIGGER "+TRIGGER_DELETE+" BEFORE DELETE ON "+NAME+" FOR EACH ROW BEGIN  "
//             + "SELECT RAISE(ROLLBACK, 'delete on table \""+NAME+"\" violates foreign key constraint \""+Observations.FIRST_TAG+"\"') WHERE  "
//             + "(SELECT "+Observations.FIRST_TAG+" FROM "+Observations.NAME+" WHERE "+Observations.FIRST_TAG+" = OLD."+ID+") IS NOT NULL; "
//             + "SELECT RAISE(ROLLBACK, 'delete on table \""+NAME+"\" violates foreign key constraint \""+Observations.SECOND_TAG+"\"') WHERE  "
//             + "(SELECT "+Observations.SECOND_TAG+" FROM "+Observations.NAME+" WHERE "+Observations.SECOND_TAG+" = OLD."+ID+") IS NOT NULL; "
//             + "END;";

      
     public static ContentValues getValuesFromData(SealTag tag){
        ContentValues values = new ContentValues();

        if(tag.getSealId() == null)
            return null;

        values.put(NUMBER, tag.getNumber());
        values.put(SEAL_ID, tag.getSealId());
        values.put(SIDE, tag.getSide());
        values.put(TYPE, tag.getType());
        values.put(LOST, tag.getLossCode());
        
        if(tag.getColor() == null || tag.getColor().length() < 1)
            values.put(COLOR, "none");
        else
            values.put(COLOR, tag.getColor());

        return values;
    }

     public static SealTag getDataFromCursor(Cursor c){
        SealTag tag = new SealTag();
        
        tag.setNumber(c.getString(c.getColumnIndex(Tags.NUMBER)));
        tag.setColor(c.getString(c.getColumnIndex(Tags.COLOR)));
        tag.setSealId(c.getString(c.getColumnIndex(Tags.SEAL_ID)));
        tag.setType(c.getString(c.getColumnIndex(Tags.TYPE)));
        tag.setSide(c.getString(c.getColumnIndex(Tags.SIDE)));

        if(!c.isNull(c.getColumnIndex(Tags.LOST))){
            tag.setLossCode(c.getInt(c.getColumnIndex(Tags.LOST)));
        }

        return tag;
     }
}
