/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.database;

import android.content.ContentValues;
import android.database.Cursor;
import org.me.sealproject.sealdatatypes.SealCount;
import org.me.sealproject.sealdatatypes.SealDataType;

/**
 *
 * @author samuelgbeecher
 */
public class Counts extends SealBaseColumns {
    public static final String NAME = "Count";

    /** PK int AutoIncrement. First Column. */
    public static final String ID = "id";

    /** Date (int). Second Column. */
    public static final String START_ENTRY_TIME = "startEntryDateTime";

    /** Date (int). Third Column */
    public static final String END_ENTRY_TIME = "endEntryDateTime";

    /** String. Fourth Column. */
    public static final String OBSERVER = "observer";

    /** String. Firth Column. */
    public static final String ISLAND = "island";

    /** String. Sixth Column. */
    public static final String ROOKERY = "rookery";
    /** int. Seventh Column. */
    public static final String ROOKERY_SECTION = "rookerySection";

    /** int. Eighth Column. */
    public static final String LIVE_TERRITORIAL_BULLS = "aliveTerrBulls";
    /** int. Ninth Column. */
    public static final String LIVE_LONE_BULLS = "aliveLoneBulls";
    /** int. Tenth Column. */
    public static final String LIVE_HAREM_BULLS = "aliveHaremBulls";

    /** int. Eleventh Column. */
    public static final String LIVE_FEMALES = "aliveFemals";
    /** int. Twelfth Column. */
    public static final String LIVE_PUPS = "alivePups";

    /** int. Thirteenth Column. */
    public static final String DEAD_NONADOLESCENT = "deadNonadolescent";
    /** int. Fourteenth Column. */
    public static final String DEAD_BULLS = "deadBulls";
    /** int. Fifteenth Column. */
    public static final String DEAD_FEMALES = "deadFemals";
    /** int. Sixteenth Column. */
    public static final String DEAD_PUPS = "deadPups";

    public static final String CREATE_COUNT_TABLE = "CREATE TABLE "+NAME+" ("
                                                    +ID+                       " INTEGER PRIMARY KEY AUTOINCREMENT, "
                                                    +START_ENTRY_TIME+         " INTEGER NOT NULL, "
                                                    +END_ENTRY_TIME+           " INTEGER NOT NULL, "
                                                    +OBSERVER+                 " TEXT NOT NULL, "
                                                    +ISLAND+                   " TEXT NOT NULL, "
                                                    +ROOKERY+                  " TEXT NOT NULL, "
                                                    +ROOKERY_SECTION+          " TEXT NOT NULL, "
                                                    +LIVE_TERRITORIAL_BULLS+   " INTEGER, "
                                                    +LIVE_LONE_BULLS+          " INTEGER, "
                                                    +LIVE_HAREM_BULLS+         " INTEGER, "
                                                    +LIVE_FEMALES+             " INTEGER, "
                                                    +LIVE_PUPS+                " INTEGER, "
                                                    +DEAD_NONADOLESCENT+       " INTEGER, "
                                                    +DEAD_BULLS+               " INTEGER, "
                                                    +DEAD_FEMALES+             " INTEGER, "
                                                    +DEAD_PUPS+                " INTEGER);";
    /*
     *  public static final String TRIGGER_ADD = "fk_insert_count";
        public static final String TRIGGER_UPDATE = "fk_update_count";

        

        public static final String CREATE_TRIGGER_ADD = "CREATE TRIGGER "+TRIGGER_ADD+" BEFORE INSERT ON "+COUNT_TABLE+" FOR EACH ROW BEGIN "
                + "SELECT RAISE(ROLLBACK, 'insert on table \""+COUNT_TABLE+"\" violates constraint \"Harem Bulls must have females\"') WHERE"
                + "((NEW."+CountColumns.LIVE_HAREM_BULLS+" > 0) AND (NEW."+CountColumns.LIVE_FEMALES+" <= 0));"
                + "END;";

        public static final String CREATE_TRIGGER_UPDATE = "CREATE TRIGGER "+TRIGGER_UPDATE+" BEFORE UPDATE ON "+COUNT_TABLE+" FOR EACH ROW BEGIN "
                + "SELECT RAISE(ROLLBACK, 'insert on table \""+COUNT_TABLE+"\" violates constraint \"Harem Bulls must have females\"') WHERE"
                + "NEW."+CountColumns.LIVE_HAREM_BULLS+" > 0 AND NEW."+CountColumns.LIVE_FEMALES+" <= 0;"
                + "END;";
     *                                                
     */

//    public static ContentValues getValuesForData(SealCount count){
//
//        ContentValues values = new ContentValues();
//
//        values.put(OBSERVER, count.getObserver());
//        values.put(ISLAND, count.getIsland());
//        values.put(ROOKERY, count.getRookery());
//        values.put(ROOKERY_SECTION, count.getRookerySection());
//        values.put(START_ENTRY_TIME, count.getStartEntryTime());
//        values.put(END_ENTRY_TIME, count.getEndEntryTime());
//        values.put(LIVE_LONE_BULLS, count.getLiveLoneBullCount());
//        values.put(LIVE_TERRITORIAL_BULLS, count.getLiveTerrBullCount());
//        values.put(LIVE_HAREM_BULLS, count.getLiveHaremBullCount());
//        values.put(LIVE_FEMALES, count.getLiveFemaleCount());
//        values.put(LIVE_PUPS, count.getLivePupCount());
//        values.put(DEAD_NONADOLESCENT, count.getDeadNonAdolescentCount());
//        values.put(DEAD_BULLS, count.getDeadBullCount());
//        values.put(DEAD_FEMALES, count.getDeadFemaleCount());
//        values.put(DEAD_PUPS, count.getDeadPupCount());
//
//        return values;
//    }

    
    public static ContentValues getValuesFromData(SealCount count) {
        ContentValues values = new ContentValues();

        values.put(OBSERVER, count.getObserver());
        values.put(ISLAND, count.getIsland());
        values.put(ROOKERY, count.getRookery());
        values.put(ROOKERY_SECTION, count.getRookerySection());
        values.put(START_ENTRY_TIME, count.getStartEntryTime());
        values.put(END_ENTRY_TIME, count.getEndEntryTime());
        values.put(LIVE_LONE_BULLS, count.getLiveLoneBullCount());
        values.put(LIVE_TERRITORIAL_BULLS, count.getLiveTerrBullCount());
        values.put(LIVE_HAREM_BULLS, count.getLiveHaremBullCount());
        values.put(LIVE_FEMALES, count.getLiveFemaleCount());
        values.put(LIVE_PUPS, count.getLivePupCount());
        values.put(DEAD_NONADOLESCENT, count.getDeadNonAdolescentCount());
        values.put(DEAD_BULLS, count.getDeadBullCount());
        values.put(DEAD_FEMALES, count.getDeadFemaleCount());
        values.put(DEAD_PUPS, count.getDeadPupCount());

        return values;
    }

     public static SealCount getDataFromCursor(Cursor c){
        SealCount count = new SealCount();

        count.setLiveHaremBullCount((c.getInt(c.getColumnIndex(Counts.LIVE_HAREM_BULLS))));
        count.setLiveLoneBullCount((c.getInt(c.getColumnIndex(Counts.LIVE_LONE_BULLS))));
        count.setLiveTerrBullCount((c.getInt(c.getColumnIndex(Counts.LIVE_TERRITORIAL_BULLS))));
        count.setLiveFemaleCount((c.getInt(c.getColumnIndex(Counts.LIVE_FEMALES))));
        count.setLivePupCount((c.getInt(c.getColumnIndex(Counts.LIVE_PUPS))));

        count.setDeadBullCount((c.getInt(c.getColumnIndex(Counts.DEAD_BULLS))));
        count.setDeadFemaleCount((c.getInt(c.getColumnIndex(Counts.DEAD_FEMALES))));
        count.setDeadPupCount((c.getInt(c.getColumnIndex(Counts.DEAD_PUPS))));
        count.setDeadNonAdolescentCount((c.getInt(c.getColumnIndex(Counts.DEAD_NONADOLESCENT))));

        count.setStartEntryTime((c.getInt(c.getColumnIndex(Counts.START_ENTRY_TIME))));
        count.setEndEntryTime((c.getInt(c.getColumnIndex(Counts.END_ENTRY_TIME))));
        
        count.setObserver((c.getString(c.getColumnIndex(Counts.OBSERVER))));
        count.setIsland((c.getString(c.getColumnIndex(Counts.ISLAND))));
        count.setRookery((c.getString(c.getColumnIndex(Counts.ROOKERY))));
        count.setRookerySection((c.getString(c.getColumnIndex(Counts.ROOKERY_SECTION))));

        return  count;
     }
}
