/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.customwidgets;

import android.content.Context;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.*;

import org.me.sealproject.R;

/**
 *
 * @author samuelgbeecher
 */
public class SealValidationRow extends TableRow implements OnClickListener {
    private TextView firstValue, secondValue;
    private Button changeButton;

    private String actualFirst, actualSecond, label;
    private boolean changed;

    private OnClickListener listener;

    private int rowValidationType;


    public SealValidationRow(Context context, String label, String firstValue, String secondValue){
        super(context);
        initialize(label, firstValue, secondValue);
    }

    public SealValidationRow(Context context){
        super(context);
        initialize(null, null, null);
    }

    public SealValidationRow(Context context, AttributeSet attrs){
        super(context, attrs);
        initialize(null, null, null);
    }

    private void initialize(String labelIn, String firstValueIn, String secondValueIn){
        super.setLayoutParams(new LayoutParams(LayoutParams.WRAP_CONTENT,LayoutParams.FILL_PARENT));

        label = labelIn;
        
        actualFirst = firstValueIn;
        actualSecond = secondValueIn;

        firstValue = new TextView(this.getContext());
        firstValue.setText(firstValueIn);
        firstValue.setLayoutParams(super.getLayoutParams());
        firstValue.setTextAppearance(this.getContext(), R.style.validation_row_style);
        firstValue.setGravity(Gravity.CENTER);
        addView(firstValue);

        secondValue = new TextView(getContext());
        secondValue.setText(secondValueIn);
        secondValue.setLayoutParams(super.getLayoutParams());
        secondValue.setTextAppearance(this.getContext(), R.style.validation_row_style);
        secondValue.setGravity(Gravity.CENTER);
        addView(secondValue);

        changeButton = new Button(getContext());
        changeButton.setText(" Change ");
        changeButton.setTextSize(16);
        changeButton.setOnClickListener(this);
        changeButton.setLayoutParams(new LayoutParams(74, LayoutParams.WRAP_CONTENT));
        changeButton.setGravity(Gravity.CENTER);
        addView(changeButton);

        changed =  false;
    }

    @Override
    public void setOnClickListener(OnClickListener newListener){
        listener = newListener;
    }

    public void onClick(View v) {
        if(changed){
            changeButton.setText(" Change ");
            changed =  false;
            firstValue.setText(actualFirst);
        }
        else{
            changeButton.setText("Unchange");
            changed = true;
            firstValue.setText(actualSecond);
        }

        if(listener != null)
            listener.onClick(this);
    }

    public String getFirstValue(){
        return firstValue.getText().toString();
    }

    public String getSecondValue(){
        return secondValue.getText().toString();
    }

    public String getChangedValue(){
        return firstValue.getText().toString();
    }

    public boolean isChanged(){
        return changed;
    }

    public int getValidationType(){
        return rowValidationType;
    }

    public void setValidationType(int type){
        rowValidationType = type;
    }

    public String getLabel(){
        return label;
    }
}
