/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.customwidgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.text.Editable;
import android.text.InputType;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.widget.*;

import org.me.sealproject.R;

/**
 * ViewGroup provides functionality for handling a tally counter. Manually entry is allowed.
 * Simple control.
 * @author samuelgbeecher
 */
public class Counter extends LinearLayout {

    public static String DEBUG = "Counter";

    private TextView label;
    private Button increment, decrement; 
    private EditText currentCount;

    private int width;

    private int maxCount;
    private int minCount;

    private boolean hasMax;
    private boolean hasMin;

    private TextWatcher watcher;

    public Counter(Context context, String labelText){
        super(context);
        setupCounter(context, labelText, 18, 64);
        this.setOrientation(LinearLayout.VERTICAL);

        //this.setLayoutParams(new LayoutParams(64,100));
    }

    public Counter(Context context, AttributeSet attr){
       super(context, attr);

       TypedArray parsedAttr = context.getResources().obtainAttributes(attr, R.styleable.Counter);
       
       String labelText = parsedAttr.getString(R.styleable.Counter_label);
       // Log.d("custom activity debug", label + "");
       float width = parsedAttr.getDimension(R.styleable.Counter_width, 113.0f);
       float labelSize = parsedAttr.getDimension(R.styleable.Counter_labelSize, 18);
       
       setupCounter(context, labelText, (int)labelSize, (int)width);
    }

    private void setupCounter(Context context, String labelText, int labelSize, int width){
        label = new TextView(context);
        label.setText(labelText);
        label.setTypeface(Typeface.DEFAULT_BOLD);
        label.setGravity(Gravity.CENTER);
        label.setTextSize(labelSize);
        label.setLayoutParams(new LayoutParams(width, 55));
        this.addView(label);

        increment = new Button(context);
        increment.setGravity(Gravity.CENTER);
        increment.setText("+");
        increment.setTextSize(30);
        increment.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
        increment.setOnClickListener(new IncrementListener());
        increment.setLayoutParams(new LayoutParams(width, 56));
        
        this.addView(increment);

        currentCount = new EditText(context);

        currentCount.setText("0");
        currentCount.setTextSize(30);
        currentCount.setTypeface(Typeface.DEFAULT_BOLD);
        currentCount.setGravity(Gravity.CENTER);
        //currentCount.setRawInputType(InputType.TYPE_CLASS_NUMBER | InputType.TYPE_NUMBER_FLAG_SIGNED);
        currentCount.setInputType(InputType.TYPE_CLASS_NUMBER | InputType.TYPE_NUMBER_FLAG_DECIMAL);
        currentCount.setLayoutParams(new LayoutParams(width, 56));
        watcher = new CurrentCountTextWatcher();
        currentCount.addTextChangedListener(watcher);
        this.addView(currentCount);

        decrement = new Button(context);
        decrement.setGravity(Gravity.CENTER);
        decrement.setText("-");
        decrement.setTextSize(30);
        decrement.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
        decrement.setOnClickListener(new DecrementListener());
        decrement.setLayoutParams(new LayoutParams(width, 56));
        this.addView(decrement);

        hasMax = false;
        hasMin = false;
    }

    public void setMaxCount(int max){
        hasMax = true;
        maxCount = max;

        if(minCount > maxCount && hasMin){
            int tmp = minCount;
            minCount = maxCount;
            maxCount = tmp;
        }
    }

    public void setMinCount(int min){
        hasMin = true;
        minCount = min;

        if(minCount > maxCount && hasMax){
            int tmp = minCount;
            minCount = maxCount;
            maxCount = tmp;
        }

    }

    public void disableMax(){
        hasMax = false;
    }

    public void disableMin(){
        hasMin = false;
    }

    public void setCount(int value){
        if(hasMax){
            if(value > maxCount){
                value = maxCount;
            }
        }

        if(hasMin){
            if(value < minCount){
                value = minCount;
            }
        }

        // Removing the listener prevents an infinite loop due to callbacks.
        currentCount.removeTextChangedListener(watcher);
        currentCount.setText(value + "");
        currentCount.addTextChangedListener(watcher);
    }

    class IncrementListener implements OnClickListener{
        public void onClick(View arg0) {
            int value = ((Integer.parseInt(currentCount.getText().toString()) + 1));
            setCount(value);
        }
    }

    class DecrementListener implements OnClickListener{
        public void onClick(View arg0) {
            int value = (Integer.parseInt(currentCount.getText().toString()) - 1);
            setCount(value);
        }
    }

    class CurrentCountTextWatcher implements TextWatcher{

        public void beforeTextChanged(CharSequence arg0, int arg1, int arg2, int arg3) {}
        public void onTextChanged(CharSequence arg0, int arg1, int arg2, int arg3) {}

        public void afterTextChanged(Editable arg0) {
            setCount(getCount());
        }
    }

    public void clear(){
        currentCount.setText("0");
    }

    public int getCount(){
        int count;
        String text = currentCount.getText().toString();

        if(text.length() > 0)
        {
            count = Integer.parseInt(text);
        }
        else
        {
            count = 0;
        }

        return count;
    }
}
