/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.datacontrollers.xmlhandler;

import android.util.Log;
import org.me.sealproject.sealdatatypes.*;
import org.xml.sax.Attributes;

/**
 *
 * @author samuelgbeecher
 */
public class SealIDHandler extends SealXmlHandler {

    public static final String SEAL_ELEMENT_SEAL = "Seal";
    public static final String SEAL_ELEMENT_TAG = "Tag";

    public static String SEAL_ATTRIBUTE_ID = "id";
    public static String SEAL_ATTRIBUTE_SEX = "sex";
    public static String SEAL_ATTRIBUTE_LASTSEEN = "lastSeen";

    public static String TAG_ATTRIBUTE_ID = "number";
    public static String TAG_ATTRIBUTE_SIDE = "side";
    public static String TAG_ATTRIBUTE_COLOR = "color";
    public static String TAG_ATTRIBUTE_TYPE = "type";
    
    @Override
    public void startElement(String elementName, Attributes attributes) {
        if(elementName.equals(SEAL_ELEMENT_SEAL)){
            Seal seal = getSealFromAttributes(attributes);

           // LOG("Seal Id = " + seal.getId());

            putIntoMap(seal.getId(), seal);
            pushOntoStack(seal);
        }
        else if(elementName.equals(SEAL_ELEMENT_TAG)){
            SealTag tag = getTagFromAttributes(attributes);
            
            // Stack will have only one tag at a time on it.
            Seal tmp = (Seal)topOfStack();
            pushOntoStack(tag);

            if(tmp.getFirstTag() == null){
                tmp.setFirstTag(tag);
            }
            else{
                tmp.setSecondTag(tag);
            }

             //LOG("Seal Tag = " + tag);
        }
    }

    @Override
    public void endElement(String elementName){
        popFromStack();
    }

    private Seal getSealFromAttributes(Attributes attributes){
        Seal seal = new Seal();

        seal.setId(attributes.getValue(SEAL_ATTRIBUTE_ID));
        seal.setSex(attributes.getValue(SEAL_ATTRIBUTE_SEX));
        seal.setLastSeen(Long.parseLong(attributes.getValue(SEAL_ATTRIBUTE_LASTSEEN)));

        return seal;
    }

    private SealTag getTagFromAttributes(Attributes attributes){
        SealTag tag = new SealTag();

        tag.setNumber(attributes.getValue(TAG_ATTRIBUTE_ID));
        
        
        //LOG("Tag Side = " + attributes.getValue(TAG_ATTRIBUTE_SIDE));

        tag.setSide(attributes.getValue(TAG_ATTRIBUTE_SIDE));

        tag.setType(attributes.getValue(TAG_ATTRIBUTE_TYPE));
        tag.setColor(attributes.getValue(TAG_ATTRIBUTE_COLOR));

        return tag;
    }


}
