/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.activitycontrollers;

import android.os.Bundle;
import org.me.sealproject.activities.sealintents.SealValidationIntent;
import android.view.View;
import android.view.View.OnClickListener;

import java.util.ArrayList;

import org.me.sealproject.R;
import org.me.sealproject.activities.*;
import org.me.sealproject.customwidgets.*;
import org.me.sealproject.sealdatatypes.*;

/**
 *
 * @author samuelgbeecher
 */
public class SealValidationActivityController extends SealActivityController{

    /** The key for the input seal to be validated. */
    public static final String INPUT_SEAL_KEY = "targetSealForValidation";
    public static final String INPUT_COMPARISON_KEY = "targetComparisonForValidation";
    public static final String INPUT_VALIDATION_ROWS_KEY = "sealValidationRows";
    public static final String OUTPUT_VALIDATION_ERROR_COMMENTS_KEY = "errorComments";

    /** The entered tag reads lost, but the comparison tag does not */
    public static final int FIRST_NOT_LOST = 0;
    public static final int FIRST_LOST = 1;
    public static final int FIRST_TYPE_MISMATCH = 2;
    public static final int FIRST_COLOR_MISMATCH = 3;
    public static final int FIRST_SIDE_MISMATCH = 4;
    public static final int FIRST_NUMBER_MISMATCH = 5;

    public static final int SECOND_NOT_LOST = 10;
    public static final int SECOND_LOST = 11;
    public static final int SECOND_TYPE_MISMATCH = 12;
    public static final int SECOND_COLOR_MISMATCH = 13;
    public static final int SECOND_SIDE_MISMATCH = 14;
    public static final int SECOND_NUMBER_MISMATCH = 15;

    public static final int SEAL_SEX_MISMATCH = 20;
    
    public static final int SEAL = -1;
    public static final int FIRST_TAG = -2;
    public static final int SECOND_TAG = -3;

    public static final int VALIDATION_RESULT_OK = SealActivity.RESULT_OK;
    public static final int VALIDATION_RESULT_CANCELED = SealActivity.RESULT_CANCELED;
    public static final int VALIDATION_RESULT_NEED_FIRST_TAG_COLOR = SealActivity.RESULT_FIRST_USER + 1;
    public static final int VALIDATION_RESULT_NEED_FIRST_TAG_TYPE = SealActivity.RESULT_FIRST_USER + 2;
    public static final int VALIDATION_RESULT_NEED_SECOND_TAG_COLOR = SealActivity.RESULT_FIRST_USER + 3;
    public static final int VALIDATION_RESULT_NEED_SECOND_TAG_TYPE = SealActivity.RESULT_FIRST_USER + 4;

    private Seal targetSeal, compSeal;
    private ArrayList<String> errorComments;
    private ArrayList<SealTagType> types;
    
    public SealValidationActivityController(SealValidationActivity act){
        super(act);
    }

    @Override
    public void onStart(){
        //TODO: Handle special cases for seal validation activity
        // 1. SealTagType cannot have the specified color after changing it to the database. (return to the form to request color) 
        // 2. If changed from lost to a tag type, must enter a color (i.e. return to the form)
        // 3.

        SealValidationIntent intent = (SealValidationIntent)dataController.getCustomIntent();

        errorComments = new ArrayList<String>();
        types = dataController.getTypes();

        targetSeal = intent.getTargetSeal();
        compSeal = intent.getCompSeal();

        ArrayList<SealValidationRow> rows = (ArrayList<SealValidationRow>)intent.getList();//getSealDataExtra(INPUT_VALIDATION_ROWS_KEY);

      //  SealValidationRow[] rows = (SealValidationRow[])intent.getSealDataExtra(INPUT_VALIDATION_ROWS_KEY);

        if(targetSeal == null || compSeal == null || rows == null){
            LOG("ERROR. Validation given null values:\nTarget Seal = " + targetSeal + "\ncomparisonSeal = " + compSeal + "\nrows = " + rows);
            activity.finish();
            return;
        }


        setupValidation(rows);

        activity.findViewById(R.id.validation_confirm_button).setOnClickListener(new OnConfirmClicked());
        activity.findViewById(R.id.validation_cancel_button).setOnClickListener(new OnCancelClicked());
    }

    public void setupValidation(ArrayList<SealValidationRow> rows){
        SealValidationTable table = (SealValidationTable)activity.findViewById(R.id.validation_table);
        table.setDrawGrid(true);

        for(SealValidationRow row : rows){
            table.addRow(row);
            errorComments.add("#ERROR COMMENT# " + row.getLabel());
        }
    }

    /**
     * Returns the result code for the activity based on changed data. 
     * @param target
     * @return
     */
    private int setSealData(Seal target){
        SealValidationTable table = (SealValidationTable)activity.findViewById(R.id.validation_table);
        ArrayList<SealValidationRow> rows = table.getRows();

        int resultCode = VALIDATION_RESULT_OK;

        SealTag first = target.getFirstTag();
        SealTag second = target.getSecondTag();
        int index = 0;
        for(SealValidationRow row : rows){
            if(row.isChanged()){
                switch(row.getValidationType()){
                    case FIRST_NOT_LOST:
                        if(row.getChangedValue().length() > 0 && Character.isDigit(row.getChangedValue().charAt(0)))
                            second.setLossCode(Integer.parseInt(row.getChangedValue()));
                        else{
                            second.setType(row.getChangedValue());
                            resultCode = VALIDATION_RESULT_NEED_FIRST_TAG_COLOR;
                        }
                        break;
                    case FIRST_LOST:
                        if(row.getChangedValue().length() > 0 && Character.isDigit(row.getChangedValue().charAt(0)))
                            first.setLossCode(Integer.parseInt(row.getChangedValue()));
                        else
                            first.setType(row.getChangedValue());
                        break;
                    case FIRST_TYPE_MISMATCH:
                        first.setType(row.getChangedValue());

                        if(first.getColor() == null || !tagTypeHasColor(first.getType(), first.getColor())){
                            resultCode = VALIDATION_RESULT_NEED_FIRST_TAG_COLOR;
                        }
                        break;
                    case FIRST_COLOR_MISMATCH:
                        first.setColor(row.getChangedValue());
                        
                        if(first.getType() == null || !tagTypeHasColor(first.getType(), first.getColor())){
                            resultCode = VALIDATION_RESULT_NEED_FIRST_TAG_TYPE;
                        }
                        break;
                    case FIRST_SIDE_MISMATCH:
                        first.setSide(row.getChangedValue());
                        break;
                    case FIRST_NUMBER_MISMATCH:
                        first.setNumber(row.getChangedValue());
                        break;
                    case SECOND_NOT_LOST:
                        if(row.getChangedValue().length() > 0 && Character.isDigit(row.getChangedValue().charAt(0)))
                            second.setLossCode(Integer.parseInt(row.getChangedValue()));
                        else{
                            second.setType(row.getChangedValue());
                            resultCode = VALIDATION_RESULT_NEED_SECOND_TAG_COLOR;
                        }
                        break;
                    case SECOND_LOST:
                        if(row.getChangedValue().length() > 0 && Character.isDigit(row.getChangedValue().charAt(0)))
                            second.setLossCode(Integer.parseInt(row.getChangedValue()));
                        else
                            second.setType(row.getChangedValue());
                        break;
                    case SECOND_TYPE_MISMATCH:
                        second.setType(row.getChangedValue());

                        if(second.getColor() == null || !tagTypeHasColor(second.getType(), second.getColor())){
                            resultCode = VALIDATION_RESULT_NEED_SECOND_TAG_COLOR;
                        }
                        break;
                    case SECOND_COLOR_MISMATCH:
                        //TODO: Check
                        second.setColor(row.getChangedValue());

                        if(second.getType() == null || !tagTypeHasColor(second.getType(), second.getColor())){
                            resultCode = VALIDATION_RESULT_NEED_SECOND_TAG_TYPE;
                        }
                        break;
                    case SECOND_SIDE_MISMATCH:
                        second.setSide(row.getChangedValue());
                        break;
                    case SECOND_NUMBER_MISMATCH:
                        second.setNumber(row.getChangedValue());
                        break;
                    case SEAL_SEX_MISMATCH:
                        target.setSex(row.getChangedValue());
                        break;
                    default:
                        break;
                }
                
                String error = errorComments.get(index);
                error += ": Changed to Match Database.";
                errorComments.set(index, error);
            }
            else{
                String error = errorComments.get(index);
                error += ": Not Changed.";
                errorComments.set(index, error);
                
            }

            index++;
        }


        return resultCode;
    }

    public boolean tagTypeHasColor(String tagType, String color){
        if(types != null){
            
            SealTagType foundTagType = null;
            for(SealTagType type : types){
                if(type.getName().equalsIgnoreCase(tagType)){
                    foundTagType = type;
                    break;
                }
            }

            return foundTagType.hasColor(color);
        }
        else{
            return true;
        }
    }

    class OnConfirmClicked implements OnClickListener{

        public void onClick(View arg0) {
            SealValidationIntent intent = new SealValidationIntent();

            int resultCode = setSealData(targetSeal);

            intent.setTargetSeal(targetSeal);

            Bundle bundle = new Bundle();
            bundle.putStringArrayList(OUTPUT_VALIDATION_ERROR_COMMENTS_KEY, errorComments);
            intent.putExtras(bundle);

            dataController.setCustomIntent(intent);

            activity.setResult(resultCode, intent);
            activity.finish();
        }
    }

    class OnCancelClicked implements OnClickListener{

        public void onClick(View arg0) {
            SealValidationIntent intent = new SealValidationIntent();

            Bundle bundle = new Bundle();
            bundle.putStringArrayList(OUTPUT_VALIDATION_ERROR_COMMENTS_KEY, errorComments);
            intent.putExtras(bundle);

            dataController.setCustomIntent(intent);
            
            activity.setResult(VALIDATION_RESULT_CANCELED, intent);
            activity.finish();
        }
    }
}
