/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers.activitycontrollers;

import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.HashMap;

import org.me.sealproject.*;
import org.me.sealproject.activities.*;
import org.me.sealproject.activities.sealintents.SealIntent;
import org.me.sealproject.controllers.datacontrollers.*;
import org.me.sealproject.sealdatatypes.*;

/**
 *
 * @author samuelgbeecher
 */
public class SealLookupActivityController extends SealActivityController {
    public static final String REQUEST_CODE = "reqestCode";

    public static final int REQUEST_CODE_COUNT = 0;
    public static final int REQUEST_CODE_OBSERVATION = 1;

    public static final int RESULT_CODE_NO_DATA = -1;


    public static final String LOOKUP_OBSERVATION_MAP_KEY_SEALNUM = "sealNumber";
    public static final String LOOKUP_OBSERVATION_MAP_KEY_SEALSEX = "sealSex";
    public static final String LOOKUP_OBSERVATION_MAP_KEY_LEFTTAG = "leftTag";
    public static final String LOOKUP_OBSERVATION_MAP_KEY_RIGHTTAG = "rightTag";


    public static final String LOOKUP_COUNT_MAP_KEY_INDEX = "index";
    public static final String LOOKUP_COUNT_MAP_KEY_LONE_BULL = "loneBull";
    public static final String LOOKUP_COUNT_MAP_KEY_TERR_BULL= "terrBull";
    public static final String LOOKUP_COUNT_MAP_KEY_HAREM_BULL = "haremBull";
    public static final String LOOKUP_COUNT_MAP_KEY_FEMALE_ALIVE = "femaleLive";
    public static final String LOOKUP_COUNT_MAP_KEY_PUP_ALIVE = "pupLive";
    public static final String LOOKUP_COUNT_MAP_KEY_ADULT_DEAD = "adultDead";
    public static final String LOOKUP_COUNT_MAP_KEY_BULL_DEAD = "bullDead";
    public static final String LOOKUP_COUNT_MAP_KEY_FEMALE_DEAD = "femaleDead";
    public static final String LOOKUP_COUNT_MAP_KEY_PUP_DEAD = "pupDead";

    private SimpleAdapter adapter;
    private SealDataType[] sealDataArray;

    public SealLookupActivityController(SealLookupActivity activity){
        super(activity);
    }

    @Override
    public void onStart(){
        Intent intent = getActivityIntent();

        int requestCode = intent.getIntExtra(REQUEST_CODE, REQUEST_CODE_COUNT);

        adapter = null;


        if(requestCode == REQUEST_CODE_COUNT){
            adapter = createCountLookupAdapter();

            activity.findViewById(R.id.lookup_count_header).setVisibility(View.VISIBLE);
            activity.findViewById(R.id.lookup_observation_header).setVisibility(View.GONE);
            ((TextView)(activity.findViewById(R.id.lookup_header_text))).setText("Previous Counts");
            activity.setTitle("Lookup Counts");

            activity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);

            LOG("Displaying Previous Counts");
        }
        else if(requestCode == REQUEST_CODE_OBSERVATION){
            adapter = createObservationLookupAdapter();
            
            activity.findViewById(R.id.lookup_observation_header).setVisibility(View.VISIBLE);
            activity.findViewById(R.id.lookup_count_header).setVisibility(View.GONE);
            ((TextView)(activity.findViewById(R.id.lookup_header_text))).setText("Previous Observations");
            activity.setTitle("Lookup Observations");

            activity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);

            LOG("Displaying Previous Observations");
        }


        if(adapter != null){
            ListView listView = setupListView(adapter);
            listView.setOnItemClickListener(new OnListItemClickedListener());
        }
        else{
            LOG("No data Found For Lookup");
            // Return error code, "No Data"
        }
    }

    /**************************************************************************
     *                             SETUP LISTVIEW                             *
     *************************************************************************/

    private ListView setupListView(SimpleAdapter adapter){
        ListView listView = (ListView)activity.findViewById(R.id.lookup_listview);
        
        listView.setAdapter(adapter);

        return listView;
    }


    /**************************************************************************
     *                             SETUP COUNT LOOKUP                         *
     *************************************************************************/

    private SimpleAdapter createCountLookupAdapter(){
        sealDataArray = getCountsFromDatabase();

        if(sealDataArray != null){
            ArrayList list = convertCountArrayToList((SealCount[])sealDataArray);

            adapter = new SimpleAdapter(activity,
                    list,
                    R.layout.lookup_count_item,
                    new String[]{"index", "loneBull", "terrBull", "haremBull", "femaleLive", "pupLive", "adultDead", "bullDead", "femaleDead", "pupDead"},
                    new int[]{R.id.lookup_count_index, R.id.lookup_count_lonebull, R.id.lookup_count_terrbull, R.id.lookup_count_harembull, R.id.lookup_count_female_live, R.id.lookup_count_pup_live,
                              R.id.lookup_count_nonadolescent, R.id.lookup_count_bull_dead, R.id.lookup_count_female_dead, R.id.lookup_count_pup_dead});

            return adapter;
        }
        else{
            return null;
        }
    }

    private SealCount[] getCountsFromDatabase(){
        SealDatabaseController db = dataController.getDatabaseController();
        db.openOrCreateDatabase();

        SealCount[] counts = null;
        if(db.isOpen()){
            counts = db.getCountsOnDate(System.currentTimeMillis()/1000);

            db.close();
        }

        return counts;
    }

    private ArrayList<HashMap<String, String>> convertCountArrayToList(SealCount[] array){
        ArrayList countList = new ArrayList();


        for(int i = 0; i < array.length; i++){
            HashMap map = getMapForCount(array[i]);
            map.put(LOOKUP_COUNT_MAP_KEY_INDEX, i+1);

            countList.add(map);
        }

        return countList;
    }

    private HashMap<String, String> getMapForCount(SealCount count){
        HashMap<String, String> map = new HashMap();

        map.put(LOOKUP_COUNT_MAP_KEY_LONE_BULL, count.getLiveLoneBullCount() +"");
        map.put(LOOKUP_COUNT_MAP_KEY_TERR_BULL, count.getLiveTerrBullCount() +"");
        map.put(LOOKUP_COUNT_MAP_KEY_HAREM_BULL, count.getLiveHaremBullCount() +"");
        map.put(LOOKUP_COUNT_MAP_KEY_FEMALE_ALIVE, count.getLiveFemaleCount() +"");
        map.put(LOOKUP_COUNT_MAP_KEY_PUP_ALIVE, count.getLivePupCount() +"");
        map.put(LOOKUP_COUNT_MAP_KEY_ADULT_DEAD, count.getDeadNonAdolescentCount() +"");
        map.put(LOOKUP_COUNT_MAP_KEY_BULL_DEAD, count.getDeadBullCount() +"");
        map.put(LOOKUP_COUNT_MAP_KEY_FEMALE_DEAD, count.getDeadFemaleCount() +"");
        map.put(LOOKUP_COUNT_MAP_KEY_PUP_DEAD, count.getDeadPupCount() +"");

        return map;

    }

    /**************************************************************************
     *                       SETUP OBSERVATION LOOKUP                         *
     *************************************************************************/


    private SimpleAdapter createObservationLookupAdapter(){
        sealDataArray = getObservationsFromDatabase();

        if(sealDataArray != null){
            ArrayList list = convertObservationArrayToList((SealObservation[])sealDataArray);

            adapter = new SimpleAdapter(activity, 
                    list,
                    R.layout.lookup_observation_item,
                    new String[]{"sealNumber", "sealSex", "leftTag", "rightTag"},
                    new int[]{R.id.lookup_observation_sealnum, R.id.lookup_observation_sealsex, R.id.lookup_observation_lefttagid, R.id.lookup_observation_righttagid});

            return adapter;
        }
        else{
            return null;
        }
    }

    private SealObservation[] getObservationsFromDatabase(){
        SealDatabaseController db = dataController.getDatabaseController();
        db.openOrCreateDatabase();

        SealObservation[] obs = null;
        if(db.isOpen()){
            obs = db.getObservationsOnDate(System.currentTimeMillis()/1000);

            db.close();
        }

        return obs;
    }

    private ArrayList<HashMap<String, String>> convertObservationArrayToList(SealObservation[] array){
        ArrayList<HashMap<String, String>> observationsList = new ArrayList<HashMap<String, String>>();

        for(int i = 0; i < array.length; i++){
            HashMap map = getMapForObservation(array[i]);
            observationsList.add(map);
        }

        return observationsList;
    }

    private HashMap<String, String> getMapForObservation(SealObservation observation){
        HashMap<String, String> map = new HashMap<String, String>();

        String number = observation.getSealNum() + "";
        map.put(LOOKUP_OBSERVATION_MAP_KEY_SEALNUM, number);

        Seal seal = observation.getSeal();

        String sex = seal.getSex();
        map.put(LOOKUP_OBSERVATION_MAP_KEY_SEALSEX, sex);

        SealTag leftTag = seal.getLeftTag();

        if(leftTag != null){
            String leftTagNum = null;
            
            if(leftTag.getLossCode() < 0){
                leftTagNum = leftTag.getType() + leftTag.getNumber();

                if(leftTag.getColor() != null && leftTag.getColor().length() > 0){
                    leftTagNum += leftTag.getColor().charAt(0);
                }
            }
            else{
                leftTagNum = "Lost";//leftTag.getLossCode() + "";
            }

            map.put(LOOKUP_OBSERVATION_MAP_KEY_LEFTTAG, leftTagNum);
        }
        else{

            map.put(LOOKUP_OBSERVATION_MAP_KEY_LEFTTAG, "");
        }



        SealTag rightTag = seal.getRightTag();

        if(rightTag != null){
            String rightTagNum = null;

            if(rightTag.getLossCode() < 0){
                rightTagNum = rightTag.getType() + rightTag.getNumber();

                if(rightTag.getColor() != null && rightTag.getColor().length() > 0){
                    rightTagNum += rightTag.getColor().charAt(0);
                }
            }
            else{
                rightTagNum = "Lost";//rightTag.getLossCode() + "";
            }

            map.put(LOOKUP_OBSERVATION_MAP_KEY_RIGHTTAG, rightTagNum);
        }
        else{
            map.put(LOOKUP_OBSERVATION_MAP_KEY_RIGHTTAG, "");
        }

        return map;
    }

    class OnListItemClickedListener implements OnItemClickListener {

        public void onItemClick(AdapterView<?> adapter, View viewClicked, int index, long id) {
            SealIntent customIntent = new SealIntent();

            ArrayList list = new ArrayList();

            LOG("Item " + index + " selected in the list view");

            list.add(sealDataArray[index]);

            customIntent.setList(list);

            dataController.setCustomIntent(customIntent);

            activity.setResult(SealActivity.RESULT_OK, new Intent());
//            if(activity.getParent() == null)
//                 activity.setResult(SealActivity.RESULT_OK, new Intent());
//            else
//                activity.getParent().setResult(SealActivity.RESULT_OK, customIntent);

            
            
            activity.finish();
        }
    }
}
