/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.controllers;

import android.app.Activity;
import android.content.*;
import android.util.Log;
import android.view.*;
import android.widget.*;

import org.me.sealproject.R;
import org.me.sealproject.SealLogger;

/**
 *
 * @author samuelgbeecher
 */
public class SealController extends Activity implements SealLogger {
    public static final String DEBUG = "CONTROLLER DEBUG";

    protected Context context;

    public SealController(Context context){
        this.context = context;
    }

    /**
     * Log the message to the console. This is disabled by SealLogger debug variable. Used specifically for debugging.
     * It is recommended to have all calls to Log.d be done through this interface as in future factorings, these could
     * be stored to an internal document for post debugging of a system error.
     * @param message - message to log. 
     */
    public void LOG(String message){
        if(debug){
            Log.d(DEBUG, message);
        }
    }

    /**
     * Log an error message to the device. This is convenient. Future editions could include logging this to an internal debugging document.
     * Errors are always logged, regardless of debugging status.
     * @param message - error message to display
     * @param e - Throwable exception.
     */
    public void ERROR(String message, Throwable e){
        
        Log.e(DEBUG, message, e);
        
    }

    /**
     * Display a simple toast message with no formatting. This is specifically for debugging purposes.
     * Can be disabled by changing the SealLogger debug variable.
     * @param message - Message to display.
     */
    public void TOAST_DEBUG(String message){
        if(debug){
            Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
        }
    }

    /**
     * Present the custom Toast Message to the user. This will always be shown to the user, regardless of debugging status. Use only if message is pertinent to user, do not use to debug.
     * Instead us TOAST_DEBUG.
     * @param message - Message to be displayed
     * @param activity - activity displaying it
     */
    public void TOAST_USER(String message, Activity activity){
        LayoutInflater inflater = (LayoutInflater)context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View layout = inflater.inflate(R.layout.toast_layout, (ViewGroup) activity.findViewById(R.id.toast_layout_root));

        ImageView image = (ImageView) layout.findViewById(R.id.image);
        image.setImageResource(R.drawable.fur_seal_icon);
        TextView text = (TextView) layout.findViewById(R.id.text);
        text.setText(message);

        Toast toast = new Toast(context);
        toast.setGravity(Gravity.CENTER_VERTICAL, 0, 0);
        toast.setDuration(Toast.LENGTH_SHORT);
        toast.setView(layout);
        toast.show();
    }

    /**
     * @return The time in seconds since Jan 1, 1970 as per the system.
     */
    public long TIME(){
        LOG("Time is " + System.currentTimeMillis()/1000);
        return System.currentTimeMillis()/1000;
    }

    /**
     * Time is adjusted by returning only the number of seconds pass until the given day, rather than the given time in the day. 
     * @return The adjusted time in seconds since Jan 1, 1970 as per the System Clock.
     */
    public long DAY(){
        long time = TIME();
        // Remove from the time all extraneous seconds
        time -= time % (24*60*60);

        return time;
    }
    
}
