/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.activities;

import android.content.Intent;
import android.os.Bundle;
import android.text.InputFilter;
import android.view.*;
import android.view.MenuItem.OnMenuItemClickListener;
import android.widget.*;

import java.util.ArrayList;

import org.me.sealproject.*;
import org.me.sealproject.controllers.activitycontrollers.*;
import org.me.sealproject.customwidgets.*;
import org.me.sealproject.sealdatatypes.*;


/**
 * @author samuelgbeecher
 */
public class SealObservationActivity extends SealActivity{

    private TextView observer;
    private TextView island;
    private TextView rookery;
    private DefaultSpinner rookerySection;
    
    private DefaultSpinner visibility;
    private EditText sealNumber;

    private ButtonGroup firstSide;
    private ComboSpinner firstType;
    private DefaultSpinner firstColor;
    private EditText firstTagNumber;
    private CheckBox firstConfirm;

    private CheckBox otherTagSeen, otherFlipperSeen;

    private ButtonGroup secondSide;
    private ComboSpinner secondType;
    private DefaultSpinner secondColor;
    private EditText secondTagNumber;
    private CheckBox secondConfirm;

    private ButtonGroup upperAgeButtons, lowerAgeButtons;
    private DefaultSpinner pupCode;
    private ButtonGroup sex;

    private CheckBox photosTaken;
    private EditText comments;

    private ArrayList<SealTagType> types;

    /********** BEGIN ACTIVITY LIFECYCLE ******************/

    @Override
    protected void initController() {
        controller = new SealObservationActivityController(this);
    }


     /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle icicle) {
        
        //OnTypeSelectedListener typeSpinnerListener = new OnTypeSelectedListener();

        setContentView(R.layout.observation_entry_form);

        observer = ((TextView) findViewById(R.id.observation_observer_text));
        island = ((TextView) findViewById(R.id.observation_island_text));
        rookery = ((TextView) findViewById(R.id.observation_rookery_text));
        rookerySection = ((DefaultSpinner) findViewById(R.id.observation_section_spinner));
        
        visibility = ((DefaultSpinner) findViewById(R.id.observation_visibility_spinner));
        sealNumber = ((EditText) findViewById(R.id.observation_seal_number_autocomplete));
        firstSide = ((ButtonGroup) findViewById(R.id.observation_tag_side_group_top));

        firstType = ((ComboSpinner) findViewById(R.id.observation_tag_type_spinner_top));
        firstType.setOnItemSelectedListener(new OnTypeSelectedListener());

        firstColor = ((DefaultSpinner) findViewById(R.id.observation_tag_color_spinner_top));

        firstTagNumber =((EditText) findViewById(R.id.observation_tag_number_autocomplete_top));
        firstTagNumber.setFilters(new InputFilter[]{ new InputFilter.AllCaps()} );

        firstConfirm = ((CheckBox) findViewById(R.id.observation_tag_confirmed_checkbox_top));

        otherTagSeen = ((CheckBox) findViewById(R.id.observation_tag_other_seen_checkbox));
        otherFlipperSeen = ((CheckBox) findViewById(R.id.observation_tag_flipper_seen_checkbox));
        secondSide = ((ButtonGroup) findViewById(R.id.observation_tag_side_group_bottom));

        secondType = ((ComboSpinner) findViewById(R.id.observation_tag_type_spinner_bottom));
        secondType.setOnItemSelectedListener(new OnTypeSelectedListener());

        secondColor = ((DefaultSpinner) findViewById(R.id.observation_tag_color_spinner_bottom));

        secondTagNumber = ((EditText) findViewById(R.id.observation_tag_number_autocomplete_bottom));
        secondTagNumber.setFilters(new InputFilter[]{ new InputFilter.AllCaps() } );
        
       
        secondConfirm = ((CheckBox) findViewById(R.id.observation_tag_confirmed_checkbox_bottom));

        upperAgeButtons = ((ButtonGroup) findViewById(R.id.observation_seal_age_group_upper));
        lowerAgeButtons = ((ButtonGroup) findViewById(R.id.observation_seal_age_group_lower));

        pupCode = ((DefaultSpinner) findViewById(R.id.observation_seal_pup_code_spinner));
        photosTaken = ((CheckBox) findViewById(R.id.observation_photos_checkbox));
        sex = ((ButtonGroup) findViewById(R.id.observation_seal_sex_group));
        comments = ((EditText) findViewById(R.id.observation_comment_edittext));
        
        super.onCreate(icicle);
    }

    @Override
    public void onStart(){
        super.onStart();
        ((RadioButton)findViewById(R.id.observation_tag_side_right_radio_bottom)).setChecked(true);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);

        final Intent observationIntent = new Intent(this, SealLookupActivity.class);
        observationIntent.putExtra(SealLookupActivityController.REQUEST_CODE, SealLookupActivityController.REQUEST_CODE_OBSERVATION);
        observationIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        observationIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);

        menu.add("Previous Observations")
                .setIcon(android.R.drawable.ic_menu_edit)
                .setOnMenuItemClickListener(new OnMenuItemClickListener(){
                    public boolean onMenuItemClick(MenuItem item) {
                        startActivityForResult(observationIntent, SealObservationActivityController.LOOKUP_ACTIVITY_REQUEST_CODE);
                        return true;
                    }
        });


        return true;
    }

    /*
     * Return null if invalid values found
     */
    public SealObservation getObservation(){
        SealObservation obs = new SealObservation();

        obs.setObserver(getObserver());
        obs.setIsland(getIsland());
        obs.setRookery(getRookery());
        obs.setRookerySection(getRookerySection());

        obs.setVisibilityCode(getVisibility());
        obs.setSealNum(getSealNumber());

        obs.setSeal(getSeal());
        
        obs.setOtherFlipperSeen(getOtherFlipperSeen());
        obs.setOtherTagSeen(getOtherTagSeen());

        obs.setFirstTagConfirmed(isFirstTagConfirmed());
        obs.setSecondTagConfirmed(isSecondTagConfirmed());

        obs.setPupCode(getPupCode());
        obs.setAge(getAge());
        obs.setPhotosTaken(werePhotosTaken());
        obs.setComments(getComments());

        return obs;
    }

    /*
     * Set the entire observation sheet based on a previous observation
     */
    public void setObservation(SealObservation obs){
        this.resetForm();
        
        setRookerySection(obs.getRookerySection());
        setVisibility(obs.getVisibilityCode());

        setSeal(obs.getSeal());
        
        setFirstTagConfirmed(obs.isFirstTagConfirmed());
        setSecondTagConfirmed(obs.isSecondTagConfirmed());

        setPupCode(obs.getPupCode());
        setAge(obs.getAge());
        setPhotosTaken(obs.isPhotosTaken());
        setComments(obs.getComments());
    }

    /*
     * Get the forms seal.
     * This is inclusive of the seals number.
     */
    public Seal getSeal(){
        Seal seal = new Seal();

        SealTag t = getFirstTag();
        seal.setFirstTag(t);
        seal.setSecondTag(getSecondTag());

        seal.setSex(getSex());

        return seal;
    }

    /*
     * Set the forms Seal, this includes first and second tag as well as sex.
     *
     */
    public void setSeal(Seal seal){
        LOG(">>>>>>>>>>");
        LOG(seal.toString());
        LOG("<<<<<<<<<<");
        
        setFirstTag(seal.getFirstTag());
        if(seal.getSecondTag() != null)
        {
            setSecondTag(seal.getSecondTag());
        }

        setSex(seal.getSex());
    }

    /*
     * Get the forms first tag.
     * This tag is assumed to be entered.
     */
    public SealTag getFirstTag(){
        SealTag firstTag = new SealTag();

        firstTag.setSide(getFirstSide());
        firstTag.setType(getFirstType());
        firstTag.setColor(getFirstColor());
        firstTag.setLossCode(getFirstLossCode());
        firstTag.setNumber(getFirstTagNumber());

        return firstTag;
    }

    /**
     * Set the first tag seen data to the given data
     * @param firstTag
     */
    public void setFirstTag(SealTag firstTag){
        if(firstTag == null){
            return;
        }

        setFirstSide(firstTag.getSide());        

        if(firstTag.getType() != null){
//            OnTypeSelectedListener listener = (OnTypeSelectedListener)firstType.getOnItemSelectedListener();
//            firstType.setEnabled(false);
//            listener.enabled = false;
            // Temp Listener simple catches this unwanted event
            firstType.setOnItemSelectedListener(new TempListener());
            setFirstType(firstTag.getType());
//            listener.enabled = true;
//            firstType.setEnabled(true);

            setColors(firstTag.getType(), firstColor);

            // Because color is dependent on type, it is actually set in the controller when a type is selected.
            // Setting it here has odd results. Selection is changed, but not visible (i.e. default selection is set to visible).

            setFirstColor(firstTag.getColor());
        }

        if(firstTag.getLossCode() >= 0)
            setFirstLossCode(firstTag.getLossCode());

        setFirstTagNumber(firstTag.getNumber());
    }

    /*
     * Get forms second tag.
     * If other tag is marked as not seen, the tag is not set.
     */
    public SealTag getSecondTag(){
        if(!otherTagSeen.isChecked() && !otherFlipperSeen.isChecked()){
            return null;
        }

        SealTag secondTag = new SealTag();

        secondTag.setSide(getFirstSide().equalsIgnoreCase("left") ? "Right" : "Left");
        secondTag.setType(getSecondType());
        secondTag.setColor(getSecondColor());
        secondTag.setLossCode(getSecondLossCode());
        secondTag.setNumber(getSecondTagNumber());

        return secondTag;
    }

    /*
     * Set the forms second tag.
     * If  given Tag is null, tag is not set.
     */
    public void setSecondTag(SealTag secondTag){
        if(secondTag == null){
            return;
        }

        setOtherTagVisibility(View.VISIBLE);

        setOtherTagSeen(true);

        if(secondTag.getType() != null){
//            OnTypeSelectedListener listener = (OnTypeSelectedListener)secondType.getOnItemSelectedListener();
//            listener.enabled = false;
//            secondType.setEnabled(false);
            secondType.setOnItemSelectedListener(new TempListener());
            setSecondType(secondTag.getType());
//            listener.enabled = true;
//            secondType.setEnabled(true);
            
            setColors(secondTag.getType(), secondColor);

            // Because color is dependent on type, it is actually set in the controller when a type is selected.
            // Setting it here has odd results. Selection is changed, but not visible (i.e. default selection is set to visible).
            
            setSecondColor(secondTag.getColor());
           
        }
        
        if(secondTag.getLossCode() >= 0)
            setSecondLossCode(secondTag.getLossCode());
        
        setSecondTagNumber(secondTag.getNumber());
    }

    public void resetForm(){
        resetFirstTag();
        resetSecondTag();
        resetBottom();
    }

    public void resetBottom(){
        setAge("Unk");
        pupCode.resetToDefaultText();
        setSex("U");
        setPhotosTaken(false);
        setComments("");
    }

    public void resetFirstTag(){
        setFirstTagNumber("");
        setFirstType(null);
        //firstType.setSelection(null);
        firstColor.resetToDefaultText();
        firstSide.uncheckAll();
        firstConfirm.setChecked(false);
    }

    public void resetSecondTag(){
        clearOtherTag();
        setSecondType(null);
        //secondType.setSelection(null);
        //secondType.resetToDefaultText();
        secondColor.resetToDefaultText();
        secondSide.uncheckAll();
        secondConfirm.setChecked(false);
        setSecondTagNumber("");
    }

    public void setFirstTagColorAndNumberVisibility(int visibilityCode){
        findViewById(R.id.observation_tag_color_row_top).setVisibility(visibilityCode);
        findViewById(R.id.observation_tag_number_row_top).setVisibility(visibilityCode);
    }

    public void setSecondTagColorAndNumberVisibility(int visibilityCode){
        findViewById(R.id.observation_tag_color_row_bottom).setVisibility(visibilityCode);
        findViewById(R.id.observation_tag_number_row_bottom).setVisibility(visibilityCode);
    }

    /*
     * Set the visibility of the second tag
     */
    public void setOtherTagVisibility(int viewVisibilityCode){
         findViewById(R.id.observation_tag_type_row_bottom).setVisibility(viewVisibilityCode);
         findViewById(R.id.observation_tag_side_row_bottom).setVisibility(viewVisibilityCode);

         if(this.getSecondType() != null){
             findViewById(R.id.observation_tag_color_row_bottom).setVisibility(viewVisibilityCode);

             findViewById(R.id.observation_tag_number_row_bottom).setVisibility(viewVisibilityCode);
         }
         else{
             findViewById(R.id.observation_tag_color_row_bottom).setVisibility(View.GONE);
             findViewById(R.id.observation_tag_number_row_bottom).setVisibility(View.GONE);
         }

         findViewById(R.id.observation_tag_confirmation_row_bottom).setVisibility(viewVisibilityCode);
    }

    // # INTERNAL RESPONDERS # //

    public void toggleTagSide(View v){
        if(((RadioButton)v).isChecked()){
            switch(v.getId()){
                case R.id.observation_tag_side_left_radio_top:
                    ((RadioButton)findViewById(R.id.observation_tag_side_right_radio_bottom)).setChecked(true);
                    break;
                case R.id.observation_tag_side_right_radio_top:
                    ((RadioButton)findViewById(R.id.observation_tag_side_left_radio_bottom)).setChecked(true);
                    break;
                case R.id.observation_tag_side_right_radio_bottom:
                    ((RadioButton)findViewById(R.id.observation_tag_side_left_radio_top)).setChecked(true);
                    break;
                case R.id.observation_tag_side_left_radio_bottom:
                    ((RadioButton)findViewById(R.id.observation_tag_side_right_radio_top)).setChecked(true);
                    break;
                default:
                    break;
            }
        }
    }

    public void onAgeClicked(View v){
        RadioButton button = (RadioButton)v;
        
        if(button.isChecked()){
            setAge(button.getText().toString());
        }
    }


    public void onSubmitButtonClick(View v){
        ((SealObservationActivityController) controller).onSubmit();
    }

    // # GETTERS AND SETTERS # //

    /**
     * @return the observer
     */
    public String getObserver() {
        return observer.getText().toString();
    }

    /**
     * @param observer the observer to set
     */
    public void setObserver(String observer) {
        if(observer == null)
            return;
        
        this.observer.setText(observer);
    }

    /**
     * @return the rookery
     */
    public String getRookery() {
        return rookery.getText().toString();
    }

    /**
     * @param rookery the rookery to set
     */
    public void setRookery(String rookery) {
        if(rookery == null)
            return;
        this.rookery.setText(rookery);
    }

    /**
     * @return the visibility
     */
    public int getVisibility() {
        return visibility.getSelectedItemPositionIgnoringDefault();
    }

    /**
     * @param visibility the visibility to set
     */
    public void setVisibility(int visCode) {
        visibility.setSelectionIgnoringDefault(visCode);
    }

    /**
     * @return the sealNumber
     */
    public int getSealNumber() {
        if(sealNumber.getText().toString().equals("")){
            return -1;
        }
        else{
            return Integer.parseInt(sealNumber.getText().toString());
        }
    }

    /**
     * @param sealNumber the sealNumber to set
     */
    public void setSealNumber(int sealNum) {
        if(sealNum < 0)
            sealNumber.setText("");
        else
            this.sealNumber.setText(sealNum +"");
    }

    /**
     * @return the firstSide
     */
    public String getFirstSide() {
        return (firstSide.getCheckedButton() == null ? null : firstSide.getCheckedButton().getText().toString() + "");
    }

    /**
     * @param firstSide the firstSide to set
     */
    public void setFirstSide(String side) {
        if(side == null){
            firstSide.uncheckAll();
            secondSide.uncheckAll();
        }
        else if(side.equalsIgnoreCase("Left"))
        {
            firstSide.setCheckedByLabel("Left");
            secondSide.setCheckedByLabel("Right");
//            ((RadioButton)firstSide.getChildAt(0)).setChecked(true);
//            ((RadioButton)secondSide.getChildAt(1)).setChecked(true);
        }
        else if(side.equalsIgnoreCase("Right")){
            firstSide.setCheckedByLabel("Right");
            secondSide.setCheckedByLabel("Left");
//            ((RadioButton)firstSide.getChildAt(1)).setChecked(true);
//            ((RadioButton)secondSide.getChildAt(0)).setChecked(true);
        }
    }

     /**
     * @return the firstType
     */
    public String getFirstType() {
        if(firstType.isTopEntrySelected()){
            return firstType.getSelectionKey();
        }
        else{
            return null;
        }
    }

    /**
     * @param firstType the firstType to set
     */
    public void setFirstType(String type) {
        if(firstType.setSelectionToKey(type)){
            setFirstTagColorAndNumberVisibility(View.VISIBLE);
        }
        else{
            setFirstTagColorAndNumberVisibility(View.GONE);
        }
    }

    /**
     * Get the first tags Loss code.
     * @return code starting from 0, or -1 if no code selected.
     */
    public int getFirstLossCode(){
        return firstType.getBottomEntriesSelection();
    }

    /**
     * Set the first loss code.
     * @param code - 0-based code being set 
     */
    public void setFirstLossCode(int code){
        firstType.setSelectionBasedOnBottomEntries(code);
        setFirstTagColorAndNumberVisibility(View.GONE);
    }

    /**
     * @return the firstColor
     */
    public String getFirstColor() {
        return firstColor.getSelectedItem();
    }

    public boolean firstColorIsEmpty() {
        return firstColor.isEmpty();
    }

    /**
     * @param firstColor the firstColor to set
     */
    public void setFirstColor(String color) {
       firstColor.setSelection(color);
    }

    /**
     * @return the firstTagNumber
     */
    public String getFirstTagNumber() {
        return firstTagNumber.getText().toString();
    }

    /**
     * @param firstTagNumber the firstTagNumber to set
     */
    public void setFirstTagNumber(String tagNum) {
        if(tagNum == null)
            firstTagNumber.setText("");
        else
            this.firstTagNumber.setText(tagNum);
    }

    /**
     * @return the otherTagSeen
     */
    public boolean getOtherTagSeen() {
        return otherTagSeen.isChecked();
    }

    /**
     * @param otherTagSeen the otherTagSeen to set
     */
    public void setOtherTagSeen(boolean seen) {
        this.otherTagSeen.setChecked(seen);
        
        if(seen || getOtherFlipperSeen()){
            this.setOtherTagVisibility(View.VISIBLE);
        }
        else{
            this.setOtherTagVisibility(View.GONE);
        }
    }

    /**
     * @return the otherTagSeen
     */
    public boolean getOtherFlipperSeen() {
        return otherFlipperSeen.isChecked();
    }

    public void clearOtherTag(){
        this.otherTagSeen.setChecked(false);
        this.otherFlipperSeen.setChecked(false);

//        findViewById(R.id.observation_tag_color_row_top).setVisibility(View.GONE);
//        findViewById(R.id.observation_tag_number_row_top).setVisibility(View.GONE);

        findViewById(R.id.observation_tag_color_row_bottom).setVisibility(View.GONE);
        findViewById(R.id.observation_tag_number_row_bottom).setVisibility(View.GONE);
        findViewById(R.id.observation_tag_type_row_bottom).setVisibility(View.GONE);
        findViewById(R.id.observation_tag_side_row_bottom).setVisibility(View.GONE);
        findViewById(R.id.observation_tag_confirmation_row_bottom).setVisibility(View.GONE);
    }

    /**
     * @param otherTagSeen the otherTagSeen to set
     */
    public void setOtherFlipperSeen(boolean seen) {
        this.otherFlipperSeen.setChecked(seen);

        if(seen || getOtherTagSeen()){
            this.setOtherTagVisibility(View.VISIBLE);
        }
        else{
            this.setOtherTagVisibility(View.GONE);
        }
    }

    /**
     * @return the secondType
     */
    public String getSecondType() {
        if(secondType.isTopEntrySelected()){
            return secondType.getSelectionKey();
        }
        else{
            return null;
        }
    }

    /**
     * @param secondType the secondType to set
     */
    public void setSecondType(String type) {
        if(secondType.setSelectionToKey(type)){
            setSecondTagColorAndNumberVisibility(View.VISIBLE);
        }
        else{
            setSecondTagColorAndNumberVisibility(View.GONE);
        }
    }

    public int getSecondLossCode(){
        return secondType.getBottomEntriesSelection();
    }

    public void setSecondLossCode(int code){
        secondType.setSelectionBasedOnBottomEntries(code);
        setSecondTagColorAndNumberVisibility(View.GONE);
    }

    /**
     * @return the secondColor
     */
    public String getSecondColor() {
        return secondColor.getSelectedItem();
    }

    public boolean secondColorIsEmpty(){
        return secondColor.isEmpty();
    }

    /**
     * @param secondColor the secondColor to set
     */
    public void setSecondColor(String color) {
        secondColor.setSelection(color);
    }

    /**
     * @return the secondTagNumber
     */
    public String getSecondTagNumber() {
        return secondTagNumber.getText().toString();
    }

    /**
     * @param secondTagNumber the secondTagNumber to set
     */
    public void setSecondTagNumber(String tagNum) {
        if(tagNum == null)
            secondTagNumber.setText("");
        else
            this.secondTagNumber.setText(tagNum);
    }

    /**
     * @return the confirmed
     */
    public boolean isFirstTagConfirmed() {
        return firstConfirm.isChecked();
    }

    /**
     * @param confirmed the confirmed to set
     */
    public void setFirstTagConfirmed(boolean confirmed) {
        this.firstConfirm.setChecked(confirmed);
    }

    public boolean isSecondTagConfirmed() {
        return secondConfirm.isChecked();
    }

    public void setSecondTagConfirmed(boolean confirmed){
        this.secondConfirm.setChecked(confirmed);
    }

    /**
     * @return the age
     */
    public String getAge() {
        CompoundButton checkedButton = upperAgeButtons.getCheckedButton();

        if(checkedButton == null){
            checkedButton = lowerAgeButtons.getCheckedButton();
        }

        if(checkedButton == null){
            return null;
        }
        else{
            return checkedButton.getText().toString();
        }

    }

    /**
     * @param age the age to set
     */
    public void setAge(String newAge) {
        if(newAge == null){
            upperAgeButtons.uncheckAll();
            lowerAgeButtons.uncheckAll();
            return;
        }

        boolean ageIsInFirstGroup = upperAgeButtons.setCheckedByLabel(newAge);

        if(ageIsInFirstGroup){
            lowerAgeButtons.clearCheck();
        }
        else{
            lowerAgeButtons.setCheckedByLabel(newAge);
            upperAgeButtons.clearCheck();
        }
    }

    /**
     * @return the pupCode
     */
    public int getPupCode() {
        return pupCode.getSelectedItemPositionIgnoringDefault();
    }

    /**
     * @param pupCode the pupCode to set
     */
    public void setPupCode(int code) {
        if(code >= 0)
            pupCode.setSelectionIgnoringDefault(code);
        else
            pupCode.resetToDefaultText();
    }

    /**
     * @return the sex
     */
    public String getSex() {
        if(sex.getCheckedRadioButtonId() == R.id.observation_seal_sex_unknown_radiobutton){
            return "Unknown";
        }
        else if(sex.getCheckedRadioButtonId() == R.id.observation_seal_sex_male_radiobutton){
            return "Male";
        } else if(sex.getCheckedRadioButtonId() == R.id.observation_seal_sex_female_radiobutton) {
            return "Female";
        } else{
            return null;
        }
    }

    /**
     * @param sex the sex to set
     */
    public void setSex(String newSex) {
        if(newSex == null){
            sex.uncheckAll();
            return;
        }

        sex.setCheckedByLabel(newSex.toUpperCase().charAt(0) + "");
    }

    /**
     * @return the photosTaken
     */
    public boolean werePhotosTaken() {
        return photosTaken.isChecked();
    }

    /**
     * @param photosTaken the photosTaken to set
     */
    public void setPhotosTaken(boolean photosTaken) {
        this.photosTaken.setChecked(photosTaken);
    }

    /**
     * @return the comments
     */
    public String getComments() {
        return comments.getText().toString();
    }

    /**
     * @param comments the comments to set
     */
    public void setComments(String newComments) {
        if(newComments == null)
            comments.setText("");
        else
            comments.setText(newComments);
    }

    /**
     * @return the island
     */
    public String getIsland() {
        return island.getText().toString();
    }

    /**
     * @param island the island to set
     */
    public void setIsland(String island) {
        this.island.setText(island);
    }

    /**
     * @return the rookerySection
     */
    public String getRookerySection() {
        return rookerySection.getSelectedItem();
    }

    /**
     * @param rookerySection the rookerySection to set
     */
    public void setRookerySection(String section) {
        rookerySection.setSelection(section);
    }

    /**
     * @param types the types to set
     */
    public void setTypes(ArrayList<SealTagType> types) {
        this.types = types;
    }

    public void setColors(String selection, DefaultSpinner colorSpinner){
            LOG("Setting Colors to type " + selection);
            if(types != null){
                SealTagType selectedType = null;
                for(SealTagType type : types){
                    if(type.getName().equalsIgnoreCase(selection)){
                        selectedType = type;
                        break;
                    }
                }

                if(selectedType != null){
                    ArrayList<String> colors = selectedType.getColors();
                    ArrayList<String> copy = new ArrayList<String>();
                    copy.addAll(colors);

                    colorSpinner.setSelectionList(copy);
                }
            }
        }

    private class OnTypeSelectedListener implements AdapterView.OnItemSelectedListener {
        public boolean enabled = true;

        public void onItemSelected(AdapterView<?> adapterView, View v, int position, long id) {
            if(!enabled)
                return;
            
            ComboSpinner spinner = (ComboSpinner)adapterView;
            if(spinner.getId() == R.id.observation_tag_type_spinner_top){

                if(!spinner.isTopEntrySelected()){
                    setFirstTagColorAndNumberVisibility(View.GONE);
//                    findViewById( R.id.observation_tag_color_row_top).setVisibility(View.GONE);
//                    findViewById( R.id.observation_tag_number_row_top).setVisibility(View.GONE);
                }
                else{
                    setFirstTagColorAndNumberVisibility(View.VISIBLE);
//                    findViewById( R.id.observation_tag_color_row_top).setVisibility(View.VISIBLE);
//                    findViewById( R.id.observation_tag_number_row_top).setVisibility(View.VISIBLE);

                    setColors(spinner.getSelectionKey(),firstColor);
                }
            }
            else if(spinner.getId() == R.id.observation_tag_type_spinner_bottom){
                if(!spinner.isTopEntrySelected()){
                    setSecondTagColorAndNumberVisibility(View.GONE);
//                    findViewById( R.id.observation_tag_color_row_bottom).setVisibility(View.GONE);
//                    findViewById( R.id.observation_tag_number_row_bottom).setVisibility(View.GONE);
                }
                else{
                    setSecondTagColorAndNumberVisibility(View.VISIBLE);
//                    findViewById( R.id.observation_tag_color_row_bottom).setVisibility(View.VISIBLE);
//                    findViewById( R.id.observation_tag_number_row_bottom).setVisibility(View.VISIBLE);

                    setColors(spinner.getSelectionKey(),secondColor);
                }
            }
            else{
                // Do Nothing
            }
        }

        public void onNothingSelected(AdapterView<?> arg0) {
            
        }
    }

    private class TempListener implements AdapterView.OnItemSelectedListener {

        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            arg0.setOnItemSelectedListener(new OnTypeSelectedListener());
        }

        public void onNothingSelected(AdapterView<?> arg0) {
            
        }

    }


}
