/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.me.sealproject.activities;


import android.os.Bundle;
import android.text.InputFilter;
import android.widget.*;

import org.me.sealproject.controllers.activitycontrollers.*;
import org.me.sealproject.*;
import org.me.sealproject.customwidgets.*;

/**
 *
 * @author samuelgbeecher
 */
public class SealLoginActivity extends SealActivity {

    private EditText observer;
    private DefaultSpinner island, rookery;

    @Override
    protected void initController() {
        controller = new SealLoginActivityController(this);
    }

    @Override
    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);

        setContentView(R.layout.login_form);
        
        observer = (EditText)findViewById(R.id.login_observer_edittext);
        island = (DefaultSpinner)findViewById(R.id.login_island_spinner);
        rookery = (DefaultSpinner)findViewById(R.id.login_rookery_spinner);

        observer.setFilters(new InputFilter[]{
           new InputFilter.AllCaps()}
        );
    }

    /**
     * @return the observer
     */
    public String getObserver() {
        return observer.getText().toString();
    }

    /**
     * @param observer the observer to set
     */
    public void setObserver(String observer) {
        this.observer.setText(observer);
    }

    /**
     * @return the island
     */
    public String getIsland() {
        return island.getSelectedItem();
    }

    /**
     * @param island the island to set
     */
    public void setIsland(String newIsland) {
        island.setSelection(newIsland);
    }

    /**
     * @return the rookery
     */
    public String getRookery() {
        return rookery.getSelectedItem();
    }

    /**
     * @param rookery the rookery to set
     */
    public void setRookery(String newRookery) {
        rookery.setSelection(newRookery);
    }

}
