<?php

class UserRoles extends ModuleClass {

	function index() {
		$ao = $this->activeObject(ActiveObject::USER);
		
		$params = array();
		$params['SunOneMembership'] = $this->getGroupNames($this->sunone()->membership($ao->id));
		$dn = $this->sunone()->get($ao, array('dn'));
		$params['SunOneDN'] = $dn['dn'];
		
		$params['FedMembership'] = $this->getGroupNames($this->federated()->membership($ao->id));
		$dn = $this->federated()->get($ao, array('dn'));
		$params['FedDN'] = $dn['dn'];
		
		$params['ADMembership'] = $this->getGroupNames($this->ad()->membership($ao->id));
		$dn = $this->ad()->get($ao, array('dn'));
		$params['ADDN'] = $dn['dn'];
		
		$this->render('UserRoles.tpl', $params);
	}
	
	private function getGroupNames($dn) {
		if(!is_array($dn)) $dn = array($dn);
		
		foreach($dn as &$str) {
			preg_match('/^CN=([^,]+),.*$/', $str, $matches);
			
			if(count($matches) > 1) $str = $matches[1];
		}
		
		return $dn;
	}
	
	public function isStudent() {
		$ao = $this->activeObject(ActiveObject::USER);
		$user = $this->sunone()->get($ao, array('dn'));
		
		if(stripos($user['dn'], 'OU=student') !== false) return true;
		else return false;
	}
	
	public function isAdmin() {
		$ao = $this->activeObject(ActiveObject::USER);
		$user = $this->sunone()->get($ao, array('dn'));
		
		if(stripos($user['dn'], 'OU=Admin') !== false) return true;
		else return false;
	}
	
	public function makeStudent() {
		$ao = $this->activeObject(ActiveObject::USER);
		
		try {
			//LDAP Credentials
			$LDAP_newParent = "OU=student,o=uaa.alaska.edu,o=isp";
			$LDAP_newRDN = "uid=" . $ao->uid;
			
			//AD Credentials
			$AD_newParent = "OU=Students,DC=uaa,DC=alaska,DC=edu";
			$AD_newRDN = "CN=" . $ao->uid;
			
			//Perform actions
			$this->sunone()->rename($ao, $LDAP_newRDN, $LDAP_newParent, true);
			$this->ad()->rename($ao, $AD_newRDN, $AD_newParent, true);
			
			//Log and return
			$this->log('Student Role', $ao->uid . "<br/>\nNew LDAP: $LDAP_newRDN,$LDAP_newParent<br/>\nNew AD: $AD_newRDN,$AD_newParent");
			redirect($ao->url);
		}
		catch(Exception $e) {
			$this->error('Student Role', 'uid=' . $ao->uid . '<br/>\n' . $e->getMessage());
			$this->renderError("Unable to change to student.", $ao->url, $e);
		}
	}
	
	public function makeAdmin() {
		$ao = $this->activeObject(ActiveObject::USER);
		
		try {
			//LDAP Credentials
			$LDAP_newParent = "OU=Admin,o=uaa.alaska.edu,o=isp";
			$LDAP_newRDN = "uid=" . $ao->uid;
			
			//AD Credentials
			$AD_newParent = "OU=Admin,DC=uaa,DC=alaska,DC=edu";
			$AD_newRDN = "CN=" . $ao->uid;
		
			//Perform actions
			$this->sunone()->rename($ao, $LDAP_newRDN, $LDAP_newParent, true);
			$this->ad()->rename($ao, $AD_newRDN, $AD_newParent, true);
			
			//Log and return
			$this->log('Admin Role', $ao->uid . "<br/>\nNew LDAP: $LDAP_newRDN,$LDAP_newParent<br/>\nNew AD: $AD_newRDN,$AD_newParent");
			redirect($ao->url);
		}
		catch(Exception $e) {
			$this->error('Admin Role', 'uid=' . $ao->uid . '<br/>\n' . $e->getMessage());
			$this->renderError("Unable to change to admin.", $ao->url, $e);
		}
	}
	
}


?>