<?php

class CMSMigration extends ModuleClass {

	function index() {
		$sites = $this->cms()->currentlyMigratedSites();
			
		$this->render('CMSMigration.tpl', array('sites' => $sites, 'count' => count($sites)));
	}
	
	function unmigrate($params) {
		if(count($params) > 1) {
			$this->cms()->unMigrateSubsite((int)$params[0], $params[1]);
		}
		else {
			$this->cms()->unMigrateSubsite((int)$params[0]);
		}
		
		$url = $this->cms()->getSubsiteURL($params[0]);
		$this->log('Unmigrate', "Unmigrated subsite '$url'");
		redirect('/module/load/' . get_class());
	}
	
	function migrateSite($params) {
		try {
			$subsiteID = $_REQUEST['subsite_id'];
			if(!is_numeric($subsiteID)) {
				//Make relative
				$subsiteID = str_replace('http://www.uaa.alaska.edu', '', $subsiteID);
				
				//Add trailing slash if needed
				if(substr($subsiteID, -1) != "/") $subsiteID .= "/";
			}
		
			if(isset($_REQUEST['filename']) && !empty($_REQUEST['filename'])) {
				$this->cms()->migrateSubsite($subsiteID, $_REQUEST['filename']);
			}
			else {
				$this->cms()->migrateSubsite($subsiteID);
			}
			
			$this->log('Migrate', "Migrated subsite '$subsiteID'");
			redirect('/module/load/' . get_class());
		}
		catch(Exception $e) {
			$this->renderError(null, '/module/load/' . get_class(), $e);
		}
	}
	
}


?>