{extends file="base.tpl"}

{block name=content}

	<h4 class='clear'>User Enrollment in {$activeObject->name}</h4>
	
	<table class='striped' style='width: 100%;'>
		<thead>
			<tr>
				<th></th>
				<th>Active</th>
				<th>Username</th>
				<th>Name</th>
				<th>UA ID</th>
				<th>Data Source</th>
			</tr>
		</thead>
		<tbody>
			{foreach $enrollment as $person}
			<tr{if $person->enrollment_role == 'P'} style='font-weight: bold;'{/if}>
				<td class='centered'>
					{if $person->enrollment_row_status == 0}
						<a class='button' href='/module/load/BlackboardEnrollment/deactivate/{$person->user_pk1}'>Deactivate</a>
					{elseif $person->enrollment_row_status == 2}
						<a class='button' href='/module/load/BlackboardEnrollment/activate/{$person->user_pk1}'>Activate</a>
					{/if}
				</td>
				<td class='centered'><div class='checkbox {if $person->enrollment_row_status == 0}checked{elseif $person->enrollment_row_status != 2}unknown{/if}'></div></td>
				<td><a href='/user/info/{$person->user_id}'>{$person->user_id}</a></td>
				<td>{$person->firstname|capitalize} {$person->lastname|capitalize}</td>
				<td>{$person->user_batch_uid|default:""}</td>
				<td>{$person->enrollment_data_src_pk1}</td>
			</tr>
			{/foreach}
		</tbody>
	</table>
	<p>* <strong>Bold</strong> text denotes course instructor.</p>

{/block}