<div id='gmail'>
	<h4 class='clear'><img src='/images/gmailLogo.png' class='logo' alt='Gmail Logo' /> Gmail Identity Resource</h4>

	{if $User}
		<fieldset>
			<legend>Identity</legend>
			<div class='formEntry'>
				<label class='formLabel'>Username:</label>
				<div class='formData'>{$User->login->userName}</div>
			</div>
			
			<div class='formEntry'>
				<label class='formLabel'>First Name:</label>
				<div class='formData'>{$User->name->givenName}</div>
			</div>
			
			<div class='formEntry'>
				<label class='formLabel'>Last Name:</label>
				<div class='formData'>{$User->name->familyName}</div>
			</div>		
			
			<div class='formEntry'>
				<label class='formLabel'>Suspended:</label>
				<div class='formData'><div class='checkbox {if $User->login->suspended}checked{/if}'></div></div>
			</div>
			
			<div class='formEntry'>
				<label class='formLabel'>Admin:</label>
				<div class='formData'><div class='checkbox {if $User->login->admin}checked{/if}'></div></div>
			</div>
			
			<div class='formEntry'>
				<label class='formLabel'>Must Change Password:</label>
				<div class='formData'><div class='checkbox {if $User->login->changePasswordAtNextLogin}checked{/if}'></div></div>
			</div>
			
			<div class='formEntry'>
				<label class='formLabel'>Has Agreed to terms:</label>
				<div class='formData'><div class='checkbox {if $User->login->agreedToTerms}checked{/if}'></div></div>
			</div>
			
		</fieldset>
	{elseif $id && isset($ao)}
		<p>Gmail account <strong>does not exist</strong>. Create Gmail account?</p>
		
		<form action="/user/createGmailAccount" method="post">
			<input type='hidden' name='uaid' value='{$id}' />
			<input name='username' type='hidden' value='{$ao->uid}' />
			<fieldset>
				<legend>Identity</legend>
				<div class='formEntry'>
					<label class='formLabel'>Username:</label>
					<div class='formData'>{$ao->uid}</div>
				</div>
				
				<div class='formEntry'>
					<label for='firstName' class='formLabel'>First Name:</label>
					<input name='firstName' id='firstName' type='text' class='formData' value='{$ao->firstName}' />
				</div>
				
				<div class='formEntry'>
					<label for='lastName' class='formLabel'>Last Name:</label>
					<input name='lastName' id='lastName' type='text' class='formData' value='{$ao->lastName}' />
				</div>
				
				<input type='submit' class='formData' value='Create Account' />
			</fieldset>
		</form>
	{else}
		<p><strong>Account could not be found.</strong></p>
	{/if}
</div>