{extends file="base.tpl"}

{block name=title}
	{if isset($LDAPUser.cn)}{$LDAPUser.cn.0} -
	{elseif isset($LDAPUser.fullname)}{$LDAPUser.fullname.0} -
	{elseif isset($FederatedUser.displayName)}{$FederatedUser.displayName.0} -
	{/if}
{/block}

{block name=bodyclass}userInfo{/block}

{block name=content}
	{if (isset($LDAPUser) && $LDAPUser != false) || (isset($FederatedUser) && $FederatedUser != false)}
		<fieldset class='formAttributes'>
			<legend>Attributes</legend>
			{foreach $attributes as $attribute}
			<div {if isset($attribute.description)}title="{$attribute.description}"{/if}>
				<label>{$attribute.name}: </label>
				<div class='checkbox loading_bool'><input type='hidden' class='target' value='{$attribute.url}'></div>
			</div>
			{/foreach}
		</fieldset>
		
		{if isset($LDAPUser.cn)}<h1>{$LDAPUser.cn.0}</h1>
		{elseif isset($LDAPUser.fullname)}<h1>{$LDAPUser.fullname.0}</h1>
		{elseif isset($FederatedUser.displayName)}<h1>{$FederatedUser.displayName.0}</h1>
		{/if}
		
		<div>
			{foreach $buttons as $button}
			<a class='button' href='{$button.url}' {if isset($button.description)}title="{$button.description}"{/if}>{$button.name}</a>
			{/foreach}
		</div>
	{/if}
	
	<div class='clear'></div>
	
	<p style='font-weight: bold;'>
		Existing Accounts for {$id}:
		<span class='checkbox {if isset($FederatedUser) && $FederatedUser != false}checked{/if}'></span> <a href='#federated'>Federated</a>
		<span class='checkbox {if isset($LDAPUser) && $LDAPUser != false}checked{/if}'></span> <a href='#sunone'>SunOne</a>
		<span class='checkbox {if isset($ADUser) && $ADUser != false}checked{/if}'></span> <a href='#ad'>Active Directory</a>
		<span class='checkbox {if isset($GmailUser) && $GmailUser != false}checked{/if}'></span> <a href='#gmail'>Gmail</a>
		<span class='checkbox {if isset($BlackboardUser) && $BlackboardUser != false}checked{/if}'></span> <a href='#blackboard'>Blackboard</a>
	</p>
	
	{include file='infoUserFederated.tpl' User=$FederatedUser}
	
	{include file='infoUserSunOne.tpl' User=$LDAPUser}
	
	{include file='infoUserAD.tpl' User=$ADUser}
	
	{include file='infoUserGmail.tpl' User=$GmailUser}
	
	{include file='infoUserBlackboard.tpl' User=$BlackboardUser Enrollment=$enrollment}
	
{/block}


{block name=debug}

{/block}