{extends file="base.tpl"}

{block name=title}{if isset($course) && $course != false}{$course->course_name} - {/if}{/block}

{block name=content}

	{if !isset($course) || $course == false}
		<div>Course could not be found.</div>
	{else}
		<fieldset class='formAttributes'>
			<legend>Attributes</legend>
			{foreach $attributes as $attribute}
			<div {if isset($attribute.description)}title="{$attribute.description}"{/if}>
				<label>{$attribute.name}: </label>
				<div class='checkbox loading_bool'><input type='hidden' class='target' value='{$attribute.url}'></div>
			</div>
			{/foreach}
		</fieldset>
		
		<h1>{$course->course_name}</h1>
		
		<div>
			{foreach $buttons as $button}
			<a class='button' href='{$button.url}' {if isset($button.description)}title="{$button.description}"{/if}>{$button.name}</a>
			{/foreach}
		</div>
		
		<div class='clear'></div>
		
		<p>{$course->course_desc}</p>
		
		<fieldset>
			<legend>Information</legend>
			
			<div class='formEntry'>
				<label class='formLabel'>Name:</label>
				<div class='formData'>{$course->course_name}</div>
			</div>
			
			<div class='formEntry'>
				<label class='formLabel'>Batch UID:</label>
				<div class='formData'>{$course->batch_uid}</div>
			</div>
			
			<div class='formEntry'>
				<label class='formLabel'>Date Created:</label>
				<div class='formData'>{$course->dtcreated|date_format:"%m-%d-%Y %I:%M %p"}</div>
			</div>
			
			<div class='formEntry'>
				<label class='formLabel'>Last Modified Date:</label>
				<div class='formData'>{$course->dtmodified|date_format:"%m-%d-%Y %I:%M %p"}</div>
			</div>
			
			<div class='formEntry'>
				<label class='formLabel'>Data Source:</label>
				<div class='formData'>{$course->data_src_pk1}</div>
			</div>
			
			<div class='formEntry'>
				<label class='formLabel'>Enrolled Users:</label>
				<div class='formData'>{count($enrollment)}</div>
			</div>
			
			<div class='formEntry'>
				<label class='formLabel'>Active Enrollments:</label>
				<div class='formData'>{$enrollmentActiveCount|default:0}</div>
			</div>
			
		</fieldset>
		

		<h4 class='clear'>Course Enrollment</h4>
		
		<table class='striped' style='width: 100%;'>
			<thead>
				<tr>
					<th>Active</th>
					<th>Username</th>
					<th>Name</th>
					<th>UA ID</th>
					<th>Email Address</th>
				</tr>
			</thead>
			<tbody>
				{foreach $enrollment as $person}
				<tr{if $person->enrollment_role == 'P'} style='font-weight: bold;'{/if}>
					<td class='centered'><div class='checkbox {if $person->enrollment_row_status == 0}checked{elseif $person->enrollment_row_status != 2}unknown{/if}'></div></td>
					<td><a href='/user/info/{$person->user_id}'>{$person->user_id}</a></td>
					<td>{$person->firstname|capitalize} {$person->lastname|capitalize}</td>
					<td>{$person->user_batch_uid|default:""}</td>
					<td><a href='mailto:{$person->email|default:""}'>{$person->email|default:""}</a></td>
				</tr>
				{/foreach}
			</tbody>
		</table>
		<p>* <strong>Bold</strong> text denotes course instructor.</p>	
	{/if}
	
{/block}


{block name=debug}

{/block}