<?php


class Coursemodel extends CI_Model {
	private $dbConn;
	
	public function __construct() {
		parent::__construct();
		
		$this->dbConn = $this->load->database('blackboard', true);
	}
	
	public function get($pk1) {
		if(is_a($pk1, ActiveObject::COURSE)) $pk1 = $pk1->pk1;
		
		if(!is_numeric($pk1)) return false;
	
		$query = $this->dbConn->query("SELECT TOP 1 * FROM course_main WHERE pk1 = ?", array($pk1));
		$result = $query->result();

		if(count($result) > 0) return $result[0];
		else return false;
	}
	
	public function getByCourseID($course_id) {
		$query = $this->dbConn->query("SELECT TOP 1 * FROM course_main WHERE course_id = ?", array($course_id));
		$result = $query->result();

		if(count($result) > 0) return $result[0];
		else return false;
	}
	
	public function getUserInformationByID($uaid) {
		$query = $this->dbConn->query("SELECT TOP 1 * FROM users WHERE batch_uid = ?", array($uaid));
		$result = $query->result();

		if(count($result) > 0) return $result[0];
		else return false;
	}
	
	public function getEnrollment($pk1) {
		if(is_a($pk1, ActiveObject::COURSE)) $pk1 = $pk1->pk1;
		
		$sql = <<<SQL
			SELECT course_users.crsmain_pk1 AS course_pk1, users.pk1 AS user_pk1, course_users.role AS enrollment_role,
				course_users.row_status AS enrollment_row_status, users.user_id, users.firstname, users.lastname,
				users.batch_uid AS user_batch_uid, users.email, course_users.data_src_pk1 AS enrollment_data_src_pk1
			FROM course_users
			LEFT OUTER JOIN users ON (users.pk1 = course_users.users_pk1)
			WHERE crsmain_pk1 = ?
			ORDER BY course_users.role, users.user_id
SQL;
	
		$query = $this->dbConn->query($sql, array($pk1));
		$result = $query->result();
		
		return $result;
	}
	
	public function getEnrollmentByUserID($uid, $onlyActive = false) {
		$sql = "SELECT * FROM uaa_complete WHERE user_id = ? ";
		if($onlyActive) $sql .= "AND course_row_status = 0 ";
		$sql .= "ORDER BY course_id";
	
		$query = $this->dbConn->query($sql, array($uid));
		$result = $query->result();
		
		return $result;
	}
	
	public function search($filter, $search) {
		if($filter == 'crn') {
			$sql = <<<SQL
				SELECT TOP 100 pk1, course_name, course_id, course_desc, row_status FROM course_main
				WHERE course_id LIKE ? OR pk1 LIKE ?
				ORDER BY dtmodified DESC, course_name ASC
SQL;
		
			$query = $this->dbConn->query($sql, array("%$search%", "%$search%"));
		}
		elseif($filter == 'description') {
			$sql = <<<SQL
				SELECT TOP 100 pk1, course_name, course_id, course_desc, row_status FROM course_main
				WHERE course_desc LIKE ?
				ORDER BY dtmodified DESC, course_name ASC
SQL;
			$query = $this->dbConn->query($sql, array("%$search%"));
		}
		elseif($filter == 'instructor') {
			$sql = <<<SQL
				SELECT TOP 100 course_main.pk1 AS pk1, course_name, course_id, course_desc, course_main.row_status FROM course_main
				INNER JOIN course_users ON (course_users.crsmain_pk1 = course_main.pk1 AND course_users.role = 'P')
				INNER JOIN users ON (users.pk1 = course_users.users_pk1)
				WHERE lastname = ? OR firstname = ? or users.user_id = ? or users.batch_uid = ?
				ORDER BY course_main.dtmodified DESC, course_main.course_name ASC
SQL;
			$query = $this->dbConn->query($sql, array($search, $search, $search, $search));
		}
		elseif($filter == 'all') {
			$sql = <<<SQL
				SELECT TOP 100 course_main.pk1 AS pk1, course_name, course_id, course_desc, course_main.row_status FROM course_main
				INNER JOIN course_users ON (course_users.crsmain_pk1 = course_main.pk1 AND course_users.role = 'P')
				INNER JOIN users ON (users.pk1 = course_users.users_pk1)
				WHERE course_main.course_id LIKE ? OR course_main.pk1 LIKE ? OR course_main.course_desc LIKE ? OR lastname = ? OR firstname = ? or users.user_id = ? or users.batch_uid = ?
				ORDER BY course_main.dtmodified DESC, course_main.course_name ASC
SQL;
			$query = $this->dbConn->query($sql, array("%$search%", "%$search%", "%$search%", $search, $search, $search, $search));
		}
		else throw new Exception('Invalid filter for search query.');
		
		return $query->result();
	}
	
	public function searchCoursesByUserID($uaid, $onlyActive = false) {
		if(is_a($uaid, ActiveObject::USER)) $uaid = $uaid->uaid;
		
		$sql = <<<SQL
			SELECT TOP 100 course_main.pk1 AS pk1, course_name, course_id, course_desc, course_main.row_status FROM course_main
			INNER JOIN course_users ON (course_users.crsmain_pk1 = course_main.pk1)
			INNER JOIN users ON (users.pk1 = course_users.users_pk1)
			WHERE users.batch_uid = ?
SQL;
			
		if($onlyActive) $sql .= " AND course_main.row_status = 0";
		$sql .= " ORDER BY enrollment_date DESC, course_name ASC";
	
		$query = $this->dbConn->query($sql, array($uaid));
		$result = $query->result();
		
		return $result;
	}
	
	public function searchCoursesByUsername($uid, $onlyActive = false) {
		if(is_a($uid, ActiveObject::USER)) return $this->searchCoursesByUserID($uid, $onlyActive);
		
		//Convert to UAID
		$sql = "SELECT TOP 1 batch_uid FROM users WHERE user_id = ?";
		$query = $this->dbConn->query($sql, array($uid));
		$result = $query->result();
		
		//Search by UAID
		return $this->searchCoursesByUserID($result['batch_uid'], $onlyActive);
	}
	
	public function activateCourse($pk1) {
		if(is_a($pk1, ActiveObject::COURSE)) $pk1 = $pk1->pk1;
		
		$query = $this->dbConn->query("UPDATE course_main SET row_status = 0, data_src_pk1 = '2' WHERE pk1 = ?", array($pk1));
		return $query == 1;
	}
	
	public function deactivateCourse($pk1) {
		if(is_a($pk1, ActiveObject::COURSE)) $pk1 = $pk1->pk1;
		
		$query = $this->dbConn->query("UPDATE course_main SET row_status = 2, data_src_pk1 = '2' WHERE pk1 = ?", array($pk1));
		return $query == 1;
	}
	
	public function activateUser($pk1) {
		$query = $this->dbConn->query("UPDATE users SET row_status = 0, data_src_pk1 = '2' WHERE pk1 = ?", array($pk1));
		return $query == 1;
	}
	
	public function deactivateUser($pk1) {
		$query = $this->dbConn->query("UPDATE users SET row_status = 2, data_src_pk1 = '2' WHERE pk1 = ?", array($pk1));
		return $query == 1;
	}
	
	public function activateUserForCourse($coursepk1, $userpk1) {
		if(is_a($coursepk1, ActiveObject::COURSE)) $coursepk1 = $coursepk1->pk1;
		
		$query = $this->dbConn->query("UPDATE course_users SET row_status = '0', data_src_pk1 = '2' WHERE crsmain_pk1 = ? AND users_pk1 = ?", array($coursepk1, $userpk1));
		return $query == 1;
	}
	
	public function deactivateUserForCourse($coursepk1, $userpk1) {
		if(is_a($coursepk1, ActiveObject::COURSE)) $coursepk1 = $coursepk1->pk1;
		
		$query = $this->dbConn->query("UPDATE course_users SET row_status = '2', data_src_pk1 = '2' WHERE crsmain_pk1 = ? AND users_pk1 = ?", array($coursepk1, $userpk1));
		return $query == 1;
	}
}


?>