<?php


class Cmsmodel extends CI_Model {
	private $dbConn;
	private $dataConn;

	public function __construct() {
		parent::__construct();
		
		//$this->dbConn = $this->load->database('cms', true);
		$this->dataConn = $this->load->database('cmsdata', true);
	}

	public function migrateSubsite($siteID, $filename = null) {
		if(!is_numeric($siteID)) {
			$siteID = $this->getSubsiteID($siteID);
			if($siteID == false) throw new Exception("Subsite does not exist");
		}
	
		if($this->isSubsiteMigrated($siteID, $filename)) throw new Exception("Site already migrated");
		
		if(is_null($filename))
			$this->dataConn->query("INSERT INTO CMSMigration (subsite_id) VALUES(?)", array($siteID));
		else
			$this->dataConn->query("INSERT INTO CMSMigration (subsite_id, filename) VALUES(?, ?)", array($siteID, $filename));
	}
	
	
	public function unMigrateSubsite($siteID, $filename = null) {
		if(!is_numeric($siteID)) {
			$siteID = $this->getSubsiteID($siteID);
			if($siteID == false) throw new Exception("Subsite does not exist");
		}
	
		if(is_null($filename))
			$this->dataConn->query("DELETE FROM CMSMigration WHERE subsite_id = ? AND filename IS NULL", array($siteID));
		else
			$this->dataConn->query("DELETE FROM CMSMigration WHERE subsite_id = ? AND filename = ?", array($siteID, $filename));
	}
	
	public function getSubsiteID($subsiteURL) {
		$query = $this->dataConn->query("SELECT id FROM [cms-site-www].dbo.SubSites WHERE SubsiteURL = ?", array($subsiteURL));
		$result = $query->result();
		
		if(count($result) == 0) return false;
		else return $result[0]->id;
	}
	
	public function getSubsiteURL($subsiteID) {
		$query = $this->dataConn->query("SELECT SubsiteURL FROM [cms-site-www].dbo.SubSites WHERE id = ?", array($subsiteID));
		$result = $query->result();
		
		if(count($result) == 0) return false;
		else return $result[0]->SubsiteURL;
	}
	
	private function isSubsiteMigrated($siteID, $filename = null) {
		if(!is_numeric($siteID)) {
			$siteID = $this->getSubsiteID($siteID);
			if($siteID == false) throw new Exception("Subsite does not exist");
		}
	
		if(is_null($filename))
			$query = $this->dataConn->query("SELECT * FROM CMSMigration WHERE subsite_id = ? AND filename IS NULL", array($siteID));
		else
			$query = $this->dataConn->query("SELECT * FROM CMSMigration WHERE subsite_id = ? AND filename = ?", array($siteID, $filename));
			
		return count($query->result()) > 0;
	}
	
	
	public function currentlyMigratedSites() {
		$sql = <<<SQL
			SELECT subsite_id, filename, subsites.SubsiteURL as url
			FROM CMSMigration
			LEFT OUTER JOIN [cms-site-www].dbo.SubSites AS subsites ON (subsites.ID = CMSMigration.subsite_id)
			ORDER BY url, filename
SQL;
	
		$query = $this->dataConn->query($sql);
		return $query->result();
	}
	
}


?>