<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require "Smarty/Smarty.class.php";

class SmartyParser extends Smarty {

	public function SmartyParser() {
		parent::__construct();
		
		$this->setTemplateDir(APPPATH . 'views');
		$this->setCompileDir(APPPATH . 'cache/template_cache');
		$this->setCacheDir(APPPATH . 'cache');
		$this->setConfigDir(APPPATH . 'config');

		$this->assign('REQUEST', $_REQUEST);
		
		//Pull the session variable and set the search & filter attributes
		$CI =& get_instance();
		$this->assign('search', $CI->session->userdata('search'));
		$this->assign('filter', $CI->session->userdata('filter'));
		
		//Set the breadcrumb data
		$segments = $CI->uri->segment_array();
		$breadcrumbs = array();
		$str = "/";
		
		for($i = 1; $i <= count($segments); $i++) {
			$breadcrumb = array();
			
			$breadcrumb['name'] = $segments[$i];
			$str .= $segments[$i] . "/";
			$breadcrumb['url'] = $str;
			
			array_push($breadcrumbs, $breadcrumb);
		}
		
		$this->assign('breadcrumbs', $breadcrumbs);
		
		$this->assign('revision', '$Id: SmartyParser.php 56 2011-04-07 21:06:07Z srnixon $');
	}
	
	/*public function display($template, $cache_id = null, $compile_id = null, $parent = null) { 
        $CI =& get_instance();
		if(!$CI->input->is_ajax_request() || ($template != 'empty.tpl' && $template != 'base.tpl'))
			parent::display($template, $cache_id, $compile_id, $parent);
		else
			print $this->getTemplateVars('content');
    } */
	
}

?>