<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

define('MODULE_PATH', realpath(APPPATH . "../modules/") . "\\");
require_once(APPPATH . 'classes/ModuleConfig.php');
require_once(APPPATH . 'classes/ModuleClass.php');

class ModuleLoader {
	private $modules;
	
	/**
	 * Parses all modules from the /modules/ directory and instantiates ModuleInfo classes
	 * for each one. These classes are then stored into an associative array with the name of the module as 
	 * the key. The leftnav is then set in the Smarty library.
	 **/
	function __construct() {
		$this->modules = array();
		
		$CI =& get_instance();
		$CI->load->helper('directory');
		$moduleDirectory = directory_map(MODULE_PATH);
		
		if(!empty($moduleDirectory)) {
			//Turn off PHP Warnings for XML import so we can handle them gracefully
			$previousLibXMLErrorsAttr = libxml_use_internal_errors(true);
		
			foreach($moduleDirectory as $moduleName => $moduleDir) {
				//Skip files
				if(!is_array($moduleDir)) continue;
			
				try {
					//Validate basic directory stucture. Additional validation will be provided by the ModuleInfo class.
					if(empty($moduleDir) || !in_array('config.xml', $moduleDir) || !in_array("$moduleName.php", $moduleDir)) continue;
					
					$this->modules[$moduleName] = new ModuleConfig($moduleName, $moduleDir);
				}
				catch(Exception $e) {
					log_error($moduleName, 'Load', $e->getMessage());
					if(isset($this->modules[$moduleName])) unset($this->modules[$moduleName]);
				}
			}
			
			uksort($this->modules, array($this, 'moduleNameComparison'));
			
			//Change the libxml warnings to it's previous value
			libxml_use_internal_errors($previousLibXMLErrorsAttr);
		}
		else log_error('', 'Load Module Library', 'Error loading Module library');
		
		//Retrieve list of enabled left-nav'ed modules for parsing into the left navigation
		$leftnavitems = $this->getLeftNav();
		$CI->smartyparser->assign('leftnav', $leftnavitems);
	}
	
	private function moduleNameComparison($k1, $k2) {
		return strcasecmp($this->modules[$k1]->name, $this->modules[$k2]->name);
	}
	
	private function leftNavComparison($k1, $k2) {
		return strcasecmp($k1['name'], $k2['name']);
	}
	
	public function getLeftNav() {
		$ret = array();
		
		foreach($this->modules as $moduleName => $module) {
			//Filter results
			if(!$module->enabled) continue;
			
			//Filtering check passed, add to module list
			$category = $module->category;

			if($module->leftnav) {
				if(!isset($ret[$category])) $ret[$category] = array();
				array_push($ret[$category], array("name" => $module->name, 'url' => "/module/load/$moduleName/"));
			}
			
			//Custom page declarations
			foreach($module->pages as $page) {
				//Check to see if the page is in an external category
				if(isset($page['category'])) {
					$category = $page['category'];
					if(!isset($ret[$category])) $ret[$category] = array();
				}
				else $category = $module->category;

				//Add the page to its declared category
				array_push($ret[$category], array("name" => $page['name'], 'url' => "/module/load/$moduleName/" . $page['function']));
			}
		}
		
		foreach($ret as $category => $module) {
			usort($ret[$category], array($this, 'leftNavComparison'));
		}
		ksort($ret);
		
		return $ret;
	}
	
	public function getModuleListByCategory($filter = array()) {
		$ret = array();
		
		foreach($this->modules as $moduleName => $module) {
			//Filter results by whatever checks have been passed to this method
			$filterPassed = true;
			$moduleVars = get_object_vars($module);
			foreach($filter as $key => $value) {
				if(!isset($moduleVars[$key]) || $moduleVars[$key] != $value) $filterPassed = false;
			}
			if(!$filterPassed) continue;
			
			//Filtering check passed, add to module list
			$category = $module->category;

			if(!isset($ret[$category])) $ret[$category] = array();
			$ret[$category][$moduleName] = $this->modules[$moduleName];
		}
		
		return $ret;
	}
	
	public function getInstance($moduleName) {
		if(!isset($this->modules[$moduleName])) throw new Exception("Module '$moduleName' does not exist.");
		try {
			if(!isset($this->modules[$moduleName]->instance)) $this->modules[$moduleName]->instantiate();
			return $this->modules[$moduleName]->instance;
		}
		catch(Exception $e) {
			log_error($moduleName, 'Construct', $e->getMessage());
		}
		
		return null;
	}
	
	public function getAttributes() {
		$CI =& get_instance();
		$ao = $CI->activeobjectloader->get();
		
		if(is_a($ao, ActiveObject::USER)) $type = ActiveObject::USER;
		elseif(is_a($ao, ActiveObject::COURSE)) $type = ActiveObject::COURSE;
		else throw new ActiveObjectRequiredException();
		
		$toReturn = array();
		
		foreach($this->modules as $module) {
			if($type == ActiveObject::USER) $toReturn = array_merge($toReturn, $module->getValidItems($module->userAttributes));
			elseif($type == ActiveObject::COURSE) $toReturn = array_merge($toReturn, $module->getValidItems($module->classAttributes));
		}
			
		sort($toReturn);
		
		return $toReturn;
	}
	
	public function getButtons() {
		$CI =& get_instance();
		$ao = $CI->activeobjectloader->get();
		
		if(is_a($ao, ActiveObject::USER)) $type = ActiveObject::USER;
		elseif(is_a($ao, ActiveObject::COURSE)) $type = ActiveObject::COURSE;
		else throw new ActiveObjectRequiredException();
		
		$toReturn = array();
		
		foreach($this->modules as $module) {
			if($type == ActiveObject::USER) $toReturn = array_merge($toReturn, $module->getValidItems($module->userButtons));
			elseif($type == ActiveObject::COURSE) $toReturn = array_merge($toReturn, $module->getValidItems($module->classButtons));
		}
			
		sort($toReturn);
		
		return $toReturn;
	}
	
}

?>