<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once(APPPATH . 'classes/ActiveObject.php');
require_once(APPPATH . 'classes/AOUser.php');
require_once(APPPATH . 'classes/AOCourse.php');
require_once(APPPATH . 'classes/ActiveObjectRequiredException.php');

class ActiveObjectLoader {
	private $activeObject;
	
	public function __construct() {
		session_start();
		
		$ao = $this->get();
		if(!is_null($ao)) $this->setSmarty($ao);
	}

	public function get() {
		if(!isset($this->activeObject)) {
			$CI =& get_instance();
			$type = $CI->session->userdata('activeObjectType');
			
			if(empty($type)) return null;
			$this->activeObject = call_user_func(array($type, 'restoreFromSession'));
		}
		
		return $this->activeObject;
	}
	
	public function clear() {
		$CI =& get_instance();
		$CI->session->unset_userdata('activeObjectType');
		
		$this->activeObject = null;
		return null;
	}
	
	public function setUser($id) {
		$ao = new AOUser($id);
		$this->setActiveObject($ao);
		$this->setSmarty($ao);
		return $ao;
	}
	
	public function setCourse($id) {
		$ao = new AOCourse($id);
		$this->setActiveObject($ao);
		$this->setSmarty($ao);
		return $ao;
	}
	
	private function setActiveObject(ActiveObject $ao) {
		$CI =& get_instance();
		$ao->saveToSession();
		$CI->session->set_userdata('activeObjectType', get_class($ao));
		
		$this->activeObject = $ao;
	}
	
	public function setSmarty($ao) {
		$CI =& get_instance();
		
		if($ao instanceof ActiveObject) {
			$CI->smartyparser->assign('activeObject', $ao);
			$CI->smartyparser->assign('ao', $ao);
		}
		elseif(is_null($ao)) {
			$CI->smartyparser->clearAssign('activeObject');
			$CI->smartyparser->clearAssign('ao');
		}
	}
}

?>