<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User extends CI_Controller {

	function index() {
		redirect('/');
	}
	
	function info($id = null) {
		if(is_null($id)) redirect('/');
		
		//Set the activeObject for this user
		try {
			$ao = $this->activeobjectloader->setUser($id);
			if(!$ao) throw new Exception('Account could not be found.');
		}
		catch(Exception $e) {
			$this->activeobjectloader->clear();
			renderError(null, null, $e);
			return;
		}
		
		$id = $ao->id;
		$this->smartyparser->assign('id', $id);
		
		//Retrieve all account information
		foreach(array('sunone' => 'LDAPUser', 'federated' => 'FederatedUser', 'activedirectory' => 'ADUser') as $db => $assn) {
			$this->load->library($db);
			$this->smartyparser->assign($assn, $this->$db->get($ao));
		}
		
		//Blackboard account information
		$this->load->model('Coursemodel');
		$BBUser = $this->Coursemodel->getUserInformationByID($id);
		$this->smartyparser->assign('BlackboardUser', $BBUser);
		
		//Load Class Enrollment
		$enrollment = $this->Coursemodel->searchCoursesByUserID($id);
		$this->smartyparser->assign('enrollment', $enrollment);
		
		//Retrieve Gmail Account
		$this->load->library('gmail');
		if(!is_null($ao)) $GmailUser = $this->gmail->get($ao);
		else $GmailUser = null;
		
		$this->smartyparser->assign('GmailUser', $GmailUser);
		
		//Set module attributes & buttons
		$this->smartyparser->assign('attributes', $this->moduleloader->getAttributes());
		$this->smartyparser->assign('buttons', $this->moduleloader->getButtons());
		
		$this->smartyparser->display('infoUser.tpl');
	}
	
	function addDaysToExpiration() {
		$daysToAdd = 14;
		
		try {
			$ao = $this->activeobjectloader->get();
			if(!is_a($ao, ActiveObject::USER)) throw new ActiveObjectRequiredException();
			
			$user = $this->federated->get($ao, array('accountExpires'));
			//$date = strtotime("+$daysToAdd days", strtotime($user['accountExpires'][0]));
			//$date = $this->federated->convertToAD($date);
			
			//print $user['accountExpires'][0] . "<br><br>";
			
			$date = strtotime($user['accountExpires'][0]);
			$date = strtotime("+$daysToAdd days", $date);
			$date = $this->federated->convertToAD($date);
			
			//Final version converted into string since PHP goes wonky with the float-induced scientific notation
			$date = str_replace(',', '', number_format($date));
			
			$this->federated->modify($user['dn'], array('accountExpires' => $date));
			
			redirect($ao->url);
		}
		catch(Exception $e) {
			log_error('', 'Increase Identity Expiration', $e->getMessage());
			renderError("Unable to increase expiration on identity. See <a href='/logentries/'>log</a> for details.", null, $e);
		}
	}
	
	function createGmailAccount() {
		try {
			$this->load->library('gmail');
			
			if(!isset($_POST['username'])) throw new Exception('Username required for account creation.');
			elseif($this->gmail->get($_POST['username'])) throw new Exception("Gmail account already exists for " . $_POST['username']);
			
			$gmailUser = $this->gmail->createUser($_POST['username'], $_POST['firstName'], $_POST['lastName'], null, $_POST['uaid']);
			
			log_entry('', 'Create Gmail Account', $_POST['username']);
			redirect('/user/info/' . $_POST['username']);
		}
		catch(Exception $e) {
			log_error('', 'Create Gmail Account', $e->getMessage());
			
			if(!$this->input->is_ajax_request())
				renderError("Unable to create user. See <a href='/logentries/'>log</a> for details.", null, $e);
			else
				print "An error was encountered while creating the Gmail Account. Cannot complete action.";
		}
	}
	
}