<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Search extends CI_Controller {

	function index() {
		$search = $this->input->get_post('search');
		$filter = $this->input->get_post('filter');
		if(empty($filter)) $filter = 'all';
		if($search === false || empty($search)) redirect('/');
		
		$this->session->set_userdata('search', $search);
		$this->session->set_userdata('filter', $filter);
		
		$this->smartyparser->assign('filter', $filter);
		$this->smartyparser->assign('search', $search);
		
		$this->smartyparser->display('search.tpl');
	}
	
	function federated($filter, $search) {
		$this->load->library('federated', '', 'ldap');
		
		$info = array();
		foreach(preg_split("/ |\+/", $search) as $searchItem)
			$info = $this->combine($info, $this->ldap->search($filter, $searchItem));
		
		$this->smartyparser->assign('info', $info);
		$this->smartyparser->display('searchFederated.tpl');
	}
	
	
	function ad($filter, $search) {
		$this->load->library('activedirectory', '', 'ldap');
		
		$info = array();
		foreach(preg_split("/ |\+/", $search) as $searchItem)
			$info = $this->combine($info, $this->ldap->search($filter, $searchItem));
			
		$this->smartyparser->assign('info', $info);
		$this->smartyparser->display('searchAD.tpl');
	}
	
	function sunone($filter, $search) {
		$this->load->library('sunone', '', 'ldap');
		
		$info = array();
		foreach(preg_split("/ |\+/", $search) as $searchItem)
			$info = $this->combine($info, $this->ldap->search($filter, $searchItem));
			
		$this->smartyparser->assign('info', $info);
		$this->smartyparser->display('searchLDAP.tpl');
	}
	
	function courses($filter, $search) {
		//"201101_31601"
		$this->load->model('Coursemodel');
		$this->smartyparser->assign('info', $this->Coursemodel->search($filter, $search));
		$this->smartyparser->display('searchBlackboard.tpl');
	}
	
	function classname($filter, $search) {
		//"%Applied Software%"
		$this->load->model('Coursemodel');
		$this->smartyparser->assign('info', $this->Coursemodel->searchByDescription($search));
		$this->smartyparser->display('searchBlackboard.tpl');
	}
	
	private function combine(array $ary1, array $ary2) {
		if(empty($ary1)) return $ary2;
		
		$newAry = array();
		
		for($x = 0; $x < $ary1['count']; $x++) {
			for($y = 0; $y < $ary2['count']; $y++) {
				if($ary1[$x]['dn'] == $ary2[$y]['dn']) {
					array_push($newAry, $ary1[$x]);
					break;
				}
			}
		}
		
		$newAry['count'] = count($newAry);
		
		return $newAry;
	}
	
}