<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Course extends CI_Controller {

	public function index() {
		redirect('/');
	}
	
	public function info($pk1 = null) {
		if(is_null($pk1)) redirect('/');
		
		//Assign the ActiveObject variable
		$ao = $this->activeobjectloader->setCourse($pk1);
		if(!$ao) {
			$this->activeobjectloader->clear();
			renderError('Account could not be found.');
			return;
		}
		
		$pk1 = $ao->pk1;
		$this->smartyparser->assign('pk1', $ao->pk1);
		$this->smartyparser->assign('id', $ao->id);
		
		$this->load->model('Coursemodel');
		$info = $this->Coursemodel->get($ao);
		
		try {
			$enrollment = $this->Coursemodel->getEnrollment($ao);
			$enrollmentActiveCount = 0;
			foreach($enrollment as $listing)
				if($listing->enrollment_row_status == 0) $enrollmentActiveCount++;
		}
		catch(Exception $e) {
			$enrollmentActiveCount = 0;
			$enrollment = array();
		}
		
		$this->smartyparser->assign('course', $info);
		$this->smartyparser->assign('enrollment', $enrollment);
		$this->smartyparser->assign('enrollmentActiveCount', $enrollmentActiveCount);
		$this->smartyparser->assign('attributes', $this->moduleloader->getAttributes());
		$this->smartyparser->assign('buttons', $this->moduleloader->getButtons());
		
		$this->smartyparser->display('infoCourse.tpl');
	}

}