<?php


/**
 * Active Object for User accounts.
 * Manages saving and loading user accounts between sessions and provides
 * public access to loaded account information.
 **/
class AOUser extends ActiveObject {
	public $IMG_SRC = '/images/vista_people_icons/png/48x48/User.png';
	public $db;
	public $dn;
	public $uid;
	public $uaid;
	public $firstName;
	public $lastName;
	
	/**
	 * Instantiates member variables through directory lookups on the provided ID.
	 * The ID should either be a username or unique identifier for an account.
	 * This method will attempt to look up the account and deal with directory
	 * differences in how the account information is stored.
	 **/
	public function __construct($id) {
		$CI =& get_instance();
		
		//Strip off a potential 'x' prefix
		if(!is_numeric($id) && is_numeric(substr($id, 1))) {
			$id = substr($id, 1);
		}
		
		foreach(array('federated', 'sunone', 'activedirectory') as $db) {
			$CI->load->library($db);
			$info = $CI->$db->get($id);
			
			if($info) {
				$this->db = $db;
				break;
			}
		}
		
		switch($this->db) {
			case "sunone":
				$this->id = $info['uniqueidentifier'][0];
				$this->name = $info['cn'][0];
				$this->firstName = $info['givenname'][0];
				$this->uid = $info['uid'][0];
				$this->IMG_SRC = "/images/SunOneLogo.png";
				break;
		
			case 'activedirectory':
				$this->id = $info['uaIdentifier'][0];
				$this->name = $info['displayName'][0];
				$this->firstName = $info['givenName'][0];
				$this->uid = $info['name'][0];
				$this->IMG_SRC = "/images/ActiveDirectoryLogo.png";
				break;
				
			case 'federated':
				$this->id = $info['uaIdentifier'][0];
				$this->name = $info['displayName'][0];
				$this->firstName = $info['givenName'][0];
				$this->uid = $info['name'][0];
				$this->IMG_SRC = "/images/FederatedLogo.png";
				break;
				
			default:
				throw new Exception("User account could not be found");
		}
		
		if(!is_numeric($this->id)) throw new Exception("This account has a malformed UAID: " . $this->id);
		
		$this->uaid = $this->id;
		$this->lastName = $info['sn'][0];
		$this->url = "/user/info/" . $id;
		$this->dn = $info['dn'];
	}
	
	/**
	 * Restores a user account from the stored session variable.
	 **/
	public static function restoreFromSession() {
		$CI =& get_instance();
		$id = $CI->session->userdata('activeObjectId');
		$db = $CI->session->userdata('activeObjectDb');

		$ao = new AOUser($id, $db); 
		if(empty($ao)) return null;
		return $ao;
	}
	
	/**
	 * Saves the current user account to the session variable.
	 **/
	public function saveToSession() {
		$CI =& get_instance();
		$CI->session->set_userdata('activeObjectId', $this->id);
		$CI->session->set_userdata('activeObjectDb', $this->db);
	}
}

?>