<?php

/*********************************************MAIN.PHP FUNCTION(S) **************************************/
/* showMainPage: shows the contents for the main page*/
function showMainPage($project_count, $student_count, $faculty_count)
{
	echo'<p><h2>Welcome to the University of Alaska Anchorage' .
		'<br/>CAHDRE</h2></p>';
	echo '<div id="about"><p>';
	echo 'The Undergraduate Research Project Management System was developed by the <a href="http://www.uaa.alaska.edu/ours/">Office of Undergraduate Research and Scholarship</a> in conjunction with the <a href="http://www.uaa.alaska.edu/ours/about-ours/task-force/index.cfm">Task Force on Undergraduate Research and Scholarship</a>. ';
	echo '</p></div>'; 
	echo '<p>';
	echo "The system is a public, online database of research projects that involve undergraduates as part of the research team.  It is intended both to inform students, colleagues, and the community about UAA's undergraduate research projects.";
	echo '</p><br/>'; 
	echo'<p>There are currently <b>' . $project_count . '</b> projects,<b>' . 
		$student_count . '</b> students, and <b>' . 
		$faculty_count . '</b> faculty registered in the database.' .
		'</p>';
//		'<p>' .
//		'Last modified project: <br/>' .
//		'Last modified faculty: <br/>' .
//		'Last modified student: <br/>' .
//		'</p>';
}
/*********************************************************************************************************/

/**************************USER.PHP AND VIEW_USER.PHP FUNCTION(S) ******************************************/
//showUserPrivatePage(): shows the user's profile and module when they log in
function showUserPrivate($user)
{
	//header
	showUserHeader($user['fname']);
	
	//picture
	showPicture($user['username'], $user['picture']);

	if ($_SESSION['isFaculty'])
	{
		//module
		if ($user['activated']) showModuleMentor();
		else showModuleEmpty();
		//Profile
		echo '<div id="profile"><h2>Profile</h2>';
		showProfileMentor($user);
	}
	else
	{		
		//module
		showModuleMentee();
		//profile
		echo '<div id="profile"><h2>Profile</h2>';
		showProfileMentee($user);
	}
}

//showUserPublic(): shows the user's profile without the module
function showUserPublic($user)
{
	showUserHeader($user['fname']);
	showPicture($user['username'], $user['picture']);
	if($user['usertype']==1)
	{
		//Profile
		echo '<div id="publicprofile"><h2>Mentee Profile</h2>';
		showProfileMentee($user);

	}
	else
	{		
		//profile
		echo '<div id="publicprofile"><h2>Mentor Profile</h2>';
		showProfileMentor($user);
	}
}
function showPicture($username, $picture)
{
	if($picture=='nopic')
	{
		echo ('<div id="picture">' . '<img src= "seawolf.jpg"  width="150" align="middle" ></img></div><!--end picture-->');
		//echo ('<div id="picture">' . '<img src= "No_Photo.jpg"  width="250" height="300" align="middle" ></img></div><!--end picture-->');
	}
	else
	{
		echo ('<div id="picture">' . '<img src= "files/' . $username . '/image/' . $picture . '"  width="150" align="middle" ></img></div><!--end picture-->');
	}
}

//showModuleMentor(): shows the faculty's accessible controls which
//includes starting a new project
function showModuleMentor()
{
	echo '<div id ="module"><h2>User Control</h2>';
	echo'<p><a href="editMentor.php">Edit Profile</a></p>';
	echo'<p><a href="load_user_picture.php">Change Picture</a></p>';
	echo'<p><a href="new_project.php">Create Current Practice or New Project</a> (mentees associated with the mentor are added here)</p>';
	//echo'<p><a href="load_user_file.php">Add Shared Files</a></p>';
	echo'</div><!--end module-->';
}

function showModuleEmpty()
{
	echo '<div id ="module"><h2>User Control</h2>';
	echo'</div><!--end module-->';
}

//showModuleMentee(): shows the student's accessible controls
function showModuleMentee()
{
	echo '<div id ="module"><h2>User Control</h2>';
	echo'<p><a href="editMentee.php">Edit Profile</a></p>';
	echo'<p><a href="load_user_picture.php">Change Picture</a></p>';
	//echo'<p><a href="load_user_file.php">Add Shared Files</a></p>';
	echo'</div><!--end module-->';
}

//showProfileMentor() and showProfileMentee: shows specific user-type fields
function showProfileMentee($user)
{
	//echo '<p>';
	echo '<table cellspacing=10><tr>';
	echo ('<td>Name</td><td>' .$user['fname'] .' ' . $user['lname'] .'</td></tr>');
	echo ('<tr><td>Email</td><td><a href ="mailto:'. $user['email'] .'">' . $user['email'] .'</a></td></tr>');
	//echo ('<tr><td>Birthdate</td><td>' .$user['birthdate'] .'</td></tr>');
	echo ('<tr><td>School</td><td>' .$user['schoolname'] .'</td></tr>');
	echo '<td>Year/Grade in school</td><td>' . $user['cur_year'] . '</td></tr>';
	echo '<td>Expected graduation year</td><td>' . $user['graduation_year'] . '</td></tr>';
	if (strlen($user['major'])>0)
	{
		echo ('<tr><td>Major</td><td>' . $user['major'] . '</td></tr>');
	}
	if (strlen($user['facebook'])>0)
	{
		echo ('<tr><td>Facebook</td><td><a href ="http://www.facebook.com/'. $user['facebook'] .'">' . $user['facebook'] .'</a></td></tr>');
	}
	if (strlen($user['myspace'])>0)
	{
		echo ('<tr><td>Myspace</td><td><a href ="http://www.myspace.com/'. $user['myspace'] .'">' . $user['myspace'] .'</a></td></tr>');
	}
	if (($_SESSION['isFaculty']) || ($_SESSION['isAdmin']))
	{
		echo ('<tr><td>Address</td><td>' . $user['address'] . '</td></tr>');
		echo ('<tr><td>Current City</td><td>' . $user['curcity'] . '</td></tr>');
		echo ('<tr><td>Sex</td><td>' . $user['sex'] . '</td></tr>');
		echo ('<tr><td>Race/Ethnicity</td><td>' . $user['race'] . '</td></tr>');
		if (strlen($user['sid'])>0)
		{
			echo ('<tr><td>UAA Student ID</td><td>' . $user['sid'] . '</td></tr>');
		}
	}
	echo '</table>';
	echo '</p>';
	echo '<h2>About me</h2>';
	echo '<table cellspacing=10>';
	echo ('<tr><td>Languages spoken</td><td>' . $user['languages'] . '</td></tr>');
	if (($_SESSION['isFaculty']) || ($_SESSION['isAdmin']))
	{
		echo '<tr><td>Parent\'s Highest Education Level</td>';
		if ($user['parent_education_level']==0)
			echo '<td>K-6</td></tr>';
		else if ($user['parent_education_level']==1)
			echo '<td>7-8</td></tr>';
		else if ($user['parent_education_level']==2)
			echo '<td>9-12</td></tr>';
		else if ($user['parent_education_level']==3)
			echo '<td>Some College</td></tr>';
		else if ($user['parent_education_level']==4)
			echo '<td>Associate Degree</td></tr>';
		else if ($user['parent_education_level']==5)
			echo '<td>Baccaulaureate Degree</td></tr>';
		else if ($user['parent_education_level']==5)
			echo '<td>Post-Graduate Degree</td></tr>';
		echo ('<tr><td>Economically Disadvantaged</td><td>');
		if ($user['disadvantaged']==0)
			echo ' No';
		else
			echo ' Yes';
 		echo '</td></tr>';
		echo '<tr><td>Year Born</td>';
		echo '<td>' . date("Y",strtotime($user['birthdate'])) . '</td>';
 		echo '</tr>';
	}
	echo ('<tr><td>Extracurricular activities</td><td>' . $user['extracurricular'] . '</td></tr>');
	echo ('<tr><td>Career goals</td><td>' . $user['career_goals'] . '</td></tr>');
	echo '</table>';
	echo '<h2>Interests</h2>';
	echo ('<p>I\'m interested in Health Disparities because...</p>');
	echo ('<ul>' . htmlToVerbatim($user['interested_because']) . '</ul>');
	echo '<p>Health areas/topics of interest';
	echo ('<ul>' . htmlToVerbatim($user['interested_topics']) .'</ul>');
	echo '<table cellspacing=15><tr>';
	echo '<td>Preference for mentor\'s health field:</td><td>' . $user['mentor_field_pref'] . '</td></tr>';
	echo '</table>';
	echo '</div><!--end profile or public profile-->';
}

function showProfileMentor($user)
{
	if (($user['activated']==false) && (!isset($_SESSION['isAdmin'])))
	{
		echo 'This user is not yet activated.';
		return;
	}
	//echo '<p>';
	echo '<table cellspacing=15><tr>';
	echo ('<td>Name</td><td>' .$user['fname'] .' ' . $user['lname'] .'</td></tr>');
	echo ('<tr><td>Occupation</td><td>' .$user['occupation'] .'</td></tr>');
	echo ('<tr><td>Employer</td><td>' .$user['employer'] .'</td></tr>');
	if (strlen($user['department'])>0)
	   echo ('<tr><td>Department</td><td>' .$user['department'] .'</td></tr>');
	echo ('<tr><td>Email</td><td><a href ="mailto:'. $user['email'] .'">' . $user['email'] .'</a></td></tr>');
	if (strlen($user['facebook'])>0)
	{
		echo ('<tr><td>Facebook</td><td><a href ="http://www.facebook.com/'. $user['facebook'] .'">' . $user['facebook'] .'</a></td></tr>');
	}
	if (strlen($user['myspace'])>0)
	{
		echo ('<tr><td>Myspace</td><td><a href ="http://www.myspace.com/'. $user['myspace'] .'">' . $user['myspace'] .'</a></td></tr>');
	}
	if (isset($_SESSION['isAdmin']))
	{
		echo ('<tr><td>Phone</td><td>' .$user['phone'] .'</td></tr>');
		echo ('<tr><td>Sex</td><td>' .$user['sex'] .'</td></tr>');
		echo ('<tr><td>Race/Ethnicity</td><td>' .$user['race'] .'</td></tr>');
	}
	echo '</table>';
	echo '</p>';
	echo '<h2>About me</h2>';
	echo '<table cellspacing=10>';
	if (strlen($user['bachelors'])>0)
	{
		echo '<tr><td>Bachelors degree(s)</td><td>' . $user['bachelors'] . '</td></tr>';
	}
	if (strlen($user['masters'])>0)
	{
		echo '<tr><td>Masters degree(s)</td><td>' . $user['masters'] . '</td></tr>';
	}
	if (strlen($user['doctorates'])>0)
	{
		echo '<tr><td>Doctorate degree(s)</td><td>' . $user['doctorates'] . '</td></tr>';
	}
	echo '<tr><td>Years in current occupation</td><td>' . $user['years_work'] . '</td></tr>';
	echo '<tr><td>Occupation involves health disparities</td>';
	if ($user['health_disparities']==1)
		echo '<td>Yes</td></tr>';
	else
		echo '<td>No</td></tr>';
	echo ('<td>Languages spoken</td><td>' . $user['languages'] . '</td></tr>');
	echo ('<td>Areas of health expertise</td><td>' . $user['mentor_fields'] . '</td></tr>');
	echo '</table>';
	echo '<h2>Interests</h2>';
	echo ('<p>I\'m interested in Health Disparities because...</p>');
	echo ('<ul>' . htmlToVerbatim($user['interested_because']) . '</ul>');
	echo '<p>Relevant Health Research or Practice';
	echo ('<ul>' . htmlToVerbatim($user['relevant_research']) .'</ul>');
	echo '<table cellspacing=10><tr>';
	echo '<td>Preferred educational level of mentees</td><td>' . $user['mentee_educational_level'] . '</td></tr>';
	echo '</table>';
/*
	if (strlen($user['specific_grade_level']>0))
	{
	  echo '<table cellspacing=10><tr>';
	  echo '<td>Specific educational level of interest</td><td>' . $user['specific_grade_level'] . '</td></tr>';
 	  echo '</table>';
	}
*/
	if (isset($_SESSION['isAdmin']))
	{
	  echo '<table cellspacing=10><tr>';
	  echo '<td>Preferred Number of Mentees</td><td>' . $user['num_students'] . '</td></tr>';
	  echo '<td>Time Available for Mentorship</td><td>' . $user['time_available'] . '</td></tr>';
 	  echo '</table>';
	}
	echo '</div><!--end profile or public profile-->';
}

//showUserFileOpenTag(), showUserFile(), showUserFileCloseTag():
//functions to show list of user files, the open and closing html
//tags are in separate function since there could be multiple user files
function showUserFileOpenTag()
{
	echo '<div id="file"><h2>Shared Files</h2>';
	//echo '<p>';
	echo '<table cellspacing=10>';
	echo '<tr><td>File name</td><td>Description</td></tr>';
}
function showUserFile($row)
{
	
	$filename = $row['filename'];
	$description = $row['description'];
	$username = $row['username'];
	
	$path = 'files/' . $username . '/' . $filename;
	echo '<tr>';
	print('<td><a href="' . $path . '" target="_blank">' . $filename . '</a></td>');
	print('<td>' . $description . '</td>');
	echo '</tr>';
	
}
function showUserFileCloseTag()
{
	echo'</table>';
	echo'</p>';
	echo'</div><!--end file-->';
}
//opening and closing tags for the project listings at user profile
function showProjectOpenTag()
{	
	echo '<div id="project"><h2>Current Practice / Projects</h2>';
	echo '<p>';
	echo '<table cellspacing=10>';
	echo '<tr><td width=45%>Title</td><td width=10%>Status</td><td width=20%>Keywords</td><td width=13%>Activity Date</td><td width=12%>Action</td></tr>';
	
}
//showProject()--queries the database



function showProjectCloseTag()
{
	echo '</table>';
	echo '</p>';
	echo '</div><!--end project-->';
}
/***********************************************************************************************************************/

/*****************************************NEW_PROJECT AND EDIT_PROJECT FUNCTION(S) ******************************************************/
function showProjectNewFormPage()
{	
	echo '<table cellspacing = 8>';
	
	
	echo '<tr><td>';
	echo 'Begin typing the name or username of an existing mentor and select from the suggestion list:';
	echo '
		<div id="add_form">
			<form name="addMentor" action="newProjectParticipant.php" method="post">
				<div>
					<br />
					<input type="text" size="30" value="" name="inputStringMentor" id="inputStringMentor" onkeyup="lookupMentor(this.value);" onblur="fillMentor();" autocomplete=off />
				</div>

				<div class="suggestionsBox" id="suggestions1" style="display: none;">
					<div id="autoSuggestionsList1">&nbsp;</div>
				</div>
				<div>
					<input type="submit" name="add_submit" value="Add Mentor"/>
				</div>
			</form>
		</div>
	';
	echo '</td>';
	
	echo '<tr><td>';
	echo 'Begin typing the name or username of an existing mentee and select from the suggestion list:';
	echo '
		<div id="add_form">
			<form name="addMentee" action="newProjectParticipant.php" method="post">
				<div>
					<br />
					<input type="text" size="30" value="" name="inputStringMentee" id="inputStringMentee" onkeyup="lookupMentee(this.value);" onblur="fillMentee();" autocomplete=off />
				</div>

				<div class="suggestionsBox" id="suggestions2" style="display: none;">
					<div id="autoSuggestionsList2">&nbsp;</div>
				</div>
				<div>
					<input type="submit" name="add_submit" value="Add Mentee"/>
				</div>
			</form>
		</div>
	';
	echo '</td>';
	
	echo '<td>';

	echo '<table id="userTable" class="tablesorter">';
	echo '<thead>';
	echo '<tr>
			<th>Name</th>
			<th>Username</th>
			<th>Type</th>
			<th width="20%">Remove</th>
		</tr>';
	echo '</thead>';
	echo '<tbody>';
	
	$sql1 = "select username, usertype from researchers" . $_SESSION['username'] . ";";
	$result1 = mysql_query($sql1);
	$usernames = array();
	$names = array();
	$usertypes = array();
	if ($_SESSION['addPerformed'])
	{
		for ($i = 0; $i < mysql_num_rows($result1); $i++)
		{
			$row1 = mysql_fetch_assoc($result1);
			$usernames[$i] = $row1['username'];
			$names[$i] = $usernames[$i];
			$usertypes[$i] = $row1['usertype'];
		}
	}
	
	$names = getNames($names);
	
	for ($i = 0; $i < count($usernames); $i++)
	{
		if (trim($names[$i]) != ',')
		{
			echo '<tr>';
			echo '<td>' . $names[$i] . '</td>';
			echo '<td>' . $usernames[$i] . '</td>';
			echo '<td>' . $usertypes[$i] . '</td>';
			echo '<td align="center">';
			echo '<form action="newProjectParticipant.php" method="post">';
			echo '<input type="image" src="delete.png" width="20" height="20" />';
			echo '<input type="hidden" name="deleteResearcher" value="' . $usernames[$i] . '"/>';
			echo '</form>';
			echo '</td>';
			echo '</tr>';
		}
	}
	echo '</tbody>';
	echo '</table>';
	paginate();
	echo '</td></tr>';

	echo '<tr><td>';
	if (isset($_SESSION['addSuccessful']) && $_SESSION['addSuccessful'])
	{
		echo '<b>Administrator successfully added.</b>';
		unset($_SESSION['addSuccessful']);
	}
	else if (isset($_SESSION['addSuccessful']))
	{
		echo '<error_message>There was an error with your submission. Administrator not added.</error_message>';
		unset($_SESSION['addSuccessful']);
	}
	echo '</td></td></tr>';
	
	
	
	echo '<form name="project" action="new_project.php" method="post" /*onsubmit="return checkForm(this)"*/>';
	echo '<tr><td>Title if specific project, otherwise title describing the type of current practice</td><td><input type="text" name="project_title" maxlength="255" size=60/></td></tr>';
	//echo '<tr><td>Usernames of other collaborating mentors separated by a comma</td>';
	//echo '<td><input type="hidden" name="comentors" maxlength="255" size=60 value="'. $row['comentors'].'" /></td></tr>';
	//echo '<tr><td>Usernames of student mentees separated by a comma</td>';
	//echo '<td><input type="hidden" name="mentees" maxlength="255" size=60 value="'. $row['mentees'].'" /></td></tr>';
	echo '<tr><td>Start Date</td>';
	
	echo '<td><select name="smonth">';
	generateMonth($row['month']);
	echo '</select>';
	
	echo '<select name="sday">';
	generateDay($row['day']);
	echo '</select>';
	
	echo '<select name="syear">';
	generateYear($row['year']);
	echo '</select><br/>';

	echo '</td></tr>';

	echo '<tr><td>End Date (if not known, pick estimated future date)</td>';
	
	echo '	<td><select name="emonth">';		
	generateMonth($row['month']);
	echo '</select>';
	
	echo '<select name="eday">';
	generateDay($row['day']);
	echo '</select>';

	echo '<select name="eyear">';
	generateYear($row['year']);
	echo '</select><br/>';

	echo '</td></tr>';	
/*
	echo '<tr><td>Funding Source (if applicable)</td>';
	echo '	<td><input type="text" name="funding_source" maxlength="255" size=40 /></td></tr>';
	echo '<tr><td>Funding Amount (if applicable)</td>';
	echo '	<td><input type="text" name="funding_amount" maxlength="255" size=40 /></td></tr>';
*/
	echo '<input type="hidden" name="funding_source" value="">';
	echo '<input type="hidden" name="funding_amount" value="">';

	echo '<tr><td>Related Course (if applicable, e.g. CS A495)</td>';
	echo '	<td><input type="text" name="course" maxlength="255" size=40/></td></tr>';
	echo '<tr><td>Partner Agencies (if applicable)</td>';
	echo '	<td><input type="text" name="partner" maxlength="255" size=40/></td></tr>';
	echo '<tr><td>Status
		<td><input type="radio" name="status" value="1" checked/>In Progress<br>
		<input type="radio" name="status" value="2" />Complete</td></tr>';
	echo '<tr><td>Seeking mentees?
		<td><input type="radio" name="seeking_help" value="1" checked/>Yes<br>
		<input type="radio" name="seeking_help" value="0" />No</td></tr>';
	echo '<tr><td>Summary of Work / Abstract</td><td></td></tr>';
	echo '	<tr><td colspan = "2"><textarea name="abstract" style="width:100%;" rows="10"></textarea></td></tr>';
	echo '<tr><td>Keyword(s) <br/>
		Separate multiple keywords with a comma</td>';
	echo '<td><input type="text" name="keyword" maxlength="255" size=40/></td></tr>';
	echo '<tr><td></td> <td></td></tr>';
	echo '<tr><td><input type="submit" name="submit" value="Submit" />';
	echo '<input type="submit" name="cancel" value="Cancel" onclick="this.form.onsubmit=null; return true;"/></td></tr>';
	
	echo '</form>';
	
	echo '</table>';
	//echo '<script type="text/javascript">';
	/*echo 'window.onload=function(){populatedropdown("sday", "smonth", "syear")
						populatedropdown("eday", "emonth", "eyear")}';
	echo '</script>';*/
}

//show complete option faculty only
function showProjectEditFormPage($row)
{
	echo'<h2>Edit Your Current Practice / Project</h2>';

	//echo '<form name="project" action="edit_project.php?pid='. $row['pid'] .'" method="post" onsubmit="return checkForm(this)">';
	echo '<table>';
	if($row['isFaculty'])
	{
	
		echo '<tr><td>';
		echo 'Begin typing the name or username of an existing mentor and select from the suggestion list:';
		echo '
			<div id="add_form">
				<form name="addMentor" action="addResearcher.php" method="post">
					<div>
						<br />
						<input type="text" size="30" value="" name="inputStringMentor" id="inputStringMentor" onkeyup="lookupMentor(this.value);" onblur="fillMentor();" autocomplete=off />
					</div>

					<div class="suggestionsBox" id="suggestions1" style="display: none;">
						<div id="autoSuggestionsList1">&nbsp;</div>
					</div>
					<div>
						<input type="submit" name="add_submit" value="Add Mentor"/>
					</div>
				</form>
			</div>
		';
		echo '</td>';

		echo '<tr><td>';
		echo 'Begin typing the name or username of an existing mentee and select from the suggestion list:';
		echo '
			<div id="add_form">
				<form name="addMentee" action="addResearcher.php" method="post">
					<div>
						<br />
						<input type="text" size="30" value="" name="inputStringMentee" id="inputStringMentee" onkeyup="lookupMentee(this.value);" onblur="fillMentee();" autocomplete=off />
					</div>

					<div class="suggestionsBox" id="suggestions2" style="display: none;">
						<div id="autoSuggestionsList2">&nbsp;</div>
					</div>
					<div>
						<input type="submit" name="add_submit" value="Add Mentee"/>
					</div>
				</form>
			</div>
		';
		echo '</td>';
		
		
		echo '<td>';
		
		echo '<table id="userTable" class="tablesorter">';
		echo '<thead>';
		echo '<tr>
				<th>Name</th>
				<th>Username</th>
				<th>Type</th>
				<th width="23%">Remove</th>
			</tr>';
		echo '</thead>';
		echo '<tbody>';
		$m1 = explode(',', $row['comentors']);
		$m2 = explode(',', $row['mentees']);
		$usernames = array_merge($m1, $m2);
		$names = array_merge($row['comentors_names'], $row['mentees_names']);
		for ($i = 0; $i < count($usernames); $i++)
		{
			if (trim($names[$i]) != ',')
			{
				echo '<tr>';
				echo '<td>' . $names[$i] . '</td>';
				echo '<td>' . $usernames[$i] . '</td>';
				
				if ($i < count($m1))
					echo '<td>Mentor</td>';
				else
					echo '<td>Mentee</td>';
				
				echo '<td align="center">';
				echo '<form action="deleteResearcher.php" method="post">';
				echo '<input type="image" src="delete.png" width="20" height="20" />';
				echo '<input type="hidden" name="deleteResearcher" value="' . $usernames[$i] . '"/>';
				echo '</form>';
				echo '</td>';
				echo '</tr>';
			}
		}
		echo '</tbody>';
		echo '</table>';
		paginate();
		$_SESSION['comentors'] = $row['comentors'];
		$_SESSION['mentees'] = $row['mentees'];
		$_SESSION['proj_id'] = $_GET['pid'];
		echo '</td></tr>';

	}
	echo '<tr><td>';
	if (isset($_SESSION['addSuccessful']) && $_SESSION['addSuccessful'])
	{
		echo '<b>Administrator successfully added.</b>';
		unset($_SESSION['addSuccessful']);
	}
	else if (isset($_SESSION['addSuccessful']))
	{
		echo '<error_message>There was an error with your submission. Administrator not added.</error_message>';
		unset($_SESSION['addSuccessful']);
	}
	echo '</td><td></td></tr>';
	
	echo '<form name="project" action="edit_project.php?pid='. $row['pid'] .'" method="post" onsubmit="return checkForm(this)">';
	echo '<tr><td>Title</td><td><input type="text" name="project_title" maxlength="255" value="'. $row['project_title'] . '" size=50 /></td></tr>';
	if($row['isFaculty'])
	{
		echo '<input type="hidden" name="comentors" maxlength="255" value="'. $row['comentors'] .'" size=50/>';
		echo '<input type="hidden" name="mentees" maxlength="255" value="'. $row['mentees'] .'" size=50/>';
	}
	
	echo '<tr><td>Start Date</td>';
	
	echo '<td><select name="smonth">';
	generateMonth($row['smonth']);
	echo '</select>';
	
	echo '<select name="sday">';
	generateDay($row['sday']);
	echo '</select>';
	
	echo '<select name="syear">';
	generateYear($row['syear']);
	echo '</select><br/>';

	echo '</td></tr>';

	echo '<tr><td>End Date</td>';
	
	echo '	<td><select name="emonth">';		
	generateMonth($row['emonth']);
	echo '</select>';
	
	echo '<select name="eday">';
	generateDay($row['eday']);
	echo '</select>';

	echo '<select name="eyear">';
	generateYear($row['eyear']);
	echo '</select><br/>';

	echo '</td></tr>';

/*
	echo '<tr><td>Funding Source (if applicable)</td>';
	echo '	<td><input type="text" name="funding_source" maxlength="255" value = "' . $row['funding_source'] . '" size=50 /></td></tr>';
	echo '<tr><td>Funding Amount (if applicable)</td>';
	echo '	<td><input type="text" name="funding_amount" maxlength="255" value = "' . $row['funding_amount'] . '" size=50 /></td></tr>';
*/

	echo '<tr><td>Related Course (if applicable, e.g. CS A495)</td>';
	echo '	<td><input type="text" name="course" maxlength="255" value = "' . $row['course'] . '" size=50 /></td></tr>';
	echo '<tr><td>Community Partner (if applicable)</td>';
	echo '	<td><input type="text" name="partner" maxlength="255" value = "' . $row['partner'] . '" size=50 /></td></tr>';

	if($row['isFaculty'])
	{
		if($row['status']==1)
		{
			echo '<tr><td>Status
				<td><input type="radio" name="status" value="1" checked/>In Progress
				<input type="radio" name="status" value="2" />Complete</td></tr>';
		}
		else
		{
			echo '<tr><td>Status
				<td><input type="radio" name="status" value="1" />In Progress
				<input type="radio" name="status" value="2" checked/>Complete</td></tr>';
		}
		if($row['seeking_help']==1)
		{
			echo '<tr><td>Seeking mentees?
				<td><input type="radio" name="seeking_help" value="1" checked/>Yes
				<input type="radio" name="seeking_help" value="0" />No</td></tr>';
		}
		else
		{
			echo '<tr><td>Seeking mentees?
				<td><input type="radio" name="seeking_help" value="1" />Yes
				<input type="radio" name="seeking_help" value="0" checked/>No</td></tr>';
		}
	}
	echo '<tr><td>Summary of Work / Abstract</td><td></td></tr>';
	echo '<tr><td colspan="2"><textarea name="abstract" style="width: 100%;"  rows="10">' . $row['abstract'] . '</textarea></td></tr>';
	echo '<tr><td>Keyword(s)<br/>Separate multiple keywords with a comma</td>';
	echo '	<td><input type="text" name="keyword" maxlength="255" value="'.$row['k_words'] . '" size=50/></td></tr>';
	echo '<tr><td></td> <td></td></tr>';
	echo '<tr><td><input type="submit" name="submit" value="Submit" />';
	echo '<input type="submit" name="cancel" value="Cancel" onclick="this.form.onsubmit=null; return true;" /></td></tr>';
	
	echo '</form>';
	echo '</table>';
	
	//echo '<p>Return to <a href ="project.php?pid=' . $row['pid'] . '">' . $row['project_title'] . '</a> project page.</p>';
}



/***********************************************************************************************************************/

/**************************************LOAD_USER_FILE.PHP FUNCTION(S) **********************************************************/
function showUploadUserFile($username)
{
	print('<p>');
	print('<h2>Manage Shared File Attachments</h2>');
	print('</p>');
	print('<p>Attach or remove an electronic document to your profile (e.g. vita, research documents, files not related to a specific project, etc.)<p><b>These files may be viewed by anyone.  There is a 4 MB limit.</b></p></p>');
	print('<br />');
	placeApostrophe($username);
	print(' files</h2>');
	print('<table style="padding: 5px 10px; width: 100%; border-top:1px solid #8D8D8D; border-bottom:1px solid #8D8D8D;">');
	print('<tr style="background-color: #D4DFD4;">');
	print('<td>Filename</td><td>Description</td><td style="width: 90px;">Uploaded by</td><td  style="width: 20px;">Action</td>');
	print('</tr>');
}

function showUserFileUploaded($row)
{	
	$username = $row['username'];
	$filename = $row['filename'];
	$description = $row['description'];
	$path = 'files/' . $username . '/' . $filename;
	//file link
	print('<tr>');
	print('<td><a href="'. $path . '" target="_blank">' . $filename . '</a></td>');
	print('<td>' . $description . '</td>');
	print('<td>' . $username . '</td>');
	//delete button
	print('<td>');
	print('<form action="load_user_file.php" method="post">');
	print('<input type="hidden" name="username" value="'. $username .'">');
	print('<input type="hidden" name="file" value="' . $filename . '">');
	print('<input type="submit" name="delete" value="Delete" style="font-size: 9px;">');
	print('</form>');
	print('</td>');
	print('</tr>');
}

function showAttachUserFileForm($username)
{
	print('<br />');
	print('<h2>Attach File</h2>');
	print('<form enctype="multipart/form-data" action="load_user_file.php" method="post">');
	print('<input type="hidden" name="username" value="'. $username . '" />');
	print('<input type="hidden" name="MAX_FILE_SIZE" value="9999999" />');
	print('<table style="padding: 5px 10px; width: 100%;">');  
	print('<tr>');
	print('<td>Choose a file to upload:</td><td><input name="uploadedfile" type="file" /></td>');
	print('</tr>');
	print('<tr>');
	print('<td>Enter a description of the file:</td><td><input type="text" name="description" size="60" /></td>');
	print('</tr>');
	print('</table>');
	print('<p>');
	print('<input type="submit" name="attach" value="Attach File" />');
	print('<input type="submit" name="cancel" value="Cancel" />');
	print('</p>');
	print('</form>');
}
/**********************************************************************************************************************/
/***********************************LOAD_PROJECT_FILE.PHP FUNCTION(S)**************************************************/
//title: project title
function showUploadProjectFile($title)
{
	echo'<h2>Manage File Attachments for Current Practice / Project: ' . $title . '</h2>';
	echo'<p>Attach or remove an electronic document to your project(e.g. PowerPoint, Documentation, Images, etc.)</p>';
	echo'<br/>';
	echo'<h2>' . $title . ' files</h2>';
	print('<table style="padding: 5px 10px; width: 100%; border-top:1px solid #8D8D8D; border-bottom:1px solid #8D8D8D;">');
	print('<tr style="background-color: #D4DFD4;">');
	print('<td>Filename</td><td>Description</td><td style="width: 90px;">Uploaded by</td><td  style="width: 20px;">Action</td>');
	print('</tr>');
	

}
//row: username, project_id, filename, description--add date
function showProjectFileUploaded($row)
{	
	$username = $row['username'];
	$project_id = $row['project_id'];
	$filename = $row['filename'];
	//$filetype = $row['filetype'];
	$description = $row['description'];
	$path = 'files/' . $project_id . '/' . $filename;
	//file link
	print('<tr valign=baseline>');
	print('<td><a href="'. $path . '" target="_blank">' . $filename . '</a></td>');
	print('<td>' . $description . '</td>');
	print('<td>' . $username . '</td>');
	//delete button
	print('<td>');
	print('<form action="load_project_file.php?pid=' . $project_id . '" method="post">');
	print('<input type="hidden" name="project_id" value="'. $project_id .'">');
	print('<input type="hidden" name="file" value="' . $filename . '">');
	print('<input type="submit" name="delete" value="Delete" style="font-size: 9px;">');
	print('</form>');
	print('</td>');
	
	
	print('</tr>');
}

function showAttachProjectFileForm($project_id)
{
	print('<br />');
	print('<h2>Attach File</h2>');
	print('<form enctype="multipart/form-data" action="load_project_file.php?pid=' . $project_id .'" method="post">');
	print('<input type="hidden" name="project_id" value="'. $project_id . '" />');
	print('<input type="hidden" name="MAX_FILE_SIZE" value="9999999" />');
	print('<table style="padding: 5px 10px; width: 100%;">');  
	print('<tr>');
	print('<td>Choose a file to upload:</td><td><input name="uploadedfile" type="file" /></td>');
	print('</tr>');
	print('<tr>');
	print('<td>Enter a description of the file:</td><td><input type="text" name="description" size="60" /></td>');
	print('</tr>');
	print('</table>');
	print('<p>');
	print('<input type="submit" name="attach" value="Attach File" />');
	print('<input type="submit" name="cancel" value="Cancel" />');
	print('</p>');
	print('</form>');
}





/*********************************************************************************************************************/
/**********************************************************LOAD_USER_PICTURE.PHP FUNCTION(S)***************************************************/
function showPictureUpload($username, $picture)
{
	if($picture!='nopic')
	{
	   	echo'<p>';
		echo'<table style="padding: 5px 10px;">';
		echo'<tr><td>Your Profile Image</td><td></td></tr>';
		echo'<tr><td><img src= "files/' . $username . '/image/' . $picture . '"  width="150"></img></td><td></td></tr>';
		echo'<tr><td>';
		echo'<form action="load_user_picture.php" method="post">';
		echo'<input type="hidden" name="picture" value="' . $picture . '">';
		echo'<input type="submit" name="delete" value="Remove Picture">';
		echo'</form>';
		echo'</td><td></td>';
		echo'</tr>';
		echo'</table>';
		echo'</p>';
	}
}

function showAttachUserPictureForm($wrongFileType)
{
	echo'<h2>Upload Image to Profile</h2>';
	echo'<p>Image files must be in JPEG, GIF, or PNG format and will be displayed 150 pixels wide and at most 200 pixels tall.</p>';
	if($wrongFileType)
	{
		echo '<h4>Warning: wrong file type.  Please use a file of type ".jpg", ".jpeg", ".gif", or ".png".</h4>';
	}
	echo'<p>';
	echo'<form  enctype="multipart/form-data" action="load_user_picture.php" method="post">';
	echo'<input type="hidden" name="MAX_FILE_SIZE" value="9999999" />';
	echo'<table style="padding: 5px 10px;">';
	echo'<tr>';
	echo'<td ><strong>Image file:</strong></td>';
	echo'<td><input name="uploadimage" type="file" /><br /></td>';
	echo'<td><input type="submit" name="setpicture" value="Upload Image" /></td>';
	echo'</tr>';
	echo'</form>';
	echo'</table>';
	echo'</p>';
}





/************************************PROJECT.PHP AND VIEW_PROJECT.PHP FUNCTION(S) ************************************/
//showModuleProject(): shows the controls for the project page
function showModuleProjectFaculty($pid)
{
	echo'<div id="projectmodule">';
	echo'<h2>Controls</h2>';
	echo'<p><a href="edit_project.php?pid='. $pid .'">Edit This Current Practice / Project</a></p>';
	echo'<p><a href="load_project_file.php?pid='. $pid .'">Manage Shared Files (e.g. deliverables) Attached to This Current Practice / Project</a></p>';
	echo'<p><a href="delete_project.php?pid='. $pid .'">Delete This Current Practice / Project</a></p>';
	echo'</div><!--end projectmodule-->';
}

function showModuleProjectFacultyDeleteWarning($pid)
{
	echo'<div id="projectmodule">';
	echo'<h2>Controls</h2>';
	echo'<p><font color="red">Warning! You are about to delete this current practice / project</font></p>';
	echo'<p><font color="red">If this work is complete, please mark it complete instead of deleting.</font></p>';
	echo'<table><tr><td></td>';
	echo'<td><form name="projdelete" action="delete_project.php?pid=' . $pid . '" method="post">';
	echo'<input style="font-size:10pt" type="submit" name="delete" value="Delete"/></form></td>';
	echo'<td></td><td><form name="projdeletecancel" action="cancel_delete.php?pid=' . $pid .'" method="post">';
	echo'<input style="font-size:10pt" type="submit" name="cancel" value="Cancel"/></form></td>';	
	echo'</tr></table></div><!--end projectmodule-->';
	
}

function showModuleProjectFacultyWarning($pid)
{
	echo'<div id="projectmodule">';
	echo'<h2>Controls</h2>';
	echo'<p><a href="edit_project.php?pid='. $pid .'">Edit Current Practice / Project</a></p>';
	echo'<p><a href="load_project_file.php?pid='. $pid .'">Manage Shared Files (e.g. deliverables)</a></p>';
	echo'<p><font color="red">This work is past its End Date</font></p>';
	echo'<p><font color="red">Mark this Current Practice / Project Complete or extend the End Date using the Edit link</font></p>';
	echo'</div><!--end projectmodule-->';
}

function showModuleProjectStudentWarning($pid)
{
	echo'<div id="projectmodule">';
	echo'<h2>Controls</h2>';
	echo'<p><a href="edit_project.php?pid='. $pid .'">Edit Current Practice / Project</a></p>';
	echo'<p><a href="load_project_file.php?pid='. $pid .'">Manage Shared Files (e.g. deliverables)</a></p>';
	echo'<p><font color="red">This Current Practice / Project is past its End Date</font></p>';
	echo'<p><font color="red">Have your faculty mentor mark this work Complete or extend the End Date using the Edit link</font></p>';
	echo'</div><!--end projectmodule-->';
}

function showModuleProjectStudent($pid)
{
	echo'<div id="projectmodule">';
	echo'<h2>Controls</h2>';
	echo'<p><a href="edit_project.php?pid='. $pid .'">Edit Current Practice / Project</a></p>';
	echo'<p><a href="load_project_file.php?pid='. $pid .'">Manage Shared Files (e.g. deliverables)</a></p>';
	echo'</div><!--end projectmodule-->';
}


//showProfileProject(): shows the project info
function showProfileProject($project, $divid)
{
	echo'<div id="'. $divid .'">';
	echo'<h2>' . $project['project_title'] . '</h2>';
	echo'<p>';
	echo'<table cellspacing=10>';
	if($project['status']== 1)
	{
		echo'<tr><td>Status</td><td>' . 'Current' . '</td></tr>';
	}
	else
	{
		echo'<tr><td>Status</td><td>' . 'Completed' . '</td></tr>';
	}
	if($project['seeking_help']== 1)
	{
		echo'<tr><td>Seeking Mentees</td><td>' . 'Yes' . '</td></tr>';
	}
	else
	{
		echo'<tr><td>Seeking Mentees</td><td>' . 'No' . '</td></tr>';
	}
	echo'<tr><td>Start Date</td><td>' . $project['start_date'] . '</td></tr>';
	echo'<tr><td>End Date</td><td>' . $project['end_date'] . '</td></tr>';
/*
	echo'<tr><td>Funding Source</td><td>' . $project['funding_source'] . '</td></tr>';
	if ($project['funding_amount'] > 0)
	  echo'<tr><td>Funding Amount</td><td>' . "$" . number_format($project['funding_amount']) . '</td></tr>';
	else
	  echo'<tr><td>Funding Amount</td><td></td></tr>';
*/
	echo'<tr><td>Community Partner</td><td>' . $project['partner'] . '</td></tr>';
	echo'<tr><td>Related Course</td><td>' . $project['course'] . '</td></tr>';
	echo'<tr><td>Last Updated</td><td>' . $project['modification_date'] . '</td></tr>';
	echo'<tr><td>Keywords</td><td>' . $project['keywords'] . '</td></tr>';

	echo'</table>';
	echo'</p>';
	
	echo'</div><!--end projectinfo-->';
}

function showCollaboratorOpenTag()
{
	echo'<div id="collaborator"><h2>People</h2>';
}
function showMentor($row)
{
	echo'<a href="view_user.php?username=' . $row['mentor'] . '">' . $row['fname'] . " " . $row['lname'] . '</a>';

}
function showResearcher($row)
{
	if ($row['standing_started']=="")
		echo'<a href="view_user.php?username=' . $row['researcher'] . '">' . $row['fname'] . " " . $row['lname'] . '</a>)';
	else
		echo'<a href="view_user.php?username=' . $row['researcher'] . '">' . $row['fname'] . " " . $row['lname'] . '</a> (' . $row['standing_started'] . ')';

}

function showCollaboratorCloseTag()
{
	echo'</div><!--end collaboratror-->';
}

function htmlToVerbatim($html)
{
        $html2 = str_replace("\n", "<br />", $html);
	return stripslashes($html2);
}

function showAbstract($abstract)
{
	echo'<div id="abstract"><h2>Summary / Abstract</h2>';
	echo'<p>';
        $abstract2 = str_replace("\n", "<br />", $abstract);
	echo stripslashes($abstract2);
	echo'</p>';
	echo'</div><!--end abstract-->';
}

function showProjectFileOpenTag()
{
	echo '<div id="file"><h2>Shared Files (e.g. papers, presentations)</h2>';
	echo '<table style="width: 100%; padding: 5px 10px;">';
	echo '<tr><td>File name</td><td>Description</td><td>Uploaded by</td></tr>';
}
function showProjectFile($row)
{
	
	$project_id=$row['project_id'];
	$filename = $row['filename'];
	$description = $row['description'];
	$username = $row['username'];
	
	$path = 'files/' . $project_id . '/' . $filename;
	echo '<tr>';
	print('<td><a href="' . $path . '" target="_blank">' . $filename . '</a></td>');
	print('<td>' . $description . '</td>');
	print('<td>' . '<a href="view_user.php?username='. $username . '">' . $username . '</a></td>');
	echo '</tr>';
	
}
function showProjectFileCloseTag()
{
	echo'</table>';
	echo'</div><!--end file-->';
}






/***********************************************************************************************************************/

/***************************************EDIT_USER.PHP FUNCTION(S) ********************************************************/
function showEditUserPage($user)
{
	echo'<h2>Edit Profile for ' . $user['username'] . '</h2>';
	echo'<table style="padding: 5px 10px; vertical-align:bottom;">';
	echo'<form name="uedit" action="edit_user.php" method="post" /*onSubmit = "return checkForm(this)"*/>';
	echo'<tr>';
	
	echo'<td>First Name</td>'; 
	echo'<td><input type="text" name="fname"   value="' . $user['fname'] .'" maxlength="255" size=40/></td>';
	echo'</tr><tr>';
	
	echo'<td>Last Name</td>'; 
	echo'<td><input type="text" name="lname" value="' . $user['lname'] .'"  maxlength="255" size=40/></td>';
	echo'</tr><tr>';
	
	echo'<td>Email</td>'; 
	echo'<td><input type="text" name="email" value="' . $user['email'] .'" maxlength="255" size=40/></td>';
	echo'</tr><tr>';
	
	echo'<td>Url</td>'; 
	echo'<td><input type="text" name="url" value="' . $user['url'] .'" maxlength="255" size=40/></td>';
	echo'</tr><tr>';
	
	//if user type is a faculty, print faculty form
	//if($user['usertype']=='faculty')
	if ($_SESSION['isFaculty'])
	{
				
		echo'<td>Title</td>'; 
		echo'<td><input type="text" name="title" value="' . $user['title'] .'" maxlength="255" size=40/></td>';
		echo'</tr><tr>';

		echo'<td>Department</td>'; 
		echo'<td><input type="text" name="department" value="' . $user['department'] .'" maxlength="255" size=40/></td>';
		echo'</tr><tr>';

		echo'<td>Campus</td>'; 
		echo'<td><input type="text" name="campus" value="' . $user['campus'] .'" maxlength="255" size=40/></td>';
		echo'</tr><tr>';


	}
	else
	{
		echo'<td>Student Status</td>'; 
		echo'<td>';
		
		if ($user['userstatus'] == "H")
		{
			echo'<input type="radio" name="status" value="H" checked/> High School Student or Graduate';
			echo'<br/><input type="radio" name="status" value="U"/> Undergraduate Student';
			echo'<br/><input type="radio" name="status" value="G"/> Graduate Student';
			echo'<br/><input type="radio" name="status" value="Z"/> Not Applicable';		
		}
		else if ($user['userstatus'] == "U")
		{
			echo'<input type="radio" name="status" value="H"/> High School Student or Graduate';
			echo'<br/><input type="radio" name="status" value="U" checked/> Undergraduate Student';
			echo'<br/><input type="radio" name="status" value="G"/> Graduate Student';
			echo'<br/><input type="radio" name="status" value="Z"/> Not Applicable';				
		}
		else if ($user['userstatus'] == "G")
		{
			echo'<input type="radio" name="status" value="H"/> High School Student or Graduate';
			echo'<br/><input type="radio" name="status" value="U"/> Undergraduate Student';
			echo'<br/><input type="radio" name="status" value="G" checked/> Graduate Student';
			echo'<br/><input type="radio" name="status" value="Z"/> Not Applicable';				
		}
		else if ($user['userstatus'] == "Z")
		{
			echo'<input type="radio" name="status" value="H"/> High School Student or Graduate';
			echo'<br/><input type="radio" name="status" value="U"/> Undergraduate Student';
			echo'<br/><input type="radio" name="status" value="G"/> Graduate Student';
			echo'<br/><input type="radio" name="status" value="Z" checked/> Not Applicable';				
		}
		else
		{
			echo'<input type="radio" name="status" value="H"/> High School Student or Graduate';
			echo'<br/><input type="radio" name="status" value="U" checked/> Undergraduate Student';
			echo'<br/><input type="radio" name="status" value="G"/> Graduate Student';
			echo'<br/><input type="radio" name="status" value="Z"/> Not Applicable';
		}
		
		echo'</td>';
		echo'</tr><tr>';
		
		echo'<td>Major</td>'; 
		echo'<td><input type="text" name="major" value="' . $user['major'] .'" maxlength="255" size=40/></td>';
		echo'</tr><tr>';
		
		//show date
		echo'<td>Expected Graduation Date</td>'; 
		echo'<td>';

		echo'<select name="graduation_semester">';
		if ($user['graduation_semester']=='Fall')
		  echo'<option value="Fall" selected>Fall</option>';
		else
		  echo'<option value="Fall">Fall</option>';
		if ($user['graduation_semester']=='Spring')
		  echo'<option value="Spring" selected>Spring</option>';
		else
		  echo'<option value="Spring">Spring</option>';
		if ($user['graduation_semester']=='Summer')
		  echo'<option value="Summer" selected>Summer</option>';
		else
		  echo'<option value="Summer">Summer</option>';
		echo'</select>';

		echo'<select name="graduation_year">';
		for ($i = 2005; $i <= 2030; $i++)
		{
			if ($user['graduation_year']==$i)
			  echo'<option value=' . $i . ' selected>' . $i . '</option>';
			else
			  echo'<option value=' . $i . ' >' . $i . '</option>';
		}
		echo'</select>';
		echo'</td>';
		echo'</tr><tr>';

		echo'<td>Career Goals</td>'; 
		echo'<td><input type="text" name="career_goals" value="' . $user['career_goals'] .'" maxlength="255" size=40/></td>';
		echo'</tr><tr>';

	}
	echo'<tr></tr><tr></tr><td>About me</td>';
	echo'<td></td></tr><tr>';
	echo'<td colspan="2"><textarea name="info" cols="53" rows="10" >'. $user['info']. '</textarea></td>';
	echo'</tr><tr>';
	
	echo'<tr></tr><tr></tr><td>Research Interests</td>';
	echo'<td></td></tr><tr>';
	echo'<td colspan="2"><textarea name="research_interest" cols="53" rows="10" >'. $user['research_interest'] . '</textarea></td>';
	echo'</tr><tr>';
	
	echo'<td><input type="submit" name="submit" value="Submit" />';
	echo'<input type="submit" name="cancel" value="Cancel" onclick="this.form.onsubmit=null; return true;" /></td>';
	echo'</tr>';
	echo'</form>';
	echo'</table>';
}

function showEditSuccess()
{
	//echo'Your Profile has been updated!';
	//echo'<a href="user.php">Return to homepage</a>';
	header("Location: user.php");
}
/***********************************************************************************************************************/



//edit this
/*********************************************SEARCH.PHP FUNCTION(S)*********************************************/

function showSearchForm()
{
	echo '<table class="searchtable">';
	
	echo '<tr><td><form name="searchKeywords" action="search.php" method="GET">';
	echo '<input class="searchbox" type="text" name="searchKeywords" value="Search Keywords" maxlength="255" 
				onKeyPress="checkEnter(event)" onfocus="searchfield_focus(this)" onblur="searchfield_blur(this)"/>';
	echo '<input type="submit" name="submit" value="Search" class="searchbutton"/>';
	echo '</form></td>';
	echo '</tr></table>';
}

// This returns an array of project ID's that contain the keywords
// entered in the "search keywords" textbox
function keywordSearch($ids)
{
	if($_GET['searchKeywords'])
	{
		//$keywords = mysql_real_escape_string(trim($_GET['searchKeywords']));
		$keywords = $_GET['searchKeywords'];
		$sql = "SELECT DISTINCT project.project_id as id
				FROM project, keywordproject, keyword
				WHERE keywordproject.project_id = project.project_id
				AND keywordproject.k_id = keyword.k_id
				AND (";
		// If keywords only, interpret keywords literally
		// (don't separate out spaces)
		if (!isset($_GET['keywordsOnly']))
			$arr = explode(" ", $keywords);
		else
			$arr[] = $keywords;

		$first = true;
		foreach ($arr as $val)
		{
			$keyword = trim($val);
			if ($keyword != "")
			{
				if ($first == true)
				{
					$sql = $sql . "keyword.k_word LIKE '%" . $keyword . "%' ";
					$first = false;
				}
				else
				{
					$sql = $sql . "OR keyword.k_word LIKE '%" . $keyword . "%' ";
				}
			}
		}
		$sql = $sql . ");";

		$result = mysql_query($sql);
		if($result)
		$row=mysql_fetch_assoc($result);
		while($row)
		{
			$id = $row['id'];
			if (is_int(array_search($id, $ids)) == false)
				$ids[] = $row['id'];
			$row=mysql_fetch_assoc($result);
		}
	}
	return $ids;
}

function paginate()
{
	echo '<div id="pager" class="pager">
		<form>
			<img src="jquery.tablesorter/addons/pager/icons/first.png" class="first"/>
			<img src="jquery.tablesorter/addons/pager/icons/prev.png" class="prev"/>
			<input type="text" class="pagedisplay"/>
			<img src="jquery.tablesorter/addons/pager/icons/next.png" class="next"/>
			<img src="jquery.tablesorter/addons/pager/icons/last.png" class="last"/>
			  Results per page:
			<select class="pagesize">
				<option selected="selected"  value="10">10</option>
				<option value="20">20</option>
				<option value="30">30</option>
				<option  value="40">40</option>
			</select>
		</form>
	</div>';
}

// This function displays the actual results entered in the keywords
// box.  It searches keywords, last name, title, abstract
function searchKeywords()
{
	if($_GET['searchKeywords'])
	{
		//$keywords = mysql_real_escape_string(trim($_GET['searchKeywords']));
		$ids = array();
		$ids = keywordSearch($ids);
		// Don't search names/titles/abstracts if keywords only set
//print "keywords: " . $keywordsOnly . "<p>";
		if (!isset($_GET['keywordsOnly']))
		{
		 $ids = nameSearch($ids);
		 $ids = titleSearch($ids);
		 $ids = abstractSearch($ids);
		}
		$printheader = false;
		$i = 1;
		
		foreach ($ids as $id)
		{
		   $sql = "SELECT DISTINCT project.abstract, project.status, project.project_title as title, project.project_id as id FROM project WHERE project.project_id = " . $id . ";";
		   $result = mysql_query($sql);
		   if($result)
			$row=mysql_fetch_assoc($result);
		   if($row)
		   {
			if ($printheader == false)
			{
			   echo'<h2>Keyword Result(s) for "' . $_GET['searchKeywords'] . '"</h2>';
			   echo'<div id="searchresults"><table class="tablesorter" id="resultsTable">';
			   echo '<thead>';
			   echo'<tr><th>#</th><th width=75%>Title</th><th>Status</th></tr>';
			   echo '</thead>';
			   $printheader = true;
			   echo '<tbody>';
			}
			echo'<tr><td>' . $i++ . '.</td><td>';

   			$researchers = get_investigator($id);
		   	// Keywords
   			$sql = "SELECT k_word FROM keywordproject, keyword WHERE keywordproject.k_id = keyword.k_id and project_id = " . $id . ";";
   			$kresults = mysql_query($sql);
   			$k_words = array();
   			$keywords = "";
   			while($rowk = mysql_fetch_assoc($kresults))
   			{
			        $k_words[] = trim($rowk['k_word']);
   			}
   			$keywords = concatenate($k_words);
			echo '<a href="view_project.php?pid=' . $row['id'] . '" style="font-size: 14px;">' . $row['title'] . '</a>';
   			if (trim($keywords)!='')
   			{
				echo '<br/><font style="font-size:10px;">Keywords: ' . $keywords . '</font>';
   			}
		   	echo '<br/>';
   			$first = true;
   			foreach ($researchers as $username=>$rname)
   			{
	   			if ($first == false)
	   				echo ", ";
				else
					$first = false;
				if ($username != $rname)
						echo '<a href="view_user.php?username=' . $username . '" style="font-size:10px; color:#834A11;">' . $rname . '</a>';
				else
						echo $rname . " &nbsp;&nbsp;";
    		}
			if ($row['status']==1)
				echo'</td><td>Current</td>';
			else
				echo'</td><td>Completed</td>';
			echo '</tr>';
			$row=mysql_fetch_assoc($result);
		   }
		}
	  	if ($printheader == false)
		{
			echo'<h2>No current practices / projects found with the keywords "' . $_GET['searchKeywords'] . '"</h2>';
		}
		else
		{
			echo'</tbody>';
			echo '</table>';
			echo '</div>';
			paginate();
		}

	}
}

// Searches for titles and adds project IDs to the list, if
// not there already
function titleSearch($ids)
{
	if($_GET['searchKeywords'])
	{
		//$keywords = mysql_real_escape_string(trim($_GET['searchTitles']));
		$keywords = $_GET['searchKeywords'];
		$sql = "SELECT status, project_title as title, project_id as id
				FROM project
				WHERE ";
		$arr = explode(" ", $keywords);
		$first = true;
		foreach ($arr as $val)
		{
			$keyword = trim($val);
			if ($keyword != "")
			{
				if ($first == true)
				{
					$sql = $sql . "project_title LIKE '%" . $keyword . "%' ";
					$first = false;
				}
				else
				{
					$sql = $sql . "OR project_title LIKE '%" . $keyword . "%' ";
				}
			}
		}
		$sql = $sql . ";";

		$result = mysql_query($sql);
		if($result)
			$row=mysql_fetch_assoc($result);
		while($row)
		{
			$id = $row['id'];
			if (is_int(array_search($id, $ids)) == false)
				$ids[] = $row['id'];
			$row=mysql_fetch_assoc($result);
		}
	}
	return $ids;
}

// Searches for last names and adds project IDs to the list, if
// not there already
function nameSearch($ids)
{
	if($_GET['searchKeywords'])
	{
		$keywords = $_GET['searchKeywords'];

		$sql = "SELECT userproject.project_id as id FROM person, userproject WHERE person.username = userproject.username AND (";
		$arr = explode(" ", $keywords);
		$first = true;
		foreach ($arr as $val)
		{
			$keyword = trim($val);
			if ($keyword != "")
			{
				if ($first == true)
				{
					$sql = $sql . "person.lname LIKE '%" . $keyword . "%' ";
					$first = false;
				}
				else
				{
					$sql = $sql . "OR person.lname LIKE '%" . $keyword . "%' ";
				}
			}
		}
		$sql = $sql . ");";

		$result = mysql_query($sql);
		if($result)
			$row=mysql_fetch_assoc($result);
		while($row)
		{
			$id = $row['id'];
			if (is_int(array_search($id, $ids)) == false)
				$ids[] = $row['id'];
			$row=mysql_fetch_assoc($result);
		}
	}
	return $ids;
}

function abstractSearch($ids)
{
	if($_GET['searchKeywords'])
	{
		//$keywords = mysql_real_escape_string(trim($_GET['searchAbstracts']));
		$keywords = $_GET['searchKeywords'];
		$sql = "SELECT abstract, status, project_title as title, project_id as id
				FROM project
				WHERE ";
		$arr = explode(" ", $keywords);
		$first = true;
		foreach ($arr as $val)
		{
			$keyword = trim($val);
			if ($keyword != "")
			{
				if ($first == true)
				{
					$sql = $sql . "abstract LIKE '% " . $keyword . " %' ";
					$first = false;
				}
				else
				{
					$sql = $sql . "OR abstract LIKE '% " . $keyword . " %' ";
				}
			}
		}
		$sql = $sql . ";";

		$result = mysql_query($sql);
		if($result)
			$row=mysql_fetch_assoc($result);
		while($row)
		{
			$id = $row['id'];
			if (is_int(array_search($id, $ids)) == false)
				$ids[] = $row['id'];
			$row=mysql_fetch_assoc($result);
		}
	}
	return $ids;
}

function showSearchResultUser($arr)
{

	//loop through user
}
function showSearchResultKeyword($row)
{
	echo '<p><a href="view_project.php?pid=' . $row['id'] . '">' . $row['title'] . '</a></p>';
}

/****************************************************************************************************************/

/***************************************HELPER FUNCTION(S) **************************************************/

function showMargin()
{
	echo'<div id="margin"> </div><!--end bottom margin-->';
}


function showUserHeader($fname)
{
	placeApostrophe($fname);
	echo" page </h2>";

}

function placeApostrophe($word)
{
	$length = strlen($word) - 1;
	$last_letter = substr($word, $length);
	if($last_letter=="s")
	{
		echo ("<h2>" . $word . "'");
	}
	else
	{
		echo ("<h2>" . $word . "'s");
	}
}


function generateYear($year)
{
	//$y=intval(date("Y"));
	$y = 2000;
	if ($year == "")
	{
		$year = intval(date("Y"));
	}
	for($i=$y; $i < $y + 30; $i++)
	{	
		if($i==$year)
		{
			print ('<option value="' . $i .'" selected>' .$i . '</option>');
		}
		else
		{
			print ('<option value="' . $i .'">' .$i . '</option>');
		}
	}
	
}
function generateBirthYear()
{
	//$y=intval(date("Y"));
	$y = 1950;
	$year = intval(date("Y"));
	for($i=$y; $i < $year; $i++)
	{	
	   if ($i==1995)
	     print ('<option value="' . $i .'" selected>' .$i . '</option>');
	   else
	     print ('<option value="' . $i .'">' .$i . '</option>');
	}
}
function generateBirthGivenYear($year_born)
{
	//$y=intval(date("Y"));
	$y = 1950;
	$year = intval(date("Y"));
	for($i=$y; $i < $year; $i++)
	{	
	   if ($i==$year_born)
	     print ('<option value="' . $i .'" selected>' .$i . '</option>');
	   else
	     print ('<option value="' . $i .'">' .$i . '</option>');
	}
}

function generateMonth($mon)
{
	echo $mon;
	$month[1] = "January";
	$month[2] = "February";
	$month[3] = "March";
	$month[4] = "April";
	$month[5] = "May";
	$month[6] = "June";
	$month[7] = "July";
	$month[8] = "August";
	$month[9] = "September";
	$month[10] = "October";
	$month[11] = "November";
	$month[12] = "December";

	for($i=1; $i<=12; $i++)
	{
		if($i==$mon)
		{
			print ('<option value="' . $i .'" selected>' . $month[$i] . '</option>');
		}
		else
		{
			print ('<option value="' . $i .'">' . $month[$i] . '</option>');
		}
	}
}
function generateDay($day)
{

	for($i=1; $i<=31; $i++)
	{
		if($i==$day)
		{
			print ('<option value="' . $i .'" selected>' .$i . '</option>');
		}
		else
		{
			print ('<option value="' . $i .'">' .$i . '</option>');
		}
	}
}
/*
function showDegree()
{
	echo'<option value="" selected
Accounting   
Anthropology   
Art   
Aviation Technology   
Biological Sciences   
Chemistry   
Civil Engineering   
Computer Science   
Economics   
Education, Early Childhood   
Education, Elementary   
Engineering   
English   
Finance   
Geology   
Geomatics   
Global Logistics Management   
History   
Hospitality and Restaurant Management   
Human Services   
Interdisciplinary Studies   
International Studies   
Journalism and Public Communications   
Justice   
Languages   
Liberal Studies   
Management   
Management Information Systems   
Marketing   
Mathematics   
Medical Technology   
Music   
Music, Music Education Emphasis   
Music, Performance   
Natural Science   
Nursing Science   
Philosophy   
Physical Education   
Political Science   
Psychology   
Social Work   
Sociology   
Technology   
Theatre  */

/***********************************************************************************************************************/
/****************************************************************************************************************/

/***************************************VIEW FUNCTIONS(S) **************************************************/

function showFilterLinksAlphabet($page)
{
	if (!$_GET['vf'])
		$vf = 'A';
	else
	{
		$vf = $_GET['vf'];
	}
	echo '<div id="pagination"><p>';
	
	
	if($page == "view_title.php" && $vf != "0-9")
		echo '<a href="' . $page . '?vf=0-9">0-9</a>&nbsp; | &nbsp;';
	else if($page == "view_title.php" && $vf == "0-9")
		echo '<font style="font-size: 10px; font-weight: bold; color: #A38B1F;">0-9</font>&nbsp; | &nbsp;';
	
	
	$vf == "A" ? showLetterText("A", true) : showLetterLink($page, "A", true);
	$vf == "B" ? showLetterText("B", true) : showLetterLink($page, "B", true);
	$vf == "C" ? showLetterText("C", true) : showLetterLink($page, "C", true);
	$vf == "D" ? showLetterText("D", true) : showLetterLink($page, "D", true);
	$vf == "E" ? showLetterText("E", true) : showLetterLink($page, "E", true);
	$vf == "F" ? showLetterText("F", true) : showLetterLink($page, "F", true);
	$vf == "G" ? showLetterText("G", true) : showLetterLink($page, "G", true);
	$vf == "H" ? showLetterText("H", true) : showLetterLink($page, "H", true);
	$vf == "I" ? showLetterText("I", true) : showLetterLink($page, "I", true);
	$vf == "J" ? showLetterText("J", true) : showLetterLink($page, "J", true);
	$vf == "K" ? showLetterText("K", true) : showLetterLink($page, "K", true);
	$vf == "L" ? showLetterText("L", true) : showLetterLink($page, "L", true);
	$vf == "M" ? showLetterText("M", true) : showLetterLink($page, "M", true);
	$vf == "N" ? showLetterText("N", true) : showLetterLink($page, "N", true);
	$vf == "O" ? showLetterText("O", true) : showLetterLink($page, "O", true);
	$vf == "P" ? showLetterText("P", true) : showLetterLink($page, "P", true);
	$vf == "Q" ? showLetterText("Q", true) : showLetterLink($page, "Q", true);
	$vf == "R" ? showLetterText("R", true) : showLetterLink($page, "R", true);
	$vf == "S" ? showLetterText("S", true) : showLetterLink($page, "S", true);
	$vf == "T" ? showLetterText("T", true) : showLetterLink($page, "T", true);
	$vf == "U" ? showLetterText("U", true) : showLetterLink($page, "U", true);
	$vf == "V" ? showLetterText("V", true) : showLetterLink($page, "V", true);
	$vf == "W" ? showLetterText("W", true) : showLetterLink($page, "W", true);
	$vf == "X" ? showLetterText("X", true) : showLetterLink($page, "X", true);
	$vf == "Y" ? showLetterText("Y", true) : showLetterLink($page, "Y", true);
	$vf == "Z" ? showLetterText("Z", false) : showLetterLink($page, "Z", false);
	
	echo '</p></div>';
}

function showLetterLink($page, $letter, $spacer)
{
	if($spacer == true)
	{
		echo '<a href="' . $page . '?vf=' . $letter . '">' . $letter . '</a>&nbsp; | &nbsp;';
	}
	else
	{
		echo '<a href="' . $page . '?vf=' . $letter . '">' . $letter . '</a>';
	}
}
function showLetterText($letter, $spacer)
{
	if($spacer == true)
	{
		echo '<font style="font-size: 11px; font-weight: bold; color: #A38B1F;">' . $letter . '</font>&nbsp; | &nbsp;';
	}
	else
	{
		echo '<font style="font-size: 11px; font-weight: bold; color: #A38B1F;">' . $letter . '</font>';
	}
}

function showFilterLinksDate()
{
	if ($_GET['vf'])
		$vf = $_GET['vf'];
	else
		$vf = date("Y"); //current year
	$sql = "SELECT start_date 
			FROM project 
			ORDER BY start_date DESC, project_title;";
	$result = mysql_query($sql);
	echo '<div id="pagination"><p>';
	$first = false;
	while($list = mysql_fetch_array($result))
	{
		//get the first instance of that year
		$year = substr($list['start_date'], 0, 4);
		if($first && $year != $prev_year)
		{
			
			echo '&nbsp; | &nbsp;';
			
		}
		if($year != $prev_year && $vf != $year)
		{
			echo '<a href="view_date.php?vf=' . $year . '">' . $year . '</a>';
			
		}
		else if ($year != $prev_year)
		{
			echo '<font style="font-weight: bold; color: #A38B1F;">' . $year . '</font>';
			
		}

		$prev_year = $year;
		$first = true;
	}//end while
	echo '</p></div>';
}

function showFilterDate()
{
	if ($_GET['vf'])
		$vf = $_GET['vf'];
	else
		$vf = date("Y"); //current year

	$sql = "SELECT * 
			FROM project 
			WHERE YEAR(start_date) = '" . $vf . "'
			ORDER BY start_date DESC, project_title;";
	
	$result = mysql_query($sql);
	$num = 1;
	
	echo '<table id="resultsTable" class="tablesorter">';
	echo '<thead>';
	echo '<tr>';
	echo '<th>#</th><th>Project Title</th><th>Description</th><th>Researchers</th>';
	echo '</tr>';
	echo '</thead>';
	echo '<tbody>';
	while($list = mysql_fetch_array($result))
	{
		$researchers = get_investigator($list['project_id']);
		echo '<tr>';
		echo '<td width="5%">';
		echo $num++ . '. ';
		echo '</td>';
		echo '<td>';
		echo '<a href="view_project.php?pid=' . $list['project_id'] . '" style="font-size:14px;">' . $list['project_title'] . '</a>';
		echo '</td>';
		echo '<td>';
		if($list['abstract'] != "")
		{
			echo '<font style="font-size:10px;">' . substr($list['abstract'], 0, 250) . ' ...</font>';
		}
		echo '</td>';
		$first = true;
		echo '<td>';
		foreach ($researchers as $username=>$rname)
		{
			if ($first == false)
				echo ", ";
			else
				$first = false;
			if ($username != $rname)
				echo "<a href='view_user.php?username=" . $username . "' style='font-size:10px; color:#834A11;'>" . $rname . "</a>";
			else
				echo $rname;
		}
		echo '</td>';
		echo '</tr>';
	}//end while
	echo '</tbody>';
	echo '</table>';
	paginate();
}

function showFilterTitle()
{
	if (!$_GET['vf'])
		$vf = 'a';
	else
	{
		$vf = $_GET['vf'];
	}
	if ($vf == '0-9')
	{
		$sql = "SELECT project_id, project_title, abstract
				FROM project
				WHERE project_title LIKE '0%'
				OR project_title LIKE '1%'
				OR project_title LIKE '2%'
				OR project_title LIKE '3%'
				OR project_title LIKE '4%'
				OR project_title LIKE '5%'
				OR project_title LIKE '6%'
				OR project_title LIKE '7%'
				OR project_title LIKE '8%'
				OR project_title LIKE '9%'
				ORDER BY project_title";
	}
	else
	{
		$sql = "SELECT project_id, project_title, abstract
				FROM project
				WHERE project_title LIKE '" . $vf . "%'
				ORDER BY project_title";
	}
	
	



	$result = mysql_query($sql);
	$num = 1 ;

	// Print the first result or no projects found
	
	/*if($list = mysql_fetch_array($result))
	{
			$researchers = get_investigator($list['project_id']);
			echo '<p>' . $num++ . '. <a href="view_project.php?pid=' . $list['project_id'] . '" style="font-size:14px;">' . $list['project_title'] . '</a>';
			//echo '<br><p><a href="view_project.php?pid=' . $list['project_id'] . '" style="font-size:14px;">' . $list['project_title'] . '</a>';
			if($list['abstract'] != "N/A")
			{
				echo '<br/><font style="font-size:10px;">' . substr($list['abstract'], 0, 250) . ' ...</font>';
			}
			//echo '<br>Researchers: ';
			echo '<br/>';
			$first = true;
			foreach ($researchers as $username=>$rname)
			{
				if ($first == false)
					echo ", ";
				else
					$first = false;
				if ($username != $rname)
					echo "<a href='view_user.php?username=" . $username . "' style='font-size: 10px;color: #834A11;'>" . $rname . "</a>";
				else
					echo $rname . " &nbsp;&nbsp;";
			}
			echo '</p><br/><p></p>';
	}
	else
		echo '<p> No Current Practice / Projects Found </p>';*/


	echo '<table id="resultsTable" class="tablesorter">';
	echo '<thead>';
	echo '<tr><th>#</th><th>Project Title</th><th>Description</th><th>Researchers</th></tr>';
	echo '</thead>';
	echo '<tbody>';
	// Print the rest of the query result
	while($list = mysql_fetch_array($result))
	{
		$researchers = get_investigator($list['project_id']);
		echo '<tr>';
		echo '<td width="5%">';
		echo $num++ . '. ';
		echo '</td>';			
		echo '<td><a href="view_project.php?pid=' . $list['project_id'] . '"  style="font-size:14px;">' . $list['project_title'] . '</a></td>';
		//echo '<p><a href="view_project.php?pid=' . $list['project_id'] . '"  style="font-size:14px;">' . $list['project_title'] . '</a>';
		echo '<td>';
		if($list['abstract'] != "N/A")
		{
			echo '<font style="font-size:10px;">' . substr($list['abstract'], 0, 250) . ' ...</font>';
		}
		echo '</td>';

		echo '<td>';
		$first = true;
		foreach ($researchers as $username=>$rname)
		{
			if ($first == false)
				echo ", ";
			else
				$first = false;
			if ($username != $rname)
				echo "<a href='view_user.php?username=" . $username . "' style='font-size: 10px;color: #834A11;'>" . $rname . "</a>";
			else
				echo $rname;
		}
		echo '</td>';
		echo '</tr>';
	 }
	 echo '</tbody>';
	 echo '</table>';
	 paginate();
}

// TODO: Refactor with showDropDownMenuDepartment
function showDropDownMenuEmployer()
{
    $sql = "SELECT DISTINCT employer
            FROM mentor_occupation
            ORDER BY employer";
    $result = mysql_query($sql);
    
    echo '<form name="dropdown" style="border-bottom: 1px solid #8D8D8D;">';
    echo '<select class="dropdown" name="list">';
	echo '<option value="view_dept.php"></option>';
    while($row = mysql_fetch_array($result))
    {
        $employer = $row['employer'];
        echo '<option value="view_employer.php?vf=' . $employer . '">' . $employer . '</option>';
    }
    echo '</select>';
    echo '<input class="dropdown" type="button" 
			onClick="location=document.dropdown.list.options[document.dropdown.list.selectedIndex].value;" value="View">';
    echo '</form>';
}

// TODO: Refactor with showFilterDepartment
function showFilterEmployer()
{
    if ($_GET['vf'])
    {
            $vf = $_GET['vf'];
    }
    else
    {
            $vf = '';
    }
    
    $sql = "SELECT DISTINCT employer , project_title, project.project_id, abstract
            FROM mentor_occupation, userproject, project
            WHERE mentor_occupation.username = userproject.username
            and userproject.project_id = project.project_id
            AND employer = '" . $vf . "'
            ORDER BY project_title;";

    $result = mysql_query($sql);

    $num = 1;
    
    echo '<table id="resultsTable" class="tablesorter">';
	echo '<thead>';
	echo '<tr>';
	echo '<th>#</th><th>Project Title</th><th>Description</th><th>Researchers</th>';
	echo '</tr>';
	echo '</thead>';
	echo '<tbody>';
    while($row = mysql_fetch_array($result))
    {
		$employer = $row['employer'];
		if($employer != $prev_employer)
		{
				echo '<h2>' . $employer . '</h2>';
		}
		$researchers = get_investigator($row['project_id']);
		
		echo '<tr>';
		echo '<td width="5%">';
		echo $num++ . '. ';
		echo '</td>';
		echo '<td>';
		echo '<a href="view_project.php?pid=' . $row['project_id'] . '" style="font-size: 14px;">' . $row['project_title'] . '</a>';
		echo '</td>';
		echo '<td>';
		if($row['abstract'] != "N/A")
		{
			echo '<font style="font-size:10px;">' . substr($row['abstract'], 0, 250) . ' ...</font>';
		}
		echo '</td>';
		//echo '<br>Researchers: ';
		$first = true;
		echo '<td>';
		foreach ($researchers as $username=>$rname)
		{
		   if ($first == false)
				echo ", ";
		   else
				$first = false;
		   if ($username != $rname)
				echo "<a href='view_user.php?username=" . $username . "' style='font-size:10px; color: #834A11;'>" . $rname . "</a>";
		   else
				echo $rname;
		}
		echo '</td>';

    	//	echo '<p><a href="view_project.php?pid=' . $row['id'] . '">' . $row['project_title'] . '</a></p>';
        $prev_employer = $employer;
        echo '</tr>';
    }
    echo '</tbody>';
    echo '</table>';
    paginate();
    if($num == 1)
    {
	if ($vf == '')
		echo '<p>Choose a selection from the pull down menu.</p>';
	else
	    echo '<p>No Current Practice / Projects Found for ' . $vf . '</p>';
    }

}


function showDropDownMenuDepartment()
{
    $sql = "SELECT DISTINCT department
            FROM mentor_occupation
            ORDER BY department";
    $result = mysql_query($sql);
    
    echo '<form name="dropdown" style="border-bottom: 1px solid #8D8D8D;">';
    echo '<select class="dropdown" name="list">';
	echo '<option value="view_dept.php"></option>';
    while($row = mysql_fetch_array($result))
    {
        $department = $row['department'];
        echo '<option value="view_dept.php?vf=' . $department . '">' . $department . '</option>';
    }
    echo '</select>';
    echo '<input class="dropdown" type="button" 
			onClick="location=document.dropdown.list.options[document.dropdown.list.selectedIndex].value;" value="View">';
    echo '</form>';
}

function showFilterDepartment()
{
    if ($_GET['vf'])
    {
            $vf = $_GET['vf'];
    }
    else
    {
            $vf = '';
    }
    
    $sql = "SELECT DISTINCT department, project_title, project.project_id, abstract
            FROM mentor_occupation, userproject, project
            WHERE mentor_occupation.username = userproject.username
            and userproject.project_id = project.project_id
            AND department = '" . $vf . "'
            ORDER BY project_title;";

    $result = mysql_query($sql);

    $num = 1;
    
    echo '<table id="resultsTable" class="tablesorter">';
	echo '<thead>';
	echo '<tr>';
	echo '<th>#</th><th>Project Title</th><th>Description</th><th>Researchers</th>';
	echo '</tr>';
	echo '</thead>';
	echo '<tbody>';
    while($row = mysql_fetch_array($result))
    {
		$department = $row['department'];
		if($department != $prev_department)
		{
			echo '<h2>' . $department . '</h2>';
		}
		$researchers = get_investigator($row['project_id']);
		
		echo '<tr>';
		echo '<td width="5%">';
		echo $num++ . '. ';
		echo '</td>';
		echo '<td>';
		echo '<a href="view_project.php?pid=' . $row['project_id'] . '" style="font-size: 14px;">' . $row['project_title'] . '</a>';
		echo '</td>';
		echo '<td>';
		if($row['abstract'] != "N/A")
		{
			echo '<font style="font-size:10px;">' . substr($row['abstract'], 0, 250) . ' ...</font>';
		}
		echo '</td>';
		//echo '<br>Researchers: ';
		echo '<td>';
		$first = true;
		foreach ($researchers as $username=>$rname)
		{
		   if ($first == false)
				echo ", ";
		   else
				$first = false;
		   if ($username != $rname)
				echo "<a href='view_user.php?username=" . $username . "' style='font-size:10px; color: #834A11;'>" . $rname . "</a>";
		   else
				echo $rname;
		}
		echo '</td>';

		//	echo '<p><a href="view_project.php?pid=' . $row['id'] . '">' . $row['project_title'] . '</a></p>';
		$prev_department = $department;
		echo '</tr>';
	}
	echo '</tbody>';
	echo '</table>';
    paginate();
	if($num == 1)
	{
		if ($vf == '')
			echo '<p>Choose a selection from the pull down menu.</p>';
		else
				echo '<p>No Current Practice / Projects Found for ' . $vf . '</p>';
	}

}

function showFilterMentors()
{
	if ($_GET['vf'])
	{
		$vf = $_GET['vf'];
	}
	else
	{
		$vf = 'a';
	}

	$sql = "SELECT user.username, user.fname, user.lname
	FROM user
	WHERE user.usertype = 2
	AND user.lname LIKE '" . $vf . "%'
	ORDER BY user.lname , user.fname;";

	$result = mysql_query($sql);

	print(mysql_error());

	$letter = 'A';
	if (isset($_GET['vf']))
		$letter = strtoupper($_GET['vf']);
	echo '<h2>'. $letter .'</h2>';
	
	echo '<table id="mentorTable" class="tablesorter">';
	echo '<thead>';
	echo '<tr><th>Name</th></tr>';
	echo '</thead>';
	echo '<tbody>';
	while($row = mysql_fetch_array($result))
	{
		echo '<tr><td>';
		echo '<p><a href="view_user.php?username=' . $row['username'] . '">' . $row['lname'] . ', ' . $row['fname'] . '</a></p>';
		echo '</td></tr>';
	}
	echo '</tbody>';
	echo '</table>';
	paginate();
}

function showFilterMentee()
{
	if ($_GET['vf'])
	{
		$vf = $_GET['vf'];
	}
	else
	{
		$vf = 'a';
	}
	$sql = "SELECT user.username, user.fname, user.lname
			FROM user
			WHERE user.usertype = 1
			AND user.lname LIKE '" . $vf . "%'
			ORDER BY user.lname , user.fname;";
	$result = mysql_query($sql);

	$letter = 'A';
	if (isset($_GET['vf']))
		$letter = strtoupper($_GET['vf']);
	echo '<h2>'. $letter .'</h2>';

	echo '<table id="menteeTable" class="tablesorter">';
	echo '<thead>';
	echo '<tr><th>Name</th></tr>';
	echo '</thead>';
	echo '<tbody>';
	while($row = mysql_fetch_array($result))
	{
		echo '<tr><td>';
		echo '<p><a href="view_user.php?username=' . $row['username'] . '">' . $row['lname'] . ', ' . $row['fname'] . '</a></p>';
		echo '</td></tr>';
	}
	echo '</tbody>';
	echo '</table>';
	paginate();
}

// Displays icons for displaying list of projects by discipline area
// if $selected is set, don't hyperlink that icon
function showDisciplineIcons($selected)
{
 // Show icons for disciplines
 echo '<table cellpadding=5 border=0>';

 echo '<tr>';
 $url = "view_discipline.php?disc=All Current Practices / Projects";
 if (strcmp($selected, "All Current Practices / Projects"))
    echo '<td colspan=4><center><a href="' . $url . '" style="text-decoration:none;"><img src="icons/All.png"></a><br/><a href="' . $url . '">All Current Practices / Projects</a></center></td></tr>';
 else
    echo '<td colspan=4><center><img src="icons/All.png"><br/><b>All Current Practices / Projects</b></center></td></tr>';

 echo '<tr>';
 $url = "view_discipline.php?disc=Natural Sciences";
 if (strcmp($selected,"Natural Sciences"))
    echo '<td><center><a href="' . $url . '" style="text-decoration:none;"><img src="icons/NaturalScience.png"></a><br/><a href="' . $url . '">Natural Sciences</a></center></td>';
 else
    echo '<td><center><img src="icons/NaturalScience.png"><br/><b>Natural Sciences</b></center></td>';
 $url = "view_discipline.php?disc=Physical Sciences";
 if (strcmp($selected,"Physical Sciences"))
   echo '<td><center><a href="' . $url . '" style="text-decoration:none;"><img src="icons/PhysicalScience.png"></a><br/><a href="' . $url . '">Physical Sciences</a></center></td>';
 else
   echo '<td><center><img src="icons/PhysicalScience.png"><br/><B>Physical Sciences</b></center></td>';
 $url = "view_discipline.php?disc=Computer and Mathematical Sciences";
 if (strcmp($selected, "Computer and Mathematical Sciences"))
    echo '<td><center><a href="' . $url . '" style="text-decoration:none;"><img src="icons/MathCS.png"></a><br/><a href="' . $url . '">Computer and <br/>Mathematical Sciences</a></center></td>';
 else
    echo '<td><center><img src="icons/MathCS.png"><br/><B>Computer and <br/>Mathematical Sciences</b></center></td>';
 $url = "view_discipline.php?disc=Engineering";
 if (strcmp($selected, "Engineering"))
   echo '<td><center><a href="' . $url . '" style="text-decoration:none;"><img src="icons/Engineering.png"></a><br/><a href="' . $url . '">Engineering</a></center></td>';
 else
   echo '<td><center><img src="icons/Engineering.png"><br/><B>Engineering</b></center></td>';
 echo '</tr>';
 echo '<tr>';
 $url = "view_discipline.php?disc=Social Sciences";
 if (strcmp($selected, "Social Sciences"))
    echo '<td><center><a href="' . $url . '" style="text-decoration:none;"><img src="icons/SocialScience.png"></a><br/><a href="' . $url . '">Social Sciences</a></center></td>';
 else
    echo '<td><center><img src="icons/SocialScience.png"><br/><B>Social Sciences</b></center></td>';
 $url = "view_discipline.php?disc=Humanities";
 if (strcmp($selected, "Humanities"))
    echo '<td><center><a href="' . $url . '" style="text-decoration:none;"><img src="icons/Humanities.png"></a><br/><a href="' . $url . '">Humanities</a></center></td>';
 else
    echo '<td><center><img src="icons/Humanities.png"><br/><b>Humanities</b></center></td>';
 $url = "view_discipline.php?disc=Arts";
 if (strcmp($selected, "Arts"))
    echo '<td><center><a href="' . $url . '" style="text-decoration:none;"><img src="icons/PerfArts.png"></a><br/><a href="' . $url . '">Art and Performing Arts</a></center></td>';
 else
    echo '<td><center><img src="icons/PerfArts.png"><br/><b>Art and Performing Arts</b></center></td>';
 $url = "view_discipline.php?disc=Health Sciences";
 if (strcmp($selected, "Health Sciences"))
    echo '<td><center><a href="' . $url . '" style="text-decoration:none;"><img src="icons/HealthSciences.png"></a><br/><a href="' . $url . '">Health Sciences</a></center></td>';
 else
    echo '<td><center><img src="icons/HealthSciences.png"><br/><b>Health Sciences</b></center></td>';

 echo '</tr>';
 echo '</table>';
}

?>
