CREATE DATABASE IF NOT EXISTS cahdre;
USE cahdre;
CREATE TABLE user (
				username varchar(255) NOT NULL,
				password varchar(255) default '',
				usertype int(4) NOT NULL default '1',
				picture varchar(255) default 'nopic',
				disadvantaged int(4) default '0',
				sid varchar(12) default '',
				email varchar(255) default '',
				lname varchar(255) default '',
				fname varchar(255) default '',
				phone varchar(255) default '',
				sex varchar(2) default 'M',
				race varchar(255) default '',
				languages varchar(255) default '',
				facebook varchar(255) default '',
				myspace varchar(255) default '',
				address varchar(255) default '',
				curcity varchar(255) default '',
				birthdate date default NULL,
				bachelors varchar(255) default '',
				masters varchar(255) default '',
				doctorates varchar(255) default '',
				modification_date timestamp(14) NOT NULL,
				PRIMARY KEY (username),
				INDEX (username),
				UNIQUE KEY (username)
				) ENGINE = INNODB;
CREATE TABLE mentee_school (
				username varchar(255) NOT NULL,
				name varchar(255) default '',
				year varchar(50) default '',
				graduation_year varchar(5) default '2015',
				major varchar(100) default '',
				career_goals text,
				extracurricular text,
				gpa varchar(10) default '',
				parent_education_level int(4) default '1',
				PRIMARY KEY (username),
				FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
				) ENGINE = INNODB;
CREATE TABLE mentee_interests (
				username varchar(255) NOT NULL,
				interested_because text,
				mentor_field_pref varchar(255) default '',
				interested_topics text,
				PRIMARY KEY (username),
				FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
				) ENGINE = INNODB;
CREATE TABLE mentor_occupation (
				username varchar(255) NOT NULL,
				occupation varchar(255) default '',
				employer varchar(255) default '',
				department varchar(255) default '',
				years_work int(4) default '0',
				mentor_fields varchar(255) default '',
				health_disparities int(4) default '0',
				PRIMARY KEY (username),
				FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
				) ENGINE = INNODB;
CREATE TABLE mentor_interests (
				username varchar(255) NOT NULL,
				interested_because text,
				relevant_research text,
				num_students int(4) default '0',
				time_available varchar(255) default '',
				specific_grade_level varchar(100) default '',
				mentee_educational_level varchar(100) default '',
				PRIMARY KEY (username),
				FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
				) ENGINE = INNODB;
CREATE TABLE project (
					project_id int(10) unsigned NOT NULL auto_increment,
					project_title varchar(255) default '',
					abstract text,
					status int(4) NOT NULL 	default '0',
					start_date date NOT NULL,
					end_date date NOT NULL,
					funding_source varchar(255) default '',
					funding_amount varchar(255) default '',
					course varchar(255) default '',
					partner varchar(255) default '',
					seeking_help int(4) default '1',
					modification_date timestamp(14) NOT NULL,
					PRIMARY KEY (project_id),
					INDEX (project_id),
					INDEX (status)
					) ENGINE = INNODB;
CREATE TABLE keyword (
					k_id int(10) unsigned NOT NULL auto_increment,
					k_word varchar(255) NOT NULL,
					PRIMARY KEY (k_id),
					UNIQUE KEY (k_id)
					) ENGINE = INNODB;
CREATE TABLE keywordproject (
					project_id int(10) unsigned NOT NULL,
					k_id int(10) unsigned NOT NULL,
					PRIMARY KEY (project_id, k_id),
					INDEX (project_id),
					INDEX (k_id),
					FOREIGN KEY (project_id) REFERENCES project(project_id) ON DELETE CASCADE,
					FOREIGN KEY (k_id) REFERENCES keyword(k_id) ON DELETE CASCADE
					)ENGINE = INNODB;
CREATE TABLE userproject (
						project_id int(10) unsigned NOT NULL,
						username varchar(255) NOT NULL,
						userstatus int(4) default '0',
						standing_started varchar(50) default '',
						PRIMARY KEY (project_id, username),
						INDEX (project_id),
						INDEX (username),
						FOREIGN KEY (project_id) REFERENCES project(project_id) ON DELETE CASCADE,
						FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
						) ENGINE = INNODB;
CREATE TABLE projectfile (
						project_id int(10) unsigned NOT NULL,
						username varchar(255) NOT NULL,
						filename varchar(255) default '',
						description varchar(255) default '',
						modification_date timestamp(14) NOT NULL,
						PRIMARY KEY(project_id, username, filename),
						INDEX (project_id),
						INDEX (username),
						INDEX (filename),
						FOREIGN KEY (project_id) REFERENCES project(project_id) ON DELETE CASCADE,
						FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
						) ENGINE = INNODB;
CREATE TABLE userfile (
					username varchar(255) NOT NULL,
					filename varchar(255) default '',
					description text,
					PRIMARY KEY (username, filename),
					INDEX (username),
					INDEX (filename),
					FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
					) ENGINE = INNODB;
CREATE TABLE activated (
					username varchar(255) NOT NULL,
					status int(10) unsigned NOT NULL,
					PRIMARY KEY (username),
					INDEX (username),
					FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
					) ENGINE = INNODB;

CREATE TABLE administrator (
					username varchar(255) NOT NULL,
					privilegelevel tinyint default 0,
					PRIMARY KEY (username),
					INDEX (username),
					FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
					) ENGINE = INNODB;
					
CREATE TABLE usagestatistic (
					generation_date date NOT NULL,
					total_mentors int(10) unsigned NOT NULL,
					total_mentees int(10) unsigned NOT NULL,
					total_projects int(10) unsigned NOT NULL,
					total_page_hits int(10) unsigned NOT NULL,
					unique_page_hits int(10) unsigned NOT NULL,
					PRIMARY KEY (generation_date)
					) ENGINE = INNODB;
					
CREATE TABLE websitevisit (
					hit_id int(10) unsigned NOT NULL auto_increment,
					ip_address varchar(255) NOT NULL,
					timestamp datetime NOT NULL,
					PRIMARY KEY (hit_id),
					INDEX (ip_address)
					) ENGINE = INNODB;

CREATE TABLE userlogin (
					username varchar(255) NOT NULL,
					num_logins int(10) NOT NULL,
					PRIMARY KEY (username),
					INDEX (username),
					FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
					) ENGINE = INNODB;
					
CREATE TABLE userfeedback (
					username varchar(255) NOT NULL,
					survey_declined bool NOT NULL,
					search_feedback int(2),
					project_feedback int(2),
					overall_feedback int(2),
					comments text,
					PRIMARY KEY (username),
					INDEX (username),
					FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
					) ENGINE = INNODB;