<?php
session_start();
include("includes.inc");
include("template/doJavascript.inc");
include("template/doHtml.inc");

headerWithJSJQEnter($page_title);
include("template/look.inc");

$showDemographics = false;
if (($_SESSION['isAdmin']) && ($_SESSION['isAdmin']==true))
  $showDemographics = true;
if (($_SESSION['isFaculty']) && ($_SESSION['isFaculty']==true))
  $showDemographics = true;

echo '<p>';

echo '<link rel="stylesheet" href="jquery.tablesorter/themes/blue/style.css" type="text/css" media="print, projection, screen" />';
echo '<link rel="stylesheet" href="jquery.tablesorter/addons/pager/jquery.tablesorter.pager.css" type="text/css"/>';
//echo '<script type="text/javascript" src="jquery.tablesorter/jquery-latest.js"></script>';
echo '<script type="text/javascript" src="jquery.tablesorter/jquery.tablesorter.js"></script>';
echo '<script type="text/javascript" src="jquery.tablesorter/addons/pager/jquery.tablesorter.pager.js"></script>';

echo '<script>';
echo '$(document).ready(function()
					{
						$( "#tabs" ).tabs();
					}
			);';
echo '	</script>';

echo '<script>
$(document).ready(function() {
    $("#table")
    .tablesorter({widthFixed: true, widgets: [\'zebra\']})
    .tablesorterPager({container: $("#pager"), positionFixed: false });
});
</script>';

echo '</script>';

echo '<div id="tabs">';
echo '	<ul>';
echo '		<li><a href="#tabs-keyword">Keyword</a></li>';
echo '		<li><a href="#tabs-mentor-field">Mentor Field Preference</a></li>';
if ($showDemographics)
   echo '		<li><a href="#tabs-mentee-demo">Mentee Demographics</a></li>';
echo '	</ul>';
echo '	<div id="tabs-keyword">';
echo '<b>Search mentees by keyword</b>';
echo '<p>';
echo '<form name=menteeSearch action="menteeSearch.php#tabs-keyword" method=get>';
echo 'Search term(s): <input type=text name=searchKeywords size=20>';
echo '<input type=hidden name=keyword_search value="k">';
echo '<br/>';
echo '<input type=submit>';
echo '</form>';
echo '	</div>';

// REFACTORED checkbox code
$boxName = array('mentee_field_ah', 'mentee_field_br', 'mentee_field_bh', 'mentee_field_m', 'mentee_field_n', 'mentee_field_oh', 'mentee_field_pa', 'mentee_field_ph', 'mentee_field_sw');
$boxTag = array('Allied Health', 'Biomedical Research', 'Behavioral Health', 'Medicine', 'Nursing', 'Oral Health / Dentistry', 'Physician Assistant', 'Public Health', 'Social Work');
echo '	<div id="tabs-mentor-field">';
// TODO re-check boxes if they were submitted
echo '<b>Search mentees by preferred field for a mentor</b>';
echo '<p>';
echo '<form name=menteeSearch action="menteeSearch.php#tabs-mentor-field" method=get>';
echo '<table border=0>';
for ($i = 0, $j = 0; $i < 3; $i++)
{
	echo '<tr>';
	for ($k = 0; $k < 3; $k++, $j++)
	{
		echo '<td>';
		echo '<input type="checkbox" name="' . $boxName[$j] . '"';
		if(isset($_GET[$boxName[$j]]))
			echo 'checked';
		echo '>' . $boxTag[$j] . '<br/>';
		echo '</td>';
	}
	echo '</tr>';
}
echo '<tr><td>';
echo 'Other: <input type=text name="other" size=10 maxlength=100>';
echo '</td>';
echo '</tr></table>';
echo '<input type=hidden name=mentee_fields value="m">';
echo '<br/>';
echo '<input type=submit>';
echo '</form>';
echo '</p>';
echo '	</div>';

if ($showDemographics)
{
  echo '	<div id="tabs-mentee-demo">';
  echo '  <p>';
  echo '<form name=menteeSearch action="menteeSearch.php#tabs-mentee-demo" method=get>';
  echo '<table border=0>';
  echo '<tr><td>Sex</td><td>Race/Ethnicity</td><td>Age</td></tr>';
  echo '<tr><td valign=top>';
  echo '<input type=radio name="sex" value="Any" checked>Any sex<br/>';
  echo '<input type=radio name="sex" value="Male">Male<br/>';
  echo '<input type=radio name="sex" value="Female">Female<br/>';
  echo '</td>';
  echo '<td>';
  echo '<input type="checkbox" name="White">White<br/>';
  echo '<input type="checkbox" name="Black">Black or African American<br/>';
  echo '<input type="checkbox" name="Hispanic">Hispanic or Latino<br/>';
  echo '<input type="checkbox" name="Native">Alaska Native or American Indian<br/>';
  echo '<input type="checkbox" name="Asian">Asian<br/>';
  echo '<input type="checkbox" name="Pacific">Native Hawaiian or Pacific Islander<br/>';
  echo '<input type="checkbox" name="Other">Other<br/>';
  echo '</td>';
  echo '<td valign=top>';
  echo '<input type=radio name="BirthBeforeAfter" value="any" checked>Any age<br/>';
  echo '<input type=radio name="BirthBeforeAfter" value="before">Born in or before ';
  echo '<select name="byearBefore">';
  generateBirthYear();
  echo '</select><br/>';
  echo '<input type=radio name="BirthBeforeAfter" value="after">Born in or after';
  echo '<select name="byearAfter">';
  generateBirthYear();
  echo '</select>';
  echo '</td>';
  echo '</table>';
  echo '<input type=hidden name=mentee_demo value="m">';
  echo '<br/>';
  echo '<input type=submit>';
  echo '</form>';
  echo '  </p>';
  echo '	</div>';
}

echo '</div>';

// **************************************************************
// Make SQL Query based upon the selected fields in the form
echo '<p>';
$sql = "SELECT mentee_interests.username from mentee_interests ";
$resultsTitle = '<b>All Mentees</b>';

if ($_GET['keyword_search'])
{
   $keywords = trim($_GET['searchKeywords']);
   if (strlen($keywords)>0)
   {
       	$sql = "SELECT DISTINCT user.username
                         FROM user, mentee_school, mentee_interests
                         WHERE mentee_school.username = user.username
                         AND mentee_interests.username = user.username
                         AND (";
	$arr = explode(" ", $keywords);
	$first = true;
	foreach ($arr as $val)
	{
	   $keyword=trim($val);
	   if ($keyword != "")
	   {
		if ($first)
		{
		  $sql = $sql . "user.email LIKE '%" . $keyword . "%' ";
		  $first = false;
		}
		else
		  $sql = $sql . "OR user.email LIKE '%" . $keyword . "%' ";
	        $sql = $sql . "OR user.fname LIKE '%" . $keyword . "%' ";
	        $sql = $sql . "OR user.lname LIKE '%" . $keyword . "%' ";
	        $sql = $sql . "OR user.race LIKE '%" . $keyword . "%' ";
	        $sql = $sql . "OR user.languages LIKE '%" . $keyword . "%' ";
	        $sql = $sql . "OR mentee_interests.interested_because LIKE '%" . $keyword . "%' ";
	        $sql = $sql . "OR mentee_interests.interested_topics LIKE '%" . $keyword . "%' ";
	        $sql = $sql . "OR mentee_interests.mentor_field_pref LIKE '%" . $keyword . "%' ";
	        $sql = $sql . "OR mentee_school.name LIKE '%" . $keyword . "%' ";
	        $sql = $sql . "OR mentee_school.major LIKE '%" . $keyword . "%' ";
	        $sql = $sql . "OR mentee_school.career_goals LIKE '%" . $keyword . "%' ";
	        $sql = $sql . "OR mentee_school.extracurricular LIKE '%" . $keyword . "%' ";
	   }
	}
	$sql = $sql . ")";
	$resultsTitle = '<b>Mentees matching: ' . $keywords . '</b>';
   }
}
else if ($_GET['mentee_fields'])
{
	$mentee_fields = array();
	if ($_REQUEST['mentee_field_ah'])
	  $mentee_fields[] = "Allied Health";
	if ($_REQUEST['mentee_field_br'])
	  $mentee_fields[] = "Biomedical Research";
	if ($_REQUEST['mentee_field_bh'])
	  $mentee_fields[] = "Behavioral Health";
	if ($_REQUEST['mentee_field_m'])
	  $mentee_fields[] = "Medicine";
	if ($_REQUEST['mentee_field_n'])
	  $mentee_fields[] = "Nursing";
	if ($_REQUEST['mentee_field_oh'])
	  $mentee_fields[] = "Oral Health / Dentistry";
	if ($_REQUEST['mentee_field_pa'])
	  $mentee_fields[] = "Physician Assistant";
	if ($_REQUEST['mentee_field_ph'])
	  $mentee_fields[] = "Public Health";
	if ($_REQUEST['mentee_field_sw'])
	  $mentee_fields[] = "Social Work";
	if ((isset($_REQUEST['other'])) && (strlen($_REQUEST['other'])>0))
	  $mentee_fields[] = $_REQUEST['other'];

	if (count($mentee_fields) > 0)
	{
  	  $mentee_all = $mentee_fields[0];
	  for ($i = 1; $i < count($mentee_fields); $i++)
	  {
		$mentee_all .= ", " . $mentee_fields[$i];
	  }
	  $resultsTitle = '<b>Mentees with mentor field preferences of: ' . $mentee_all . '</b>';
	  $sql = $sql . "WHERE mentor_field_pref LIKE '%" .
		$mentee_fields[0] . "%' ";
	  for ($i = 1; $i < count($mentee_fields); $i++)
  	  {
		$sql = $sql . "OR mentor_field_pref LIKE '%" .
			$mentee_fields[$i] . "%' ";
	  }
  	}
}
else if ($_GET['mentee_demo'] && ($showDemographics))
{
	$selections = "";
       	$sql = "SELECT DISTINCT user.username
                         FROM user, mentee_school, mentee_interests
                         WHERE mentee_school.username = user.username
                         AND mentee_interests.username = user.username ";
	if ($_REQUEST['sex']=="Male")
 	{
	   $sql .= "AND user.sex = 'M' ";
	   $selections .= "Male; ";
	}
	else if ($_REQUEST['sex']=="Female")
 	{
	   $sql .= "AND user.sex = 'F' ";
	   $selections .= "Female; ";
	}
	else
	{
	   $selections .= "Male or Female; ";
	}
	$raceCount = 0;
	if ($_REQUEST['White'] || $_REQUEST['Black'] || $_REQUEST['Hispanic']
  		|| $_REQUEST['Native'] || $_REQUEST['Asian'] ||
	     	$_REQUEST['Pacific'] || $_REQUEST['Other'])
	{
		$sql .= "AND (";
	}
	if ($_REQUEST['White'])
	{
	   if ($raceCount > 0) $sql .= "OR ";
	   $sql .= "user.race LIKE '%White%' ";
	   $selections .= "White ";
	   $raceCount++;
	}
	if ($_REQUEST['Black'])
	{
	   if ($raceCount > 0) $sql .= "OR ";
	   $sql .= "user.race LIKE '%Black%' ";
	   $selections .= "Black ";
	   $raceCount++;
	}
	if ($_REQUEST['Hispanic'])
	{
	   if ($raceCount > 0) $sql .= "OR ";
	   $sql .= "user.race LIKE '%Hispanic%' ";
	   $selections .= "Hispanic ";
	   $raceCount++;
	}
	if ($_REQUEST['Native'])
	{
	   if ($raceCount > 0) $sql .= "OR ";
	   $sql .= "user.race LIKE '%Native%' ";
	   $selections .= "Alaska Native/American Indian ";
	   $raceCount++;
	}
	if ($_REQUEST['Asian'])
	{
	   if ($raceCount > 0) $sql .= "OR ";
	   $sql .= "user.race LIKE '%Asian%' ";
	   $selections .= "Asian ";
	   $raceCount++;
	}
	if ($_REQUEST['Pacific'])
	{
	   if ($raceCount > 0) $sql .= "OR ";
	   $sql .= "user.race LIKE '%Pacific%' ";
	   $selections .= "Native Hawaiian/Pacific Islander ";
	   $raceCount++;
	}
	if ($_REQUEST['Other'])
	{
	   if ($raceCount > 0) $sql .= "OR ";
	   $sql .= "user.race LIKE '%Other%' ";
	   $selections .= "Other ";
	   $raceCount++;
	}
  	if ($raceCount > 0)
	{
		$sql .= ") ";
	   	$selections .= "; ";
	}

	if ($_REQUEST['BirthBeforeAfter'] == 'before')
	{
		$sql .= "AND user.birthdate <= \'". $_REQUEST['byearBefore'] .
			"-01-01' ";
	   	$selections .= "Born in or before " . $_REQUEST['byearBefore'];
	}
	else if ($_REQUEST['BirthBeforeAfter'] == 'after')
	{
		$sql .= "AND user.birthdate >= '" . $_REQUEST['byearAfter'] .
			"-01-01' ";
	   	$selections .= "Born in or before " . $_REQUEST['byearAfter'];
	}

	$sql .= ";";
        $resultsTitle = '<b>Mentees with : ' . $selections . '</b>';
}

// DISPLAY SQL RESULTS
echo $resultsTitle;
echo '<table id="table" class="tablesorter">';
echo '<thead>';
echo "<tr>";
echo "<th>Name</th><th>School</th><th>Year in School</th><th>Graduation Year</th><th>Mentor Field Preference</th><th>Mentor Field Preference</th><th>Number Active Projects</th><th>Mentors</th>";
echo "</tr>";
echo '</thead>';
echo '<tbody>';
$sql = $sql . ";";
$result = mysql_query($sql);
while ($row = mysql_fetch_array($result))
{
	$curusername = $row['username'];
	$sql2 = "SELECT user.username, user.fname, user.lname,
			mentee_school.name, mentee_school.year,
			mentee_school.graduation_year,
			mentor_field_pref
		FROM user, mentee_interests, mentee_school
		WHERE user.username = '" . $curusername . "'" .
		      " AND user.username = mentee_school.username AND
			user.username = mentee_interests.username;";
	$result2 = mysql_query($sql2);
	if ($row2 = mysql_fetch_array($result2))
	{
	  echo '<tr><td width=20%><a href="view_user.php?username=' . $row2['username'] . '">' . $row2['lname'] . ', ' . $row2['fname'] . '</a></td>';
	  echo '<td width=20%>' . $row2['name'] . '</td>';
	  echo '<td>' . $row2['year'] . '</td>';
	  echo '<td>' . $row2['graduation_year'] . '</td>';
	  $prefarr = explode(',', $row2['mentor_field_pref']);
	  echo '<td>' . $prefarr[0] . '</td>';
	  echo '<td>' . $prefarr[1] . '</td>';
	  echo '<td>' . numActiveProjects($row2['username']) . '</td>';
	  echo '<td>' . getMentors($row2['username']) . '</td>';
	}
}
echo '</tbody>';
//echo '<tfoot>';
//paginationDiv();
//echo '</tfoot>';
echo '</table>';
paginationDiv();
echo '</p>';


include("template/footer.inc");
exit();

// Returns number of projects this user is in, if both the user and
// project are active
function numActiveProjects($username)
{
 $sql3 = "select count(DISTINCT userproject.project_id) AS ProjectCount FROM userproject, project WHERE userproject.project_id = project.project_id AND project.status=1 AND userproject.userstatus=1 AND userproject.username='" . $username . "';";
 $result3 = mysql_query($sql3);
 if ($row3 = mysql_fetch_array($result3))
	return $row3['ProjectCount'];
 else
	return 0;
}

// Returns URL list of all assigned mentors for any project, active or closed
// for the given username
function getMentors($username)
{
 $names = array();
 $sql3 = "SELECT DISTINCT username FROM userproject
		WHERE userproject.project_id IN
		(SELECT userproject.project_id FROM userproject WHERE
	 	 userproject.username='" . $username . "') AND
		userproject.standing_started='Mentor';";
 $result3 = mysql_query($sql3);
 while ($row3 = mysql_fetch_array($result3))
 {
	$mentor_username = $row3['username'];
	$sql4 = "SELECT user.fname, user.lname FROM user WHERE
			user.username = '" . $mentor_username . "';";
	$result4 = mysql_query($sql4);
	if ($row4 = mysql_fetch_array($result4))
	{
		$names[] = "<a href='view_user.php?username=" . $mentor_username . "'>" . $row4['fname'] . " " . $row4['lname'] . "</a>";
	}
	else
	{
		$names[] = $mentor_username;
	}
 }
 return implode(", ", $names);
}

function paginationDiv()
{
	echo '<div id="pager" class="pager">
		<form>
			<img src="jquery.tablesorter/addons/pager/icons/first.png" class="first"/>
			<img src="jquery.tablesorter/addons/pager/icons/prev.png" class="prev"/>
			<input type="text" class="pagedisplay"/>
			<img src="jquery.tablesorter/addons/pager/icons/next.png" class="next"/>
			<img src="jquery.tablesorter/addons/pager/icons/last.png" class="last"/>
			<select class="pagesize">
				<option selected="selected"  value="10">10</option>
				<option value="20">20</option>
				<option value="30">30</option>
				<option  value="40">40</option>
			</select>
		</form>
	</div>';
}

?>
