-- MySQL dump 10.10
--
-- Host: localhost    Database: cahdre
-- ------------------------------------------------------
-- Server version	5.0.22-Debian_0ubuntu6.06.12-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activated`
--

DROP TABLE IF EXISTS `activated`;
CREATE TABLE `activated` (
  `username` varchar(255) NOT NULL,
  `status` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`username`),
  KEY `username` (`username`),
  CONSTRAINT `activated_ibfk_1` FOREIGN KEY (`username`) REFERENCES `user` (`username`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `activated`
--


/*!40000 ALTER TABLE `activated` DISABLE KEYS */;
LOCK TABLES `activated` WRITE;
INSERT INTO `activated` VALUES ('mentor3',1),('mentor5',1),('mentor6',0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `activated` ENABLE KEYS */;

--
-- Table structure for table `keyword`
--

DROP TABLE IF EXISTS `keyword`;
CREATE TABLE `keyword` (
  `k_id` int(10) unsigned NOT NULL auto_increment,
  `k_word` varchar(255) NOT NULL,
  PRIMARY KEY  (`k_id`),
  UNIQUE KEY `k_id` (`k_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `keyword`
--


/*!40000 ALTER TABLE `keyword` DISABLE KEYS */;
LOCK TABLES `keyword` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `keyword` ENABLE KEYS */;

--
-- Table structure for table `keywordproject`
--

DROP TABLE IF EXISTS `keywordproject`;
CREATE TABLE `keywordproject` (
  `project_id` int(10) unsigned NOT NULL,
  `k_id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`project_id`,`k_id`),
  KEY `project_id` (`project_id`),
  KEY `k_id` (`k_id`),
  CONSTRAINT `keywordproject_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`project_id`) ON DELETE CASCADE,
  CONSTRAINT `keywordproject_ibfk_2` FOREIGN KEY (`k_id`) REFERENCES `keyword` (`k_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `keywordproject`
--


/*!40000 ALTER TABLE `keywordproject` DISABLE KEYS */;
LOCK TABLES `keywordproject` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `keywordproject` ENABLE KEYS */;

--
-- Table structure for table `mentee_interests`
--

DROP TABLE IF EXISTS `mentee_interests`;
CREATE TABLE `mentee_interests` (
  `username` varchar(255) NOT NULL,
  `interested_because` text,
  `mentor_field_pref` varchar(255) default '',
  `interested_topics` text,
  PRIMARY KEY  (`username`),
  CONSTRAINT `mentee_interests_ibfk_1` FOREIGN KEY (`username`) REFERENCES `user` (`username`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mentee_interests`
--


/*!40000 ALTER TABLE `mentee_interests` DISABLE KEYS */;
LOCK TABLES `mentee_interests` WRITE;
INSERT INTO `mentee_interests` VALUES ('student1','I want to become a doctor and help people','Nursing, Social Work','How to do lab tests well'),('student2','I\'m just curious.  What if I try an URL here?  http://www.google.com','Social Work','Social work!'),('student3','My mother suffers from diabetes','Behavioral Health, Public Health','Radiology'),('student4','I want to go to Medical school.','Biomedical Research, Physician Assistant','Alcholism');
UNLOCK TABLES;
/*!40000 ALTER TABLE `mentee_interests` ENABLE KEYS */;

--
-- Table structure for table `mentee_school`
--

DROP TABLE IF EXISTS `mentee_school`;
CREATE TABLE `mentee_school` (
  `username` varchar(255) NOT NULL,
  `name` varchar(255) default '',
  `year` varchar(50) default '',
  `graduation_year` varchar(5) default '2015',
  `major` varchar(100) default '',
  `career_goals` text,
  `extracurricular` text,
  `gpa` varchar(10) default '',
  `parent_education_level` int(4) default '1',
  PRIMARY KEY  (`username`),
  CONSTRAINT `mentee_school_ibfk_1` FOREIGN KEY (`username`) REFERENCES `user` (`username`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mentee_school`
--


/*!40000 ALTER TABLE `mentee_school` DISABLE KEYS */;
LOCK TABLES `mentee_school` WRITE;
INSERT INTO `mentee_school` VALUES ('student1','Bartlett High','Junior','2014','Biological Sciences','Career goals!','Swimming and Hiking and Fishing','',6),('student2','My School','20','2016','Nursing','','','',6),('student3','Dimond','Senior','','','Become a computer scientist','Fishing','',5),('student4','UAA','Senior','2011','Languages','Becoming a translator','Swimming and basketball','',5);
UNLOCK TABLES;
/*!40000 ALTER TABLE `mentee_school` ENABLE KEYS */;

--
-- Table structure for table `mentor_interests`
--

DROP TABLE IF EXISTS `mentor_interests`;
CREATE TABLE `mentor_interests` (
  `username` varchar(255) NOT NULL,
  `interested_because` text,
  `relevant_research` text,
  `num_students` int(4) default '0',
  `time_available` varchar(255) default '',
  `specific_grade_level` varchar(100) default '',
  `mentee_educational_level` varchar(100) default '',
  PRIMARY KEY  (`username`),
  CONSTRAINT `mentor_interests_ibfk_1` FOREIGN KEY (`username`) REFERENCES `user` (`username`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mentor_interests`
--


/*!40000 ALTER TABLE `mentor_interests` DISABLE KEYS */;
LOCK TABLES `mentor_interests` WRITE;
INSERT INTO `mentor_interests` VALUES ('mentor3','I am interested because I want to learn more','Paper X; Conference Y; Thing Z',2,'1 hour a week','13','College, Post Graduate'),('mentor5','I like it','',2,'','','Post Graduate'),('mentor6','I like to eat','I like to do this',1,'1 hour a month','','Elementary (K-6), Post Graduate');
UNLOCK TABLES;
/*!40000 ALTER TABLE `mentor_interests` ENABLE KEYS */;

--
-- Table structure for table `mentor_occupation`
--

DROP TABLE IF EXISTS `mentor_occupation`;
CREATE TABLE `mentor_occupation` (
  `username` varchar(255) NOT NULL,
  `occupation` varchar(255) default '',
  `employer` varchar(255) default '',
  `years_work` int(4) default '0',
  `mentor_fields` varchar(255) default '',
  `health_disparities` int(4) default '0',
  PRIMARY KEY  (`username`),
  CONSTRAINT `mentor_occupation_ibfk_1` FOREIGN KEY (`username`) REFERENCES `user` (`username`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `mentor_occupation`
--


/*!40000 ALTER TABLE `mentor_occupation` DISABLE KEYS */;
LOCK TABLES `mentor_occupation` WRITE;
INSERT INTO `mentor_occupation` VALUES ('mentor3','Doctor','Providence Hospital',10,'Biomedical Research, Nursing, Social Work, Sleep, Video Games',0),('mentor5','','',0,'Allied Health, Medicine',1),('mentor6','Research Scientist','Institute of the North',2,'Nursing, Public Health',1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `mentor_occupation` ENABLE KEYS */;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
CREATE TABLE `project` (
  `project_id` int(10) unsigned NOT NULL auto_increment,
  `project_title` varchar(255) default '',
  `abstract` text,
  `status` int(4) NOT NULL default '0',
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `funding_source` varchar(255) default '',
  `funding_amount` varchar(255) default '',
  `course` varchar(255) default '',
  `partner` varchar(255) default '',
  `seeking_help` int(4) default '1',
  `modification_date` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`project_id`),
  KEY `project_id` (`project_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `project`
--


/*!40000 ALTER TABLE `project` DISABLE KEYS */;
LOCK TABLES `project` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `project` ENABLE KEYS */;

--
-- Table structure for table `projectfile`
--

DROP TABLE IF EXISTS `projectfile`;
CREATE TABLE `projectfile` (
  `project_id` int(10) unsigned NOT NULL,
  `username` varchar(255) NOT NULL,
  `filename` varchar(255) NOT NULL default '',
  `description` varchar(255) default '',
  `modification_date` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`project_id`,`username`,`filename`),
  KEY `project_id` (`project_id`),
  KEY `username` (`username`),
  KEY `filename` (`filename`),
  CONSTRAINT `projectfile_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`project_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `projectfile`
--


/*!40000 ALTER TABLE `projectfile` DISABLE KEYS */;
LOCK TABLES `projectfile` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `projectfile` ENABLE KEYS */;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
  `username` varchar(255) NOT NULL,
  `password` varchar(255) default '',
  `usertype` int(4) NOT NULL default '1',
  `disadvantaged` int(4) default '0',
  `email` varchar(255) default '',
  `lname` varchar(255) default '',
  `fname` varchar(255) default '',
  `phone` varchar(255) default '',
  `sex` varchar(2) default 'M',
  `race` varchar(255) default '',
  `languages` varchar(255) default '',
  `facebook` varchar(255) default '',
  `myspace` varchar(255) default '',
  `address` varchar(255) default '',
  `curcity` varchar(255) default '',
  `birthdate` date default NULL,
  `bachelors` varchar(255) default '',
  `masters` varchar(255) default '',
  `doctorates` varchar(255) default '',
  `modification_date` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `picture` varchar(255) default 'nopic',
  `sid` varchar(12) default '',
  PRIMARY KEY  (`username`),
  UNIQUE KEY `username_2` (`username`),
  KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `user`
--


/*!40000 ALTER TABLE `user` DISABLE KEYS */;
LOCK TABLES `user` WRITE;
INSERT INTO `user` VALUES ('mentor3','mentor3',2,0,'kenrick@acm.org','Mentor3','Joe','786-1956','M','White, Alaska Native or American Indian, Other','French, German','kenrickm','myspacekenrick','','',NULL,'BS CS','MS CSE','PhD Egg Science','2010-11-07 00:06:40','nopic',''),('mentor5','mentor5',2,0,'kenrick@uaa.alaska.edu','Mentor5','Tom','','M','Asian,Black','','','','','',NULL,'','','','2010-11-06 21:59:33','nopic',''),('mentor6','mentor6',2,0,'kenrick','Mentor6','Bill','787-1956','M','Native Hawaiian or Pacific Islander','French','','','','',NULL,'Arts','Biology','PhD in Foo','2010-11-06 08:14:19','nopic',''),('student1','student1',1,0,'kenrick@uaa.alaska.edu','Student1','Joe','929-9833','F','White, Alaska Native or American Indian, Native Hawaiian or Pacific Islander','Spanish, Russian, Cantonese','facebookname1','myspacename2','123 XYZ St','Homer','1990-01-01','','','','2010-12-13 04:30:25','kmsimp2.png','30560123'),('student2','student2',1,0,'kenrick@uaa.alaska.edu','Student2','Ted','7861956','M','White','English','kenrickm','','999 X St','Anchorage','1989-01-01','','','','2010-11-15 23:28:18','nopic',''),('student3','password',1,0,'kenrick@uaa.alaska.edu','Student3','Jane','9073507389','F','Alaska Native or American Indian','spanish','facebookname','myspacename','123 X St','Haines','1996-01-01','','','','2010-11-19 23:08:55','kmhead2.jpg',''),('student4','student4',1,0,'kenrick@uaa.alaska.edu','Garcia','Francisco','7861956','M','Hispanic or Latino','spanish','','','1000 A St','Anchorage','1987-01-01','','','','2010-12-13 05:54:43','nopic','30412312');
UNLOCK TABLES;
/*!40000 ALTER TABLE `user` ENABLE KEYS */;

--
-- Table structure for table `userfile`
--

DROP TABLE IF EXISTS `userfile`;
CREATE TABLE `userfile` (
  `username` varchar(255) NOT NULL,
  `filename` varchar(255) NOT NULL default '',
  `description` text,
  PRIMARY KEY  (`username`,`filename`),
  KEY `username` (`username`),
  KEY `filename` (`filename`),
  CONSTRAINT `userfile_ibfk_1` FOREIGN KEY (`username`) REFERENCES `user` (`username`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `userfile`
--


/*!40000 ALTER TABLE `userfile` DISABLE KEYS */;
LOCK TABLES `userfile` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `userfile` ENABLE KEYS */;

--
-- Table structure for table `userproject`
--

DROP TABLE IF EXISTS `userproject`;
CREATE TABLE `userproject` (
  `project_id` int(10) unsigned NOT NULL,
  `username` varchar(255) NOT NULL,
  `userstatus` int(4) default '0',
  `standing_started` varchar(50) default '',
  PRIMARY KEY  (`project_id`,`username`),
  KEY `project_id` (`project_id`),
  KEY `username` (`username`),
  CONSTRAINT `userproject_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`project_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `userproject`
--


/*!40000 ALTER TABLE `userproject` DISABLE KEYS */;
LOCK TABLES `userproject` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `userproject` ENABLE KEYS */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

