﻿using System;
using System.Collections;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

//This class constructs the GUI. It is the most critical part of the program.  It handles
//all user interactions that occur through the GUI, and maintains the current phase of the
//game.  Phases allow certain actions, and disallow others.
namespace Sea4
{
    public partial class Form1 : Form
    {
        int numShips = 5;                               //default number of ships, can change by user
        String difficulty = "normal";                   //default difficulty
        String phase = "start";                         //initial phase, and ship placement stage
        int placementStage = 1;
        int shipType = 1;                           //1 = aircraft carrier, 2 = battleship, 3 = frigate, 4 = submarine, 5 = patrol boat
        int counter = 1;
        int indexEnd1 = 0;                                          //The tab index for button corresponding to one end of the ship
        int indexEnd2 = 0;                                          //The tab index for button corresponding to the other end
        int End1X;                                                  //one end of the ship X
        int End1Y;                                                  //one end of the ship Y
        int End2X;                                                  //other end X
        int End2Y;                                                  //other end Y

        Game game;                                      //instance of game, created when user finishes placing ships
        int firingRow;                                  //location for firing choice
        int firingColumn;
        int firingIndex;

        Boolean clear = true;                                   //The current game states of player and computer
        Boolean buttonValid = false;
        String[,] playerState;
        String[,] compState;

        //ship placement pics
        PictureBox A1 = new PictureBox();                           //pictures of each ship
        PictureBox A2 = new PictureBox();
        PictureBox B1 = new PictureBox();
        PictureBox B2 = new PictureBox();
        PictureBox F1 = new PictureBox();
        PictureBox F2 = new PictureBox();
        PictureBox S1 = new PictureBox();
        PictureBox S2 = new PictureBox();
        PictureBox P1 = new PictureBox();
        PictureBox P2 = new PictureBox();



        //initializes the form... sets music to loop when app is started
        public Form1()
        {
            InitializeComponent();

            byte[] b = Properties.Resources._009_Sound_System___Born_To_Be_Wasted___Track_one_recordings_HQ__Lyrics_;
            FileInfo fileInfo = new FileInfo("test.wmv");
            FileStream fs = fileInfo.OpenWrite();
            fs.Write(b, 0, b.Length);
            fs.Close();
            axWindowsMediaPlayer2.URL = fileInfo.Name;
            axWindowsMediaPlayer2.settings.setMode("loop", true);

            loadHitVideo();
            loadSinkVideo();
        }

        //closes the program
        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        //used during ship placement phase to place a ship, 3 stages of 
        //phase require different actions.  Invoked by the ship grid buttons.
        private void shipPlacementProtcol(Button b)
        {
            if (phase == "ship")
            {
                
                if (placementStage == 1)
                {
                    b.BackColor = Color.Gold;
                    cancelShip.ForeColor = Color.Black;
                    int sRow = Convert.ToInt16(b.Name.Substring(1, 1));
                    int sColumn = Convert.ToInt16(b.Name.Substring(2, 1));
                    indexEnd1 = b.TabIndex;
                    End1X = b.Location.X;
                    End1Y = b.Location.Y;

                    int extraunits = 0;
                    if (shipType == 1)
                    {
                        extraunits = 4;
                    }
                    if (shipType == 2)
                    {
                        extraunits = 3;
                    }
                    if (shipType == 3 || shipType == 4)
                    {
                        extraunits = 2;
                    }
                    if (shipType == 5)
                    {
                        extraunits = 1;
                    }

                    if ((sColumn - extraunits) >= 0)
                    {
                        int indexIterate = indexEnd1;

                        for (int i = 0; i < extraunits; i++)
                        {
                            int neighborIndex = indexIterate - 1;
                            pathClear(this, neighborIndex);
                            indexIterate--;
                        }

                        indexIterate = indexEnd1;
                        if (clear)
                        {
                            for (int i = 0; i < extraunits; i++)
                            {
                                int neighborIndex = indexIterate - 1;
                                redLayout(this, neighborIndex);
                                indexIterate--;
                            }
                        }
                        clear = true;
                    }
                    if ((sColumn + extraunits) <= 7)
                    {
                         int indexIterate = indexEnd1;

                        for (int i = 0; i < extraunits; i++)
                        {
                            int neighborIndex = indexIterate + 1;
                            pathClear(this, neighborIndex);
                            indexIterate++;
                        }

                        indexIterate = indexEnd1;
                        if (clear)
                        {
                            for (int i = 0; i < extraunits; i++)
                            {
                                int neighborIndex = indexIterate + 1;
                                redLayout(this, neighborIndex);
                                indexIterate++;
                            }
                        }
                        clear = true;
                    }
                    if ((sRow - extraunits) >= 0)
                    {
                        int indexIterate = indexEnd1;

                        for (int i = 0; i < extraunits; i++)
                        {
                            int neighborIndex = indexIterate - 8;
                            pathClear(this, neighborIndex);
                            indexIterate = indexIterate - 8;
                        }

                        indexIterate = indexEnd1;
                        if (clear)
                        {
                            for (int i = 0; i < extraunits; i++)
                            {
                                int neighborIndex = indexIterate - 8;
                                redLayout(this, neighborIndex);
                                indexIterate = indexIterate - 8;
                            }
                        }
                        clear = true;
                    }
                    if ((sRow + extraunits) <= 7)
                    {
                         int indexIterate = indexEnd1;

                        for (int i = 0; i < extraunits; i++)
                        {
                            int neighborIndex = indexIterate + 8;
                            pathClear(this, neighborIndex);
                            indexIterate = indexIterate + 8;
                        }

                        indexIterate = indexEnd1;
                        if (clear)
                        {
                            for (int i = 0; i < extraunits; i++)
                            {
                                int neighborIndex = indexIterate + 8;
                                redLayout(this, neighborIndex);
                                indexIterate = indexIterate + 8;
                            }
                        }
                        clear = true;
                    }
                    placementStage = 2;
                }
                else if (placementStage == 2 || placementStage == 3)
                {
                    if (b.BackColor == Color.Red)
                    {
                        placementStage = 3;
                        indexEnd2 = b.TabIndex;
                     //   End2X = b.Location.X;
                    //    End2Y = b.Location.Y;
                        aquaLayout(this);
                        placeShip.ForeColor = Color.Black;
                    }
                }

            }
        }

        //detects whether a path is clear, searches the controls
        //in specific layout direction, to ensure tehy are not
        //colored black, which would indicate a ship is present
        //used to place ships by user
        public void pathClear(Control Page, int index)
        {
            foreach (Control ctrl in Page.Controls)
            {
                if (ctrl is Button)
                {
                    if (((Button)(ctrl)).TabIndex == index)
                    {
                        if (ctrl.BackColor == Color.Black)
                        {
                            clear = false;
                        }
                    }
                }
                else
                {
                    if (ctrl.Controls.Count > 0)
                    {
                        pathClear(ctrl, index);
                    }
                }
            }
        }

        //used during the second stage of ship placement,
        //recolors the layouts not selected by the user 
        //the color of the ocean, while keeping
        //the layout selected red
        private void aquaLayout(Control Page)
        {
            int temp = indexEnd2 - indexEnd1;

            int maxTabIndex;
            if (temp < 0)
            {
                maxTabIndex = 1000;
            }
            else
            {
                maxTabIndex = 0;
            }

            foreach (Control ctrl in Page.Controls)
            {
                if (ctrl is Button)
                {
                    if (ctrl.BackColor == Color.Red)
                    {
                        if (temp < 0)
                        {
                            if (ctrl.TabIndex > indexEnd1)
                            {
                                ctrl.BackColor = Color.Aqua;
                            }

                            if (temp < -7)
                            {
                                if ((ctrl.TabIndex - indexEnd1) > -7)
                                {
                                    ctrl.BackColor = Color.Aqua;
                                }
                                else if (ctrl.TabIndex < maxTabIndex)
                                {
                                    maxTabIndex = ctrl.TabIndex;
                                    End2X = ctrl.Location.X;
                                    End2Y = ctrl.Location.Y;
                                }
                            }
                            else
                            {
                                if ((ctrl.TabIndex - indexEnd1) < -7)
                                {
                                    ctrl.BackColor = Color.Aqua;
                                }
                                else if (ctrl.TabIndex < maxTabIndex)
                                {
                                    maxTabIndex = ctrl.TabIndex;
                                    End2X = ctrl.Location.X;
                                    End2Y = ctrl.Location.Y;
                                }
                            }
                        }
                        else
                        {
                            if (ctrl.TabIndex < indexEnd1)
                            {
                                ctrl.BackColor = Color.Aqua;
                            }

                            if (temp > 7)
                            {
                                if ((ctrl.TabIndex - indexEnd1) < 7)
                                {
                                    ctrl.BackColor = Color.Aqua;
                                }
                                else if (ctrl.TabIndex > maxTabIndex)
                                {
                                    maxTabIndex = ctrl.TabIndex;
                                    End2X = ctrl.Location.X;
                                    End2Y = ctrl.Location.Y;
                                }
                            }
                            else
                            {
                                if ((ctrl.TabIndex - indexEnd1) > 7)
                                {
                                    ctrl.BackColor = Color.Aqua;
                                }
                                else if (ctrl.TabIndex > maxTabIndex)
                                {
                                    maxTabIndex = ctrl.TabIndex;
                                    End2X = ctrl.Location.X;
                                    End2Y = ctrl.Location.Y;
                                }
                            }
                        }

                    }
                    
                }
                else
                {
                    if (ctrl.Controls.Count > 0)
                    {
                        aquaLayout(ctrl);
                    }
                }
            }
        }

        //identifies possible ship layouts, by coloring
        //the controls for those locations red
        private void redLayout(Control Page, int index)
        {
            foreach (Control ctrl in Page.Controls)
            {
                if (ctrl is Button)
                {
                    if(((Button)(ctrl)).TabIndex == index)
                    {
                        ctrl.BackColor = Color.Red;
                        indexEnd2 = ctrl.TabIndex;
                    }
                }
                else
                {
                    if (ctrl.Controls.Count > 0)
                    {
                        redLayout(ctrl, index);
                    }
                }
            }
        }

        //places images over the final ship location,
        //images are placed over the buttons corresponding
        //to the location of the ship
        private void shipLayout(Control Page)
        {
            int temp = indexEnd2 - indexEnd1;
            
            foreach (Control ctrl in Page.Controls)
            {
                if (ctrl is Button)
                {
                    if (((Button)(ctrl)).BackColor != Color.Aqua)
                    {
                        
                    //    int tempX = ctrl.Bounds.Location.X;
                    //    int tempY = ctrl.Bounds.Location.Y;
                        int heightOfContrl = ctrl.Bounds.Size.Height;
                        int widthOfContrl = ctrl.Bounds.Size.Height;

                        if (((Button)(ctrl)).BackColor == Color.Gold)
                        {
                            
                            if (temp < 0)
                            {
                                if (temp < -7)                 //ship going north
                                {
                                    if (shipType == 1)
                                    {
                                        if (counter <= 5)
                                        {
                                            A1.Width = widthOfContrl + 5;
                                            A1.Height = heightOfContrl * 5 + 26;
                                            A1.Location = new System.Drawing.Point(End2X, End2Y);
                                            A1.Image = Properties.Resources.acV;
                                            A1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            A1.Anchor = AnchorStyles.Bottom;
                                            A1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(A1);
                                            A1.Visible = true;
                                            A1.BringToFront();
                                            ctrl.Text = "A1";
                                        }
                                        else
                                        {
                                            A2.Width = widthOfContrl + 5;
                                            A2.Height = heightOfContrl * 5 + 26;
                                            A2.Location = new System.Drawing.Point(End2X, End2Y);
                                            A2.Image = Properties.Resources.acV;
                                            A2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            A2.Anchor = AnchorStyles.Bottom;
                                            A2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(A2);
                                            A2.Visible = true;
                                            A2.BringToFront();
                                            ctrl.Text = "A2";
                                        }
                                    }
                                    if (shipType == 2)
                                    {
                                        if (counter <= 5)
                                        {
                                            B1.Width = widthOfContrl + 5;
                                            B1.Height = heightOfContrl * 4 + 20;
                                            B1.Location = new System.Drawing.Point(End2X, End2Y);
                                            B1.Image = Properties.Resources.bsV;
                                            B1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            B1.Anchor = AnchorStyles.Bottom;
                                            B1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(B1);
                                            B1.Visible = true;
                                            B1.BringToFront();
                                            ctrl.Text = "B1";
                                        }
                                        else
                                        {
                                            B2.Width = widthOfContrl + 5;
                                            B2.Height = heightOfContrl * 4 + 20;
                                            B2.Location = new System.Drawing.Point(End2X, End2Y);
                                            B2.Image = Properties.Resources.bsV;
                                            B2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            B2.Anchor = AnchorStyles.Bottom;
                                            B2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(B2);
                                            B2.Visible = true;
                                            B2.BringToFront();
                                            ctrl.Text = "B2";
                                        }
                                    }
                                    if (shipType == 3)
                                    {
                                        if (counter <= 5)
                                        {
                                            F1.Width = widthOfContrl + 5;
                                            F1.Height = heightOfContrl * 3 + 14;
                                            F1.Location = new System.Drawing.Point(End2X, End2Y);
                                            F1.Image = Properties.Resources.fgV;
                                            F1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            F1.Anchor = AnchorStyles.Bottom;
                                            F1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(F1);
                                            F1.Visible = true;
                                            F1.BringToFront();
                                            ctrl.Text = "F1";
                                        }
                                        else
                                        {
                                            F2.Width = widthOfContrl + 5;
                                            F2.Height = heightOfContrl * 3 + 14;
                                            F2.Location = new System.Drawing.Point(End2X, End2Y);
                                            F2.Image = Properties.Resources.fgV;
                                            F2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            F2.Anchor = AnchorStyles.Bottom;
                                            F2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(F2);
                                            F2.Visible = true;
                                            F2.BringToFront();
                                            ctrl.Text = "F2";
                                        }
                                    }
                                    if (shipType == 4)
                                    {
                                        if (counter <= 5)
                                        {
                                            S1.Width = widthOfContrl + 5;
                                            S1.Height = heightOfContrl * 3 + 14;
                                            S1.Location = new System.Drawing.Point(End2X, End2Y);
                                            S1.Image = Properties.Resources.subV;
                                            S1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            S1.Anchor = AnchorStyles.Bottom;
                                            S1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(S1);
                                            S1.Visible = true;
                                            S1.BringToFront();
                                            ctrl.Text = "S1";
                                        }
                                        else
                                        {
                                            S2.Width = widthOfContrl + 5;
                                            S2.Height = heightOfContrl * 3 + 14;
                                            S2.Location = new System.Drawing.Point(End2X, End2Y);
                                            S2.Image = Properties.Resources.subV;
                                            S2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            S2.Anchor = AnchorStyles.Bottom;
                                            S2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(S2);
                                            S2.Visible = true;
                                            S2.BringToFront();
                                            ctrl.Text = "S2";
                                        }
                                    }
                                    if (shipType == 5)
                                    {
                                        if (counter <= 5)
                                        {
                                            P1.Width = widthOfContrl + 5;
                                            P1.Height = heightOfContrl * 2 + 8;
                                            P1.Location = new System.Drawing.Point(End2X, End2Y);
                                            P1.Image = Properties.Resources.pbV;
                                            P1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            P1.Anchor = AnchorStyles.Bottom;
                                            P1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(P1);
                                            P1.Visible = true;
                                            P1.BringToFront();
                                            ctrl.Text = "P1";
                                        }
                                        else
                                        {
                                            P2.Width = widthOfContrl + 5;
                                            P2.Height = heightOfContrl * 2 + 8;
                                            P2.Location = new System.Drawing.Point(End2X, End2Y);
                                            P2.Image = Properties.Resources.pbV;
                                            P2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            P2.Anchor = AnchorStyles.Bottom;
                                            P2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(P2);
                                            P2.Visible = true;
                                            P2.BringToFront();
                                            ctrl.Text = "P2";
                                        }
                                    }
                                }

                                else            // ship going west                                 
                                {
                                    if (shipType == 1)
                                    {
                                        if (counter <= 5)
                                        {
                                            A1.Width = widthOfContrl * 5 + 44;
                                            A1.Height = heightOfContrl;
                                            A1.Location = new System.Drawing.Point(End2X, End2Y);
                                            A1.Image = Properties.Resources.acH;
                                            A1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            A1.Anchor = AnchorStyles.Bottom;
                                            A1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(A1);
                                            A1.Visible = true;
                                            A1.BringToFront();
                                            ctrl.Text = "A1";
                                        }
                                        else
                                        {
                                            A2.Width = widthOfContrl * 5 + 44;
                                            A2.Height = heightOfContrl;
                                            A2.Location = new System.Drawing.Point(End2X, End2Y);
                                            A2.Image = Properties.Resources.acH;
                                            A2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            A2.Anchor = AnchorStyles.Bottom;
                                            A2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(A2);
                                            A2.Visible = true;
                                            A2.BringToFront();
                                            ctrl.Text = "A2";
                                        }
                                    }
                                    if (shipType == 2)
                                    {
                                        if (counter <= 5)
                                        {
                                            B1.Width = widthOfContrl *4 + 34;
                                            B1.Height = heightOfContrl;
                                            B1.Location = new System.Drawing.Point(End2X, End2Y);
                                            B1.Image = Properties.Resources.bsH;
                                            B1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            B1.Anchor = AnchorStyles.Bottom;
                                            B1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(B1);
                                            B1.Visible = true;
                                            B1.BringToFront();
                                            ctrl.Text = "B1";
                                        }
                                        else
                                        {
                                            B2.Width = widthOfContrl *4 + 34;
                                            B2.Height = heightOfContrl;
                                            B2.Location = new System.Drawing.Point(End2X, End2Y);
                                            B2.Image = Properties.Resources.bsH;
                                            B2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            B2.Anchor = AnchorStyles.Bottom;
                                            B2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(B2);
                                            B2.Visible = true;
                                            B2.BringToFront();
                                            ctrl.Text = "B2";
                                        }
                                    }
                                    if (shipType == 3)
                                    {
                                        if (counter <= 5)
                                        {
                                            F1.Width = widthOfContrl * 3 + 24;
                                            F1.Height = heightOfContrl;
                                            F1.Location = new System.Drawing.Point(End2X, End2Y);
                                            F1.Image = Properties.Resources.fgH;
                                            F1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            F1.Anchor = AnchorStyles.Bottom;
                                            F1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(F1);
                                            F1.Visible = true;
                                            F1.BringToFront();
                                            ctrl.Text = "F1";
                                        }
                                        else
                                        {
                                            F2.Width = widthOfContrl *3 + 24;
                                            F2.Height = heightOfContrl;
                                            F2.Location = new System.Drawing.Point(End2X, End2Y);
                                            F2.Image = Properties.Resources.fgH;
                                            F2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            F2.Anchor = AnchorStyles.Bottom;
                                            F2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(F2);
                                            F2.Visible = true;
                                            F2.BringToFront();
                                            ctrl.Text = "F2";
                                        }
                                    }
                                    if (shipType == 4)
                                    {
                                        if (counter <= 5)
                                        {
                                            S1.Width = widthOfContrl * 3 + 24;
                                            S1.Height = heightOfContrl;
                                            S1.Location = new System.Drawing.Point(End2X, End2Y);
                                            S1.Image = Properties.Resources.subH;
                                            S1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            S1.Anchor = AnchorStyles.Bottom;
                                            S1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(S1);
                                            S1.Visible = true;
                                            S1.BringToFront();
                                            ctrl.Text = "S1";
                                        }
                                        else
                                        {
                                            S2.Width = widthOfContrl *3 + 24;
                                            S2.Height = heightOfContrl;
                                            S2.Location = new System.Drawing.Point(End2X, End2Y);
                                            S2.Image = Properties.Resources.subH;
                                            S2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            S2.Anchor = AnchorStyles.Bottom;
                                            S2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(S2);
                                            S2.Visible = true;
                                            S2.BringToFront();
                                            ctrl.Text = "S2";
                                        }
                                    }
                                    if (shipType == 5)
                                    {
                                        if (counter <= 5)
                                        {
                                            P1.Width = widthOfContrl *2 + 14;
                                            P1.Height = heightOfContrl;
                                            P1.Location = new System.Drawing.Point(End2X, End2Y);
                                            P1.Image = Properties.Resources.pbH;
                                            P1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            P1.Anchor = AnchorStyles.Bottom;
                                            P1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(P1);
                                            P1.Visible = true;
                                            P1.BringToFront();
                                            ctrl.Text = "P1";
                                        }
                                        else
                                        {
                                            P2.Width = widthOfContrl *2 + 14;
                                            P2.Height = heightOfContrl;
                                            P2.Location = new System.Drawing.Point(End2X, End2Y);
                                            P2.Image = Properties.Resources.pbH;
                                            P2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            P2.Anchor = AnchorStyles.Bottom;
                                            P2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(P2);
                                            P2.Visible = true;
                                            P2.BringToFront();
                                            ctrl.Text = "P2";
                                        }
                                    }
                                }
                            }

                            else
                            {
                                if (temp > 7)           //ship going south
                                {
                                    if (shipType == 1)
                                    {
                                        if (counter <= 5)
                                        {
                                            A1.Width = widthOfContrl + 5;
                                            A1.Height = heightOfContrl * 5 + 26;
                                            A1.Location = new System.Drawing.Point(End1X, End1Y);
                                            A1.Image = Properties.Resources.acV;
                                            A1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            A1.Anchor = AnchorStyles.Bottom;
                                            A1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(A1);
                                            A1.Visible = true;
                                            A1.BringToFront();
                                            ctrl.Text = "A1";
                                        }
                                        else
                                        {
                                            A2.Width = widthOfContrl + 5;
                                            A2.Height = heightOfContrl * 5 + 26;
                                            A2.Location = new System.Drawing.Point(End1X, End1Y);
                                            A2.Image = Properties.Resources.acV;
                                            A2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            A2.Anchor = AnchorStyles.Bottom;
                                            A2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(A2);
                                            A2.Visible = true;
                                            A2.BringToFront();
                                            ctrl.Text = "A2";
                                        }
                                    }
                                    if (shipType == 2)
                                    {
                                        if (counter <= 5)
                                        {
                                            B1.Width = widthOfContrl + 5;
                                            B1.Height = heightOfContrl * 4 + 20;
                                            B1.Location = new System.Drawing.Point(End1X, End1Y);
                                            B1.Image = Properties.Resources.bsV;
                                            B1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            B1.Anchor = AnchorStyles.Bottom;
                                            B1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(B1);
                                            B1.Visible = true;
                                            B1.BringToFront();
                                            ctrl.Text = "B1";
                                        }
                                        else
                                        {
                                            B2.Width = widthOfContrl + 5;
                                            B2.Height = heightOfContrl * 4 + 20;
                                            B2.Location = new System.Drawing.Point(End1X, End1Y);
                                            B2.Image = Properties.Resources.bsV;
                                            B2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            B2.Anchor = AnchorStyles.Bottom;
                                            B2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(B2);
                                            B2.Visible = true;
                                            B2.BringToFront();
                                            ctrl.Text = "B2";

                                        }
                                    }
                                    if (shipType == 3)
                                    {
                                        if (counter <= 5)
                                        {
                                            F1.Width = widthOfContrl + 5;
                                            F1.Height = heightOfContrl * 3 + 14;
                                            F1.Location = new System.Drawing.Point(End1X, End1Y);
                                            F1.Image = Properties.Resources.fgV;
                                            F1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            F1.Anchor = AnchorStyles.Bottom;
                                            F1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(F1);
                                            F1.Visible = true;
                                            F1.BringToFront();
                                            ctrl.Text = "F1";
                                        }
                                        else
                                        {
                                            F2.Width = widthOfContrl + 5;
                                            F2.Height = heightOfContrl * 3 + 14;
                                            F2.Location = new System.Drawing.Point(End1X, End1Y);
                                            F2.Image = Properties.Resources.fgV;
                                            F2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            F2.Anchor = AnchorStyles.Bottom;
                                            F2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(F2);
                                            F2.Visible = true;
                                            F2.BringToFront();
                                            ctrl.Text = "F2";
                                        }
                                    }
                                    if (shipType == 4)
                                    {
                                        if (counter <= 5)
                                        {
                                            S1.Width = widthOfContrl + 5;
                                            S1.Height = heightOfContrl * 3 + 14;
                                            S1.Location = new System.Drawing.Point(End1X, End1Y);
                                            S1.Image = Properties.Resources.subV;
                                            S1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            S1.Anchor = AnchorStyles.Bottom;
                                            S1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(S1);
                                            S1.Visible = true;
                                            S1.BringToFront();
                                            ctrl.Text = "S1";
                                        }
                                        else
                                        {
                                            S2.Width = widthOfContrl + 5;
                                            S2.Height = heightOfContrl * 3 + 14;
                                            S2.Location = new System.Drawing.Point(End1X, End1Y);
                                            S2.Image = Properties.Resources.subV;
                                            S2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            S2.Anchor = AnchorStyles.Bottom;
                                            S2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(S2);
                                            S2.Visible = true;
                                            S2.BringToFront();
                                            ctrl.Text = "S2";
                                        }
                                    }
                                    if (shipType == 5)
                                    {
                                        if (counter <= 5)
                                        {
                                            P1.Width = widthOfContrl + 5;
                                            P1.Height = heightOfContrl * 2 + 8;
                                            P1.Location = new System.Drawing.Point(End1X, End1Y);
                                            P1.Image = Properties.Resources.pbV;
                                            P1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            P1.Anchor = AnchorStyles.Bottom;
                                            P1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(P1);
                                            P1.Visible = true;
                                            P1.BringToFront();
                                            ctrl.Text = "P1";
                                        }
                                        else
                                        {
                                            P2.Width = widthOfContrl + 5;
                                            P2.Height = heightOfContrl * 2 + 8;
                                            P2.Location = new System.Drawing.Point(End1X, End1Y);
                                            P2.Image = Properties.Resources.pbV;
                                            P2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            P2.Anchor = AnchorStyles.Bottom;
                                            P2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(P2);
                                            P2.Visible = true;
                                            P2.BringToFront();
                                            ctrl.Text = "P2";
                                        }
                                    }
                                }

                                else                    //ship going East
                                {
                                    if (shipType == 1)
                                    {
                                        if (counter <= 5)
                                        {
                                            A1.Width = widthOfContrl * 5 + 44;
                                            A1.Height = heightOfContrl;
                                            A1.Location = new System.Drawing.Point(End1X, End1Y);
                                            A1.Image = Properties.Resources.acH;
                                            A1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            A1.Anchor = AnchorStyles.Bottom;
                                            A1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(A1);
                                            A1.Visible = true;
                                            A1.BringToFront();
                                            ctrl.Text = "A1";
                                        }
                                        else
                                        {
                                            A2.Width = widthOfContrl * 5 + 44;
                                            A2.Height = heightOfContrl;
                                            A2.Location = new System.Drawing.Point(End1X, End1Y);
                                            A2.Image = Properties.Resources.acH;
                                            A2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            A2.Anchor = AnchorStyles.Bottom;
                                            A2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(A2);
                                            A2.Visible = true;
                                            A2.BringToFront();
                                            ctrl.Text = "A2";
                                        }
                                    }
                                    if (shipType == 2)
                                    {
                                        if (counter <= 5)
                                        {
                                            B1.Width = widthOfContrl * 4 + 34;
                                            B1.Height = heightOfContrl;
                                            B1.Location = new System.Drawing.Point(End1X, End1Y);
                                            B1.Image = Properties.Resources.bsH;
                                            B1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            B1.Anchor = AnchorStyles.Bottom;
                                            B1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(B1);
                                            B1.Visible = true;
                                            B1.BringToFront();
                                            ctrl.Text = "B1";
                                        }
                                        else
                                        {
                                            B2.Width = widthOfContrl * 4 + 34;
                                            B2.Height = heightOfContrl;
                                            B2.Location = new System.Drawing.Point(End1X, End1Y);
                                            B2.Image = Properties.Resources.bsH;
                                            B2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            B2.Anchor = AnchorStyles.Bottom;
                                            B2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(B2);
                                            B2.Visible = true;
                                            B2.BringToFront();
                                            ctrl.Text = "B2";
                                        }
                                    }
                                    if (shipType == 3)
                                    {
                                        if (counter <= 5)
                                        {
                                            F1.Width = widthOfContrl * 3 + 24;
                                            F1.Height = heightOfContrl;
                                            F1.Location = new System.Drawing.Point(End1X, End1Y);
                                            F1.Image = Properties.Resources.fgH;
                                            F1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            F1.Anchor = AnchorStyles.Bottom;
                                            F1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(F1);
                                            F1.Visible = true;
                                            F1.BringToFront();
                                            ctrl.Text = "F1";
                                        }
                                        else
                                        {
                                            F2.Width = widthOfContrl * 3 + 24;
                                            F2.Height = heightOfContrl;
                                            F2.Location = new System.Drawing.Point(End1X, End1Y);
                                            F2.Image = Properties.Resources.fgH;
                                            F2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            F2.Anchor = AnchorStyles.Bottom;
                                            F2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(F2);
                                            F2.Visible = true;
                                            F2.BringToFront();
                                            ctrl.Text = "F2";
                                        }
                                    }
                                    if (shipType == 4)
                                    {
                                        if (counter <= 5)
                                        {
                                            S1.Width = widthOfContrl * 3 + 24;
                                            S1.Height = heightOfContrl;
                                            S1.Location = new System.Drawing.Point(End1X, End1Y);
                                            S1.Image = Properties.Resources.subH;
                                            S1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            S1.Anchor = AnchorStyles.Bottom;
                                            S1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(S1);
                                            S1.Visible = true;
                                            S1.BringToFront();
                                            ctrl.Text = "S1";
                                        }
                                        else
                                        {
                                            S2.Width = widthOfContrl * 3 + 24;
                                            S2.Height = heightOfContrl;
                                            S2.Location = new System.Drawing.Point(End1X, End1Y);
                                            S2.Image = Properties.Resources.subH;
                                            S2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            S2.Anchor = AnchorStyles.Bottom;
                                            S2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(S2);
                                            S2.Visible = true;
                                            S2.BringToFront();
                                            ctrl.Text = "S2";
                                        }
                                    }
                                    if (shipType == 5)
                                    {
                                        if (counter <= 5)
                                        {
                                            P1.Width = widthOfContrl * 2 + 14;
                                            P1.Height = heightOfContrl;
                                            P1.Location = new System.Drawing.Point(End1X, End1Y);
                                            P1.Image = Properties.Resources.pbH;
                                            P1.SizeMode = PictureBoxSizeMode.StretchImage;
                                            P1.Anchor = AnchorStyles.Bottom;
                                            P1.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(P1);
                                            P1.Visible = true;
                                            P1.BringToFront();
                                            ctrl.Text = "P1";
                                        }
                                        else
                                        {
                                            P2.Width = widthOfContrl * 2 + 14;
                                            P2.Height = heightOfContrl;
                                            P2.Location = new System.Drawing.Point(End1X, End1Y);
                                            P2.Image = Properties.Resources.pbH;
                                            P2.SizeMode = PictureBoxSizeMode.StretchImage;
                                            P2.Anchor = AnchorStyles.Bottom;
                                            P2.Anchor = AnchorStyles.Right;
                                            panel4.Controls.Add(P2);
                                            P2.Visible = true;
                                            P2.BringToFront();
                                            ctrl.Text = "P2";
                                        }
                                    }
                                }
                            }
                        }

                        if (ctrl.BackColor == Color.Red)
                        {
                            if (shipType == 1)                                      //Set text for ship location
                            {
                                if (counter < 5)
                                {
                                    ctrl.Text = "A1";
                                }
                                else
                                {
                                    ctrl.Text = "A2";
                                }

                            }
                            else if (shipType == 2)
                            {
                                if (counter < 5)
                                {
                                    ctrl.Text = "B1";
                                }
                                else
                                {
                                    ctrl.Text = "B2";
                                }
                            }
                            else if (shipType == 3)
                            {
                                if (counter < 5)
                                {
                                    ctrl.Text = "F1";
                                }
                                else
                                {
                                    ctrl.Text = "F2";
                                }
                            }
                            else if (shipType == 4)
                            {
                                if (counter < 5)
                                {
                                    ctrl.Text = "S1";
                                }
                                else
                                {
                                    ctrl.Text = "S2";
                                }
                            }
                            else if (shipType == 5)
                            {
                                if (counter <= 5)
                                {
                                    ctrl.Text = "P1";
                                }
                                else
                                {
                                    ctrl.Text = "P2";
                                }
                            }
                        }
                        ctrl.BackColor = Color.Black;
                    }
                }
                else
                {
                    if (ctrl.Controls.Count > 0)
                    {
                        shipLayout(ctrl);
                    }
                }
            }
            start.BackColor = Color.Silver;
            playagain.BackColor = Color.Silver;
            fire.BackColor = Color.Silver;
            placeShip.BackColor = Color.Silver;
            cancelShip.BackColor = Color.Silver;
        }

        //THE FOLLOWING METHODS ARE USED TO SELECT THE NUMBER OF SHIPS

        private void num1_Click(object sender, EventArgs e)
        {
            if (phase == "start")
            {
                numShips = 1;
                num1.Checked = true;
                num2.Checked = false;
                num3.Checked = false; 
                num4.Checked = false;
                num5.Checked = false;
                num6.Checked = false;
                num7.Checked = false;
                num8.Checked = false;
                num9.Checked = false;
                num10.Checked = false;
            }
        }

        private void num2_Click(object sender, EventArgs e)
        {
            if (phase == "start")
            {
                numShips = 2;
                num1.Checked = false;
                num2.Checked = true;
                num3.Checked = false;
                num4.Checked = false;
                num5.Checked = false;
                num6.Checked = false;
                num7.Checked = false;
                num8.Checked = false;
                num9.Checked = false;
                num10.Checked = false;
            }
        }

        private void num3_Click(object sender, EventArgs e)
        {
            if (phase == "start")
            {
                numShips = 3;
                num1.Checked = false;
                num2.Checked = false;
                num3.Checked = true;
                num4.Checked = false;
                num5.Checked = false;
                num6.Checked = false;
                num7.Checked = false;
                num8.Checked = false;
                num9.Checked = false;
                num10.Checked = false;
            }
        }

        private void num4_Click(object sender, EventArgs e)
        {
            if (phase == "start")
            {
                numShips = 4;
                num1.Checked = false;
                num2.Checked = false;
                num3.Checked = false;
                num4.Checked = true;
                num5.Checked = false;
                num6.Checked = false;
                num7.Checked = false;
                num8.Checked = false;
                num9.Checked = false;
                num10.Checked = false;
            }
        }

        private void num5_Click(object sender, EventArgs e)
        {
            if (phase == "start")
            {
                numShips = 5;
                num1.Checked = false;
                num2.Checked = false;
                num3.Checked = false;
                num4.Checked = false;
                num5.Checked = true;
                num6.Checked = false;
                num7.Checked = false;
                num8.Checked = false;
                num9.Checked = false;
                num10.Checked = false;
            }
        }

        private void num6_Click(object sender, EventArgs e)
        {
            if (phase == "start")
            {
                numShips = 6;
                num1.Checked = false;
                num2.Checked = false;
                num3.Checked = false;
                num4.Checked = false;
                num5.Checked = false;
                num6.Checked = true;
                num7.Checked = false;
                num8.Checked = false;
                num9.Checked = false;
                num10.Checked = false;
            }
        }

        private void num7_Click(object sender, EventArgs e)
        {
            if (phase == "start")
            {
                numShips = 7;
                num1.Checked = false;
                num2.Checked = false;
                num3.Checked = false;
                num4.Checked = false;
                num5.Checked = false;
                num6.Checked = false;
                num7.Checked = true;
                num8.Checked = false;
                num9.Checked = false;
                num10.Checked = false;
            }
        }

        private void num8_Click(object sender, EventArgs e)
        {
            if (phase == "start")
            {
                numShips = 8;
                num1.Checked = false;
                num2.Checked = false;
                num3.Checked = false;
                num4.Checked = false;
                num5.Checked = false;
                num6.Checked = false;
                num7.Checked = false;
                num8.Checked = true;
                num9.Checked = false;
                num10.Checked = false;
            }
        }

        private void num9_Click(object sender, EventArgs e)
        {
            if (phase == "start")
            {
                numShips = 9;
                num1.Checked = false;
                num2.Checked = false;
                num3.Checked = false;
                num4.Checked = false;
                num5.Checked = false;
                num6.Checked = false;
                num7.Checked = false;
                num8.Checked = false;
                num9.Checked = true;
                num10.Checked = false;
            }
        }

        private void num10_Click(object sender, EventArgs e)
        {
            if (phase == "start")
            {
                numShips = 10;
                num1.Checked = false;
                num2.Checked = false;
                num3.Checked = false;
                num4.Checked = false;
                num5.Checked = false;
                num6.Checked = false;
                num7.Checked = false;
                num8.Checked = false;
                num9.Checked = false;
                num10.Checked = true;
            }
        }

        //Loads the ship explosion video into an embedded player
        private void loadHitVideo()
        {
            byte[] b = Properties.Resources.shipExplode;
            FileInfo fileInfo = new FileInfo("test1.wmv");
            FileStream fis = fileInfo.OpenWrite();
            fis.Write(b, 0, b.Length);
            fis.Close();
            axWindowsMediaPlayer1.URL = fileInfo.Name;
            axWindowsMediaPlayer1.Ctlcontrols.stop();
        }

        //loads the ship sinking video into an embedded player
        private void loadSinkVideo()
        {
            byte[] b = Properties.Resources.sinking;
            FileInfo fileInfo = new FileInfo("test2.wmv");
            FileStream fist = fileInfo.OpenWrite();
            fist.Write(b, 0, b.Length);
            fist.Close();
            axWindowsMediaPlayer3.URL = fileInfo.Name;
            axWindowsMediaPlayer3.Ctlcontrols.stop();
        }

        //STARTS the game, begins the ship placement phase
        private void start_Click(object sender, EventArgs e)
        {
           // axWindowsMediaPlayer1.URL =
           // @"http://go.microsoft.com/fwlink/?LinkId=95772";

            playerState = new String[8,8];
            phase = "ship";
            shipInstruct.Visible = true;
            welcome.Visible = false;
            shipDescript.Visible = true;
            shipPic.Visible = true;
            shipMsg.Visible = true;
            shipPic.BringToFront();
            shipMsg.BringToFront();
            start.Visible = false;
            label1.Visible = true;
            label2.Visible = true;
            label3.Visible = true;
            youShips.Visible = true;
            compShips.Visible = true;
            youShips.Text = numShips.ToString();
            compShips.Text = numShips.ToString();
            message.Text = "Game Setup: \r\n\r\n Place your ships using the ship placement grid. \r\n\r\n A new game will begin once all ships are placed.";
        }

        //New Game - initializes all phases and values to their defaults
        //to allow a new game to be started
        private void newGameToolStripMenuItem_Click(object sender, EventArgs e)
        {
            phase = "start";
            placementStage = 1;
            playagain.Visible = false;
            shipType = 1;   //1 = aircraft carrier, 2 = battleship, 3 = frigate, 4 = submarine, 5 = patrol boat
            counter = 1;
            indexEnd1 = 0;
            indexEnd2 = 0;
            cancelShip.ForeColor = Color.Gray;
            placeShip.ForeColor = Color.Gray;
            fire.ForeColor = Color.Gray;
            fire.Visible = true;
            cancelShip.Visible = true;
            placeShip.Visible = true;
            shipType = 1;
            shipInstruct.Visible = false;
            welcome.Visible = true;
            shipDescript.BringToFront();
            welcome.BringToFront();
            shipDescript.Visible = false;
            start.Visible = true;
            label1.Visible = false;
            label2.Visible = false;
            label3.Visible = false;
            youShips.Visible = false;
            compShips.Visible = false;
            message.Text = "New Game:  \r\n\r\n  To begin a new game, please click start.";
            SetButtonBackColor(this, Color.Aqua);
            start.BackColor = Color.Silver;
            playagain.BackColor = Color.Silver;
            fire.BackColor = Color.Silver;
            placeShip.BackColor = Color.Silver;
            cancelShip.BackColor = Color.Silver;
            shipPic.Image = Properties.Resources.ac;
            shipMsg.Text = "Current Ship: AIRCRAFT CARRIER \r\nUnits: 5 \r\n\r\nDescription: The heart of the fleet.  The Aircraft Carrier's size makes it a tough to sink, but a big target.";
            welcome.Image = Properties.Resources.introship;
            A1.Visible = false;
            B1.Visible = false;
            F1.Visible = false;
            S1.Visible = false;
            P1.Visible = false;
            A2.Visible = false;
            B2.Visible = false;
            F2.Visible = false;
            S2.Visible = false;
            P2.Visible = false;

        }

        //sets button control text
        private void SetButtonBackColor(Control Page, Color clr)
        {
            foreach (Control ctrl in Page.Controls)
            {
                if (ctrl is Button)
                {
                    ((Button)(ctrl)).BackColor = clr;
                    if (ctrl.TabIndex >= 65 && ctrl.TabIndex <= 128)
                    {
                        ctrl.Text = "";
                    }
                }
                else
                {
                    if (ctrl.Controls.Count > 0)
                    {
                        SetButtonBackColor(ctrl, clr);
                    }
                }
            }
        }

        //places and confirms a ship location during the placement phase
        //if the final ship has been placed, it creates an instance of
        //the game class
        private void placeShip_Click(object sender, EventArgs e)
        {
            if (placementStage == 3)
            {
                shipLayout(this);
                counter++;
                if (counter <= numShips)
                {
                    shipType++;
                    if (shipType > 5)
                    {
                        shipType = 1;
                    }
                    if (shipType == 1)                          //display ship info
                    {
                        shipPic.Image = Properties.Resources.ac;
                        shipMsg.Text = "Current Ship: AIRCRAFT CARRIER \r\nUnits: 5 \r\n\r\nDescription: The heart of the fleet.  The Aircraft Carrier's size makes it a tough to sink, but a big target.";
                    }
                    else if (shipType == 2)
                    {
                        shipPic.Image = Properties.Resources.bs;
                        shipMsg.Text = "Current Ship: BATTLESHIP \r\nUnits: 4 \r\n\r\nDescription: A must for any self-respecting naval power.  The Battleship commands respect with its armor, and assortment of guns. Smaller than the carrier, it is more agile.";
                    }
                    else if (shipType == 3)
                    {
                        shipPic.Image = Properties.Resources.fg;
                        shipMsg.Text = "Current Ship: FRIGATE \r\nUnits: 3 \r\n\r\nDescription: The workhorse.  The frigate is your standard vessel.  Big enough to hold its own in a fight, it can use its smaller size to hide from the enemy.";
                    }
                    else if (shipType == 4)
                    {
                        shipPic.Image = Properties.Resources.sm;
                        shipMsg.Text = "Current Ship: SUBMARINE \r\nUnits: 3 \r\n\r\nDescription: The hunter.  Hiding beneath the waves, the submarine is able to sneak behind enemy lines.  Spotting a submarine is tough, and sinking it can be just as much of a challenge.";
                    }
                    else if (shipType == 5)
                    {
                        shipPic.Image = Properties.Resources.pb;
                        shipMsg.Text = "Current Ship: PATROL BOAT \r\nUnits: 2 \r\n\r\nDescription: The perfect scout.  The patrol boat's size allow it to remain undetected for long periods of time, however once engaged in combat this lightly armed ship will not last long.";
                    }
                    placementStage = 1;
                    placeShip.ForeColor = Color.Gray;
                    cancelShip.ForeColor = Color.Gray;
                }
                else
                {
                 //   shipDescript.Visible = false;
                    shipInstruct.Visible = false;
                    placeShip.Visible = false;
                    cancelShip.Visible = false;
                    createPlayerState(this);
                    panel5.Visible = true;
                    panel5.BringToFront();
                    axWindowsMediaPlayer1.BringToFront();
                    game = new Game(playerState, numShips, difficulty);
                    compState = game.getCompState();
                    phase = "game";
                    message.Text = "You may fire when ready. \r\n\r\nAwaiting your orders, Captain!\r\n\r\nClick a position on the firing grid, and press FIRE!";
                }
            }
        }
        
        //creates a player state based on the status of the buttons
        //in the ship placement grid
        private void createPlayerState(Control Page)
        {
            int x = 0;
            int y = 0;

            foreach (Control ctrl in Page.Controls)
            {
                if (ctrl is Button)
                {
                    if (((Button)(ctrl)).TabIndex >= 65 && ((Button)(ctrl)).TabIndex <= 128)
                    {
                        x = Convert.ToInt16(ctrl.Name.Substring(1, 1));
                        y = Convert.ToInt16(ctrl.Name.Substring(2, 1));
                        if (ctrl.Text == "")
                        {
                            playerState[x, y] = "XX";
                        }
                        else
                        {
                            playerState[x, y] = ctrl.Text;
                        }
                    }
                }
                else
                {
                    if (ctrl.Controls.Count > 0)
                    {
                        createPlayerState(ctrl);
                    }
                }
            }
        }

        //THE FOLLOWING METHODS PERFORM THE SAME ACTION BUT WITH DIFFERENT VALUES
        //THEY RESPOND TO BUTTON CLICKS, FROM BUTTONS IN THE SHIP GRID.

        private void s00_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s00);
        }

        private void s01_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s01);
        }

        private void s02_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s02);
        }

        private void s03_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s03);
        }

        private void s04_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s04);
        }

        private void s05_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s05);
        }

        private void s06_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s06);
        }

        private void s07_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s07);
        }

        private void s10_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s10);
        }

        private void s11_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s11);
        }

        private void s12_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s12);
        }

        private void s13_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s13);
        }

        private void s14_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s14);
        }

        private void s15_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s15);
        }

        private void s16_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s16);
        }

        private void s17_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s17);
        }

        private void s20_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s20);
        }

        private void s21_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s21);
        }

        private void s22_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s22);
        }

        private void s23_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s23);
        }

        private void s24_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s24);
        }

        private void s25_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s25);
        }

        private void s26_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s26);
        }

        private void s27_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s27);
        }

        private void s30_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s30);
        }

        private void s31_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s31);
        }

        private void s32_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s32);
        }

        private void s33_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s33);
        }

        private void s34_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s34);
        }

        private void s35_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s35);
        }

        private void s36_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s36);
        }

        private void s37_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s37);
        }

        private void s40_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s40);
        }

        private void s41_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s41);
        }

        private void s42_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s42);
        }

        private void s43_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s43);
        }

        private void s44_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s44);
        }

        private void s45_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s45);
        }

        private void s46_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s46);
        }

        private void s47_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s47);
        }

        private void s50_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s50);
        }

        private void s51_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s51);
        }

        private void s52_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s52);
        }

        private void s53_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s53);
        }

        private void s54_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s54);
        }

        private void s55_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s55);
        }

        private void s56_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s56);
        }

        private void s57_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s57);
        }

        private void s60_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s60);
        }

        private void s61_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s61);
        }

        private void s62_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s62);
        }

        private void s63_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s63);
        }

        private void s64_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s64);
        }

        private void s65_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s65);
        }

        private void s66_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s66);
        }

        private void s67_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s67);
        }

        private void s70_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s70);
        }

        private void s71_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s71);
        }

        private void s72_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s72);
        }

        private void s73_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s73);
        }

        private void s74_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s74);
        }

        private void s75_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s75);
        }

        private void s76_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s76);
        }

        private void s77_Click(object sender, EventArgs e)
        {
            shipPlacementProtcol(s77);
        }

        //THE FOLLOWING METHODS PROVIDE THE SAME ACTION WITH DIFFERENT VALUES
        //THEY RESPOND TO BUTTONS IN THE FIRING GRID

        //Firing Grid
        private void f00_Click(object sender, EventArgs e)
        {
            firingProtocol(f00);
        }

        private void f01_Click(object sender, EventArgs e)
        {
            firingProtocol(f01);
        }

        private void f02_Click(object sender, EventArgs e)
        {
            firingProtocol(f02);
        }

        private void f03_Click(object sender, EventArgs e)
        {
            firingProtocol(f03);
        }

        private void f04_Click(object sender, EventArgs e)
        {
            firingProtocol(f04);
        }

        private void f05_Click(object sender, EventArgs e)
        {
            firingProtocol(f05);
        }

        private void f06_Click(object sender, EventArgs e)
        {
            firingProtocol(f06);
        }

        private void f07_Click(object sender, EventArgs e)
        {
            firingProtocol(f07);
        }

        private void f10_Click(object sender, EventArgs e)
        {
            firingProtocol(f10);
        }

        private void f11_Click(object sender, EventArgs e)
        {
            firingProtocol(f11);
        }

        private void f12_Click(object sender, EventArgs e)
        {
            firingProtocol(f12);
        }

        private void f13_Click(object sender, EventArgs e)
        {
            firingProtocol(f13);
        }

        private void f14_Click(object sender, EventArgs e)
        {
            firingProtocol(f14);
        }

        private void f15_Click(object sender, EventArgs e)
        {
            firingProtocol(f15);
        }

        private void f16_Click(object sender, EventArgs e)
        {
            firingProtocol(f16);
        }

        private void f17_Click(object sender, EventArgs e)
        {
            firingProtocol(f17);
        }

        private void f20_Click(object sender, EventArgs e)
        {
            firingProtocol(f20);
        }

        private void f21_Click(object sender, EventArgs e)
        {
            firingProtocol(f21);
        }

        private void f22_Click(object sender, EventArgs e)
        {
            firingProtocol(f22);
        }

        private void f23_Click(object sender, EventArgs e)
        {
            firingProtocol(f23);
        }

        private void f24_Click(object sender, EventArgs e)
        {
            firingProtocol(f24);
        }

        private void f25_Click(object sender, EventArgs e)
        {
            firingProtocol(f25);
        }

        private void f26_Click(object sender, EventArgs e)
        {
            firingProtocol(f26);
        }

        private void f27_Click(object sender, EventArgs e)
        {
            firingProtocol(f27);
        }

        private void f30_Click(object sender, EventArgs e)
        {
            firingProtocol(f30);
        }

        private void f31_Click(object sender, EventArgs e)
        {
            firingProtocol(f31);
        }

        private void f32_Click(object sender, EventArgs e)
        {
            firingProtocol(f32);
        }

        private void f33_Click(object sender, EventArgs e)
        {
            firingProtocol(f33);
        }

        private void f34_Click(object sender, EventArgs e)
        {
            firingProtocol(f34);
        }

        private void f35_Click(object sender, EventArgs e)
        {
            firingProtocol(f35);
        }

        private void f36_Click(object sender, EventArgs e)
        {
            firingProtocol(f36);
        }

        private void f37_Click(object sender, EventArgs e)
        {
            firingProtocol(f37);
        }

        private void f40_Click(object sender, EventArgs e)
        {
            firingProtocol(f40);
        }

        private void f41_Click(object sender, EventArgs e)
        {
            firingProtocol(f41);
        }

        private void f42_Click(object sender, EventArgs e)
        {
            firingProtocol(f42);
        }

        private void f43_Click(object sender, EventArgs e)
        {
            firingProtocol(f43);
        }

        private void f44_Click(object sender, EventArgs e)
        {
            firingProtocol(f44);
        }

        private void f45_Click(object sender, EventArgs e)
        {
            firingProtocol(f45);
        }

        private void f46_Click(object sender, EventArgs e)
        {
            firingProtocol(f46);
        }

        private void f47_Click(object sender, EventArgs e)
        {
            firingProtocol(f47);
        }

        private void f50_Click(object sender, EventArgs e)
        {
            firingProtocol(f50);
        }

        private void f51_Click(object sender, EventArgs e)
        {
            firingProtocol(f51);
        }

        private void f52_Click(object sender, EventArgs e)
        {
            firingProtocol(f52);
        }

        private void f53_Click(object sender, EventArgs e)
        {
            firingProtocol(f53);
        }

        private void f54_Click(object sender, EventArgs e)
        {
            firingProtocol(f54);
        }

        private void f55_Click(object sender, EventArgs e)
        {
            firingProtocol(f55);
        }

        private void f56_Click(object sender, EventArgs e)
        {
            firingProtocol(f56);
        }

        private void f57_Click(object sender, EventArgs e)
        {
            firingProtocol(f57);
        }

        private void f60_Click(object sender, EventArgs e)
        {
            firingProtocol(f60);
        }

        private void f61_Click(object sender, EventArgs e)
        {
            firingProtocol(f61);
        }

        private void f62_Click(object sender, EventArgs e)
        {
            firingProtocol(f62);
        }

        private void f63_Click(object sender, EventArgs e)
        {
            firingProtocol(f63);
        }

        private void f64_Click(object sender, EventArgs e)
        {
            firingProtocol(f64);
        }

        private void f65_Click(object sender, EventArgs e)
        {
            firingProtocol(f65);
        }

        private void f66_Click(object sender, EventArgs e)
        {
            firingProtocol(f66);
        }

        private void f67_Click(object sender, EventArgs e)
        {
            firingProtocol(f67);
        }

        private void f70_Click(object sender, EventArgs e)
        {
            firingProtocol(f70);
        }

        private void f71_Click(object sender, EventArgs e)
        {
            firingProtocol(f71);
        }

        private void f72_Click(object sender, EventArgs e)
        {
            firingProtocol(f72);
        }

        private void f73_Click(object sender, EventArgs e)
        {
            firingProtocol(f73);
        }

        private void f74_Click(object sender, EventArgs e)
        {
            firingProtocol(f74);
        }

        private void f75_Click(object sender, EventArgs e)
        {
            firingProtocol(f75);
        }

        private void f76_Click(object sender, EventArgs e)
        {
            firingProtocol(f76);
        }

        private void f77_Click(object sender, EventArgs e)
        {
            firingProtocol(f77);
        }

        //Actions to take when a user selects a potential firing
        //location, by clicking on a button in the firing grid
        //Highlights selected button gold, activates fire button
        private void firingProtocol(Button b)
        {
            if (phase == "game")
            {
                cancelFireChoice(this);
                fire.ForeColor = Color.Gray;
                if (b.BackColor == Color.Aqua)
                {
                    firingRow = Convert.ToInt16(b.Name.Substring(1, 1));
                    firingColumn = Convert.ToInt16(b.Name.Substring(2, 1));
                    firingIndex = b.TabIndex;
                    b.BackColor = Color.Gold;
                    buttonValid = true;
                    fire.ForeColor = Color.Black;
                }
            }
        }

        //deactivates fire button, and removes highlight of previous
        //firing choice
        private void cancelFireChoice(Control Page)
        {
            foreach (Control ctrl in Page.Controls)
            {
                if (ctrl is Button)
                {
                    if (((Button)(ctrl)).BackColor == Color.Gold)
                    {
                        ctrl.BackColor = Color.Aqua;
                    }
                }
                else
                {
                    if (ctrl.Controls.Count > 0)
                    {
                        cancelFireChoice(ctrl);
                    }
                }
            }
        }

        //resets the ship placement phase to stage 1
        private void cancelShip_Click(object sender, EventArgs e)
        {
            cancelLayout(this);
        }

        //recolors all red or gold buttons to aqua, in
        //order to wipeout a previous selection for
        //ship placement
        private void cancelLayout(Control Page)
        {
            foreach (Control ctrl in Page.Controls)
            {
                if (ctrl is Button)
                {
                    if (((Button)(ctrl)).BackColor != Color.Black)
                    {
                        ctrl.BackColor = Color.Aqua;
                    }
                }
                else
                {
                    if (ctrl.Controls.Count > 0)
                    {
                        cancelLayout(ctrl);
                    }
                }
            }
            start.BackColor = Color.Silver;
            fire.BackColor = Color.Silver;
            placeShip.BackColor = Color.Silver;
            cancelShip.BackColor = Color.Silver;
            cancelShip.ForeColor = Color.Gray;
            placeShip.ForeColor = Color.Gray;
            placementStage = 1;
        }

        //Fires, using the coordinates of the button selected
        //from the firing grid
        //results are calculated, and the turn is switched to
        //the computer
        private void fire_Click(object sender, EventArgs e)
        {
            axWindowsMediaPlayer1.Ctlcontrols.stop();
            axWindowsMediaPlayer1.Ctlcontrols.currentPosition = 0;
            axWindowsMediaPlayer3.Ctlcontrols.stop();
            axWindowsMediaPlayer3.Ctlcontrols.currentPosition = 0;
            axWindowsMediaPlayer3.SendToBack();
            miss.SendToBack();

            if (phase == "game" && fire.ForeColor == Color.Black)
            {
                if (game.getTurn() == "player" && game.validChoice(firingRow, firingColumn) && buttonValid == true)
                {
                    game.playerFire(firingRow, firingColumn);

                    String result = game.getFiringResult();
                    if (result == "miss")
                    {
                        updateBoardColor(this, Color.White, firingIndex);
                        game.updateState(firingRow, firingColumn, "MM");
                        message.Text = ("Status Report:\r\n\r\nThe enemy has evaded us!\r\n\r\n.");
                        buttonValid = false;
                        fire.ForeColor = Color.Gray;
                        fire.Visible = false;
                        choosing.Visible = true;
                        miss.Visible = true;
                        miss.BringToFront();
                        Refresh();
                        Thread.Sleep(3000);
                    }
                    else if (result == "hit")
                    {
                        updateBoardColor(this, Color.Red, firingIndex);
                        axWindowsMediaPlayer1.Ctlcontrols.play();

                        game.updateState(firingRow, firingColumn, "HH");
                        message.Text = ("A HIT! \r\nThe enemy's ship has been damaged!");
                        if (game.shipSunk(game.getLastShipHit()))
                        {
                            axWindowsMediaPlayer1.Ctlcontrols.stop();
                            axWindowsMediaPlayer3.Ctlcontrols.play();
                            axWindowsMediaPlayer3.BringToFront();
                            message.Text = ("Status Report: \r\n\r\nCaptain, I am pleased to inform you that we have DESTROYED the enemy's " + game.getLastShipHitLabel() + "!");
                            youShips.Text = game.getPlayerCount().ToString();
                            compShips.Text = game.getComputerCount().ToString();

                            if (game.gameOver())
                            {
                                if (game.getPlayerCount() == 0)
                                {
                                    message.Text = ("YOU HAVE LOST!\r\n\r\n You have FAILED your crew as Captain, and your once mighty fleet now lies at the bottom of the ocean.");
                                    phase = "Game Over";
                                }
                                else
                                {
                                    message.Text = ("YOU ARE VICTORIOUS!\r\n\r\n The enemy never should have underestimated your skills...\r\n\r\nTheir fleet was obliterated for their insolence.\r\n\r\n");
                                }
                                phase = "game over";
                                welcome.Image = Properties.Resources.gameover;
                                welcome.Visible = true;
                                playagain.BackColor = Color.Silver;
                                playagain.Visible = true;
                                fire.Visible = false;
                            }
                        }
                        buttonValid = false;
                       // fire.ForeColor = Color.Gray;
                      //  fire.Visible = false;
                       // choosing.Visible = true;
                    }
                    else
                    {
                        //do nothing
                    }
                    computersTurn();
                }
            }                   
        }

        //Computer makes their move, and the turn is switched to
        //the player
        public void computersTurn()
        {
            if (!game.gameOver())
            {
                game.setTurn("computer");
                game.makeComputerMove();
                Refresh();
                updateComputerBoard(this, game.getComputerResult(), game.getComputerMove());

                if (game.getComputerResult() == Color.Red)
                {
                    message.Text = ("Status Report:  Captain, we're taking fire! Our " + game.getLastShipHitLabel() + " has been HIT!");
                    if (game.shipSunk(game.getLastShipHit()))
                    {
                        message.Text = ("Status Report: \r\n\r\nCaptain, I have horrible news. \r\n\r\nThe enemy has sunk our " + game.getLastShipHitLabel() + "! May the poor souls who were aboard that vessel find peace.");
                        youShips.Text = game.getPlayerCount().ToString();
                        compShips.Text = game.getComputerCount().ToString();

                        if (game.gameOver())
                        {
                            if (game.getPlayerCount() == 0)
                            {
                                message.Text = ("YOU HAVE LOST!\r\n\r\n You have FAILED your crew as Captain, and your once mighty fleet now lies at the bottom of the ocean.");
                                phase = "Game Over";
                            }
                            else
                            {
                                message.Text = ("YOU ARE VICTORIOUS!\r\n\r\n The enemy never should have underestimated your skills...\r\n\r\nTheir fleet was obliterated for their insolence.\r\n\r\n");
                            }
                            phase = "game over";
                            welcome.Image = Properties.Resources.gameover;
                            welcome.Visible = true;
                            playagain.BackColor = Color.Silver;
                            playagain.Visible = true;
                            fire.Visible = false;
                        }
                    }
                }
                game.setTurn("player");
                fire.Visible = true;
                choosing.Visible = false;
                miss.Visible = false;
            }                       
        }

        //updates the game board
        private void updateComputerBoard(Control Page, Color c, String xy)
        {
            foreach (Control ctrl in Page.Controls)
            {
                if (ctrl is Button)
                {
                    if (((Button)(ctrl)).Name == xy)
                    {
                        ctrl.BackColor = c;
                        ctrl.Text = "";
                        ctrl.BringToFront();
                    }
                }
                else
                {
                    if (ctrl.Controls.Count > 0)
                    {
                        updateComputerBoard(ctrl, c, xy);
                    }
                }
            }
        }

        //updates the game board
        private void updateBoardColor(Control Page, Color c, int index)
        {
            foreach (Control ctrl in Page.Controls)
            {
                if (ctrl is Button)
                {
                    if (((Button)(ctrl)).TabIndex == index)
                    {
                        ctrl.BackColor = c;
                    }
                }
                else
                {
                    if (ctrl.Controls.Count > 0)
                    {
                        updateBoardColor(ctrl, c, index);
                    }
                }
            }
        }

        //allows the user to play again, when clicked
        //it initializes values similar to new game 
        private void playagain_Click(object sender, EventArgs e)
        {
            playagain.Visible = false;
            phase = "start";
            placementStage = 1;
            cancelShip.ForeColor = Color.Gray;
            placeShip.ForeColor = Color.Gray;
            fire.ForeColor = Color.Gray;
            fire.Visible = true;
            cancelShip.Visible = true;
            placeShip.Visible = true;
            shipType = 1;
            shipInstruct.Visible = false;
            shipDescript.BringToFront();
            welcome.BringToFront();
            welcome.Visible = true;
            shipDescript.Visible = false;
            start.Visible = true;
            label1.Visible = false;
            label2.Visible = false;
            label3.Visible = false;
            youShips.Visible = false;
            compShips.Visible = false;
            message.Text = "New Game:  \r\n\r\n  To begin a new game, please click start.";
            SetButtonBackColor(this, Color.Aqua);
            start.BackColor = Color.Silver;
            playagain.BackColor = Color.Silver;
            fire.BackColor = Color.Silver;
            placeShip.BackColor = Color.Silver;
            cancelShip.BackColor = Color.Silver;
            shipPic.Image = Properties.Resources.ac;
            shipMsg.Text = "Current Ship: AIRCRAFT CARRIER \r\nUnits: 5 \r\n\r\nDescription: The heart of the fleet.  The Aircraft Carrier's size makes it a tough to sink, but a big target.";
            counter = 1;
            welcome.Image = Properties.Resources.introship;
            A1.Visible = false;
            B1.Visible = false;
            F1.Visible = false;
            S1.Visible = false;
            P1.Visible = false;
            A2.Visible = false;
            B2.Visible = false;
            F2.Visible = false;
            S2.Visible = false;
            P2.Visible = false;
        }

        //loads a game from a file
        private void loadGameToolStripMenuItem_Click(object sender, EventArgs e)
        {
            openFileDialog1.InitialDirectory = Application.StartupPath;

            openFileDialog1.Filter = "Text Files (*.txt)|*.txt|All Files (*.*)|*.*";
            openFileDialog1.Title = "Load Document";
            openFileDialog1.DefaultExt = "txt";
            
     

            if (openFileDialog1.ShowDialog() != DialogResult.Cancel)
            {
                string fileName = openFileDialog1.FileName;

                    string documentIn;
                    using (StreamReader sr = new StreamReader(fileName, Encoding.ASCII, true))
                        documentIn = sr.ReadToEnd();
                    MessageBox.Show(fileName + " was opened successfully!");

                    int pShip = Convert.ToInt16(documentIn.Substring(0,1));
                    int cShip = Convert.ToInt16(documentIn.Substring(2, 1));

                    for (int i = 0; i < documentIn.Length; i++)
                    {
                        Console.WriteLine("I = "+ i + "    " + documentIn.Substring(i, 1));
                    }
                    
                    

                    if (documentIn.Substring(5, 1) == "e")
                    {
                        difficulty = "easy";
                        easy.Checked = true;
                        normal.Checked = false;
                        hard.Checked = false;
                        impossible.Checked = false;
                    }
                    else if(documentIn.Substring(5,1) == "n")
                    {
                        difficulty = "normal";
                        easy.Checked = false;
                        normal.Checked = true;
                        hard.Checked = false;
                        impossible.Checked = false;
                    }
                    else if (documentIn.Substring(5, 1) == "h")
                    {
                        difficulty = "hard";
                        easy.Checked = false;
                        normal.Checked = false;
                        hard.Checked = true;
                        impossible.Checked = false;
                    }
                    else
                    {
                        difficulty = "impossible";
                        easy.Checked = false;
                        normal.Checked = false;
                        hard.Checked = false;
                        impossible.Checked = true;
                    }
                    pShip++;
                    cShip++;

                    shipDescript.Visible = false;
                    shipInstruct.Visible = false;
                    placeShip.Visible = false;
                    cancelShip.Visible = false;
                    start.Visible = false;
                    label1.Visible = true;
                    label2.Visible = true;
                    label3.Visible = true;
                    youShips.Visible = true;
                    compShips.Visible = true;
                    fire.ForeColor = Color.Black;

                    playerState = new String[8, 8];
                    compState = new String[8, 8];

                    for (int i = 0; i < documentIn.Length; i++)
                    {
                            Console.WriteLine("I = " + i + " " + documentIn.ElementAt(i));
                    }

                    int index = 11;
                    for (int i = 0; i < playerState.GetLength(0); i++)
                    {
                        for (int j = 0; j < playerState.GetLength(1); j++)
                        {
                            playerState[i,j] = documentIn.Substring(index, 2);
                            index = index + 3;
                        }
                        index = index + 3;
                    }
                    loadShipGridData(this);

                    for (int i = 0; i < compState.GetLength(0); i++)
                    {
                        for (int j = 0; j < compState.GetLength(1); j++)
                        {
                            compState[i, j] = documentIn.Substring(index, 2);
                            index = index + 3;
                        }
                        index = index + 3;
                    }
                    loadFireGridData(this);

                    game = new Game(playerState, compState, pShip, cShip, difficulty);

                    phase = "game";
                    message.Text = "You may fire when ready. \r\n\r\nAwaiting your orders, Captain!\r\n\r\nClick a position on the firing grid, and press FIRE!";
                    

                    youShips.Text = pShip.ToString();
                    compShips.Text = cShip.ToString();
            }
        }
        
        //establishes a loaded game state, by updating the game board
        private void loadShipGridData(Control Page)
        {
            foreach (Control ctrl in Page.Controls)
            {
                if (ctrl is Button)
                {
                    if (((Button)(ctrl)).Name.Substring(0, 1) == "s" && ctrl.Name != "start")
                    {
                        int x = Convert.ToInt16(ctrl.Name.Substring(1,1));
                        int y = Convert.ToInt16(ctrl.Name.Substring(2, 1));

                        if (playerState[x, y] == "XX")
                        {
                            ctrl.BackColor = Color.Aqua;
                        }
                        else if (playerState[x, y] == "MM")
                        {
                            ctrl.BackColor = Color.White;
                        }
                        else if (playerState[x, y] == "HH")
                        {
                            ctrl.BackColor = Color.Red;
                            ctrl.BringToFront();
                        }
                        else if (playerState[x,y] == "A1" || playerState[x,y] == "A2")
                        {
                            ctrl.Text = playerState[x, y];
                            ctrl.ForeColor = Color.White;
                            ctrl.BackColor = Color.DarkBlue;
                        }
                        else if (playerState[x, y] == "B1" || playerState[x, y] == "B2")
                        {
                            ctrl.Text = playerState[x, y];
                            ctrl.ForeColor = Color.White;
                            ctrl.BackColor = Color.DarkBlue;
                        }
                        else if (playerState[x, y] == "F1" || playerState[x, y] == "F2")
                        {
                            ctrl.Text = playerState[x, y];
                            ctrl.ForeColor = Color.White;
                            ctrl.BackColor = Color.DarkBlue;
                        }
                        else if (playerState[x, y] == "S1" || playerState[x, y] == "S2")
                        {
                            ctrl.Text = playerState[x, y];
                            ctrl.ForeColor = Color.White;
                            ctrl.BackColor = Color.DarkBlue;
                        }
                        else if (playerState[x, y] == "P1" || playerState[x, y] == "P2")
                        {
                            ctrl.Text = playerState[x, y];
                            ctrl.ForeColor = Color.White;
                            ctrl.BackColor = Color.DarkBlue;
                        }
                    }
                }
                else
                {
                    if (ctrl.Controls.Count > 0)
                    {
                        loadShipGridData(ctrl);
                    }
                }
            }
        }

        //establishes a loaded game state, by updating the board
        private void loadFireGridData(Control Page)
        {
            foreach (Control ctrl in Page.Controls)
            {
                if (ctrl is Button)
                {
                    if (((Button)(ctrl)).Name.Substring(0, 1) == "f" && ctrl.Name != "fire")
                    {
                        int x = Convert.ToInt16(ctrl.Name.Substring(1, 1));
                        int y = Convert.ToInt16(ctrl.Name.Substring(2, 1));

                        if (compState[x, y] == "XX")
                        {
                            ctrl.BackColor = Color.Aqua;
                        }
                        else if (compState[x, y] == "MM")
                        {
                            ctrl.BackColor = Color.White;
                        }
                        else if (compState[x, y] == "HH")
                        {
                            ctrl.BackColor = Color.Red;
                        }
                        else
                        {
                            ctrl.BackColor = Color.Aqua;
                        }
                    }
                }
                else
                {
                    if (ctrl.Controls.Count > 0)
                    {
                        loadFireGridData(ctrl);
                    }
                }
            }
        }

        //saves a game state to a file
        private void saveGameToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (phase == "game")
            {
                saveFileDialog1.InitialDirectory = Application.StartupPath;
                saveFileDialog1.Filter = "Text Files (*.txt)|*.txt|All Files (*.*)|*.*";
                saveFileDialog1.Title = "Save Game";
                saveFileDialog1.DefaultExt = "txt";
                saveFileDialog1.OverwritePrompt = true;


                if (saveFileDialog1.ShowDialog() != DialogResult.Cancel)
                {
                    String fileName = saveFileDialog1.FileName;
 
                    try
                    {
                        StreamWriter sw = new StreamWriter(fileName, false, Encoding.ASCII);

                        sw.WriteLine((Convert.ToInt16(game.getPlayerCount()) - 1) + " " + (Convert.ToInt16(game.getComputerCount()) - 1));
                        sw.WriteLine(difficulty.Substring(0,4));
                        for (int i = 0; i < playerState.GetLength(0); i++)
                        {
                            for (int j = 0; j < playerState.GetLength(1); j++)
                            {
                                sw.Write(playerState[i, j]);
                                sw.Write(" ");
                            }
                            sw.WriteLine(" ");
                        }
                        for (int i = 0; i < compState.GetLength(0); i++)
                        {
                            for (int j = 0; j < compState.GetLength(1); j++)
                            {
                                sw.Write(compState[i, j]);
                                sw.Write(" ");
                            }
                            sw.WriteLine(" ");
                        }
                        sw.Close();
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(string.Format("Could not write to file '{0},' because I received an exception with message: {1}.", fileName, ex.Message), "File Read Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        return;
                    }
                }
            }
            else
            {
                MessageBox.Show("THERE IS NOT CURRENTLY A GAME TO SAVE.");
            }
        }

        //FOLLOWING METHODS SET THE DIFFICULTY

        private void easy_Click(object sender, EventArgs e)
        {
            if (phase == "start")
            {
                difficulty = "easy";
                easy.Checked = true;
                normal.Checked = false;
                hard.Checked = false;
                impossible.Checked = false;
            }
        }

        private void normal_Click(object sender, EventArgs e)
        {
            if (phase == "start")
            {
                difficulty = "normal";
                easy.Checked = false;
                normal.Checked = true;
                hard.Checked = false;
                impossible.Checked = false;
            }
        }

        private void hard_Click(object sender, EventArgs e)
        {
            if (phase == "start")
            {
                difficulty = "hard";
                easy.Checked = false;
                normal.Checked = false;
                hard.Checked = true;
                impossible.Checked = false;
            }
        }

        private void impossible_Click(object sender, EventArgs e)
        {
            if (phase == "start")
            {
                difficulty = "impossible";
                easy.Checked = false;
                normal.Checked = false;
                hard.Checked = false;
                impossible.Checked = true;
            }
        }

        private void axWindowsMediaPlayer1_Enter(object sender, EventArgs e)
        {

        }

        //MUSIC ON
        private void onToolStripMenuItem_Click(object sender, EventArgs e)
        {
            axWindowsMediaPlayer2.Ctlcontrols.play();
            onToolStripMenuItem.Checked = true;
            offToolStripMenuItem.Checked = false;
        }

        //MUSIC OFF
        private void offToolStripMenuItem_Click(object sender, EventArgs e)
        {
            axWindowsMediaPlayer2.Ctlcontrols.stop();
            onToolStripMenuItem.Checked = false;
            offToolStripMenuItem.Checked = true;
        }
    }
}

        
