﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

//The AI class is primarily responsible for constructing
//the computer game state.  It uses algorithms which
//require the computer to systematically place a number of ships,
//which varies depending on the game settings, until a 
//complete game state is established.  Ships can not be placed
//over other ships, or off the edge of the board.
namespace Sea4
{
    class AI
    {
        int counter = 1;                                                    //the minimum number of ships
        String[,] computerShips;                                            //the computer ship state
        int compShipCount;                                                  //total number of ships
        String difficulty;                                                  //game difficulty

        int x;                                                          //location of one end of ship
        int y;

        Random random = new Random();                                   //used to generate random positions

        //constructor - used to load a game, passes in ship data from file
        public AI(String[,] shipData, String AILevel)
        {
            computerShips = shipData;
            difficulty = AILevel;
        }

        //constructor - used to create a new ship state depending on the number of ships
        public AI(int numShips, String AILevel)
        {
            compShipCount = numShips;
            createComputerGameState();
            difficulty = AILevel;
        }

        //creates the computer ship state
        private void createComputerGameState()
        {
            computerShips = new String[8, 8];
            for (int i = 0; i < computerShips.GetLength(0); i++)
            {
                for (int j = 0; j < computerShips.GetLength(1); j++)
                {
                    computerShips[i, j] = "XX";
                }
            }
            placeCompShips();
        }

        //gets the computer ship state
        public String[,] getCompShips()
        {
            return computerShips;
        }

        //places the computer ships sequentially, used by the createGameState method
        private void placeCompShips()
        {
            int units = 5;
            Boolean done = false;
            Boolean emptySpace = false;

            int x = 0;
            int y = 0;

            while (counter <= compShipCount)
            {
                if (counter == 6)
                {
                    units = 5;
                }
                while (!done)
                {
                    while (!emptySpace)
                    {
                        x = random.Next(0, 8);
                        y = random.Next(0, 8);
                        if (computerShips[x, y] == "XX")
                        {
                            emptySpace = true;
                        }
                    }

                    int direction = random.Next(0, 5);
                    int directioncount = 1;

                    while (directioncount <= 4)
                    {
                        if (direction > 4)
                        {
                            direction = 1;
                        }

                        if (direction == 1)
                        {
                            if (clearPath(x, y, 1, units))
                            {
                                markCompShips(x, y, 1, units, getLabel(counter));
                                done = true;
                            }
                        }
                        else if (direction == 2)
                        {
                            if (clearPath(x, y, 2, units))
                            {
                                markCompShips(x, y, 2, units, getLabel(counter));
                                done = true;
                            }
                        }
                        else if (direction == 3)
                        {
                            if (clearPath(x, y, 3, units))
                            {
                                markCompShips(x, y, 3, units, getLabel(counter));
                                done = true;
                            }
                        }
                        else if (direction == 4)
                        {
                            if (clearPath(x, y, 4, units))
                            {
                                markCompShips(x, y, 4, units, getLabel(counter));
                                done = true;
                            }
                        }
                        direction++;
                        directioncount++;
                    }
                    emptySpace = false;
                }
                if (counter != 3 && counter != 8)
                {
                    units--;
                }
                counter++;
                done = false;
            }
        }

        //Detects whether a direction is clear, to place a ship
        private Boolean clearPath(int x, int y, int direction, int shipUnits)
        {
            Boolean clear = true;
            if (direction == 1)                                //north
            {
                for (int i = 0; i < shipUnits; i++)
                {
                    if (x < 0)
                    {
                        clear = false;
                        break;
                    }
                    if (computerShips[x, y] != "XX")
                    {
                        clear = false;
                        break;
                    }
                    x--;
                }
            }
            else if (direction == 2)                              //south
            {
                for (int i = 0; i < shipUnits; i++)
                {
                    if (x > 7)
                    {
                        clear = false;
                        break;
                    }
                    if (computerShips[x, y] != "XX")
                    {
                        clear = false;
                        break;
                    }
                    x++;
                }
            }
            else if (direction == 3)                           //east
            {
                for (int i = 0; i < shipUnits; i++)
                {
                    if (y > 7)
                    {
                        clear = false;
                        break;
                    }
                    if (computerShips[x, y] != "XX")
                    {
                        clear = false;
                        break;
                    }
                    y++;
                }
            }
            else if (direction == 4)                         //west
            {
                for (int i = 0; i < shipUnits; i++)
                {
                    if (y < 0)
                    {
                        clear = false;
                        break;
                    }
                    if (computerShips[x, y] != "XX")
                    {
                        clear = false;
                        break;
                    }
                    y--;
                }
            }
            return clear;
        }

        //once a ship has been successfully placed, 
        //this method updates the array containing computer state
        private void markCompShips(int x, int y, int direction, int shipUnits, String label)
        {
            if (direction == 1)                                //north
            {
                for (int i = 0; i < shipUnits; i++)
                {
                    computerShips[x, y] = label;
                    x--;
                }
            }
            else if (direction == 2)                              //south
            {
                for (int i = 0; i < shipUnits; i++)
                {
                    computerShips[x, y] = label;
                    x++;
                }
            }
            else if (direction == 3)                           //east
            {
                for (int i = 0; i < shipUnits; i++)
                {
                    computerShips[x, y] = label;
                    y++;
                }
            }
            else if (direction == 4)                         //west
            {
                for (int i = 0; i < shipUnits; i++)
                {
                    computerShips[x, y] = label;
                    y--;
                }
            }
        }

        //generates the x for a location
        public void setMoveX()
        {
           x = random.Next(0, 8);
        }

        //generates the y for a location
        public void setMoveY()
        {
            y = random.Next(0, 8);
        }

        //gets the x
        public int getX()
        {
            return x;
        }

        //gets the y
        public int getY()
        {
            return y;
        }

        //gets the label for the type of ship,
        //used to mark the game state
        private String getLabel(int ship)
        {
            String label = "";
            if (ship == 1)
            {
                label = "A1";
            }
            if (ship == 2)
            {
                label = "B1";
            }
            if (ship == 3)
            {
                label = "F1";
            }
            if (ship == 4)
            {
                label = "S1";
            }
            if (ship == 5)
            {
                label = "P1";
            }
            if (ship == 6)
            {
                label = "A2";
            }
            if (ship == 7)
            {
                label = "B2";
            }
            if (ship == 8)
            {
                label = "F2";
            }
            if (ship == 9)
            {
                label = "S2";
            }
            if (ship == 10)
            {
                label = "P2";
            }
            return label;
        }
    }
}
