using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using XSIXNARuntime;
using Lidgren.Network;
using System.Net;

namespace Hook_FPS
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        #region Private Fields

        // XNA Defaults
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        SpriteFont spriteFont;
        Vector2 spriteFontPosition;
        
        // Network
        private KeyboardState Kstate;
        public NetClient client;
        public NetServer server;
        private NetConfiguration netconfig;

        // XSIRuntime Data, Players, and Map Assets
        XSISASContainer SASData = new XSISASContainer();
        List<Player> Players;
        MapAsset Map;
        
        // Background texture for the various screens
        Texture2D TitleScreenBackground;
        Texture2D[] crossHair = new Texture2D[7];
        Texture2D crossHairToDraw;
        Texture2D[] weaponState = new Texture2D[42];
        Texture2D weaponStateToDraw;
        Vector2 weaponStatePosition;
        
        // Screen State variables to indicate what is the current screen
        bool TitleScreenShow;
        bool GameScreenShow;
        
        

        #endregion

        #region Constructor(s)

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            graphics.PreferMultiSampling = true;
            //Content.RootDirectory = "Content";
            //Uncomment for Full Screen Mode
            //graphics.IsFullScreen = true;
            //graphics.PreferredBackBufferHeight = GraphicsAdapter.DefaultAdapter.CurrentDisplayMode.Height;
            //graphics.PreferredBackBufferWidth = GraphicsAdapter.DefaultAdapter.CurrentDisplayMode.Width;
            graphics.PreferredBackBufferWidth = 1024;
            graphics.PreferredBackBufferHeight = 768;
        }

        #endregion

        #region XNA Methods

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // Window initialization
            Window.Title = "Hook - A First Person Shooter";
            
            // TODO: Intialize Network Logic

            // Initialize SAS Lighting
            //XSISASPointLight light1 = new XSISASPointLight();
            //XSISASPointLight light2 = new XSISASPointLight();
            //XSISASPointLight light3 = new XSISASPointLight();
            //light1.Color = new Vector4(0.7f, 0.7f, 0.7f, 1.0f);
            //light2.Color = new Vector4(0.7f, 0.7f, 0.7f, 1.0f);
            //light3.Color = new Vector4(0.7f, 0.7f, 0.7f, 1.0f);
            //light1.Position = new Vector4(100.0f, 100.0f, 100.0f, 1.0f);
            //light2.Position = new Vector4(-100.0f, 100.0f, 100.0f, 1.0f);
            //light3.Position = new Vector4(0.0f, 0.0f, -100.0f, 1.0f);
            //light1.Range = 10000.0f;
            //light2.Range = 10000.0f;
            //light3.Range = 10000.0f;
            //SASData.PointLights.Add(light1);
            //SASData.PointLights.Add(light2);
            //SASData.PointLights.Add(light3);

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Initialize the sprite batch
            spriteBatch = new SpriteBatch(GraphicsDevice);
            spriteFont = Content.Load<SpriteFont>("Content/SpriteFonts/SpriteFont1");
            spriteFontPosition = new Vector2(10, GraphicsDevice.Viewport.Height - 60);

            
            // Load screen background
            TitleScreenBackground = Content.Load<Texture2D>("Content/Textures/spaceTexture");
            
            // Load crosshairs
            //crossHair = Content.Load<Texture2D>("Content/Textures/crosshair");
            //crossHair1 = Content.Load<Texture2D>("Content/Textures/crosshair1");
            //crossHair2 = Content.Load<Texture2D>("Content/Textures/crosshair2");
            //crossHair3 = Content.Load<Texture2D>("Content/Textures/crosshair3");
            //crossHair4 = Content.Load<Texture2D>("Content/Textures/crosshair4");
            //crossHair5 = Content.Load<Texture2D>("Content/Textures/crosshair5");
            //crossHair6 = Content.Load<Texture2D>("Content/Textures/crosshair6");
            

            for (int num = 0; num < crossHair.Length; num++)
            {
                crossHair[num] = Content.Load<Texture2D>("Content/Textures/crosshair" + num.ToString());
            }
            crossHairToDraw = Content.Load<Texture2D>("Content/Textures/crosshair1");
            
            // Load weapon states
            for (int state = 0; state < weaponState.Length; state++)
            {
                weaponState[state] = Content.Load<Texture2D>("Content/Textures/weapon" + state.ToString());
            }
            weaponStateToDraw = Content.Load<Texture2D>("Content/Textures/weapon0");
            weaponStatePosition = new Vector2(GraphicsDevice.Viewport.Width - weaponStateToDraw.Width - 10, 10);
           
            // Initialize the screen state variables
            GameScreenShow = false;
            TitleScreenShow = true;
            
            
            // Load the map model and set the boundingBoxArraySize to 0 initially.
            Map = new MapAsset("Content/Models/mp_tower", Content, 0);
            Map.Scale = 85.0f;  // Scale the map bigger to fit model.
            
            // Initialize the Map bounding boxes.
            int numBoxes = (Map.CrosswalkModel.Bones.Count - Map.CrosswalkModel.Meshes.Count - 1 ) / 2; // Each mesh has a single bone so subtract the mesh bones and the single root
            Map.boundingBoxes = new BoundingBox[numBoxes]; // Initialize the boundingBox array
            int boneNumber = 0; // Used to match the min and max bone
            
            // Loop through all the bones in the map
            // and initialize a new bounding box for each
            // wall bone found.
            foreach (ModelBone bone in Map.CrosswalkModel.Bones)
            {
                if (bone.Name.Contains("wall_max" + boneNumber))
                {
                    //Console.WriteLine(bone.Name);
                    Vector3 minVect = Matrix.Multiply(Map.CrosswalkModel.Bones["wall_min" + boneNumber].Transform, Map.Scale).Translation;
                    Vector3 maxVect = Matrix.Multiply(Map.CrosswalkModel.Bones["wall_max" + boneNumber].Transform, Map.Scale).Translation;
                    Map.boundingBoxes[boneNumber] = new BoundingBox(minVect, maxVect);
                    
                    //Console.WriteLine("wall" + boneNumber.ToString() + "min    " + minVect.ToString() + "max    " + maxVect.ToString());
                    boneNumber++;
                }
            }
            
            // Set mouse position to middle of screen
            Mouse.SetPosition(graphics.GraphicsDevice.Viewport.Width / 2, graphics.GraphicsDevice.Viewport.Height / 2);

            // Load the player models and intialize camera.
            Players = new List<Player>();
            Players.Add(new Player("Content/Models/playerBlack", "Content/Models/scene_data", Content, graphics, Mouse.GetState(), Map.boundingBoxes, Players.Count));
            
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Press escape to exit the game
            if (Keyboard.GetState().IsKeyDown(Keys.Escape))
                this.Exit();
                
            if (client != null || server != null)
            {
                UpdateNetwork();
            }
            else
	        {
                Kstate = Keyboard.GetState();
                if (Kstate.IsKeyDown(Keys.H))
	            {
                    HostClicked();
	            }
	            if  (Kstate.IsKeyDown(Keys.C))
	            {
	                ClientClicked();
	            }
	        }
                
            // Call the appropriate update method
            if (GameScreenShow)
            {
                //Mouse.SetPosition(graphics.GraphicsDevice.Viewport.Width/2, graphics.GraphicsDevice.Viewport.Height/2);
                UpdateGameScreen(gameTime);
            }
            else if (TitleScreenShow)
            {
                UpdateTitleScreen();
            }    

            base.Update(gameTime);
        }
        
        public void HostClicked()
        {
            this.Window.Title = "Hosting. . . .";
            netconfig = new NetConfiguration("Hook");
            netconfig.Port = 12321;
            netconfig.MaxConnections = 16;
            server = new NetServer(netconfig);
            server.Start();
            server.CreateBuffer();
            
        }
        
        public void ClientClicked()
        {
            this.Window.Title = "Trying to Connect. . . .";
            netconfig = new NetConfiguration("Hook");
            client = new NetClient(netconfig);
            client.Start();
            client.DiscoverLocalServers(55555);
        }
        
        public void UpdateNetwork()
        {
            if (client != null)
            {
                NetMessageType msg;
                NetBuffer buffer = client.CreateBuffer();
                IPEndPoint source;
                while (client.ReadMessage(buffer, out msg, out source))
                {
                    HandleClientMSG(buffer, msg, source);

                }
            }
            
            if (server != null)
            {
                NetMessageType msg;
                NetConnection sender;
                NetBuffer buffer = server.CreateBuffer();
                while(server.ReadMessage(buffer, out msg, out sender))
                {
                    HandleServerMSG(buffer, msg, sender);
                }
            }
        }
        
        public void HandleClientMSG(NetBuffer buffer, NetMessageType msg, IPEndPoint source)
        {
            string str;
            if (source != null)
            {
                NetConnection conn = client.GetConnection(source);
                //str = buffer.ReadString(client.GetConnection(source));
                str = "bladh";
            }
            else
            {
                str = buffer.ReadString();
            }
            this.Window.Title = str;
            Console.WriteLine("Client msg = " + msg.ToString());
            Console.WriteLine("Client buffer = " + str);
            if (source != null)
            {
                Console.WriteLine("Client source = " + source.ToString());
            }
            Console.WriteLine();

            if (msg == NetMessageType.ServerDiscovered)
            {
                client.Connect(source);
            }
            
            if (str.Equals("Connected"))
            {
                this.Window.Title = "sending a message to server";
                Console.WriteLine("Client sending message");
                client.SendMessage(client.CreateBuffer("Hello Server! I am connected"), NetChannel.ReliableInOrder1);
            }
        }
        
        public void HandleServerMSG(NetBuffer buffer, NetMessageType msg, NetConnection sender)
        {
            string str = buffer.ReadString();
            this.Window.Title = str;
            Console.WriteLine("Server msg = " + msg.ToString());
            Console.WriteLine("Server buffer = " + str);
            if (sender != null)
            {
                Console.WriteLine("Server sender = " + sender.ToString());
            }
            Console.WriteLine();
            
            if (msg.Equals(NetMessageType.Data))
            {
                this.Window.Title = "sending message to client";
                Console.WriteLine("Server sending message");
                server.SendMessage(server.CreateBuffer("Hi client, this is the server"), sender, NetChannel.ReliableInOrder1);
            }
        }
        
        private void UpdateGameScreen(GameTime gameTime)
        {
            if (Keyboard.GetState().IsKeyDown(Keys.F2))
            {
                TitleScreenShow = true;
                GameScreenShow = false;
                return;
            }
            
            if (Keyboard.GetState().IsKeyDown(Keys.D1))
            {
                crossHairToDraw = crossHair[0];
            }

            if (Keyboard.GetState().IsKeyDown(Keys.D2))
            {
                crossHairToDraw = crossHair[1];
            }

            if (Keyboard.GetState().IsKeyDown(Keys.D3))
            {
                crossHairToDraw = crossHair[2];
            }

            if (Keyboard.GetState().IsKeyDown(Keys.D4))
            {
                crossHairToDraw = crossHair[3];
            }

            if (Keyboard.GetState().IsKeyDown(Keys.D5))
            {
                crossHairToDraw = crossHair[4];
            }

            if (Keyboard.GetState().IsKeyDown(Keys.D6))
            {
                crossHairToDraw = crossHair[5];
            }

            if (Keyboard.GetState().IsKeyDown(Keys.D7))
            {
                crossHairToDraw = crossHair[6];
            }
            
            foreach (Player player in Players)
            {
                player.Update(gameTime, Keyboard.GetState(), Mouse.GetState());
                Mouse.SetPosition(graphics.GraphicsDevice.Viewport.Width / 2, graphics.GraphicsDevice.Viewport.Height / 2);
            }
        }

        private void UpdateTitleScreen()
        {
            if (Keyboard.GetState().IsKeyDown(Keys.F1))
            {
                TitleScreenShow = false;
                GameScreenShow = true;
                this.GraphicsDevice.Reset();
                return;
            }
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            // Initialize the graphics device set Render options
            GraphicsDevice.Clear(Color.DarkGray);
            
            
            //Call the appropriate draw method
            if (GameScreenShow)
            {
                DrawGameScreen();
            }
            else if (TitleScreenShow)
            {
                DrawTitleScreen();
            }
  
            base.Draw(gameTime);
        }

        #endregion

        #region Private Draw Methods
        
        private void DrawTitleScreen()
        {
            //Draw the title screen
            spriteBatch.Begin();
            spriteBatch.Draw(TitleScreenBackground, graphics.GraphicsDevice.Viewport.TitleSafeArea, Color.White);
            spriteBatch.End();
        }
        
        private void DrawGameScreen()
        {   
            // Reset the render state to allow 2d and 3d textures
            GraphicsDevice.RenderState.AlphaBlendEnable = false;
            GraphicsDevice.RenderState.DepthBufferEnable = true;
            GraphicsDevice.RenderState.DepthBufferWriteEnable = true;
            GraphicsDevice.RenderState.CullMode = CullMode.CullCounterClockwiseFace;
            GraphicsDevice.SamplerStates[0].AddressU = TextureAddressMode.Wrap;
            GraphicsDevice.SamplerStates[0].AddressV = TextureAddressMode.Wrap;
            
            // Initialize the SASData camera parameters
            SASData.Camera.NearFarClipping.X = 1.0f;
            SASData.Camera.NearFarClipping.Y = 10000.0f;
            SASData.Camera.Position.X = Players[0].Camera.Position.X;
            SASData.Camera.Position.Y = Players[0].Camera.Position.Y;
            SASData.Camera.Position.Z = Players[0].Camera.Position.Z;
            SASData.Projection = Matrix.CreatePerspectiveFieldOfView(
                MathHelper.PiOver4,
                graphics.GraphicsDevice.Viewport.AspectRatio,
                SASData.Camera.NearFarClipping.X,
                SASData.Camera.NearFarClipping.Y);
            SASData.View = Matrix.CreateLookAt(
                Players[0].Camera.Position,
                Players[0].Camera.Forward,
                Players[0].Camera.Up);
            SASData.ComputeViewAndProjection();

            // Draw the map
            DrawMap(Map);

            // Draw the map bounding boxes for debugging purposes.
            //for (int i = 0; i < Map.boundingBoxes.Length; i++)
            //{
            //    BoundingBoxRenderer.Render(Map.boundingBoxes[i], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.White);
            //}


            // Draw the players, Don't draw your own model
            foreach (Player player in Players)
            {
                if (player.IsAlive)
                {
                    DrawModel(player.Model);
                    
                }

                for (int i = 0; i < player.Bullets.Length; i++)
                {
                    // Draw the players bullets if they are alive
                    if (player.Bullets[i].IsAlive)
                    {
                        DrawBullet(player.Bullets[i]);
                        //BoundingSphereRenderer.Render(player.Bullets[i].BoundSphere, graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.HotPink);
                        //BoundingSphereRenderer.Render(player.Bullets[i].BoundSphere1, graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.HotPink);
                        //BoundingSphereRenderer.Render(player.Bullets[i].BoundSphere2, graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.HotPink);
                        //BoundingSphereRenderer.Render(player.Bullets[i].BoundSphere3, graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.HotPink);
                        //BoundingSphereRenderer.Render(player.Bullets[i].BoundSphere4, graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.HotPink);
                        //BoundingSphereRenderer.Render(player.Bullets[i].BoundSphere5, graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.HotPink);
                        //BoundingSphereRenderer.Render(player.Bullets[i].BoundSphere6, graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.HotPink);
                    }
                }

                // Render the players 9 bounding spheres
                //BoundingSphereRenderer.Render(player.BoundSpheres[0], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.Gray);
                //BoundingSphereRenderer.Render(player.BoundSpheres[1], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.Gray);
                //BoundingSphereRenderer.Render(player.BoundSpheres[2], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.Gray);
                //BoundingSphereRenderer.Render(player.BoundSpheres[3], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.Gray);
                //BoundingSphereRenderer.Render(player.BoundSpheres[4], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.GreenYellow);
                //BoundingSphereRenderer.Render(player.BoundSpheres[5], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.Red);
                //BoundingSphereRenderer.Render(player.BoundSpheres[6], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.Yellow);
                //BoundingSphereRenderer.Render(player.BoundSpheres[7], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.Blue);
                //BoundingSphereRenderer.Render(player.BoundSpheres[8], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.White);
                //BoundingSphereRenderer.Render(player.BoundSpheres[9], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.DarkBlue);
                //BoundingSphereRenderer.Render(player.BoundSpheres[10], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.DarkBlue);
                //BoundingSphereRenderer.Render(player.BoundSpheres[11], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.DarkBlue);
                //BoundingSphereRenderer.Render(player.BoundSpheres[12], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.DarkBlue);
                //BoundingSphereRenderer.Render(player.BoundSpheres[13], graphics.GraphicsDevice, SASData.View, SASData.Projection, Color.HotPink);
            }

            spriteBatch.Begin();
            
            // Draw crosshair
            spriteBatch.Draw(crossHairToDraw, new Rectangle(
                (GraphicsDevice.Viewport.Width - crossHairToDraw.Width) / 2,
                (GraphicsDevice.Viewport.Height - crossHairToDraw.Height) / 2,
                crossHairToDraw.Width, crossHairToDraw.Height), new Color(255, 255, 255, 150));
            
            // Draw player health
            string playerHealth = "HP " + Players[0].Health.ToString() + "%";
            Color textColor = new Color((byte)(255 - Players[0].Health/10 * 22), (byte)(Players[0].Health/10 * 22), 10, 255);
            spriteBatch.DrawString(spriteFont, playerHealth, spriteFontPosition, textColor);
            
            // Draw weapon state
            weaponStateToDraw = weaponState[Players[0].WeaponState];
            spriteBatch.Draw(weaponStateToDraw, weaponStatePosition, new Color(255, 255, 255, 200));
            
            spriteBatch.End();

        }
        
        /// <summary>
        /// This is called to draw a model and load it's animation data. (i.e. Player)
        /// </summary>
        /// <param name="m">The model to be drawn.</param>
        private void DrawModel(ModelAsset modelAsset)
        {           
            // Get animation and bone data
            XSIAnimationData animationData = modelAsset.CrosswalkModel.Tag as XSIAnimationData;
            Matrix[] transforms = new Matrix[modelAsset.CrosswalkModel.Bones.Count];
            modelAsset.CrosswalkModel.CopyAbsoluteBoneTransformsTo(transforms);
            animationData.ComputeBoneTransforms(transforms);
            Matrix[] bones = animationData.BoneTransforms;

            foreach (ModelMesh mesh in modelAsset.CrosswalkModel.Meshes)
            {
                // Compute the model matrix for lighting
                SASData.Model = transforms[mesh.ParentBone.Index];
                SASData.ComputeModel();
                
                foreach (Effect effect in mesh.Effects)
                {
                    // The Map uses Basic Effects
                    if (effect.GetType() == typeof(BasicEffect))
                    {
                        // Set basic effect parameters
                        BasicEffect basiceffect = (BasicEffect)effect;
                        basiceffect.EnableDefaultLighting();
                        basiceffect.PreferPerPixelLighting = true;
                        basiceffect.View = SASData.View;
                        basiceffect.Projection = SASData.Projection;
                        basiceffect.World = SASData.Model * Matrix.CreateScale(modelAsset.Scale);
                    }
                    else
                    {
                        // Set the techniques for shader
                        bool isSkinned = (bones.GetLength(0) > 0);

                        if (isSkinned && (effect.Techniques["Skinned"] != null))
                        {
                            effect.CurrentTechnique = effect.Techniques["Skinned"];
                            
                        }
                        else
                        {
                            if (effect.Techniques["Static"] != null)
                            {
                                effect.CurrentTechnique = effect.Techniques["Static"];
                            }
                            else
                            {
                                effect.CurrentTechnique = effect.Techniques[0];
                            }
                        }

                        // Set the bones parameter of the shader
                        if ((effect.Parameters["Bones"] != null) && isSkinned)
                                effect.Parameters["Bones"].SetValue(bones);

                        // Set all other parameters
                        foreach (EffectParameter Parameter in effect.Parameters)
                        {
                            SASData.SetEffectParameterValue(Parameter);
                        }
                    }
                }

                // Draw the mesh
                //if (!mesh.Name.Contains("box"))
                    mesh.Draw();
            }
        }

        /// <summary>
        /// Draws a Crosswalk Bullet Model
        /// </summary>
        /// <param name="bullet"></param>
        private void DrawBullet(BulletObject bullet) 
        {
            XSIAnimationData animationData = bullet.Model.Tag as XSIAnimationData;
            Matrix[] transforms = new Matrix[bullet.Model.Bones.Count];
            bullet.Model.CopyAbsoluteBoneTransformsTo(transforms);
            animationData.ComputeBoneTransforms(transforms);
            Matrix[] bones = animationData.BoneTransforms;

            foreach (ModelMesh mesh in bullet.Model.Meshes)
            {
                // Compute the model matrix for lighting
                SASData.Model = transforms[mesh.ParentBone.Index];
                SASData.ComputeModel();

                foreach (BasicEffect effect in mesh.Effects)
                {
                    effect.EnableDefaultLighting();
                    effect.PreferPerPixelLighting = true;
                    effect.View = SASData.View;
                    effect.Projection = SASData.Projection;
                    effect.World = SASData.Model * Matrix.CreateWorld(bullet.Position, bullet.Velocity, bullet.Up);
                }
                mesh.Draw();
            }
        }

        /// <summary>
        /// Draws a Crosswalk Map Model
        /// </summary>
        /// <param name="mapAsset"></param>
        private void DrawMap(MapAsset mapAsset)
        {
            XSIAnimationData animationData = mapAsset.CrosswalkModel.Tag as XSIAnimationData;
            Matrix[] transforms = new Matrix[mapAsset.CrosswalkModel.Bones.Count];
            mapAsset.CrosswalkModel.CopyAbsoluteBoneTransformsTo(transforms);
            animationData.ComputeBoneTransforms(transforms);
            Matrix[] bones = animationData.BoneTransforms;

            foreach (ModelMesh mesh in mapAsset.CrosswalkModel.Meshes)
            {
                // Compute the model matrix for lighting
                SASData.Model = transforms[mesh.ParentBone.Index];
                SASData.ComputeModel();

                foreach (BasicEffect effect in mesh.Effects)
                {
                    effect.EnableDefaultLighting();
                    effect.PreferPerPixelLighting = true;
                    effect.View = SASData.View;
                    effect.Projection = SASData.Projection;
                    effect.World = SASData.Model * Matrix.CreateScale(mapAsset.Scale);
                }
                mesh.Draw();
            }
        }

        #endregion

    }
}
