﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using XSIXNARuntime;

namespace Hook_FPS
{
    /// <summary>
    /// The ModelAsset Class stores information about the Crosswalk Model 
    /// content including animations and its World Parameters.
    /// </summary>
    public class CameraAsset
    {
        #region Private Fields

        // Model, Animation, and Animation Data
        private Model _CrosswalkModel;
        private String _FilePath;
        private Vector3 _Position;
        private Vector3 _Forward;
        private Vector3 _Up;
        private float _Yaw;
        private float _Pitch;
        private float _Roll;
        private Matrix _World;

        #endregion

        #region Properties

        // Get and Set Asset Properties
        public Model CrosswalkModel { get { return _CrosswalkModel; } }
        public String FilePath { get { return _FilePath; } }
        public Vector3 Position { get { return _Position; } set { _Position = value; } }
        public Vector3 Forward { get { return _Forward; } set { _Forward = value; } }
        public Vector3 Up { get { return _Up; } set { _Up = value; } }
        public float Yaw { get { return _Yaw; } }
        public float Pitch { get { return _Pitch; } }
        public float Roll { get { return _Roll; } }
        
        #endregion

        #region Constructor(s)

        /// <summary>
        /// This is called to construct and initialize a new ModelAsset
        /// </summary>
        /// <param name="AssetPath">The path of the Model to load</param>
        /// <param name="content">The game content manager</param>
        public CameraAsset(String AssetPath, ContentManager content)
        {
            // Load the Model and Initialize Private Fields
            _CrosswalkModel = content.Load<Model>(AssetPath);
            _FilePath = AssetPath;

            // Init public fields
            _Position = Vector3.Zero;
            _Forward = Vector3.Forward;
            _Up = Vector3.Up;

            _Yaw = 0.0f;
            _Pitch = 0.0f;
            _Roll = 0.0f;
            
            _World = Matrix.Identity;

        }

        #endregion

        #region Public Methods

        /// <summary>
        /// This is used to set the Position vector for Translating
        /// </summary>
        /// <param name="vector">The vector to set the Model position</param>
        public void Translate(Vector3 vector)
        {
            _Position += vector;

        }

        /// <summary>
        /// This is used to set the amount of rotation in radians
        /// </summary>
        /// <param name="radians">The amount of rotation in radians</param>
        public void RotateAboutY(float radians)
        {
            _Yaw += radians;
            
        }

        /// <summary>
        /// This is used to set the amount of rotation in radians
        /// </summary>
        /// <param name="radians">The amount of rotation in radians</param>
        public void RotateAboutX(float radians)
        {
            _Pitch += radians;
            _Pitch = MathHelper.Clamp(_Pitch, -MathHelper.ToRadians(89.9f), MathHelper.ToRadians(89.9f));
        }

        /// <summary>
        /// This is used to set the amount of rotation in radians
        /// </summary>
        /// <param name="radians">The amount of rotation in radians</param>
        public void RotateAboutZ(float radians)
        {
            _Roll += radians;
        }

        /// <summary>
        /// This will calculate the world matrix based on the rotation and translation parameters
        /// </summary>
        public void CalculateWorld()
        {

            _World = Matrix.CreateWorld(_Position, _Forward, _Up);
            _CrosswalkModel.Root.Transform = _World;
        }

        #endregion


    }
}