﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using XSIXNARuntime;

namespace Hook_FPS
{
    /// <summary>
    /// A bullet object. Stores data about the bullet model, position, 
    /// if alive, its bounding sphere for collision detection, and who
    /// shot the bullet.
    /// Variables are public for performance reasons.
    /// </summary>
    class BulletObject
    {
        public Model Model = null;
        public bool IsAlive = false;
        public Vector3 Position = Vector3.Zero;
        public Vector3 Forward = Vector3.Forward;
        public Vector3 Up = Vector3.Up;
        public Vector3 Velocity = Vector3.Forward;
        public BoundingSphere BoundSphere = new BoundingSphere(Vector3.Zero, 3.0f);
        public BoundingSphere BoundSphere1 = new BoundingSphere(Vector3.Zero, 2.0f);
        public BoundingSphere BoundSphere2 = new BoundingSphere(Vector3.Zero, 2.0f);
        public BoundingSphere BoundSphere3 = new BoundingSphere(Vector3.Zero, 2.0f);
        public BoundingSphere BoundSphere4 = new BoundingSphere(Vector3.Zero, 2.0f);
        public BoundingSphere BoundSphere5 = new BoundingSphere(Vector3.Zero, 2.0f);
        public BoundingSphere BoundSphere6 = new BoundingSphere(Vector3.Zero, 2.0f);
        public int Shooter = -1; // The player number of the person whom shot the bullet
    }
}
