/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package btclientalpha.mech;

import btclientalpha.mech.parts.*;


/**
 *
 * @author Steven
 */
public class InnerStructure {

   //define the armor locations for the internal structure
   double tonnage;
   int headArmor;
   int leftLegArmor;
   int leftArmArmor;
   int leftTorsoArmor;
   int centerTorsoArmor;
   int rightTorsoArmor;
   int rightArmArmor;
   int rightLegArmor;
   
   //define the critical slots
   Part[] head; //6 slots
   Part[] leftLeg; //6 slots
   Part[] leftArm; //12 slots
   Part[] leftTorso; //12 slots
   Part[] centerTorso; //12 slots
   Part[] rightTorso; //12 slots
   Part[] rightArm; //12 slots
   Part[] rightLeg; //6 slots

   int headCritsAvail; //keep track of availability
   int leftLegCritsAvail;
   int leftArmCritsAvail;
   int leftTorsoCritsAvail;
   int centerTorsoCritsAvail;
   int rightTorsoCritsAvail;
   int rightArmCritsAvail;
   int rightLegCritsAvail;

   //define parts
   Engine engine;
   Gyro gyro;
   Cockpit cockpit;
   Sensors sensors;
   LifeSupport lifeSupport;
   ActuatorArmShoulder leftShoulder, rightShoulder;
   ActuatorArmUpper leftUpperArm, rightUpperArm;
   ActuatorArmLower leftLowerArm, rightLowerArm;
   ActuatorArmHand leftHand, rightHand;
   ActuatorLegHip leftHip, rightHip;
   ActuatorLegUpper leftUpperLeg, rightUpperLeg;
   ActuatorLegLower leftLowerLeg, rightLowerLeg;
   ActuatorLegFoot leftFoot, rightFoot;

   public InnerStructure(int tonnageIn, int engineRating)
   {
       tonnage = tonnageIn * 0.1;

       defineArmor(tonnageIn);

       head        = new Part[6];
       leftLeg     = new Part[6];
       leftArm     = new Part[12];
       leftTorso   = new Part[12];
       centerTorso = new Part[12];
       rightTorso  = new Part[12];
       rightArm    = new Part[12];
       rightLeg    = new Part[6];

       engine        = new Engine(engineRating);
       gyro          = new Gyro(engineRating);
       cockpit       = new Cockpit();
       sensors       = new Sensors();
       lifeSupport   = new LifeSupport();
       leftShoulder  = new ActuatorArmShoulder();
       rightShoulder = new ActuatorArmShoulder();
       leftUpperArm  = new ActuatorArmUpper();
       rightUpperArm = new ActuatorArmUpper();
       leftLowerArm  = new ActuatorArmLower();
       rightLowerArm = new ActuatorArmLower();
       leftHand      = new ActuatorArmHand();
       rightHand     = new ActuatorArmHand();
       leftHip       = new ActuatorLegHip();
       rightHip      = new ActuatorLegHip();
       leftUpperLeg  = new ActuatorLegUpper();
       rightUpperLeg = new ActuatorLegUpper();
       leftLowerLeg  = new ActuatorLegLower();
       rightLowerLeg = new ActuatorLegLower();
       leftFoot      = new ActuatorLegFoot();
       rightFoot     = new ActuatorLegFoot();

       head[0] = lifeSupport;
       head[1] = sensors;
       head[2] = cockpit;
       head[4] = sensors;
       head[5] = lifeSupport;
       headCritsAvail = 1;

       leftArm[0] = leftShoulder;
       leftArm[1] = leftUpperArm;
       leftArm[2] = leftLowerArm;
       leftArm[3] = leftHand;
       leftArmCritsAvail = 8;

       rightArm[0] = rightShoulder;
       rightArm[1] = rightUpperArm;
       rightArm[2] = rightLowerArm;
       rightArm[3] = rightHand;
       rightArmCritsAvail = 8;

       leftLeg[0] = leftHip;
       leftLeg[1] = leftUpperLeg;
       leftLeg[2] = leftLowerLeg;
       leftLeg[3] = leftFoot;
       leftLegCritsAvail = 2;

       rightLeg[0] = rightHip;
       rightLeg[1] = rightUpperLeg;
       rightLeg[2] = rightLowerLeg;
       rightLeg[3] = rightFoot;
       rightLegCritsAvail = 2;

       centerTorso[0] = engine;
       centerTorso[1] = engine;
       centerTorso[2] = engine;
       centerTorso[3] = gyro;
       centerTorso[4] = gyro;
       centerTorso[5] = gyro;
       centerTorso[6] = gyro;
       centerTorso[7] = engine;
       centerTorso[8] = engine;
       centerTorso[9] = engine;
       centerTorsoCritsAvail = 2;

       leftTorsoCritsAvail = 12;
       rightTorsoCritsAvail = 12;

   }

   public int getCritAvail(int loc)
   {
       int temp = -1;
       
       switch(loc)
       {
           case 0: temp = headCritsAvail; break;
           case 1: temp = leftLegCritsAvail; break;
           case 2: temp = leftArmCritsAvail; break;
           case 3: temp = leftTorsoCritsAvail; break;
           case 4: temp = centerTorsoCritsAvail; break;
           case 5: temp = rightTorsoCritsAvail; break;
           case 6: temp = rightArmCritsAvail; break;
           case 7: temp = rightLegCritsAvail; break;
           
       }
       
       return temp;
   }

   public boolean isPart(int loc, int critical) //check to see if critical slot is valid
   {
     try
     {
       Part temp = partAt(loc, critical);

      if(temp==null)
          return false;
      else
          return true;

     }
     catch(Exception e)
     {
         return false;
     }
     
   }

   public boolean setPart(Part partIn, int loc)
   {
       int critical = 0;

       int count = partIn.getCritical();

       if(count > getCritAvail(loc))
           return false;

       while(count != 0)
       {

            if(!isPart(loc, critical))
            {
 
                switch(loc)
                {
                    case 0: head[critical] = partIn;        break;
                    case 1: leftLeg[critical] = partIn;     break;
                    case 2: leftArm[critical] = partIn;     break;
                    case 3: leftTorso[critical] = partIn;   break;
                    case 4: centerTorso[critical] = partIn; break;
                    case 5: rightTorso[critical] = partIn;  break;
                    case 6: rightArm[critical] = partIn;    break;
                    case 7: rightLeg[critical] = partIn;    break;
                }

                count--;
            }
            if(critical < 12)
                critical++;
            else
                critical = 0;
       }

       return true;
      
   }
   
   public Part partAt(int loc, int critical)
   {
       Part temp = new Part();

        switch(loc)
       {
           case 0: if(critical < 6) temp = head[critical];        break;
           case 1: if(critical < 6) temp = leftLeg[critical];     break;
           case 2: temp = leftArm[critical];     break;
           case 3: temp = leftTorso[critical];   break;
           case 4: temp = centerTorso[critical]; break;
           case 5: temp = rightTorso[critical];  break;
           case 6: temp = rightArm[critical];    break;
           case 7: if(critical < 6) temp = rightLeg[critical];    break;
       }

       return temp;
   }

   //Below are the get mehods for the armor locations

   public int getLeftLegArmor()
   {
       return leftLegArmor;
   }

   public int getLeftArmArmor()
   {
       return leftArmArmor;
   }

   public int getLeftTorsoArmor()
   {
       return leftTorsoArmor;
   }

   public int getCenterTorsoArmor()
   {
       return centerTorsoArmor;
   }

   public int getRightTorsoArmor()
   {
       return rightTorsoArmor;
   }

   public int getRightArmArmor()
   {
       return rightArmArmor;
   }


   public int getRightLegArmor()
   {
       return rightLegArmor;
   }


   //below is the armor set routine. switch statement for now...

   private void defineArmor(int input) //lengthy for now...
   {
       headArmor = 3;

       switch(input)
       {
           case 10:
               leftLegArmor     = 2;
               leftArmArmor     = 1;
               leftTorsoArmor   = 3;
               centerTorsoArmor = 4;
               rightTorsoArmor  = 3;
               rightArmArmor    = 1;
               rightLegArmor    = 2;
               break;
           case 15:
               leftLegArmor     = 3;
               leftArmArmor     = 2;
               leftTorsoArmor   = 4;
               centerTorsoArmor = 5;
               rightTorsoArmor  = 4;
               rightArmArmor    = 2;
               rightLegArmor    = 3;
               break;
           case 20:
               leftLegArmor     = 4;
               leftArmArmor     = 3;
               leftTorsoArmor   = 5;
               centerTorsoArmor = 6;
               rightTorsoArmor  = 5;
               rightArmArmor    = 3;
               rightLegArmor    = 4;
               break;
           case 25:
               leftLegArmor     = 6;
               leftArmArmor     = 4;
               leftTorsoArmor   = 6;
               centerTorsoArmor = 8;
               rightTorsoArmor  = 6;
               rightArmArmor    = 4;
               rightLegArmor    = 6;
               break;
           case 30:
               leftLegArmor     = 7;
               leftArmArmor     = 5;
               leftTorsoArmor   = 7;
               centerTorsoArmor = 10;
               rightTorsoArmor  = 7;
               rightArmArmor    = 5;
               rightLegArmor    = 7;
               break;
           case 35:
               leftLegArmor     = 8;
               leftArmArmor     = 6;
               leftTorsoArmor   = 8;
               centerTorsoArmor = 11;
               rightTorsoArmor  = 8;
               rightArmArmor    = 6;
               rightLegArmor    = 8;
               break;
           case 40:
               leftLegArmor     = 10;
               leftArmArmor     = 6;
               leftTorsoArmor   = 10;
               centerTorsoArmor = 12;
               rightTorsoArmor  = 10;
               rightArmArmor    = 6;
               rightLegArmor    = 10;
               break;
           case 45:
               leftLegArmor     = 11;
               leftArmArmor     = 7;
               leftTorsoArmor   = 11;
               centerTorsoArmor = 14;
               rightTorsoArmor  = 11;
               rightArmArmor    = 7;
               rightLegArmor    = 11;
               break;
           case 50:
               leftLegArmor     = 12;
               leftArmArmor     = 8;
               leftTorsoArmor   = 12;
               centerTorsoArmor = 16;
               rightTorsoArmor  = 12;
               rightArmArmor    = 8;
               rightLegArmor    = 12;
               break;
           case 55:
               leftLegArmor     = 13;
               leftArmArmor     = 9;
               leftTorsoArmor   = 13;
               centerTorsoArmor = 18;
               rightTorsoArmor  = 13;
               rightArmArmor    = 9;
               rightLegArmor    = 13;
               break;
           case 60:
               leftLegArmor     = 14;
               leftArmArmor     = 10;
               leftTorsoArmor   = 14;
               centerTorsoArmor = 20;
               rightTorsoArmor  = 14;
               rightArmArmor    = 10;
               rightLegArmor    = 14;
               break;
           case 65:
               leftLegArmor     = 15;
               leftArmArmor     = 10;
               leftTorsoArmor   = 15;
               centerTorsoArmor = 21;
               rightTorsoArmor  = 15;
               rightArmArmor    = 10;
               rightLegArmor    = 15;
               break;
           case 70:
               leftLegArmor     = 15;
               leftArmArmor     = 11;
               leftTorsoArmor   = 15;
               centerTorsoArmor = 22;
               rightTorsoArmor  = 15;
               rightArmArmor    = 11;
               rightLegArmor    = 15;
               break;
           case 75:
               leftLegArmor     = 16;
               leftArmArmor     = 12;
               leftTorsoArmor   = 16;
               centerTorsoArmor = 23;
               rightTorsoArmor  = 16;
               rightArmArmor    = 12;
               rightLegArmor    = 16;
               break;
           case 80:
               leftLegArmor     = 17;
               leftArmArmor     = 13;
               leftTorsoArmor   = 17;
               centerTorsoArmor = 25;
               rightTorsoArmor  = 17;
               rightArmArmor    = 13;
               rightLegArmor    = 17;
               break;
           case 85:
               leftLegArmor     = 18;
               leftArmArmor     = 14;
               leftTorsoArmor   = 18;
               centerTorsoArmor = 27;
               rightTorsoArmor  = 18;
               rightArmArmor    = 14;
               rightLegArmor    = 18;
               break;
           case 90:
               leftLegArmor     = 19;
               leftArmArmor     = 15;
               leftTorsoArmor   = 19;
               centerTorsoArmor = 29;
               rightTorsoArmor  = 19;
               rightArmArmor    = 15;
               rightLegArmor    = 19;
               break;
           case 95:
               leftLegArmor     = 20;
               leftArmArmor     = 16;
               leftTorsoArmor   = 20;
               centerTorsoArmor = 30;
               rightTorsoArmor  = 20;
               rightArmArmor    = 16;
               rightLegArmor    = 20;
               break;
           case 100:
               leftLegArmor     = 21;
               leftArmArmor     = 17;
               leftTorsoArmor   = 21;
               centerTorsoArmor = 31;
               rightTorsoArmor  = 21;
               rightArmArmor    = 17;
               rightLegArmor    = 21;
               break;

       }

   }

    double getTonnage() {
        return tonnage;
    }
}
