/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package btclientalpha;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;

/**
 *
 * @author Steven
 */
public class GameCanvas extends Canvas{


    Hex[][] h1;
    int hexSize, hexX, hexY, h, v;
    int[] xPoints, yPoints;

    int mechX, mechY, mechDirection;

    public GameCanvas(int sizeIn, int hexXIn, int hexYIn)
    {
        hexSize = sizeIn;
        hexX = hexXIn;
        hexY = hexYIn;
        h1 = new Hex[hexX][hexY];
        Hex template = new Hex(0, 0, hexSize);

        h = template.getHorzOffset();
        v = template.getYVertsAT(0)[0];

        int lx = 0;
        int ly = 0;


        for(int i = 0; i<hexX;i++)
        {
            if (i % 2 == 1)
            {
                ly = v;
            }
            else
                ly = 0;

            for(int j=0; j<hexY; j++)
            {
                h1[i][j] = new Hex(lx,ly, hexSize);
                //System.out.println("x: " + i + " y: " + j + " lx: " + lx + " ly: " + ly);

                ly = ly + (2 * v);
            }
            lx = lx + h;
        }

       mechX = 0;
       mechY = 0;
       mechDirection = 2;


    }

    public void mechTurnLeft()
    {
        if(mechDirection == 0)
            mechDirection = 5;
        else
            mechDirection--;
    }
    
    public void mechTurnRight()
    {
        if(mechDirection == 5)
            mechDirection = 0;
        else
            mechDirection++;
    }
    
    public void mechForward()
    {
        //System.out.println("dir: " + mechDirection + " x: " + mechX + " y: " + mechY);
        switch(mechDirection)
        {
            case 0: if(mechY != 0) mechY--; break;
            case 1: if(mechY != 0 && mechX != hexX-1)
                    {    if((mechX % 2) == 0)
                        {
                            mechX++;
                            mechY--;
                            
                        }
                         else
                             mechX++;
                    }
                    else if(mechY == 0 && mechX != hexX-1 && (mechX %2) == 1)
                        mechX++;
                    break;
            case 2: if(mechX != hexX-1 && mechY != hexY-1)
                    {   if((mechX % 2) == 0)
                        {
                            mechX++;
                            
                        }
                        else
                        {
                            mechX++;
                            mechY++;

                        }
                    }
                    break;
            case 3: if(mechY !=hexY-1) mechY++; break;
            case 4: if(mechX !=0 && mechY !=hexY-1)
                    {   if((mechX % 2) == 0)
                        {
                            mechX--;
                            
                        }
                        else
                        {
                            mechX--;
                            mechY++;
                            
                        }
                    }
                       break;

            case 5: if(mechY != 0 && mechX !=0)
                    {    if((mechX % 2) == 0)
                        {
                            mechX--;
                            mechY--;

                        }
                         else
                             mechX--;
                    }
                    else if(mechY == 0 && (mechX %2) == 1)
                        mechX--;
                    break;
                
        }
        //System.out.println(mechDirection + " " + mechX + " " + mechY);
    }

    public void mechBackward()
    {
        switch(mechDirection)
        {
            case 0: if(mechY != hexY-1) mechY++; break;
            case 1: if(mechY != hexY-1 && mechX != 0)
                    {    if((mechX % 2) == 1)
                        {
                            mechX--;
                            mechY++;

                        }
                         else
                             mechX--;
                    }
                    else if(mechY == 0 && (mechX %2) == 1)
                        mechX--;
                    break;
            case 2: if(mechX != 0 && mechY != 0)
                    {   if((mechX % 2) == 1)
                        {
                            mechX--;

                        }
                        else
                        {
                            mechX--;
                            mechY--;

                        }
                    }
                    break;
            case 3: if(mechY !=0) mechY--; break;
            case 4: if(mechX !=hexX-1)
                    {   if((mechX % 2) == 1)
                        {
                            mechX++;

                        }
                        else
                        {
                            mechX++;
                            mechY--;

                        }
                    }
                       break;

            case 5: if(mechY != hexY-1 && mechX !=hexX-1)
                    {    if((mechX % 2) == 1)
                        {
                            mechX++;
                            mechY++;

                        }
                         else
                             mechX++;
                    }
                    else if(mechY == hexY-1 && (mechX %2) == 1)
                        mechX++;
                    break;

        }
    }


    public void updateSize(int sizeIn)
    {
        hexSize = sizeIn;
        h1[0][0] = new Hex(0, 0, hexSize);
      
    }

    @Override
    public void paint(Graphics g)
    {
        super.paint(g);
        drawHexGrid(g);

        drawMech(g);

    }

    private void drawMech(Graphics g)
    {
        int[] mx = {10,30,20,10}; //default onstructor, overwritten shortly
        int[] my = {0,0,30,0}; //same

        xPoints = h1[mechX][mechY].getXVertsAT(h1[mechX][mechY].getX());
        yPoints = h1[mechX][mechY].getYVertsAT(h1[mechX][mechY].getY());

        switch(mechDirection)
        {
            case 0: mx[0] = xPoints[4];
                    my[0] = yPoints[4];
                    mx[1] = xPoints[5];
                    my[1] = yPoints[5];
                    mx[2] = xPoints[1] + (xPoints[2] - xPoints[1])/2;
                    my[2] = yPoints[2];
                    mx[3] = mx[0];
                    my[3] = my[0];
                    break;
            case 1: mx[0] = xPoints[5];
                    my[0] = yPoints[5];
                    mx[1] = xPoints[6];
                    my[1] = yPoints[6];
                    mx[2] = xPoints[2] + (xPoints[3] - xPoints[2])/2;
                    my[2] = yPoints[2] - (yPoints[2] - yPoints[3])/2;
                    mx[3] = mx[0];
                    my[3] = my[0];
                    break;
            case 2: mx[0] = xPoints[0];
                    my[0] = yPoints[0];
                    mx[1] = xPoints[1];
                    my[1] = yPoints[1];
                    mx[2] = xPoints[4] + (xPoints[3] - xPoints[2])/2;
                    my[2] = yPoints[4] + (xPoints[4] - xPoints[3])/2;
                    mx[3] = mx[0];
                    my[3] = my[0];
                    break;
            case 3: mx[0] = xPoints[1];
                    my[0] = yPoints[1];
                    mx[1] = xPoints[2];
                    my[1] = yPoints[2];
                    mx[2] = xPoints[5] + (xPoints[4] - xPoints[5])/2;
                    my[2] = yPoints[4];
                    mx[3] = mx[0];
                    my[3] = my[0];
                    break;
            case 4: mx[0] = xPoints[2];
                    my[0] = yPoints[2];
                    mx[1] = xPoints[3];
                    my[1] = yPoints[3];
                    mx[2] = xPoints[5] - (xPoints[5] - xPoints[6])/2;
                    my[2] = yPoints[5] - (xPoints[5] - xPoints[6])/2;
                    mx[3] = mx[0];
                    my[3] = my[0];
                    break;
            case 5: mx[0] = xPoints[3];
                    my[0] = yPoints[3];
                    mx[1] = xPoints[4];
                    my[1] = yPoints[4];
                    mx[2] = xPoints[0] + (xPoints[1] - xPoints[0])/2;
                    my[2] = yPoints[0] + (xPoints[0] - xPoints[1])/2;
                    mx[3] = mx[0];
                    my[3] = my[0];
                    break;
        }



        g.setColor(Color.RED);
        g.fillPolygon(mx, my, 4);
    }
 
    private void drawHexGrid(Graphics g)
    {
        for (int i = 0; i < hexX; i++)
        {
             
            for (int j = 0; j < hexY; j++)
            {

                xPoints = h1[i][j].getXVertsAT(h1[i][j].getX());
                yPoints = h1[i][j].getYVertsAT(h1[i][j].getY());
                
                g.drawPolygon(xPoints, yPoints, xPoints.length);
                g.drawString(Integer.toString(h1[i][j].getTerrain()), xPoints[0]+10, yPoints[0]+10);
                
            }
        }
    }

}
