/*
 * BTClientALPHAView.java
 *
 * This will be a rough initial foray into a UI. I have a feeling that This will
 * get bloated with unused elements as I work through design ideas...
 */

package btclientalpha;

import btclientalpha.mech.MechBody;
import btclientalpha.mech.MechJenner;
import btclientalpha.mech.weapons.Weapon;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.TaskMonitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;

/**
 * The application's main frame.
 */
public class BTClientALPHAView extends FrameView {

    public BTClientALPHAView(SingleFrameApplication app) {
        super(app);

        //----------------------------------------
        //Custom code elements initialized here
        dice = new DieGenerator(); //random number generator that returns a value from 2-12
        phase = new PhaseEngine(); //simple boolean check for game state

        //showMechSelector();

        pm1 = new PlayerMech(1, "Steven", 1);
        pm1.setMech(new MechJenner(), 0);
        initComponents();
        tempCanvas = (GameCanvas) canvas1;
        
        //canvas1.createBufferStrategy(2);
        uiUpdate();


        // status bar initialization - message timeout, idle icon and busy animation, etc
        ResourceMap resourceMap = getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        messageTimer = new Timer(messageTimeout, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                statusMessageLabel.setText("");
            }
        });
        messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < busyIcons.length; i++) {
            busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        busyIconTimer = new Timer(busyAnimationRate, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                busyIconIndex = (busyIconIndex + 1) % busyIcons.length;
                statusAnimationLabel.setIcon(busyIcons[busyIconIndex]);
            }
        });
        idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        statusAnimationLabel.setIcon(idleIcon);
        progressBar.setVisible(false);

        // connecting action tasks to status bar via TaskMonitor
        TaskMonitor taskMonitor = new TaskMonitor(getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!busyIconTimer.isRunning()) {
                        statusAnimationLabel.setIcon(busyIcons[0]);
                        busyIconIndex = 0;
                        busyIconTimer.start();
                    }
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    busyIconTimer.stop();
                    statusAnimationLabel.setIcon(idleIcon);
                    progressBar.setVisible(false);
                    progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)(evt.getNewValue());
                    statusMessageLabel.setText((text == null) ? "" : text);
                    messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)(evt.getNewValue());
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(false);
                    progressBar.setValue(value);
                }
            }
        });
    }

      public void showMechSelector() {
        if (mechSelector == null) {
            JFrame mainFrame = BTClientALPHAApp.getApplication().getMainFrame();
            mechSelector = new MechSelectorDialog(mainFrame, true);
            mechSelector.setLocationRelativeTo(mainFrame);
        }
        BTClientALPHAApp.getApplication().show(mechSelector);

   }

    @Action
    public void showAboutBox() {
        if (aboutBox == null) {
            JFrame mainFrame = BTClientALPHAApp.getApplication().getMainFrame();
            aboutBox = new BTClientALPHAAboutBox(mainFrame);
            aboutBox.setLocationRelativeTo(mainFrame);
        }
        BTClientALPHAApp.getApplication().show(aboutBox);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPanel = new javax.swing.JPanel();
        movementPanel = new javax.swing.JPanel();
        movementLabel = new javax.swing.JLabel();
        moveWalkLabel = new javax.swing.JLabel();
        moveRunLabel = new javax.swing.JLabel();
        moveModLabel = new javax.swing.JLabel();
        moveAvailLabel = new javax.swing.JLabel();
        moveWalkValueLabel = new javax.swing.JLabel();
        moveRunValueLabel = new javax.swing.JLabel();
        moveModValueLabel = new javax.swing.JLabel();
        moveAvailValueLabel = new javax.swing.JLabel();
        playerStatusPanel = new javax.swing.JPanel();
        PlayerLabel = new javax.swing.JLabel();
        PlayerNameLabel = new javax.swing.JLabel();
        mechLabel = new javax.swing.JLabel();
        mechNameLabel = new javax.swing.JLabel();
        tonnageLabel = new javax.swing.JLabel();
        tonnageValueLabel = new javax.swing.JLabel();
        headLabel = new javax.swing.JLabel();
        leftLegLabel = new javax.swing.JLabel();
        leftrmLabel = new javax.swing.JLabel();
        leftTorsoLabel = new javax.swing.JLabel();
        centerTorsoLabel = new javax.swing.JLabel();
        rightTorsoLabel = new javax.swing.JLabel();
        rightArmLabel = new javax.swing.JLabel();
        rightLegLabel = new javax.swing.JLabel();
        headArmorLabel = new javax.swing.JLabel();
        leftLegArmorLabel = new javax.swing.JLabel();
        leftArmArmorLabel = new javax.swing.JLabel();
        leftTorsoArmorLabel = new javax.swing.JLabel();
        leftTorsoRearArmorLabel = new javax.swing.JLabel();
        centerTorsoArmorLabel = new javax.swing.JLabel();
        centerTorsoRearArmorLabel = new javax.swing.JLabel();
        rightTorsoArmorLabel = new javax.swing.JLabel();
        rightTorsoRearArmorLabel = new javax.swing.JLabel();
        rightArmArmorLabel = new javax.swing.JLabel();
        rightLegArmorLabel = new javax.swing.JLabel();
        heatLabel = new javax.swing.JLabel();
        heatLevelValue = new javax.swing.JLabel();
        weapon1Label = new javax.swing.JLabel();
        weapon1AmmoValue = new javax.swing.JLabel();
        weapon2Label = new javax.swing.JLabel();
        weapon2AmmoValue = new javax.swing.JLabel();
        weapon3Label = new javax.swing.JLabel();
        weapon3AmmoValue = new javax.swing.JLabel();
        weapon4Label = new javax.swing.JLabel();
        weapon4AmmoValue = new javax.swing.JLabel();
        weapon5Label = new javax.swing.JLabel();
        weapon5AmmoValue = new javax.swing.JLabel();
        wep5Btn = new javax.swing.JButton();
        wep1Btn = new javax.swing.JButton();
        wep2Btn = new javax.swing.JButton();
        wep3Btn = new javax.swing.JButton();
        wep4Btn = new javax.swing.JButton();
        CanvasStatusLabel = new javax.swing.JLabel();
        torsoTwistPanel = new javax.swing.JPanel();
        torsoTwistLeftBtn = new javax.swing.JButton();
        torsoTwistRightBtn = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        PhaseChange = new javax.swing.JButton();
        rollDiceBtn = new javax.swing.JButton();
        diceRollResult = new javax.swing.JLabel();
        canvas1 = new GameCanvas(16, 33, 21);
        menuBar = new javax.swing.JMenuBar();
        javax.swing.JMenu fileMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
        javax.swing.JMenu helpMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();
        statusPanel = new javax.swing.JPanel();
        javax.swing.JSeparator statusPanelSeparator = new javax.swing.JSeparator();
        statusMessageLabel = new javax.swing.JLabel();
        statusAnimationLabel = new javax.swing.JLabel();
        progressBar = new javax.swing.JProgressBar();
        PhaseLabel = new javax.swing.JLabel();
        PhaseStatus = new javax.swing.JLabel();
        torsoTwistLabel = new javax.swing.JLabel();
        jFrame1 = new javax.swing.JFrame();

        mainPanel.setMaximumSize(new java.awt.Dimension(914, 480));
        mainPanel.setMinimumSize(new java.awt.Dimension(914, 480));
        mainPanel.setName("mainPanel"); // NOI18N
        mainPanel.setLayout(null);

        movementPanel.setName("movementPanel"); // NOI18N

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(btclientalpha.BTClientALPHAApp.class).getContext().getResourceMap(BTClientALPHAView.class);
        movementLabel.setText(resourceMap.getString("movementLabel.text")); // NOI18N
        movementLabel.setName("movementLabel"); // NOI18N

        moveWalkLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        moveWalkLabel.setText(resourceMap.getString("moveWalkLabel.text")); // NOI18N
        moveWalkLabel.setName("moveWalkLabel"); // NOI18N

        moveRunLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        moveRunLabel.setText(resourceMap.getString("moveRunLabel.text")); // NOI18N
        moveRunLabel.setName("moveRunLabel"); // NOI18N

        moveModLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        moveModLabel.setText(resourceMap.getString("moveModLabel.text")); // NOI18N
        moveModLabel.setName("moveModLabel"); // NOI18N

        moveAvailLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        moveAvailLabel.setText(resourceMap.getString("moveAvailLabel.text")); // NOI18N
        moveAvailLabel.setName("moveAvailLabel"); // NOI18N

        moveWalkValueLabel.setText(resourceMap.getString("moveWalkValueLabel.text")); // NOI18N
        moveWalkValueLabel.setName("moveWalkValueLabel"); // NOI18N

        moveRunValueLabel.setText(resourceMap.getString("moveRunValueLabel.text")); // NOI18N
        moveRunValueLabel.setName("moveRunValueLabel"); // NOI18N

        moveModValueLabel.setText(resourceMap.getString("moveModValueLabel.text")); // NOI18N
        moveModValueLabel.setName("moveModValueLabel"); // NOI18N

        moveAvailValueLabel.setText(resourceMap.getString("moveAvailValueLabel.text")); // NOI18N
        moveAvailValueLabel.setName("moveAvailValueLabel"); // NOI18N

        javax.swing.GroupLayout movementPanelLayout = new javax.swing.GroupLayout(movementPanel);
        movementPanel.setLayout(movementPanelLayout);
        movementPanelLayout.setHorizontalGroup(
            movementPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(movementPanelLayout.createSequentialGroup()
                .addGroup(movementPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(movementPanelLayout.createSequentialGroup()
                        .addGap(20, 20, 20)
                        .addGroup(movementPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(moveWalkLabel, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(moveRunLabel, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(moveModLabel, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(moveAvailLabel, javax.swing.GroupLayout.Alignment.TRAILING))
                        .addGap(3, 3, 3)
                        .addGroup(movementPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(moveWalkValueLabel)
                            .addComponent(moveRunValueLabel)
                            .addComponent(moveModValueLabel)
                            .addComponent(moveAvailValueLabel)))
                    .addGroup(movementPanelLayout.createSequentialGroup()
                        .addGap(50, 50, 50)
                        .addComponent(movementLabel)))
                .addGap(26, 26, 26))
        );
        movementPanelLayout.setVerticalGroup(
            movementPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(movementPanelLayout.createSequentialGroup()
                .addComponent(movementLabel)
                .addGap(6, 6, 6)
                .addGroup(movementPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(moveWalkLabel)
                    .addComponent(moveWalkValueLabel))
                .addGap(6, 6, 6)
                .addGroup(movementPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(moveRunLabel)
                    .addComponent(moveRunValueLabel))
                .addGap(6, 6, 6)
                .addGroup(movementPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(moveModLabel)
                    .addComponent(moveModValueLabel))
                .addGap(6, 6, 6)
                .addGroup(movementPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(moveAvailLabel)
                    .addComponent(moveAvailValueLabel)))
        );

        movementPanel.setVisible(false);

        mainPanel.add(movementPanel);
        movementPanel.setBounds(40, 500, 123, 94);

        playerStatusPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.RAISED, resourceMap.getColor("playerStatusPanel.border.highlightColor"), resourceMap.getColor("playerStatusPanel.border.shadowColor"))); // NOI18N
        playerStatusPanel.setName("playerStatusPanel"); // NOI18N

        PlayerLabel.setName("PlayerLabel"); // NOI18N

        PlayerNameLabel.setText(pm1.getPlayerName());
        PlayerNameLabel.setName("PlayerNameLabel"); // NOI18N

        mechLabel.setText(resourceMap.getString("mechLabel.text")); // NOI18N
        mechLabel.setName("mechLabel"); // NOI18N

        mechNameLabel.setText(pm1.getMechName(0));
        mechNameLabel.setName("mechNameLabel"); // NOI18N

        tonnageLabel.setText(resourceMap.getString("tonnageLabel.text")); // NOI18N
        tonnageLabel.setName("tonnageLabel"); // NOI18N

        tonnageValueLabel.setText(Double.toString(pm1.getMech(0).currentBuildTonnage()));
        tonnageValueLabel.setName("tonnageValueLabel"); // NOI18N

        headLabel.setText(resourceMap.getString("headLabel.text")); // NOI18N
        headLabel.setName("headLabel"); // NOI18N

        leftLegLabel.setText(resourceMap.getString("leftLegLabel.text")); // NOI18N
        leftLegLabel.setName("leftLegLabel"); // NOI18N

        leftrmLabel.setText(resourceMap.getString("leftrmLabel.text")); // NOI18N
        leftrmLabel.setName("leftrmLabel"); // NOI18N

        leftTorsoLabel.setText(resourceMap.getString("leftTorsoLabel.text")); // NOI18N
        leftTorsoLabel.setName("leftTorsoLabel"); // NOI18N

        centerTorsoLabel.setText(resourceMap.getString("centerTorsoLabel.text")); // NOI18N
        centerTorsoLabel.setName("centerTorsoLabel"); // NOI18N

        rightTorsoLabel.setText(resourceMap.getString("rightTorsoLabel.text")); // NOI18N
        rightTorsoLabel.setName("rightTorsoLabel"); // NOI18N

        rightArmLabel.setText(resourceMap.getString("rightArmLabel.text")); // NOI18N
        rightArmLabel.setName("rightArmLabel"); // NOI18N

        rightLegLabel.setText(resourceMap.getString("rightLegLabel.text")); // NOI18N
        rightLegLabel.setName("rightLegLabel"); // NOI18N

        headArmorLabel.setText(resourceMap.getString("headArmorLabel.text")); // NOI18N
        headArmorLabel.setName("headArmorLabel"); // NOI18N

        leftLegArmorLabel.setText(resourceMap.getString("leftLegArmorLabel.text")); // NOI18N
        leftLegArmorLabel.setName("leftLegArmorLabel"); // NOI18N

        leftArmArmorLabel.setText(resourceMap.getString("leftArmArmorLabel.text")); // NOI18N
        leftArmArmorLabel.setName("leftArmArmorLabel"); // NOI18N

        leftTorsoArmorLabel.setText(resourceMap.getString("leftTorsoArmorLabel.text")); // NOI18N
        leftTorsoArmorLabel.setName("leftTorsoArmorLabel"); // NOI18N

        leftTorsoRearArmorLabel.setText(resourceMap.getString("leftTorsoRearArmorLabel.text")); // NOI18N
        leftTorsoRearArmorLabel.setName("leftTorsoRearArmorLabel"); // NOI18N

        centerTorsoArmorLabel.setText(resourceMap.getString("centerTorsoArmorLabel.text")); // NOI18N
        centerTorsoArmorLabel.setName("centerTorsoArmorLabel"); // NOI18N

        centerTorsoRearArmorLabel.setText(resourceMap.getString("centerTorsoRearArmorLabel.text")); // NOI18N
        centerTorsoRearArmorLabel.setName("centerTorsoRearArmorLabel"); // NOI18N

        rightTorsoArmorLabel.setText(resourceMap.getString("rightTorsoArmorLabel.text")); // NOI18N
        rightTorsoArmorLabel.setName("rightTorsoArmorLabel"); // NOI18N

        rightTorsoRearArmorLabel.setText(resourceMap.getString("rightTorsoRearArmorLabel.text")); // NOI18N
        rightTorsoRearArmorLabel.setName("rightTorsoRearArmorLabel"); // NOI18N

        rightArmArmorLabel.setText(resourceMap.getString("rightArmArmorLabel.text")); // NOI18N
        rightArmArmorLabel.setName("rightArmArmorLabel"); // NOI18N

        rightLegArmorLabel.setText(resourceMap.getString("rightLegArmorLabel.text")); // NOI18N
        rightLegArmorLabel.setName("rightLegArmorLabel"); // NOI18N

        heatLabel.setText(resourceMap.getString("heatLabel.text")); // NOI18N
        heatLabel.setName("heatLabel"); // NOI18N

        heatLevelValue.setText(resourceMap.getString("heatLevelValue.text")); // NOI18N
        heatLevelValue.setName("heatLevelValue"); // NOI18N

        weapon1Label.setText(resourceMap.getString("weapon1Label.text")); // NOI18N
        weapon1Label.setName("weapon1Label"); // NOI18N

        weapon1AmmoValue.setText(resourceMap.getString("weapon1AmmoValue.text")); // NOI18N
        weapon1AmmoValue.setName("weapon1AmmoValue"); // NOI18N

        weapon2Label.setText(resourceMap.getString("weapon2Label.text")); // NOI18N
        weapon2Label.setName("weapon2Label"); // NOI18N

        weapon2AmmoValue.setText(resourceMap.getString("weapon2AmmoValue.text")); // NOI18N
        weapon2AmmoValue.setName("weapon2AmmoValue"); // NOI18N

        weapon3Label.setText(resourceMap.getString("weapon3Label.text")); // NOI18N
        weapon3Label.setName("weapon3Label"); // NOI18N

        weapon3AmmoValue.setText(resourceMap.getString("weapon3AmmoValue.text")); // NOI18N
        weapon3AmmoValue.setName("weapon3AmmoValue"); // NOI18N

        weapon4Label.setText(resourceMap.getString("weapon4Label.text")); // NOI18N
        weapon4Label.setName("weapon4Label"); // NOI18N

        weapon4AmmoValue.setText(resourceMap.getString("weapon4AmmoValue.text")); // NOI18N
        weapon4AmmoValue.setName("weapon4AmmoValue"); // NOI18N

        weapon5Label.setText(resourceMap.getString("weapon5Label.text")); // NOI18N
        weapon5Label.setName("weapon5Label"); // NOI18N

        weapon5AmmoValue.setText(resourceMap.getString("weapon5AmmoValue.text")); // NOI18N
        weapon5AmmoValue.setName("weapon5AmmoValue"); // NOI18N

        wep5Btn.setText(resourceMap.getString("wep5Btn.text")); // NOI18N
        wep5Btn.setEnabled(false);
        wep5Btn.setName("wep5Btn"); // NOI18N
        wep5Btn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                wep5BtnActionPerformed(evt);
            }
        });

        wep1Btn.setText(resourceMap.getString("wep1Btn.text")); // NOI18N
        wep1Btn.setEnabled(false);
        wep1Btn.setName("wep1Btn"); // NOI18N
        wep1Btn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                wep1BtnActionPerformed(evt);
            }
        });

        wep2Btn.setText(resourceMap.getString("wep2Btn.text")); // NOI18N
        wep2Btn.setEnabled(false);
        wep2Btn.setName("wep2Btn"); // NOI18N
        wep2Btn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                wep2BtnActionPerformed(evt);
            }
        });

        wep3Btn.setText(resourceMap.getString("wep3Btn.text")); // NOI18N
        wep3Btn.setEnabled(false);
        wep3Btn.setName("wep3Btn"); // NOI18N
        wep3Btn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                wep3BtnActionPerformed(evt);
            }
        });

        wep4Btn.setText(resourceMap.getString("wep4Btn.text")); // NOI18N
        wep4Btn.setEnabled(false);
        wep4Btn.setName("wep4Btn"); // NOI18N
        wep4Btn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                wep4BtnActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout playerStatusPanelLayout = new javax.swing.GroupLayout(playerStatusPanel);
        playerStatusPanel.setLayout(playerStatusPanelLayout);
        playerStatusPanelLayout.setHorizontalGroup(
            playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(playerStatusPanelLayout.createSequentialGroup()
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(playerStatusPanelLayout.createSequentialGroup()
                        .addGap(24, 24, 24)
                        .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addComponent(weapon5Label)
                            .addComponent(weapon4Label)
                            .addComponent(weapon3Label)
                            .addComponent(weapon2Label)
                            .addComponent(weapon1Label))
                        .addGap(10, 10, 10)
                        .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addComponent(weapon1AmmoValue)
                            .addComponent(weapon2AmmoValue)
                            .addComponent(weapon3AmmoValue)
                            .addComponent(weapon4AmmoValue)
                            .addComponent(weapon5AmmoValue))
                        .addGap(11, 11, 11)
                        .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addComponent(wep1Btn, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(wep2Btn, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(wep3Btn, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(wep4Btn, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(wep5Btn, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(playerStatusPanelLayout.createSequentialGroup()
                        .addGap(13, 13, 13)
                        .addComponent(heatLabel)
                        .addGap(10, 10, 10)
                        .addComponent(heatLevelValue))
                    .addGroup(playerStatusPanelLayout.createSequentialGroup()
                        .addGap(31, 31, 31)
                        .addComponent(rightLegLabel)
                        .addGap(10, 10, 10)
                        .addComponent(rightLegArmorLabel))
                    .addGroup(playerStatusPanelLayout.createSequentialGroup()
                        .addGap(29, 29, 29)
                        .addComponent(rightArmLabel)
                        .addGap(10, 10, 10)
                        .addComponent(rightArmArmorLabel))
                    .addGroup(playerStatusPanelLayout.createSequentialGroup()
                        .addGap(30, 30, 30)
                        .addComponent(rightTorsoLabel)
                        .addGap(10, 10, 10)
                        .addComponent(rightTorsoArmorLabel)
                        .addGap(6, 6, 6)
                        .addComponent(rightTorsoRearArmorLabel))
                    .addGroup(playerStatusPanelLayout.createSequentialGroup()
                        .addGap(22, 22, 22)
                        .addComponent(centerTorsoLabel)
                        .addGap(10, 10, 10)
                        .addComponent(centerTorsoArmorLabel)
                        .addGap(6, 6, 6)
                        .addComponent(centerTorsoRearArmorLabel))
                    .addGroup(playerStatusPanelLayout.createSequentialGroup()
                        .addGap(36, 36, 36)
                        .addComponent(leftTorsoLabel)
                        .addGap(10, 10, 10)
                        .addComponent(leftTorsoArmorLabel)
                        .addGap(6, 6, 6)
                        .addComponent(leftTorsoRearArmorLabel))
                    .addGroup(playerStatusPanelLayout.createSequentialGroup()
                        .addGap(35, 35, 35)
                        .addComponent(leftrmLabel)
                        .addGap(10, 10, 10)
                        .addComponent(leftArmArmorLabel))
                    .addGroup(playerStatusPanelLayout.createSequentialGroup()
                        .addGap(37, 37, 37)
                        .addComponent(leftLegLabel)
                        .addGap(10, 10, 10)
                        .addComponent(leftLegArmorLabel))
                    .addGroup(playerStatusPanelLayout.createSequentialGroup()
                        .addGap(39, 39, 39)
                        .addComponent(headLabel)
                        .addGap(10, 10, 10)
                        .addComponent(headArmorLabel))
                    .addGroup(playerStatusPanelLayout.createSequentialGroup()
                        .addGap(22, 22, 22)
                        .addComponent(tonnageLabel)
                        .addGap(10, 10, 10)
                        .addComponent(tonnageValueLabel))
                    .addGroup(playerStatusPanelLayout.createSequentialGroup()
                        .addGap(39, 39, 39)
                        .addComponent(mechLabel)
                        .addGap(10, 10, 10)
                        .addComponent(mechNameLabel))
                    .addGroup(playerStatusPanelLayout.createSequentialGroup()
                        .addGap(34, 34, 34)
                        .addComponent(PlayerLabel)
                        .addGap(10, 10, 10)
                        .addComponent(PlayerNameLabel)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        playerStatusPanelLayout.setVerticalGroup(
            playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(playerStatusPanelLayout.createSequentialGroup()
                .addGap(11, 11, 11)
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(PlayerLabel)
                    .addComponent(PlayerNameLabel))
                .addGap(6, 6, 6)
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(mechLabel)
                    .addComponent(mechNameLabel))
                .addGap(6, 6, 6)
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(tonnageLabel)
                    .addComponent(tonnageValueLabel))
                .addGap(6, 6, 6)
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(headLabel)
                    .addComponent(headArmorLabel))
                .addGap(6, 6, 6)
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(leftLegLabel)
                    .addComponent(leftLegArmorLabel))
                .addGap(6, 6, 6)
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(leftrmLabel)
                    .addComponent(leftArmArmorLabel))
                .addGap(6, 6, 6)
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(leftTorsoLabel)
                    .addComponent(leftTorsoArmorLabel)
                    .addComponent(leftTorsoRearArmorLabel))
                .addGap(6, 6, 6)
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(centerTorsoLabel)
                    .addComponent(centerTorsoArmorLabel)
                    .addComponent(centerTorsoRearArmorLabel))
                .addGap(6, 6, 6)
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(rightTorsoLabel)
                    .addComponent(rightTorsoArmorLabel)
                    .addComponent(rightTorsoRearArmorLabel))
                .addGap(6, 6, 6)
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(rightArmLabel)
                    .addComponent(rightArmArmorLabel))
                .addGap(6, 6, 6)
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(rightLegLabel)
                    .addComponent(rightLegArmorLabel))
                .addGap(11, 11, 11)
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(heatLabel)
                    .addComponent(heatLevelValue))
                .addGap(8, 8, 8)
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(weapon1Label)
                    .addComponent(weapon1AmmoValue)
                    .addComponent(wep1Btn, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(weapon2Label)
                    .addComponent(weapon2AmmoValue)
                    .addComponent(wep2Btn, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(weapon3Label)
                    .addComponent(weapon3AmmoValue)
                    .addComponent(wep3Btn, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(weapon4Label)
                    .addComponent(weapon4AmmoValue)
                    .addComponent(wep4Btn, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGroup(playerStatusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(wep5Btn, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(weapon5AmmoValue)
                    .addComponent(weapon5Label))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        mainPanel.add(playerStatusPanel);
        playerStatusPanel.setBounds(10, 11, 182, 373);

        CanvasStatusLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        CanvasStatusLabel.setLabelFor(canvas1);
        CanvasStatusLabel.setText(resourceMap.getString("CanvasStatusLabel.text")); // NOI18N
        CanvasStatusLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        CanvasStatusLabel.setName("CanvasStatusLabel"); // NOI18N
        CanvasStatusLabel.setPreferredSize(new java.awt.Dimension(358100, 11));
        mainPanel.add(CanvasStatusLabel);
        CanvasStatusLabel.setBounds(200, 630, 890, 21);

        torsoTwistPanel.setDoubleBuffered(true);
        torsoTwistPanel.setName("torsoTwistPanel"); // NOI18N
        torsoTwistPanel.setVisible(false);

        torsoTwistLeftBtn.setText(resourceMap.getString("torsoTwistLeftBtn.text")); // NOI18N
        torsoTwistLeftBtn.setName("torsoTwistLeftBtn"); // NOI18N
        torsoTwistLeftBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                torsoTwistLeftBtnActionPerformed(evt);
            }
        });

        torsoTwistRightBtn.setText(resourceMap.getString("torsoTwistRightBtn.text")); // NOI18N
        torsoTwistRightBtn.setName("torsoTwistRightBtn"); // NOI18N
        torsoTwistRightBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                torsoTwistRightBtnActionPerformed(evt);
            }
        });

        jButton1.setFont(resourceMap.getFont("jButton1.font")); // NOI18N
        jButton1.setText(resourceMap.getString("jButton1.text")); // NOI18N
        jButton1.setName("jButton1"); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N

        javax.swing.GroupLayout torsoTwistPanelLayout = new javax.swing.GroupLayout(torsoTwistPanel);
        torsoTwistPanel.setLayout(torsoTwistPanelLayout);
        torsoTwistPanelLayout.setHorizontalGroup(
            torsoTwistPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(torsoTwistPanelLayout.createSequentialGroup()
                .addGap(10, 10, 10)
                .addGroup(torsoTwistPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 79, Short.MAX_VALUE)
                    .addComponent(torsoTwistLeftBtn, javax.swing.GroupLayout.PREFERRED_SIZE, 51, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton1)
                    .addComponent(torsoTwistRightBtn))
                .addGap(31, 31, 31))
        );
        torsoTwistPanelLayout.setVerticalGroup(
            torsoTwistPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, torsoTwistPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addGap(18, 18, 18)
                .addComponent(torsoTwistLeftBtn)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(torsoTwistRightBtn)
                .addGap(16, 16, 16))
        );

        mainPanel.add(torsoTwistPanel);
        torsoTwistPanel.setBounds(40, 500, 120, 140);

        jPanel1.setName("jPanel1"); // NOI18N

        PhaseChange.setText(resourceMap.getString("PhaseChange.text")); // NOI18N
        PhaseChange.setName("PhaseChange"); // NOI18N
        PhaseChange.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PhaseChangeActionPerformed(evt);
            }
        });

        rollDiceBtn.setIcon(resourceMap.getIcon("DieRollBTN.icon")); // NOI18N
        rollDiceBtn.setText(resourceMap.getString("DieRollBTN.text")); // NOI18N
        rollDiceBtn.setBorderPainted(false);
        rollDiceBtn.setFocusPainted(false);
        rollDiceBtn.setName("DieRollBTN"); // NOI18N
        rollDiceBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rollDiceBtnActionPerformed(evt);
            }
        });

        diceRollResult.setText(resourceMap.getString("diceRollResult.text")); // NOI18N
        diceRollResult.setName("diceRollResult"); // NOI18N

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(rollDiceBtn, javax.swing.GroupLayout.PREFERRED_SIZE, 103, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(20, 20, 20)
                        .addComponent(PhaseChange)))
                .addGap(27, 27, 27))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(diceRollResult, javax.swing.GroupLayout.PREFERRED_SIZE, 120, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(diceRollResult, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(rollDiceBtn, javax.swing.GroupLayout.PREFERRED_SIZE, 40, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(PhaseChange))
        );

        mainPanel.add(jPanel1);
        jPanel1.setBounds(37, 390, 128, 100);

        canvas1.setBackground(resourceMap.getColor("canvas1.background")); // NOI18N
        canvas1.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        canvas1.setName("canvas1"); // NOI18N
        canvas1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                canvas1MouseClicked(evt);
            }
        });
        canvas1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                canvas1KeyPressed(evt);
            }
        });
        mainPanel.add(canvas1);
        canvas1.setBounds(200, 10, 890, 620);

        menuBar.setName("menuBar"); // NOI18N

        fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
        fileMenu.setName("fileMenu"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(btclientalpha.BTClientALPHAApp.class).getContext().getActionMap(BTClientALPHAView.class, this);
        exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
        exitMenuItem.setName("exitMenuItem"); // NOI18N
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
        helpMenu.setName("helpMenu"); // NOI18N

        aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
        aboutMenuItem.setName("aboutMenuItem"); // NOI18N
        helpMenu.add(aboutMenuItem);

        menuBar.add(helpMenu);

        statusPanel.setName("statusPanel"); // NOI18N

        statusPanelSeparator.setName("statusPanelSeparator"); // NOI18N

        statusMessageLabel.setName("statusMessageLabel"); // NOI18N

        statusAnimationLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        statusAnimationLabel.setName("statusAnimationLabel"); // NOI18N

        progressBar.setName("progressBar"); // NOI18N

        PhaseLabel.setFont(resourceMap.getFont("PhaseLabel.font")); // NOI18N
        PhaseLabel.setText(resourceMap.getString("PhaseLabel.text")); // NOI18N
        PhaseLabel.setName("PhaseLabel"); // NOI18N

        PhaseStatus.setText(phase.getPhaseName());
        PhaseStatus.setName("PhaseStatus"); // NOI18N

        torsoTwistLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        torsoTwistLabel.setText(resourceMap.getString("torsoTwistLabel.text")); // NOI18N
        torsoTwistLabel.setName("torsoTwistLabel"); // NOI18N

        javax.swing.GroupLayout statusPanelLayout = new javax.swing.GroupLayout(statusPanel);
        statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(statusPanelSeparator, javax.swing.GroupLayout.DEFAULT_SIZE, 1106, Short.MAX_VALUE)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(statusMessageLabel)
                    .addGroup(statusPanelLayout.createSequentialGroup()
                        .addComponent(PhaseLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(PhaseStatus)
                        .addGap(38, 38, 38)
                        .addComponent(torsoTwistLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 688, Short.MAX_VALUE)
                        .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(statusAnimationLabel)))
                .addContainerGap())
        );
        statusPanelLayout.setVerticalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addComponent(statusPanelSeparator, javax.swing.GroupLayout.PREFERRED_SIZE, 2, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 11, Short.MAX_VALUE)
                .addGroup(statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(statusPanelLayout.createSequentialGroup()
                        .addGroup(statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(statusMessageLabel)
                            .addComponent(statusAnimationLabel)
                            .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(3, 3, 3))
                    .addGroup(statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(PhaseLabel)
                        .addComponent(PhaseStatus)
                        .addComponent(torsoTwistLabel))))
        );

        jFrame1.setTitle(resourceMap.getString("jFrame1.title")); // NOI18N
        jFrame1.setName("jFrame1"); // NOI18N
        jFrame1.setResizable(false);

        javax.swing.GroupLayout jFrame1Layout = new javax.swing.GroupLayout(jFrame1.getContentPane());
        jFrame1.getContentPane().setLayout(jFrame1Layout);
        jFrame1Layout.setHorizontalGroup(
            jFrame1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        jFrame1Layout.setVerticalGroup(
            jFrame1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );

        setComponent(mainPanel);
        setMenuBar(menuBar);
        setStatusBar(statusPanel);
    }// </editor-fold>//GEN-END:initComponents

    private void rollDiceBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rollDiceBtnActionPerformed
        diceRollResult.setText("You rolled a: " + Integer.toString(dice.rollDie(2)));
    }//GEN-LAST:event_rollDiceBtnActionPerformed

    private void PhaseChangeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PhaseChangeActionPerformed
        phase.nextPhase();

        if(phase.getPhase() == 0);
        {
            CanvasStatusLabel.setText("Roll for initiative...");
        }
        if(phase.getPhase() == 1)
        {
            moves = pm1.getMech(0).getRunningSpeed();
            moveWalkValueLabel.setText(Integer.toString(pm1.getMech(0).getWalkingSpeed()));
            moveRunValueLabel.setText(Integer.toString(pm1.getMech(0).getRunningSpeed()));
            moveModValueLabel.setText(Integer.toString(pm1.getMech(0).getMovementMod()));
            moveAvailValueLabel.setText(Integer.toString(moves));
            movementPanel.setVisible(true);
            CanvasStatusLabel.setText("Walk, Run, or Stand Still...");


        }
        if(phase.getPhase() == 2)
        {
            moves = 0; //reset
            movementPanel.setVisible(false);
            torsoTwistPanel.setVisible(true);
            CanvasStatusLabel.setText("Twist it baby...");
        }

        if(phase.getPhase() == 3)
        {
            torsoTwistPanel.setVisible(false);
            wep1Btn.setEnabled(true);
            wep2Btn.setEnabled(true);
            wep3Btn.setEnabled(true);
            wep4Btn.setEnabled(true);
            wep5Btn.setEnabled(true);
            CanvasStatusLabel.setText("Fire Zeh Weapons!");
        }
        if(phase.getPhase() == 4)
        {
            wep1Btn.setEnabled(false);
            wep2Btn.setEnabled(false);
            wep3Btn.setEnabled(false);
            wep4Btn.setEnabled(false);
            wep5Btn.setEnabled(false);
            CanvasStatusLabel.setText("Physical Attacks not implemented");
        }
        if(phase.getPhase() == 6)
        {
            pm1.playerMech[0].heatPhase();
            heatLevelValue.setText(Integer.toString(pm1.getMech(0).getHeat()) + " (" + Integer.toString(pm1.getMech(0).getBuiltHeat()) + ")");
            CanvasStatusLabel.setText("Heat level calculated...");

        }
        uiUpdate();
    }//GEN-LAST:event_PhaseChangeActionPerformed

    private void canvas1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_canvas1MouseClicked
        CanvasStatusLabel.setText("Stop clicking me!");
    }//GEN-LAST:event_canvas1MouseClicked

    private void canvas1KeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_canvas1KeyPressed

        if(phase.getPhase() == 1 && moves > 0)
        {

            if(evt.getKeyCode() == java.awt.event.KeyEvent.VK_UP)
            {
                CanvasStatusLabel.setText("Forward");
                tempCanvas.mechForward();
            }
            if(evt.getKeyCode() == java.awt.event.KeyEvent.VK_DOWN)
            {
                CanvasStatusLabel.setText("Back");
                tempCanvas.mechBackward();
            }
            if(evt.getKeyCode() == java.awt.event.KeyEvent.VK_LEFT)
            {
                CanvasStatusLabel.setText("Turn Left");
                tempCanvas.mechTurnLeft();
            }
            if(evt.getKeyCode() == java.awt.event.KeyEvent.VK_RIGHT)
            {
                CanvasStatusLabel.setText("Turn Right");
                tempCanvas.mechTurnRight();
            }
            moves--;
            moveAvailValueLabel.setText(Integer.toString(moves));
            canvas1.repaint();
        }
        else
            CanvasStatusLabel.setText("No more movement points!");
    }//GEN-LAST:event_canvas1KeyPressed

    private void wep2BtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wep2BtnActionPerformed
        MechBody temp = pm1.getMech(0);
        temp.addHeat(temp.getWeapons()[1].getHeat());
        wep2Btn.setEnabled(false);
        uiUpdate();
    }//GEN-LAST:event_wep2BtnActionPerformed

    private void wep1BtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wep1BtnActionPerformed
        MechBody temp = pm1.getMech(0);
        temp.getWeapons()[0].useAmmo();
        temp.addHeat(temp.getWeapons()[0].getHeat());
        wep1Btn.setEnabled(false);
        uiUpdate();
    }//GEN-LAST:event_wep1BtnActionPerformed

    private void wep3BtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wep3BtnActionPerformed
        MechBody temp = pm1.getMech(0);
        temp.addHeat(temp.getWeapons()[2].getHeat());
        wep3Btn.setEnabled(false);
        uiUpdate();

    }//GEN-LAST:event_wep3BtnActionPerformed

    private void wep4BtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wep4BtnActionPerformed
        MechBody temp = pm1.getMech(0);
        temp.addHeat(temp.getWeapons()[3].getHeat());
        wep4Btn.setEnabled(false);
        uiUpdate();

    }//GEN-LAST:event_wep4BtnActionPerformed

    private void wep5BtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wep5BtnActionPerformed
        MechBody temp = pm1.getMech(0);
        temp.addHeat(temp.getWeapons()[4].getHeat());
        wep5Btn.setEnabled(false);
        uiUpdate();
    }//GEN-LAST:event_wep5BtnActionPerformed

    private void torsoTwistLeftBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_torsoTwistLeftBtnActionPerformed
        pm1.getMech(0).torsoTwistLeft();
        torsoTwistLabel.setText("Torso Twist: Left");
        
    }//GEN-LAST:event_torsoTwistLeftBtnActionPerformed

    private void torsoTwistRightBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_torsoTwistRightBtnActionPerformed
        pm1.getMech(0).torsoTwistRight();
        torsoTwistLabel.setText("Torso Twist: Right");
    }//GEN-LAST:event_torsoTwistRightBtnActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
       pm1.getMech(0).torsoTwistCenter();
       torsoTwistLabel.setText("Torso Twist: Center");
    }//GEN-LAST:event_jButton1ActionPerformed

    private void uiUpdate() //most of this can be refactored, as I really only need to repaint the canvas...
    {
       PhaseStatus.setText(phase.getPhaseName());
       PlayerNameLabel.setText(pm1.getPlayerName());
       mechNameLabel.setText(pm1.getMechName(0));
       tonnageValueLabel.setText(Double.toString(pm1.getMech(0).currentBuildTonnage()));
       int[] temp = pm1.getArmorValues(0);
       headArmorLabel.setText(Integer.toString(temp[0])); // NOI18N
       leftLegArmorLabel.setText(Integer.toString(temp[1])); // NOI18N
       leftArmArmorLabel.setText(Integer.toString(temp[2])); // NOI18N
       leftTorsoArmorLabel.setText(Integer.toString(temp[3])); // NOI18N
       leftTorsoRearArmorLabel.setText("("+Integer.toString(temp[4])+")"); // NOI18N
       centerTorsoArmorLabel.setText(Integer.toString(temp[5])); // NOI18N
       centerTorsoRearArmorLabel.setText("("+Integer.toString(temp[6])+")"); // NOI18N
       rightTorsoArmorLabel.setText(Integer.toString(temp[7])); // NOI18N
       rightTorsoRearArmorLabel.setText("("+Integer.toString(temp[8])+")"); // NOI18N
       rightArmArmorLabel.setText(Integer.toString(temp[9])); // NOI18N
       rightLegArmorLabel.setText(Integer.toString(temp[10])); // NOI18N
       heatLevelValue.setText(Integer.toString(pm1.getMech(0).getHeat()) + " (" + Integer.toString(pm1.getMech(0).getBuiltHeat()) + ")");
       Weapon[] weps = pm1.getWeapons(0);
       weapon1Label.setText(weps[0].getNick());
       weapon1AmmoValue.setText(Integer.toString(weps[0].getAmmo()));
       weapon2Label.setText(weps[1].getNick());
       weapon2AmmoValue.setText(Integer.toString(weps[1].getAmmo()));
       weapon3Label.setText(weps[2].getNick());
       weapon3AmmoValue.setText(Integer.toString(weps[2].getAmmo()));
       weapon4Label.setText(weps[3].getNick());
       weapon4AmmoValue.setText(Integer.toString(weps[3].getAmmo()));
       weapon5Label.setText(weps[4].getNick());
       weapon5AmmoValue.setText(Integer.toString(weps[4].getAmmo()));
       //canvas1.repaint();


    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel CanvasStatusLabel;
    private javax.swing.JButton PhaseChange;
    private javax.swing.JLabel PhaseLabel;
    private javax.swing.JLabel PhaseStatus;
    private javax.swing.JLabel PlayerLabel;
    private javax.swing.JLabel PlayerNameLabel;
    private java.awt.Canvas canvas1;
    private javax.swing.JLabel centerTorsoArmorLabel;
    private javax.swing.JLabel centerTorsoLabel;
    private javax.swing.JLabel centerTorsoRearArmorLabel;
    private javax.swing.JLabel diceRollResult;
    private javax.swing.JLabel headArmorLabel;
    private javax.swing.JLabel headLabel;
    private javax.swing.JLabel heatLabel;
    private javax.swing.JLabel heatLevelValue;
    private javax.swing.JButton jButton1;
    private javax.swing.JFrame jFrame1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel leftArmArmorLabel;
    private javax.swing.JLabel leftLegArmorLabel;
    private javax.swing.JLabel leftLegLabel;
    private javax.swing.JLabel leftTorsoArmorLabel;
    private javax.swing.JLabel leftTorsoLabel;
    private javax.swing.JLabel leftTorsoRearArmorLabel;
    private javax.swing.JLabel leftrmLabel;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JLabel mechLabel;
    private javax.swing.JLabel mechNameLabel;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JLabel moveAvailLabel;
    private javax.swing.JLabel moveAvailValueLabel;
    private javax.swing.JLabel moveModLabel;
    private javax.swing.JLabel moveModValueLabel;
    private javax.swing.JLabel moveRunLabel;
    private javax.swing.JLabel moveRunValueLabel;
    private javax.swing.JLabel moveWalkLabel;
    private javax.swing.JLabel moveWalkValueLabel;
    private javax.swing.JLabel movementLabel;
    private javax.swing.JPanel movementPanel;
    private javax.swing.JPanel playerStatusPanel;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JLabel rightArmArmorLabel;
    private javax.swing.JLabel rightArmLabel;
    private javax.swing.JLabel rightLegArmorLabel;
    private javax.swing.JLabel rightLegLabel;
    private javax.swing.JLabel rightTorsoArmorLabel;
    private javax.swing.JLabel rightTorsoLabel;
    private javax.swing.JLabel rightTorsoRearArmorLabel;
    private javax.swing.JButton rollDiceBtn;
    private javax.swing.JLabel statusAnimationLabel;
    private javax.swing.JLabel statusMessageLabel;
    private javax.swing.JPanel statusPanel;
    private javax.swing.JLabel tonnageLabel;
    private javax.swing.JLabel tonnageValueLabel;
    private javax.swing.JLabel torsoTwistLabel;
    private javax.swing.JButton torsoTwistLeftBtn;
    private javax.swing.JPanel torsoTwistPanel;
    private javax.swing.JButton torsoTwistRightBtn;
    private javax.swing.JLabel weapon1AmmoValue;
    private javax.swing.JLabel weapon1Label;
    private javax.swing.JLabel weapon2AmmoValue;
    private javax.swing.JLabel weapon2Label;
    private javax.swing.JLabel weapon3AmmoValue;
    private javax.swing.JLabel weapon3Label;
    private javax.swing.JLabel weapon4AmmoValue;
    private javax.swing.JLabel weapon4Label;
    private javax.swing.JLabel weapon5AmmoValue;
    private javax.swing.JLabel weapon5Label;
    private javax.swing.JButton wep1Btn;
    private javax.swing.JButton wep2Btn;
    private javax.swing.JButton wep3Btn;
    private javax.swing.JButton wep4Btn;
    private javax.swing.JButton wep5Btn;
    // End of variables declaration//GEN-END:variables

    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;

    private JDialog aboutBox;

    private MechSelectorDialog mechSelector;

    private GameCanvas tempCanvas;
    private DieGenerator dice;
    private PhaseEngine phase;
    private PlayerMech pm1;
    private PlayerMech pm2;
    private int moves = 0;
}
