/*
 * Decompiled with CFR 0.152.
 */
package btclientalpha.mech;

import btclientalpha.mech.HeatScale;
import btclientalpha.mech.InnerStructure;
import btclientalpha.mech.MechLocust;
import btclientalpha.mech.parts.Part;
import btclientalpha.mech.weapons.Weapon;
import btclientalpha.mech.weapons.WeaponLaserSmall;

public class MechBody {
    int armorHead;
    int armorLeftLeg;
    int armorLeftArm;
    int armorLeftTorso;
    int armorLeftRearTorso;
    int armorCenterTorso;
    int armorCenterRearTorso;
    int armorRightTorso;
    int armorRightRearTorso;
    int armorRightArm;
    int armorRightLeg;
    InnerStructure is;
    int tonnage;
    double buildTonnage;
    int walkingSpeed;
    int heatLevel;
    HeatScale hs;
    int pilotingSkill;
    int gunnerySkill;
    int torsoDirection;
    String mechName;
    Weapon[] weaponList;

    public MechBody(int tonnageIn, int walkingSpeedIn) {
        this.tonnage = tonnageIn;
        this.walkingSpeed = walkingSpeedIn;
        this.is = new InnerStructure(this.tonnage, this.tonnage * this.walkingSpeed);
        this.hs = new HeatScale();
        this.heatLevel = 0;
        this.pilotingSkill = 5;
        this.gunnerySkill = 4;
        this.torsoDirection = 0;
        this.mechName = "Unassigned";
        this.buildTonnage = this.getBuildTonnage();
    }

    public void setName(String nameIn) {
        this.mechName = nameIn;
    }

    public String getMechName() {
        return this.mechName;
    }

    public int getPilotingRoll() {
        return this.pilotingSkill;
    }

    public int getGunneryRoll() {
        return this.gunnerySkill + this.hs.getFireMod();
    }

    public int getWalkingSpeed() {
        int temp = this.walkingSpeed + this.getMovementMod();
        if (temp < 0) {
            return 0;
        }
        return temp;
    }

    public int getRunningSpeed() {
        return (int)((double)this.getWalkingSpeed() * 1.5);
    }

    public int getMovementMod() {
        return this.hs.getMoveMod() + this.partsMoveMod();
    }

    public void torsoTwistLeft() {
        this.torsoDirection = -1;
    }

    public void torsoTwistRight() {
        this.torsoDirection = 1;
    }

    public void torsoTwistCenter() {
        this.torsoDirection = 0;
    }

    public int getTorsoDirection() {
        return this.torsoDirection;
    }

    public void addHeat(int heatIn) {
        this.heatLevel += heatIn;
    }

    public void heatPhase() {
        this.heatLevel -= 10;
        this.hs.addHeat(this.heatLevel);
        this.heatLevel = 0;
    }

    public Part partAt(int loc, int critical) {
        if (this.is.isPart(loc, critical)) {
            return this.is.partAt(loc, critical);
        }
        return null;
    }

    public void setArmor() {
        this.armorHead = 0;
        this.armorLeftLeg = 0;
        this.armorLeftArm = 0;
        this.armorLeftTorso = 0;
        this.armorLeftRearTorso = 0;
        this.armorCenterTorso = 0;
        this.armorCenterRearTorso = 0;
        this.armorRightTorso = 0;
        this.armorRightRearTorso = 0;
        this.armorRightArm = 0;
        this.armorRightLeg = 0;
    }

    public void setArmor(int[] armorIn) {
        if (armorIn.length == 11) {
            this.armorHead = armorIn[0];
            this.armorLeftLeg = armorIn[1];
            this.armorLeftArm = armorIn[2];
            this.armorLeftTorso = armorIn[3];
            this.armorLeftRearTorso = armorIn[4];
            this.armorCenterTorso = armorIn[5];
            this.armorCenterRearTorso = armorIn[6];
            this.armorRightTorso = armorIn[7];
            this.armorRightRearTorso = armorIn[8];
            this.armorRightArm = armorIn[9];
            this.armorRightLeg = armorIn[10];
        } else {
            this.setArmor();
        }
        int armorCount = 0;
        for (int i = 0; i < armorIn.length; ++i) {
            armorCount += armorIn[i];
        }
        this.buildTonnage += (double)(armorCount / 16);
    }

    public int[] getArmorValues() {
        int[] temp = new int[]{this.armorHead, this.armorLeftLeg, this.armorLeftArm, this.armorLeftTorso, this.armorLeftRearTorso, this.armorCenterTorso, this.armorCenterRearTorso, this.armorRightTorso, this.armorRightRearTorso, this.armorRightArm, this.armorRightLeg};
        return temp;
    }

    private double getBuildTonnage() {
        this.buildTonnage = this.is.engine.getTonnage();
        this.buildTonnage += this.is.gyro.getTonnage();
        this.buildTonnage += this.is.cockpit.getTonnage();
        this.buildTonnage += this.is.getTonnage();
        return this.buildTonnage;
    }

    public double currentBuildTonnage() {
        return this.buildTonnage;
    }

    public int getHeat() {
        return this.hs.getHeatLevel();
    }

    public int getBuiltHeat() {
        return this.heatLevel;
    }

    public Weapon[] getWeapons() {
        return this.weaponList;
    }

    public static void main(String[] args) {
        MechLocust mb = new MechLocust();
        System.out.println("built");
        System.out.println("Running speed: " + mb.getRunningSpeed());
        System.out.println("left Leg: " + mb.is.getLeftLegArmor());
        System.out.println("Heat level: " + mb.hs.getHeatLevel());
        System.out.println("Move mod: " + mb.hs.getMoveMod());
        System.out.println("Fire mod: " + mb.hs.getFireMod());
        System.out.println("Roll for Shutdown: " + mb.hs.checkShutdown() + "\nRoll for ammo Explosion:" + mb.hs.checkAmmoExplosion());
        System.out.println("Walk: " + mb.getWalkingSpeed() + " Gunnery: " + mb.getGunneryRoll());
        System.out.println("Running speed: " + mb.getRunningSpeed());
        System.out.println("adding 25 heat...");
        mb.hs.addHeat(25);
        System.out.println("Heat level: " + mb.hs.getHeatLevel());
        System.out.println("Move mod: " + mb.hs.getMoveMod());
        System.out.println("Fire mod: " + mb.hs.getFireMod());
        System.out.println("Roll for Shutdown: " + mb.hs.checkShutdown() + "\nRoll for ammo Explosion:" + mb.hs.checkAmmoExplosion());
        System.out.println("Walk: " + mb.getWalkingSpeed() + " Gunnery: " + mb.getGunneryRoll());
        System.out.println("Running speed: " + mb.getRunningSpeed());
        if (mb.is.setPart(new WeaponLaserSmall(), 0)) {
            System.out.println("Small Laser Placed");
        }
        for (int j = 0; j < 8; ++j) {
            for (int i = 0; i < 12 && (i != 6 || j != 0 && j != 1 && j != 7); ++i) {
                Part temp = mb.partAt(j, i);
                if (temp != null) {
                    System.out.println("Part at: " + j + ", " + i + ": " + temp.getName() + " : " + temp.getClass());
                    continue;
                }
                System.out.println("Null at: " + j + ", " + i);
            }
        }
    }

    private int partsMoveMod() {
        int partsMod = 0;
        for (int j = 0; j < 8; ++j) {
            for (int i = 0; i < 12 && (i != 6 || j != 0 && j != 1 && j != 7); ++i) {
                Part temp = this.partAt(j, i);
                if (temp == null) continue;
                partsMod -= temp.getMoveMod();
            }
        }
        return partsMod;
    }
}

