/*
 * Decompiled with CFR 0.152.
 */
package btclientalpha.mech;

import btclientalpha.mech.parts.ActuatorArmHand;
import btclientalpha.mech.parts.ActuatorArmLower;
import btclientalpha.mech.parts.ActuatorArmShoulder;
import btclientalpha.mech.parts.ActuatorArmUpper;
import btclientalpha.mech.parts.ActuatorLegFoot;
import btclientalpha.mech.parts.ActuatorLegHip;
import btclientalpha.mech.parts.ActuatorLegLower;
import btclientalpha.mech.parts.ActuatorLegUpper;
import btclientalpha.mech.parts.Cockpit;
import btclientalpha.mech.parts.Engine;
import btclientalpha.mech.parts.Gyro;
import btclientalpha.mech.parts.LifeSupport;
import btclientalpha.mech.parts.Part;
import btclientalpha.mech.parts.Sensors;

public class InnerStructure {
    double tonnage;
    int headArmor;
    int leftLegArmor;
    int leftArmArmor;
    int leftTorsoArmor;
    int centerTorsoArmor;
    int rightTorsoArmor;
    int rightArmArmor;
    int rightLegArmor;
    Part[] head;
    Part[] leftLeg;
    Part[] leftArm;
    Part[] leftTorso;
    Part[] centerTorso;
    Part[] rightTorso;
    Part[] rightArm;
    Part[] rightLeg;
    int headCritsAvail;
    int leftLegCritsAvail;
    int leftArmCritsAvail;
    int leftTorsoCritsAvail;
    int centerTorsoCritsAvail;
    int rightTorsoCritsAvail;
    int rightArmCritsAvail;
    int rightLegCritsAvail;
    Engine engine;
    Gyro gyro;
    Cockpit cockpit;
    Sensors sensors;
    LifeSupport lifeSupport;
    ActuatorArmShoulder leftShoulder;
    ActuatorArmShoulder rightShoulder;
    ActuatorArmUpper leftUpperArm;
    ActuatorArmUpper rightUpperArm;
    ActuatorArmLower leftLowerArm;
    ActuatorArmLower rightLowerArm;
    ActuatorArmHand leftHand;
    ActuatorArmHand rightHand;
    ActuatorLegHip leftHip;
    ActuatorLegHip rightHip;
    ActuatorLegUpper leftUpperLeg;
    ActuatorLegUpper rightUpperLeg;
    ActuatorLegLower leftLowerLeg;
    ActuatorLegLower rightLowerLeg;
    ActuatorLegFoot leftFoot;
    ActuatorLegFoot rightFoot;

    public InnerStructure(int tonnageIn, int engineRating) {
        this.tonnage = (double)tonnageIn * 0.1;
        this.defineArmor(tonnageIn);
        this.head = new Part[6];
        this.leftLeg = new Part[6];
        this.leftArm = new Part[12];
        this.leftTorso = new Part[12];
        this.centerTorso = new Part[12];
        this.rightTorso = new Part[12];
        this.rightArm = new Part[12];
        this.rightLeg = new Part[6];
        this.engine = new Engine(engineRating);
        this.gyro = new Gyro(engineRating);
        this.cockpit = new Cockpit();
        this.sensors = new Sensors();
        this.lifeSupport = new LifeSupport();
        this.leftShoulder = new ActuatorArmShoulder();
        this.rightShoulder = new ActuatorArmShoulder();
        this.leftUpperArm = new ActuatorArmUpper();
        this.rightUpperArm = new ActuatorArmUpper();
        this.leftLowerArm = new ActuatorArmLower();
        this.rightLowerArm = new ActuatorArmLower();
        this.leftHand = new ActuatorArmHand();
        this.rightHand = new ActuatorArmHand();
        this.leftHip = new ActuatorLegHip();
        this.rightHip = new ActuatorLegHip();
        this.leftUpperLeg = new ActuatorLegUpper();
        this.rightUpperLeg = new ActuatorLegUpper();
        this.leftLowerLeg = new ActuatorLegLower();
        this.rightLowerLeg = new ActuatorLegLower();
        this.leftFoot = new ActuatorLegFoot();
        this.rightFoot = new ActuatorLegFoot();
        this.head[0] = this.lifeSupport;
        this.head[1] = this.sensors;
        this.head[2] = this.cockpit;
        this.head[4] = this.sensors;
        this.head[5] = this.lifeSupport;
        this.headCritsAvail = 1;
        this.leftArm[0] = this.leftShoulder;
        this.leftArm[1] = this.leftUpperArm;
        this.leftArm[2] = this.leftLowerArm;
        this.leftArm[3] = this.leftHand;
        this.leftArmCritsAvail = 8;
        this.rightArm[0] = this.rightShoulder;
        this.rightArm[1] = this.rightUpperArm;
        this.rightArm[2] = this.rightLowerArm;
        this.rightArm[3] = this.rightHand;
        this.rightArmCritsAvail = 8;
        this.leftLeg[0] = this.leftHip;
        this.leftLeg[1] = this.leftUpperLeg;
        this.leftLeg[2] = this.leftLowerLeg;
        this.leftLeg[3] = this.leftFoot;
        this.leftLegCritsAvail = 2;
        this.rightLeg[0] = this.rightHip;
        this.rightLeg[1] = this.rightUpperLeg;
        this.rightLeg[2] = this.rightLowerLeg;
        this.rightLeg[3] = this.rightFoot;
        this.rightLegCritsAvail = 2;
        this.centerTorso[0] = this.engine;
        this.centerTorso[1] = this.engine;
        this.centerTorso[2] = this.engine;
        this.centerTorso[3] = this.gyro;
        this.centerTorso[4] = this.gyro;
        this.centerTorso[5] = this.gyro;
        this.centerTorso[6] = this.gyro;
        this.centerTorso[7] = this.engine;
        this.centerTorso[8] = this.engine;
        this.centerTorso[9] = this.engine;
        this.centerTorsoCritsAvail = 2;
        this.leftTorsoCritsAvail = 12;
        this.rightTorsoCritsAvail = 12;
    }

    public int getCritAvail(int loc) {
        int temp = -1;
        switch (loc) {
            case 0: {
                temp = this.headCritsAvail;
                break;
            }
            case 1: {
                temp = this.leftLegCritsAvail;
                break;
            }
            case 2: {
                temp = this.leftArmCritsAvail;
                break;
            }
            case 3: {
                temp = this.leftTorsoCritsAvail;
                break;
            }
            case 4: {
                temp = this.centerTorsoCritsAvail;
                break;
            }
            case 5: {
                temp = this.rightTorsoCritsAvail;
                break;
            }
            case 6: {
                temp = this.rightArmCritsAvail;
                break;
            }
            case 7: {
                temp = this.rightLegCritsAvail;
            }
        }
        return temp;
    }

    public boolean isPart(int loc, int critical) {
        try {
            Part temp = this.partAt(loc, critical);
            return temp != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setPart(Part partIn, int loc) {
        int critical = 0;
        int count = partIn.getCritical();
        if (count > this.getCritAvail(loc)) {
            return false;
        }
        while (count != 0) {
            if (!this.isPart(loc, critical)) {
                switch (loc) {
                    case 0: {
                        this.head[critical] = partIn;
                        break;
                    }
                    case 1: {
                        this.leftLeg[critical] = partIn;
                        break;
                    }
                    case 2: {
                        this.leftArm[critical] = partIn;
                        break;
                    }
                    case 3: {
                        this.leftTorso[critical] = partIn;
                        break;
                    }
                    case 4: {
                        this.centerTorso[critical] = partIn;
                        break;
                    }
                    case 5: {
                        this.rightTorso[critical] = partIn;
                        break;
                    }
                    case 6: {
                        this.rightArm[critical] = partIn;
                        break;
                    }
                    case 7: {
                        this.rightLeg[critical] = partIn;
                    }
                }
                --count;
            }
            if (critical < 12) {
                ++critical;
                continue;
            }
            critical = 0;
        }
        return true;
    }

    public Part partAt(int loc, int critical) {
        Part temp = new Part();
        switch (loc) {
            case 0: {
                if (critical >= 6) break;
                temp = this.head[critical];
                break;
            }
            case 1: {
                if (critical >= 6) break;
                temp = this.leftLeg[critical];
                break;
            }
            case 2: {
                temp = this.leftArm[critical];
                break;
            }
            case 3: {
                temp = this.leftTorso[critical];
                break;
            }
            case 4: {
                temp = this.centerTorso[critical];
                break;
            }
            case 5: {
                temp = this.rightTorso[critical];
                break;
            }
            case 6: {
                temp = this.rightArm[critical];
                break;
            }
            case 7: {
                if (critical >= 6) break;
                temp = this.rightLeg[critical];
            }
        }
        return temp;
    }

    public int getLeftLegArmor() {
        return this.leftLegArmor;
    }

    public int getLeftArmArmor() {
        return this.leftArmArmor;
    }

    public int getLeftTorsoArmor() {
        return this.leftTorsoArmor;
    }

    public int getCenterTorsoArmor() {
        return this.centerTorsoArmor;
    }

    public int getRightTorsoArmor() {
        return this.rightTorsoArmor;
    }

    public int getRightArmArmor() {
        return this.rightArmArmor;
    }

    public int getRightLegArmor() {
        return this.rightLegArmor;
    }

    private void defineArmor(int input) {
        this.headArmor = 3;
        switch (input) {
            case 10: {
                this.leftLegArmor = 2;
                this.leftArmArmor = 1;
                this.leftTorsoArmor = 3;
                this.centerTorsoArmor = 4;
                this.rightTorsoArmor = 3;
                this.rightArmArmor = 1;
                this.rightLegArmor = 2;
                break;
            }
            case 15: {
                this.leftLegArmor = 3;
                this.leftArmArmor = 2;
                this.leftTorsoArmor = 4;
                this.centerTorsoArmor = 5;
                this.rightTorsoArmor = 4;
                this.rightArmArmor = 2;
                this.rightLegArmor = 3;
                break;
            }
            case 20: {
                this.leftLegArmor = 4;
                this.leftArmArmor = 3;
                this.leftTorsoArmor = 5;
                this.centerTorsoArmor = 6;
                this.rightTorsoArmor = 5;
                this.rightArmArmor = 3;
                this.rightLegArmor = 4;
                break;
            }
            case 25: {
                this.leftLegArmor = 6;
                this.leftArmArmor = 4;
                this.leftTorsoArmor = 6;
                this.centerTorsoArmor = 8;
                this.rightTorsoArmor = 6;
                this.rightArmArmor = 4;
                this.rightLegArmor = 6;
                break;
            }
            case 30: {
                this.leftLegArmor = 7;
                this.leftArmArmor = 5;
                this.leftTorsoArmor = 7;
                this.centerTorsoArmor = 10;
                this.rightTorsoArmor = 7;
                this.rightArmArmor = 5;
                this.rightLegArmor = 7;
                break;
            }
            case 35: {
                this.leftLegArmor = 8;
                this.leftArmArmor = 6;
                this.leftTorsoArmor = 8;
                this.centerTorsoArmor = 11;
                this.rightTorsoArmor = 8;
                this.rightArmArmor = 6;
                this.rightLegArmor = 8;
                break;
            }
            case 40: {
                this.leftLegArmor = 10;
                this.leftArmArmor = 6;
                this.leftTorsoArmor = 10;
                this.centerTorsoArmor = 12;
                this.rightTorsoArmor = 10;
                this.rightArmArmor = 6;
                this.rightLegArmor = 10;
                break;
            }
            case 45: {
                this.leftLegArmor = 11;
                this.leftArmArmor = 7;
                this.leftTorsoArmor = 11;
                this.centerTorsoArmor = 14;
                this.rightTorsoArmor = 11;
                this.rightArmArmor = 7;
                this.rightLegArmor = 11;
                break;
            }
            case 50: {
                this.leftLegArmor = 12;
                this.leftArmArmor = 8;
                this.leftTorsoArmor = 12;
                this.centerTorsoArmor = 16;
                this.rightTorsoArmor = 12;
                this.rightArmArmor = 8;
                this.rightLegArmor = 12;
                break;
            }
            case 55: {
                this.leftLegArmor = 13;
                this.leftArmArmor = 9;
                this.leftTorsoArmor = 13;
                this.centerTorsoArmor = 18;
                this.rightTorsoArmor = 13;
                this.rightArmArmor = 9;
                this.rightLegArmor = 13;
                break;
            }
            case 60: {
                this.leftLegArmor = 14;
                this.leftArmArmor = 10;
                this.leftTorsoArmor = 14;
                this.centerTorsoArmor = 20;
                this.rightTorsoArmor = 14;
                this.rightArmArmor = 10;
                this.rightLegArmor = 14;
                break;
            }
            case 65: {
                this.leftLegArmor = 15;
                this.leftArmArmor = 10;
                this.leftTorsoArmor = 15;
                this.centerTorsoArmor = 21;
                this.rightTorsoArmor = 15;
                this.rightArmArmor = 10;
                this.rightLegArmor = 15;
                break;
            }
            case 70: {
                this.leftLegArmor = 15;
                this.leftArmArmor = 11;
                this.leftTorsoArmor = 15;
                this.centerTorsoArmor = 22;
                this.rightTorsoArmor = 15;
                this.rightArmArmor = 11;
                this.rightLegArmor = 15;
                break;
            }
            case 75: {
                this.leftLegArmor = 16;
                this.leftArmArmor = 12;
                this.leftTorsoArmor = 16;
                this.centerTorsoArmor = 23;
                this.rightTorsoArmor = 16;
                this.rightArmArmor = 12;
                this.rightLegArmor = 16;
                break;
            }
            case 80: {
                this.leftLegArmor = 17;
                this.leftArmArmor = 13;
                this.leftTorsoArmor = 17;
                this.centerTorsoArmor = 25;
                this.rightTorsoArmor = 17;
                this.rightArmArmor = 13;
                this.rightLegArmor = 17;
                break;
            }
            case 85: {
                this.leftLegArmor = 18;
                this.leftArmArmor = 14;
                this.leftTorsoArmor = 18;
                this.centerTorsoArmor = 27;
                this.rightTorsoArmor = 18;
                this.rightArmArmor = 14;
                this.rightLegArmor = 18;
                break;
            }
            case 90: {
                this.leftLegArmor = 19;
                this.leftArmArmor = 15;
                this.leftTorsoArmor = 19;
                this.centerTorsoArmor = 29;
                this.rightTorsoArmor = 19;
                this.rightArmArmor = 15;
                this.rightLegArmor = 19;
                break;
            }
            case 95: {
                this.leftLegArmor = 20;
                this.leftArmArmor = 16;
                this.leftTorsoArmor = 20;
                this.centerTorsoArmor = 30;
                this.rightTorsoArmor = 20;
                this.rightArmArmor = 16;
                this.rightLegArmor = 20;
                break;
            }
            case 100: {
                this.leftLegArmor = 21;
                this.leftArmArmor = 17;
                this.leftTorsoArmor = 21;
                this.centerTorsoArmor = 31;
                this.rightTorsoArmor = 21;
                this.rightArmArmor = 17;
                this.rightLegArmor = 21;
            }
        }
    }

    double getTonnage() {
        return this.tonnage;
    }
}

